package iso20022.auth030.hkma.dtcc;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.hkma.dtcc.LegalPersonIdentification1__5;
import iso20022.auth030.hkma.dtcc.LegalPersonIdentification1__5.LegalPersonIdentification1__5Builder;
import iso20022.auth030.hkma.dtcc.LegalPersonIdentification1__5.LegalPersonIdentification1__5BuilderImpl;
import iso20022.auth030.hkma.dtcc.LegalPersonIdentification1__5.LegalPersonIdentification1__5Impl;
import iso20022.auth030.hkma.dtcc.OrganisationIdentification15Choice__2;
import iso20022.auth030.hkma.dtcc.OrganisationIdentification15Choice__2.OrganisationIdentification15Choice__2Builder;
import iso20022.auth030.hkma.dtcc.meta.LegalPersonIdentification1__5Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Provides the identification of the organisation which is a legal person.
 * @version 1.22.0
 */
@RosettaDataType(value="LegalPersonIdentification1__5", builder=LegalPersonIdentification1__5.LegalPersonIdentification1__5BuilderImpl.class, version="1.22.0")
@RuneDataType(value="LegalPersonIdentification1__5", model="iso20022", builder=LegalPersonIdentification1__5.LegalPersonIdentification1__5BuilderImpl.class, version="1.22.0")
public interface LegalPersonIdentification1__5 extends RosettaModelObject {

	LegalPersonIdentification1__5Meta metaData = new LegalPersonIdentification1__5Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Unique and unambiguous identification of the legal person.
	 */
	OrganisationIdentification15Choice__2 getId();

	/*********************** Build Methods  ***********************/
	LegalPersonIdentification1__5 build();
	
	LegalPersonIdentification1__5.LegalPersonIdentification1__5Builder toBuilder();
	
	static LegalPersonIdentification1__5.LegalPersonIdentification1__5Builder builder() {
		return new LegalPersonIdentification1__5.LegalPersonIdentification1__5BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends LegalPersonIdentification1__5> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends LegalPersonIdentification1__5> getType() {
		return LegalPersonIdentification1__5.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("id"), processor, OrganisationIdentification15Choice__2.class, getId());
	}
	

	/*********************** Builder Interface  ***********************/
	interface LegalPersonIdentification1__5Builder extends LegalPersonIdentification1__5, RosettaModelObjectBuilder {
		OrganisationIdentification15Choice__2.OrganisationIdentification15Choice__2Builder getOrCreateId();
		@Override
		OrganisationIdentification15Choice__2.OrganisationIdentification15Choice__2Builder getId();
		LegalPersonIdentification1__5.LegalPersonIdentification1__5Builder setId(OrganisationIdentification15Choice__2 id);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("id"), processor, OrganisationIdentification15Choice__2.OrganisationIdentification15Choice__2Builder.class, getId());
		}
		

		LegalPersonIdentification1__5.LegalPersonIdentification1__5Builder prune();
	}

	/*********************** Immutable Implementation of LegalPersonIdentification1__5  ***********************/
	class LegalPersonIdentification1__5Impl implements LegalPersonIdentification1__5 {
		private final OrganisationIdentification15Choice__2 id;
		
		protected LegalPersonIdentification1__5Impl(LegalPersonIdentification1__5.LegalPersonIdentification1__5Builder builder) {
			this.id = ofNullable(builder.getId()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("id")
		@RuneAttribute("id")
		public OrganisationIdentification15Choice__2 getId() {
			return id;
		}
		
		@Override
		public LegalPersonIdentification1__5 build() {
			return this;
		}
		
		@Override
		public LegalPersonIdentification1__5.LegalPersonIdentification1__5Builder toBuilder() {
			LegalPersonIdentification1__5.LegalPersonIdentification1__5Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(LegalPersonIdentification1__5.LegalPersonIdentification1__5Builder builder) {
			ofNullable(getId()).ifPresent(builder::setId);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			LegalPersonIdentification1__5 _that = getType().cast(o);
		
			if (!Objects.equals(id, _that.getId())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (id != null ? id.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "LegalPersonIdentification1__5 {" +
				"id=" + this.id +
			'}';
		}
	}

	/*********************** Builder Implementation of LegalPersonIdentification1__5  ***********************/
	class LegalPersonIdentification1__5BuilderImpl implements LegalPersonIdentification1__5.LegalPersonIdentification1__5Builder {
	
		protected OrganisationIdentification15Choice__2.OrganisationIdentification15Choice__2Builder id;
		
		@Override
		@RosettaAttribute("id")
		@RuneAttribute("id")
		public OrganisationIdentification15Choice__2.OrganisationIdentification15Choice__2Builder getId() {
			return id;
		}
		
		@Override
		public OrganisationIdentification15Choice__2.OrganisationIdentification15Choice__2Builder getOrCreateId() {
			OrganisationIdentification15Choice__2.OrganisationIdentification15Choice__2Builder result;
			if (id!=null) {
				result = id;
			}
			else {
				result = id = OrganisationIdentification15Choice__2.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("id")
		@RuneAttribute("id")
		public LegalPersonIdentification1__5.LegalPersonIdentification1__5Builder setId(OrganisationIdentification15Choice__2 _id) {
			this.id = _id == null ? null : _id.toBuilder();
			return this;
		}
		
		@Override
		public LegalPersonIdentification1__5 build() {
			return new LegalPersonIdentification1__5.LegalPersonIdentification1__5Impl(this);
		}
		
		@Override
		public LegalPersonIdentification1__5.LegalPersonIdentification1__5Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public LegalPersonIdentification1__5.LegalPersonIdentification1__5Builder prune() {
			if (id!=null && !id.prune().hasData()) id = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getId()!=null && getId().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public LegalPersonIdentification1__5.LegalPersonIdentification1__5Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			LegalPersonIdentification1__5.LegalPersonIdentification1__5Builder o = (LegalPersonIdentification1__5.LegalPersonIdentification1__5Builder) other;
			
			merger.mergeRosetta(getId(), o.getId(), this::setId);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			LegalPersonIdentification1__5 _that = getType().cast(o);
		
			if (!Objects.equals(id, _that.getId())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (id != null ? id.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "LegalPersonIdentification1__5Builder {" +
				"id=" + this.id +
			'}';
		}
	}
}
