package iso20022.auth030.hkma.dtcc.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.hkma.dtcc.EnergyCommodityDistillates2;
import iso20022.auth030.hkma.dtcc.validation.EnergyCommodityDistillates2TypeFormatValidator;
import iso20022.auth030.hkma.dtcc.validation.EnergyCommodityDistillates2Validator;
import iso20022.auth030.hkma.dtcc.validation.exists.EnergyCommodityDistillates2OnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 1.22.0
 */
@RosettaMeta(model=EnergyCommodityDistillates2.class)
public class EnergyCommodityDistillates2Meta implements RosettaMetaData<EnergyCommodityDistillates2> {

	@Override
	public List<Validator<? super EnergyCommodityDistillates2>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super EnergyCommodityDistillates2, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super EnergyCommodityDistillates2> validator(ValidatorFactory factory) {
		return factory.<EnergyCommodityDistillates2>create(EnergyCommodityDistillates2Validator.class);
	}

	@Override
	public Validator<? super EnergyCommodityDistillates2> typeFormatValidator(ValidatorFactory factory) {
		return factory.<EnergyCommodityDistillates2>create(EnergyCommodityDistillates2TypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super EnergyCommodityDistillates2> validator() {
		return new EnergyCommodityDistillates2Validator();
	}

	@Deprecated
	@Override
	public Validator<? super EnergyCommodityDistillates2> typeFormatValidator() {
		return new EnergyCommodityDistillates2TypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super EnergyCommodityDistillates2, Set<String>> onlyExistsValidator() {
		return new EnergyCommodityDistillates2OnlyExistsValidator();
	}
}
