package iso20022.auth030.jfsa;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.jfsa.AmountAndDirection109__1;
import iso20022.auth030.jfsa.AmountAndDirection109__1.AmountAndDirection109__1Builder;
import iso20022.auth030.jfsa.ContractValuationData8__1;
import iso20022.auth030.jfsa.ContractValuationData8__1.ContractValuationData8__1Builder;
import iso20022.auth030.jfsa.ContractValuationData8__1.ContractValuationData8__1BuilderImpl;
import iso20022.auth030.jfsa.ContractValuationData8__1.ContractValuationData8__1Impl;
import iso20022.auth030.jfsa.ValuationType1Code;
import iso20022.auth030.jfsa.meta.ContractValuationData8__1Meta;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 1.22.0
 */
@RosettaDataType(value="ContractValuationData8__1", builder=ContractValuationData8__1.ContractValuationData8__1BuilderImpl.class, version="1.22.0")
@RuneDataType(value="ContractValuationData8__1", model="iso20022", builder=ContractValuationData8__1.ContractValuationData8__1BuilderImpl.class, version="1.22.0")
public interface ContractValuationData8__1 extends RosettaModelObject {

	ContractValuationData8__1Meta metaData = new ContractValuationData8__1Meta();

	/*********************** Getter Methods  ***********************/
	AmountAndDirection109__1 getCtrctVal();
	ZonedDateTime getTmStmp();
	ValuationType1Code getTp();
	BigDecimal getDlta();

	/*********************** Build Methods  ***********************/
	ContractValuationData8__1 build();
	
	ContractValuationData8__1.ContractValuationData8__1Builder toBuilder();
	
	static ContractValuationData8__1.ContractValuationData8__1Builder builder() {
		return new ContractValuationData8__1.ContractValuationData8__1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ContractValuationData8__1> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ContractValuationData8__1> getType() {
		return ContractValuationData8__1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("ctrctVal"), processor, AmountAndDirection109__1.class, getCtrctVal());
		processor.processBasic(path.newSubPath("tmStmp"), ZonedDateTime.class, getTmStmp(), this);
		processor.processBasic(path.newSubPath("tp"), ValuationType1Code.class, getTp(), this);
		processor.processBasic(path.newSubPath("dlta"), BigDecimal.class, getDlta(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface ContractValuationData8__1Builder extends ContractValuationData8__1, RosettaModelObjectBuilder {
		AmountAndDirection109__1.AmountAndDirection109__1Builder getOrCreateCtrctVal();
		@Override
		AmountAndDirection109__1.AmountAndDirection109__1Builder getCtrctVal();
		ContractValuationData8__1.ContractValuationData8__1Builder setCtrctVal(AmountAndDirection109__1 ctrctVal);
		ContractValuationData8__1.ContractValuationData8__1Builder setTmStmp(ZonedDateTime tmStmp);
		ContractValuationData8__1.ContractValuationData8__1Builder setTp(ValuationType1Code tp);
		ContractValuationData8__1.ContractValuationData8__1Builder setDlta(BigDecimal dlta);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("ctrctVal"), processor, AmountAndDirection109__1.AmountAndDirection109__1Builder.class, getCtrctVal());
			processor.processBasic(path.newSubPath("tmStmp"), ZonedDateTime.class, getTmStmp(), this);
			processor.processBasic(path.newSubPath("tp"), ValuationType1Code.class, getTp(), this);
			processor.processBasic(path.newSubPath("dlta"), BigDecimal.class, getDlta(), this);
		}
		

		ContractValuationData8__1.ContractValuationData8__1Builder prune();
	}

	/*********************** Immutable Implementation of ContractValuationData8__1  ***********************/
	class ContractValuationData8__1Impl implements ContractValuationData8__1 {
		private final AmountAndDirection109__1 ctrctVal;
		private final ZonedDateTime tmStmp;
		private final ValuationType1Code tp;
		private final BigDecimal dlta;
		
		protected ContractValuationData8__1Impl(ContractValuationData8__1.ContractValuationData8__1Builder builder) {
			this.ctrctVal = ofNullable(builder.getCtrctVal()).map(f->f.build()).orElse(null);
			this.tmStmp = builder.getTmStmp();
			this.tp = builder.getTp();
			this.dlta = builder.getDlta();
		}
		
		@Override
		@RosettaAttribute("ctrctVal")
		@RuneAttribute("ctrctVal")
		public AmountAndDirection109__1 getCtrctVal() {
			return ctrctVal;
		}
		
		@Override
		@RosettaAttribute("tmStmp")
		@RuneAttribute("tmStmp")
		public ZonedDateTime getTmStmp() {
			return tmStmp;
		}
		
		@Override
		@RosettaAttribute("tp")
		@RuneAttribute("tp")
		public ValuationType1Code getTp() {
			return tp;
		}
		
		@Override
		@RosettaAttribute("dlta")
		@RuneAttribute("dlta")
		public BigDecimal getDlta() {
			return dlta;
		}
		
		@Override
		public ContractValuationData8__1 build() {
			return this;
		}
		
		@Override
		public ContractValuationData8__1.ContractValuationData8__1Builder toBuilder() {
			ContractValuationData8__1.ContractValuationData8__1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ContractValuationData8__1.ContractValuationData8__1Builder builder) {
			ofNullable(getCtrctVal()).ifPresent(builder::setCtrctVal);
			ofNullable(getTmStmp()).ifPresent(builder::setTmStmp);
			ofNullable(getTp()).ifPresent(builder::setTp);
			ofNullable(getDlta()).ifPresent(builder::setDlta);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ContractValuationData8__1 _that = getType().cast(o);
		
			if (!Objects.equals(ctrctVal, _that.getCtrctVal())) return false;
			if (!Objects.equals(tmStmp, _that.getTmStmp())) return false;
			if (!Objects.equals(tp, _that.getTp())) return false;
			if (!Objects.equals(dlta, _that.getDlta())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (ctrctVal != null ? ctrctVal.hashCode() : 0);
			_result = 31 * _result + (tmStmp != null ? tmStmp.hashCode() : 0);
			_result = 31 * _result + (tp != null ? tp.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (dlta != null ? dlta.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ContractValuationData8__1 {" +
				"ctrctVal=" + this.ctrctVal + ", " +
				"tmStmp=" + this.tmStmp + ", " +
				"tp=" + this.tp + ", " +
				"dlta=" + this.dlta +
			'}';
		}
	}

	/*********************** Builder Implementation of ContractValuationData8__1  ***********************/
	class ContractValuationData8__1BuilderImpl implements ContractValuationData8__1.ContractValuationData8__1Builder {
	
		protected AmountAndDirection109__1.AmountAndDirection109__1Builder ctrctVal;
		protected ZonedDateTime tmStmp;
		protected ValuationType1Code tp;
		protected BigDecimal dlta;
		
		@Override
		@RosettaAttribute("ctrctVal")
		@RuneAttribute("ctrctVal")
		public AmountAndDirection109__1.AmountAndDirection109__1Builder getCtrctVal() {
			return ctrctVal;
		}
		
		@Override
		public AmountAndDirection109__1.AmountAndDirection109__1Builder getOrCreateCtrctVal() {
			AmountAndDirection109__1.AmountAndDirection109__1Builder result;
			if (ctrctVal!=null) {
				result = ctrctVal;
			}
			else {
				result = ctrctVal = AmountAndDirection109__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("tmStmp")
		@RuneAttribute("tmStmp")
		public ZonedDateTime getTmStmp() {
			return tmStmp;
		}
		
		@Override
		@RosettaAttribute("tp")
		@RuneAttribute("tp")
		public ValuationType1Code getTp() {
			return tp;
		}
		
		@Override
		@RosettaAttribute("dlta")
		@RuneAttribute("dlta")
		public BigDecimal getDlta() {
			return dlta;
		}
		
		@Override
		@RosettaAttribute("ctrctVal")
		@RuneAttribute("ctrctVal")
		public ContractValuationData8__1.ContractValuationData8__1Builder setCtrctVal(AmountAndDirection109__1 _ctrctVal) {
			this.ctrctVal = _ctrctVal == null ? null : _ctrctVal.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("tmStmp")
		@RuneAttribute("tmStmp")
		public ContractValuationData8__1.ContractValuationData8__1Builder setTmStmp(ZonedDateTime _tmStmp) {
			this.tmStmp = _tmStmp == null ? null : _tmStmp;
			return this;
		}
		
		@Override
		@RosettaAttribute("tp")
		@RuneAttribute("tp")
		public ContractValuationData8__1.ContractValuationData8__1Builder setTp(ValuationType1Code _tp) {
			this.tp = _tp == null ? null : _tp;
			return this;
		}
		
		@Override
		@RosettaAttribute("dlta")
		@RuneAttribute("dlta")
		public ContractValuationData8__1.ContractValuationData8__1Builder setDlta(BigDecimal _dlta) {
			this.dlta = _dlta == null ? null : _dlta;
			return this;
		}
		
		@Override
		public ContractValuationData8__1 build() {
			return new ContractValuationData8__1.ContractValuationData8__1Impl(this);
		}
		
		@Override
		public ContractValuationData8__1.ContractValuationData8__1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ContractValuationData8__1.ContractValuationData8__1Builder prune() {
			if (ctrctVal!=null && !ctrctVal.prune().hasData()) ctrctVal = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getCtrctVal()!=null && getCtrctVal().hasData()) return true;
			if (getTmStmp()!=null) return true;
			if (getTp()!=null) return true;
			if (getDlta()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ContractValuationData8__1.ContractValuationData8__1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ContractValuationData8__1.ContractValuationData8__1Builder o = (ContractValuationData8__1.ContractValuationData8__1Builder) other;
			
			merger.mergeRosetta(getCtrctVal(), o.getCtrctVal(), this::setCtrctVal);
			
			merger.mergeBasic(getTmStmp(), o.getTmStmp(), this::setTmStmp);
			merger.mergeBasic(getTp(), o.getTp(), this::setTp);
			merger.mergeBasic(getDlta(), o.getDlta(), this::setDlta);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ContractValuationData8__1 _that = getType().cast(o);
		
			if (!Objects.equals(ctrctVal, _that.getCtrctVal())) return false;
			if (!Objects.equals(tmStmp, _that.getTmStmp())) return false;
			if (!Objects.equals(tp, _that.getTp())) return false;
			if (!Objects.equals(dlta, _that.getDlta())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (ctrctVal != null ? ctrctVal.hashCode() : 0);
			_result = 31 * _result + (tmStmp != null ? tmStmp.hashCode() : 0);
			_result = 31 * _result + (tp != null ? tp.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (dlta != null ? dlta.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ContractValuationData8__1Builder {" +
				"ctrctVal=" + this.ctrctVal + ", " +
				"tmStmp=" + this.tmStmp + ", " +
				"tp=" + this.tp + ", " +
				"dlta=" + this.dlta +
			'}';
		}
	}
}
