package iso20022.auth030.mas;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.mas.GenericIdentification175__1;
import iso20022.auth030.mas.GenericIdentification175__1.GenericIdentification175__1Builder;
import iso20022.auth030.mas.NaturalPersonIdentification2__2;
import iso20022.auth030.mas.NaturalPersonIdentification2__2.NaturalPersonIdentification2__2Builder;
import iso20022.auth030.mas.NaturalPersonIdentification2__2.NaturalPersonIdentification2__2BuilderImpl;
import iso20022.auth030.mas.NaturalPersonIdentification2__2.NaturalPersonIdentification2__2Impl;
import iso20022.auth030.mas.meta.NaturalPersonIdentification2__2Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 1.22.0
 */
@RosettaDataType(value="NaturalPersonIdentification2__2", builder=NaturalPersonIdentification2__2.NaturalPersonIdentification2__2BuilderImpl.class, version="1.22.0")
@RuneDataType(value="NaturalPersonIdentification2__2", model="iso20022", builder=NaturalPersonIdentification2__2.NaturalPersonIdentification2__2BuilderImpl.class, version="1.22.0")
public interface NaturalPersonIdentification2__2 extends RosettaModelObject {

	NaturalPersonIdentification2__2Meta metaData = new NaturalPersonIdentification2__2Meta();

	/*********************** Getter Methods  ***********************/
	GenericIdentification175__1 getId();

	/*********************** Build Methods  ***********************/
	NaturalPersonIdentification2__2 build();
	
	NaturalPersonIdentification2__2.NaturalPersonIdentification2__2Builder toBuilder();
	
	static NaturalPersonIdentification2__2.NaturalPersonIdentification2__2Builder builder() {
		return new NaturalPersonIdentification2__2.NaturalPersonIdentification2__2BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends NaturalPersonIdentification2__2> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends NaturalPersonIdentification2__2> getType() {
		return NaturalPersonIdentification2__2.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("id"), processor, GenericIdentification175__1.class, getId());
	}
	

	/*********************** Builder Interface  ***********************/
	interface NaturalPersonIdentification2__2Builder extends NaturalPersonIdentification2__2, RosettaModelObjectBuilder {
		GenericIdentification175__1.GenericIdentification175__1Builder getOrCreateId();
		@Override
		GenericIdentification175__1.GenericIdentification175__1Builder getId();
		NaturalPersonIdentification2__2.NaturalPersonIdentification2__2Builder setId(GenericIdentification175__1 id);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("id"), processor, GenericIdentification175__1.GenericIdentification175__1Builder.class, getId());
		}
		

		NaturalPersonIdentification2__2.NaturalPersonIdentification2__2Builder prune();
	}

	/*********************** Immutable Implementation of NaturalPersonIdentification2__2  ***********************/
	class NaturalPersonIdentification2__2Impl implements NaturalPersonIdentification2__2 {
		private final GenericIdentification175__1 id;
		
		protected NaturalPersonIdentification2__2Impl(NaturalPersonIdentification2__2.NaturalPersonIdentification2__2Builder builder) {
			this.id = ofNullable(builder.getId()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("id")
		@RuneAttribute("id")
		public GenericIdentification175__1 getId() {
			return id;
		}
		
		@Override
		public NaturalPersonIdentification2__2 build() {
			return this;
		}
		
		@Override
		public NaturalPersonIdentification2__2.NaturalPersonIdentification2__2Builder toBuilder() {
			NaturalPersonIdentification2__2.NaturalPersonIdentification2__2Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(NaturalPersonIdentification2__2.NaturalPersonIdentification2__2Builder builder) {
			ofNullable(getId()).ifPresent(builder::setId);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			NaturalPersonIdentification2__2 _that = getType().cast(o);
		
			if (!Objects.equals(id, _that.getId())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (id != null ? id.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "NaturalPersonIdentification2__2 {" +
				"id=" + this.id +
			'}';
		}
	}

	/*********************** Builder Implementation of NaturalPersonIdentification2__2  ***********************/
	class NaturalPersonIdentification2__2BuilderImpl implements NaturalPersonIdentification2__2.NaturalPersonIdentification2__2Builder {
	
		protected GenericIdentification175__1.GenericIdentification175__1Builder id;
		
		@Override
		@RosettaAttribute("id")
		@RuneAttribute("id")
		public GenericIdentification175__1.GenericIdentification175__1Builder getId() {
			return id;
		}
		
		@Override
		public GenericIdentification175__1.GenericIdentification175__1Builder getOrCreateId() {
			GenericIdentification175__1.GenericIdentification175__1Builder result;
			if (id!=null) {
				result = id;
			}
			else {
				result = id = GenericIdentification175__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("id")
		@RuneAttribute("id")
		public NaturalPersonIdentification2__2.NaturalPersonIdentification2__2Builder setId(GenericIdentification175__1 _id) {
			this.id = _id == null ? null : _id.toBuilder();
			return this;
		}
		
		@Override
		public NaturalPersonIdentification2__2 build() {
			return new NaturalPersonIdentification2__2.NaturalPersonIdentification2__2Impl(this);
		}
		
		@Override
		public NaturalPersonIdentification2__2.NaturalPersonIdentification2__2Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public NaturalPersonIdentification2__2.NaturalPersonIdentification2__2Builder prune() {
			if (id!=null && !id.prune().hasData()) id = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getId()!=null && getId().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public NaturalPersonIdentification2__2.NaturalPersonIdentification2__2Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			NaturalPersonIdentification2__2.NaturalPersonIdentification2__2Builder o = (NaturalPersonIdentification2__2.NaturalPersonIdentification2__2Builder) other;
			
			merger.mergeRosetta(getId(), o.getId(), this::setId);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			NaturalPersonIdentification2__2 _that = getType().cast(o);
		
			if (!Objects.equals(id, _that.getId())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (id != null ? id.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "NaturalPersonIdentification2__2Builder {" +
				"id=" + this.id +
			'}';
		}
	}
}
