package iso20022.dtcc.rds.harmonized;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.dtcc.rds.harmonized.Error;
import iso20022.dtcc.rds.harmonized.Error.ErrorBuilder;
import iso20022.dtcc.rds.harmonized.Error.ErrorBuilderImpl;
import iso20022.dtcc.rds.harmonized.Error.ErrorImpl;
import iso20022.dtcc.rds.harmonized.meta.ErrorMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 1.22.0
 */
@RosettaDataType(value="Error", builder=Error.ErrorBuilderImpl.class, version="1.22.0")
@RuneDataType(value="Error", model="iso20022", builder=Error.ErrorBuilderImpl.class, version="1.22.0")
public interface Error extends RosettaModelObject {

	ErrorMeta metaData = new ErrorMeta();

	/*********************** Getter Methods  ***********************/
	String getErrorCode();
	String getErrorReason();
	String getErrorJurisdiction();
	String getErrorFor();

	/*********************** Build Methods  ***********************/
	Error build();
	
	Error.ErrorBuilder toBuilder();
	
	static Error.ErrorBuilder builder() {
		return new Error.ErrorBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends Error> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends Error> getType() {
		return Error.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("errorCode"), String.class, getErrorCode(), this);
		processor.processBasic(path.newSubPath("errorReason"), String.class, getErrorReason(), this);
		processor.processBasic(path.newSubPath("errorJurisdiction"), String.class, getErrorJurisdiction(), this);
		processor.processBasic(path.newSubPath("errorFor"), String.class, getErrorFor(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface ErrorBuilder extends Error, RosettaModelObjectBuilder {
		Error.ErrorBuilder setErrorCode(String errorCode);
		Error.ErrorBuilder setErrorReason(String errorReason);
		Error.ErrorBuilder setErrorJurisdiction(String errorJurisdiction);
		Error.ErrorBuilder setErrorFor(String errorFor);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("errorCode"), String.class, getErrorCode(), this);
			processor.processBasic(path.newSubPath("errorReason"), String.class, getErrorReason(), this);
			processor.processBasic(path.newSubPath("errorJurisdiction"), String.class, getErrorJurisdiction(), this);
			processor.processBasic(path.newSubPath("errorFor"), String.class, getErrorFor(), this);
		}
		

		Error.ErrorBuilder prune();
	}

	/*********************** Immutable Implementation of Error  ***********************/
	class ErrorImpl implements Error {
		private final String errorCode;
		private final String errorReason;
		private final String errorJurisdiction;
		private final String errorFor;
		
		protected ErrorImpl(Error.ErrorBuilder builder) {
			this.errorCode = builder.getErrorCode();
			this.errorReason = builder.getErrorReason();
			this.errorJurisdiction = builder.getErrorJurisdiction();
			this.errorFor = builder.getErrorFor();
		}
		
		@Override
		@RosettaAttribute("errorCode")
		@RuneAttribute("errorCode")
		public String getErrorCode() {
			return errorCode;
		}
		
		@Override
		@RosettaAttribute("errorReason")
		@RuneAttribute("errorReason")
		public String getErrorReason() {
			return errorReason;
		}
		
		@Override
		@RosettaAttribute("errorJurisdiction")
		@RuneAttribute("errorJurisdiction")
		public String getErrorJurisdiction() {
			return errorJurisdiction;
		}
		
		@Override
		@RosettaAttribute("errorFor")
		@RuneAttribute("errorFor")
		public String getErrorFor() {
			return errorFor;
		}
		
		@Override
		public Error build() {
			return this;
		}
		
		@Override
		public Error.ErrorBuilder toBuilder() {
			Error.ErrorBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(Error.ErrorBuilder builder) {
			ofNullable(getErrorCode()).ifPresent(builder::setErrorCode);
			ofNullable(getErrorReason()).ifPresent(builder::setErrorReason);
			ofNullable(getErrorJurisdiction()).ifPresent(builder::setErrorJurisdiction);
			ofNullable(getErrorFor()).ifPresent(builder::setErrorFor);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			Error _that = getType().cast(o);
		
			if (!Objects.equals(errorCode, _that.getErrorCode())) return false;
			if (!Objects.equals(errorReason, _that.getErrorReason())) return false;
			if (!Objects.equals(errorJurisdiction, _that.getErrorJurisdiction())) return false;
			if (!Objects.equals(errorFor, _that.getErrorFor())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (errorCode != null ? errorCode.hashCode() : 0);
			_result = 31 * _result + (errorReason != null ? errorReason.hashCode() : 0);
			_result = 31 * _result + (errorJurisdiction != null ? errorJurisdiction.hashCode() : 0);
			_result = 31 * _result + (errorFor != null ? errorFor.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "Error {" +
				"errorCode=" + this.errorCode + ", " +
				"errorReason=" + this.errorReason + ", " +
				"errorJurisdiction=" + this.errorJurisdiction + ", " +
				"errorFor=" + this.errorFor +
			'}';
		}
	}

	/*********************** Builder Implementation of Error  ***********************/
	class ErrorBuilderImpl implements Error.ErrorBuilder {
	
		protected String errorCode;
		protected String errorReason;
		protected String errorJurisdiction;
		protected String errorFor;
		
		@Override
		@RosettaAttribute("errorCode")
		@RuneAttribute("errorCode")
		public String getErrorCode() {
			return errorCode;
		}
		
		@Override
		@RosettaAttribute("errorReason")
		@RuneAttribute("errorReason")
		public String getErrorReason() {
			return errorReason;
		}
		
		@Override
		@RosettaAttribute("errorJurisdiction")
		@RuneAttribute("errorJurisdiction")
		public String getErrorJurisdiction() {
			return errorJurisdiction;
		}
		
		@Override
		@RosettaAttribute("errorFor")
		@RuneAttribute("errorFor")
		public String getErrorFor() {
			return errorFor;
		}
		
		@Override
		@RosettaAttribute("errorCode")
		@RuneAttribute("errorCode")
		public Error.ErrorBuilder setErrorCode(String _errorCode) {
			this.errorCode = _errorCode == null ? null : _errorCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("errorReason")
		@RuneAttribute("errorReason")
		public Error.ErrorBuilder setErrorReason(String _errorReason) {
			this.errorReason = _errorReason == null ? null : _errorReason;
			return this;
		}
		
		@Override
		@RosettaAttribute("errorJurisdiction")
		@RuneAttribute("errorJurisdiction")
		public Error.ErrorBuilder setErrorJurisdiction(String _errorJurisdiction) {
			this.errorJurisdiction = _errorJurisdiction == null ? null : _errorJurisdiction;
			return this;
		}
		
		@Override
		@RosettaAttribute("errorFor")
		@RuneAttribute("errorFor")
		public Error.ErrorBuilder setErrorFor(String _errorFor) {
			this.errorFor = _errorFor == null ? null : _errorFor;
			return this;
		}
		
		@Override
		public Error build() {
			return new Error.ErrorImpl(this);
		}
		
		@Override
		public Error.ErrorBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public Error.ErrorBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getErrorCode()!=null) return true;
			if (getErrorReason()!=null) return true;
			if (getErrorJurisdiction()!=null) return true;
			if (getErrorFor()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public Error.ErrorBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			Error.ErrorBuilder o = (Error.ErrorBuilder) other;
			
			
			merger.mergeBasic(getErrorCode(), o.getErrorCode(), this::setErrorCode);
			merger.mergeBasic(getErrorReason(), o.getErrorReason(), this::setErrorReason);
			merger.mergeBasic(getErrorJurisdiction(), o.getErrorJurisdiction(), this::setErrorJurisdiction);
			merger.mergeBasic(getErrorFor(), o.getErrorFor(), this::setErrorFor);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			Error _that = getType().cast(o);
		
			if (!Objects.equals(errorCode, _that.getErrorCode())) return false;
			if (!Objects.equals(errorReason, _that.getErrorReason())) return false;
			if (!Objects.equals(errorJurisdiction, _that.getErrorJurisdiction())) return false;
			if (!Objects.equals(errorFor, _that.getErrorFor())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (errorCode != null ? errorCode.hashCode() : 0);
			_result = 31 * _result + (errorReason != null ? errorReason.hashCode() : 0);
			_result = 31 * _result + (errorJurisdiction != null ? errorJurisdiction.hashCode() : 0);
			_result = 31 * _result + (errorFor != null ? errorFor.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ErrorBuilder {" +
				"errorCode=" + this.errorCode + ", " +
				"errorReason=" + this.errorReason + ", " +
				"errorJurisdiction=" + this.errorJurisdiction + ", " +
				"errorFor=" + this.errorFor +
			'}';
		}
	}
}
