package iso20022.dtcc.rds.harmonized;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.dtcc.rds.harmonized.SubmissionWrapper;
import iso20022.dtcc.rds.harmonized.SubmissionWrapper.SubmissionWrapperBuilder;
import iso20022.dtcc.rds.harmonized.SubmissionWrapper.SubmissionWrapperBuilderImpl;
import iso20022.dtcc.rds.harmonized.SubmissionWrapper.SubmissionWrapperImpl;
import iso20022.dtcc.rds.harmonized.meta.SubmissionWrapperMeta;


/**
 * @version 1.22.0
 */
@RosettaDataType(value="SubmissionWrapper", builder=SubmissionWrapper.SubmissionWrapperBuilderImpl.class, version="1.22.0")
@RuneDataType(value="SubmissionWrapper", model="iso20022", builder=SubmissionWrapper.SubmissionWrapperBuilderImpl.class, version="1.22.0")
public interface SubmissionWrapper extends RosettaModelObject {

	SubmissionWrapperMeta metaData = new SubmissionWrapperMeta();

	/*********************** Getter Methods  ***********************/

	/*********************** Build Methods  ***********************/
	SubmissionWrapper build();
	
	SubmissionWrapper.SubmissionWrapperBuilder toBuilder();
	
	static SubmissionWrapper.SubmissionWrapperBuilder builder() {
		return new SubmissionWrapper.SubmissionWrapperBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends SubmissionWrapper> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends SubmissionWrapper> getType() {
		return SubmissionWrapper.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
	}
	

	/*********************** Builder Interface  ***********************/
	interface SubmissionWrapperBuilder extends SubmissionWrapper, RosettaModelObjectBuilder {

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
		}
		

		SubmissionWrapper.SubmissionWrapperBuilder prune();
	}

	/*********************** Immutable Implementation of SubmissionWrapper  ***********************/
	class SubmissionWrapperImpl implements SubmissionWrapper {
		
		protected SubmissionWrapperImpl(SubmissionWrapper.SubmissionWrapperBuilder builder) {
		}
		
		@Override
		public SubmissionWrapper build() {
			return this;
		}
		
		@Override
		public SubmissionWrapper.SubmissionWrapperBuilder toBuilder() {
			SubmissionWrapper.SubmissionWrapperBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(SubmissionWrapper.SubmissionWrapperBuilder builder) {
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
		
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			return _result;
		}
		
		@Override
		public String toString() {
			return "SubmissionWrapper {" +
			'}';
		}
	}

	/*********************** Builder Implementation of SubmissionWrapper  ***********************/
	class SubmissionWrapperBuilderImpl implements SubmissionWrapper.SubmissionWrapperBuilder {
	
		
		@Override
		public SubmissionWrapper build() {
			return new SubmissionWrapper.SubmissionWrapperImpl(this);
		}
		
		@Override
		public SubmissionWrapper.SubmissionWrapperBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SubmissionWrapper.SubmissionWrapperBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public SubmissionWrapper.SubmissionWrapperBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			SubmissionWrapper.SubmissionWrapperBuilder o = (SubmissionWrapper.SubmissionWrapperBuilder) other;
			
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
		
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			return _result;
		}
		
		@Override
		public String toString() {
			return "SubmissionWrapperBuilder {" +
			'}';
		}
	}
}
