package iso20022.dtcc.rds.harmonized.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.dtcc.rds.harmonized.Error;
import iso20022.dtcc.rds.harmonized.validation.ErrorTypeFormatValidator;
import iso20022.dtcc.rds.harmonized.validation.ErrorValidator;
import iso20022.dtcc.rds.harmonized.validation.exists.ErrorOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 1.22.0
 */
@RosettaMeta(model=Error.class)
public class ErrorMeta implements RosettaMetaData<Error> {

	@Override
	public List<Validator<? super Error>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super Error, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super Error> validator(ValidatorFactory factory) {
		return factory.<Error>create(ErrorValidator.class);
	}

	@Override
	public Validator<? super Error> typeFormatValidator(ValidatorFactory factory) {
		return factory.<Error>create(ErrorTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super Error> validator() {
		return new ErrorValidator();
	}

	@Deprecated
	@Override
	public Validator<? super Error> typeFormatValidator() {
		return new ErrorTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super Error, Set<String>> onlyExistsValidator() {
		return new ErrorOnlyExistsValidator();
	}
}
