package iso20022.dtcc.rds.harmonized.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import iso20022.dtcc.rds.harmonized.GenericAttribute;
import java.util.List;
import java.util.regex.Pattern;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class GenericAttributeTypeFormatValidator implements Validator<GenericAttribute> {

	private List<ComparisonResult> getComparisonResults(GenericAttribute o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("attributeScheme", o.getAttributeScheme(), 0, empty(), of(Pattern.compile("\\w+:(\\/?\\/?)[^\\s]+")))
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, GenericAttribute o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("GenericAttribute", ValidationType.TYPE_FORMAT, "GenericAttribute", path, "", res.getError());
				}
				return success("GenericAttribute", ValidationType.TYPE_FORMAT, "GenericAttribute", path, "");
			})
			.collect(toList());
	}

}
