/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.joda.beans.Bean;
import org.joda.beans.MetaBean;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.BasicMetaProperty;

public final class StandaloneMetaProperty<P>
extends BasicMetaProperty<P> {
    private final MetaBean metaBean;
    private final Class<P> clazz;
    private final Type type;

    public static <R> StandaloneMetaProperty<R> of(String propertyName, MetaBean metaBean, Class<R> clazz) {
        return new StandaloneMetaProperty<R>(propertyName, metaBean, clazz, clazz);
    }

    public static <R> StandaloneMetaProperty<R> of(String propertyName, MetaBean metaBean, Class<R> clazz, Type type) {
        return new StandaloneMetaProperty<R>(propertyName, metaBean, clazz, type);
    }

    private StandaloneMetaProperty(String propertyName, MetaBean metaBean, Class<P> clazz, Type type) {
        super(propertyName);
        if (metaBean == null) {
            throw new NullPointerException("MetaBean must not be null");
        }
        if (clazz == null) {
            throw new NullPointerException("Class must not be null");
        }
        if (type == null) {
            throw new NullPointerException("Type must not be null");
        }
        this.metaBean = metaBean;
        this.clazz = clazz;
        this.type = type;
    }

    @Override
    public MetaBean metaBean() {
        return this.metaBean;
    }

    @Override
    public Class<?> declaringType() {
        return this.metaBean().beanType();
    }

    @Override
    public Class<P> propertyType() {
        return this.clazz;
    }

    @Override
    public Type propertyGenericType() {
        return this.type;
    }

    @Override
    public PropertyStyle style() {
        return PropertyStyle.READ_WRITE;
    }

    @Override
    public List<Annotation> annotations() {
        return Collections.emptyList();
    }

    @Override
    public P get(Bean bean) {
        return this.clazz.cast(this.metaBean().metaProperty(this.name()).get(bean));
    }

    @Override
    public void set(Bean bean, Object value) {
        this.metaBean().metaProperty(this.name()).set(bean, value);
    }
}

