/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.bin;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.joda.beans.ser.bin.MsgPack;

final class MsgPackOutput
extends MsgPack {
    private final DataOutputStream output;

    MsgPackOutput(OutputStream stream) {
        this.output = new DataOutputStream(stream);
    }

    MsgPackOutput(DataOutputStream stream) {
        this.output = stream;
    }

    void writeNil() throws IOException {
        this.output.writeByte(-64);
    }

    void writeBoolean(boolean value) throws IOException {
        if (value) {
            this.output.writeByte(-61);
        } else {
            this.output.writeByte(-62);
        }
    }

    void writeInt(int value) throws IOException {
        if (value < -32) {
            if (value >= -128) {
                this.output.writeByte(-48);
                this.output.writeByte((byte)value);
            } else if (value >= Short.MIN_VALUE) {
                this.output.writeByte(-47);
                this.output.writeShort((short)value);
            } else {
                this.output.writeByte(-46);
                this.output.writeInt(value);
            }
        } else if (value < 127) {
            this.output.writeByte(value);
        } else if (value < 255) {
            this.output.writeByte(-52);
            this.output.writeByte((byte)value);
        } else if (value < 65535) {
            this.output.writeByte(-51);
            this.output.writeShort((short)value);
        } else {
            this.output.writeByte(-50);
            this.output.writeInt(value);
        }
    }

    void writeLong(long value) throws IOException {
        if (value < -32L) {
            if (value >= -128L) {
                this.output.writeByte(-48);
                this.output.writeByte((byte)value);
            } else if (value >= -32768L) {
                this.output.writeByte(-47);
                this.output.writeShort((short)value);
            } else if (value >= Integer.MIN_VALUE) {
                this.output.writeByte(-46);
                this.output.writeInt((int)value);
            } else {
                this.output.writeByte(-45);
                this.output.writeLong(value);
            }
        } else if (value < 127L) {
            this.output.writeByte((byte)value);
        } else if (value < 255L) {
            this.output.writeByte(-52);
            this.output.writeByte((byte)value);
        } else if (value < 65535L) {
            this.output.writeByte(-51);
            this.output.writeShort((short)value);
        } else if (value < 0xFFFFFFFFL) {
            this.output.writeByte(-50);
            this.output.writeInt((int)value);
        } else {
            this.output.writeByte(-49);
            this.output.writeLong(value);
        }
    }

    void writeFloat(float value) throws IOException {
        this.output.writeByte(-54);
        this.output.writeFloat(value);
    }

    void writeDouble(double value) throws IOException {
        this.output.writeByte(-53);
        this.output.writeDouble(value);
    }

    void writeBytes(byte[] bytes) throws IOException {
        int size = bytes.length;
        if (size < 256) {
            this.output.writeByte(-60);
            this.output.writeByte(size);
        } else if (size < 65536) {
            this.output.writeByte(-59);
            this.output.writeShort(size);
        } else {
            this.output.writeByte(-58);
            this.output.writeInt(size);
        }
        this.output.write(bytes);
    }

    void writeString(String value) throws IOException {
        byte[] bytes = this.toUTF8(value);
        int size = bytes.length;
        if (size < 32) {
            this.output.writeByte(-96 + size);
        } else if (size < 256) {
            this.output.writeByte(-39);
            this.output.writeByte(size);
        } else if (size < 65536) {
            this.output.writeByte(-38);
            this.output.writeShort(size);
        } else {
            this.output.writeByte(-37);
            this.output.writeInt(size);
        }
        this.output.write(bytes);
    }

    private byte[] toUTF8(String value) {
        int size = value.length();
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            char ch = value.charAt(i);
            if (ch >= '\u0080') {
                return value.getBytes(UTF_8);
            }
            bytes[i] = (byte)ch;
        }
        return bytes;
    }

    void writeArrayHeader(int size) throws IOException {
        if (size < 16) {
            this.output.writeByte(-112 + size);
        } else if (size < 65536) {
            this.output.writeByte(-36);
            this.output.writeShort(size);
        } else {
            this.output.writeByte(-35);
            this.output.writeInt(size);
        }
    }

    void writeMapHeader(int size) throws IOException {
        if (size < 16) {
            this.output.writeByte(-128 + size);
        } else if (size < 65536) {
            this.output.writeByte(-34);
            this.output.writeShort(size);
        } else {
            this.output.writeByte(-33);
            this.output.writeInt(size);
        }
    }

    void writeExtensionByte(int extensionType, int value) throws IOException {
        this.output.write(-44);
        this.output.write(extensionType);
        this.output.write(value);
    }

    void writeExtensionString(int extensionType, String str) throws IOException {
        byte[] bytes = str.getBytes(UTF_8);
        if (bytes.length > 256) {
            throw new IllegalArgumentException("String too long");
        }
        this.output.write(-57);
        this.output.write(bytes.length);
        this.output.write(extensionType);
        this.output.write(bytes);
    }
}

