/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.validation.datarule;

import cdm.base.datetime.DateRange;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="DateRangeDatesOrdered")
@ImplementedBy(value=Default.class)
public interface DateRangeDatesOrdered
extends Validator<DateRange> {
    public static final String NAME = "DateRangeDatesOrdered";
    public static final String DEFINITION = "startDate <= endDate";

    public static class NoOp
    implements DateRangeDatesOrdered {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, DateRange dateRange) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements DateRangeDatesOrdered {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, DateRange dateRange) {
            ComparisonResult result = this.executeDataRule(dateRange);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)DateRangeDatesOrdered.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"DateRange", (RosettaPath)path, (String)DateRangeDatesOrdered.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)DateRangeDatesOrdered.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"DateRange", (RosettaPath)path, (String)DateRangeDatesOrdered.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(DateRange dateRange) {
            try {
                return ExpressionOperators.lessThanEquals((Mapper)MapperS.of((Object)dateRange).map("getStartDate", _dateRange -> _dateRange.getStartDate()), (Mapper)MapperS.of((Object)dateRange).map("getEndDate", _dateRange -> _dateRange.getEndDate()), (CardinalityOperator)CardinalityOperator.All);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

