/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.functions;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.QuantitySchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=FilterQuantityByFinancialUnitDefault.class)
public abstract class FilterQuantityByFinancialUnit
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends QuantitySchedule> evaluate(List<? extends QuantitySchedule> quantities, FinancialUnitEnum financialUnit) {
        List filteredQuantities;
        List<QuantitySchedule.QuantityScheduleBuilder> filteredQuantitiesBuilder = this.doEvaluate(quantities, financialUnit);
        if (filteredQuantitiesBuilder == null) {
            filteredQuantities = null;
        } else {
            filteredQuantities = filteredQuantitiesBuilder.stream().map(QuantitySchedule::build).collect(Collectors.toList());
            this.objectValidator.validate(QuantitySchedule.class, filteredQuantities);
        }
        return filteredQuantities;
    }

    protected abstract List<QuantitySchedule.QuantityScheduleBuilder> doEvaluate(List<? extends QuantitySchedule> var1, FinancialUnitEnum var2);

    public static class FilterQuantityByFinancialUnitDefault
    extends FilterQuantityByFinancialUnit {
        @Override
        protected List<QuantitySchedule.QuantityScheduleBuilder> doEvaluate(List<? extends QuantitySchedule> quantities, FinancialUnitEnum financialUnit) {
            if (quantities == null) {
                quantities = Collections.emptyList();
            }
            ArrayList<QuantitySchedule.QuantityScheduleBuilder> filteredQuantities = new ArrayList<QuantitySchedule.QuantityScheduleBuilder>();
            return this.assignOutput(filteredQuantities, quantities, financialUnit);
        }

        protected List<QuantitySchedule.QuantityScheduleBuilder> assignOutput(List<QuantitySchedule.QuantityScheduleBuilder> filteredQuantities, List<? extends QuantitySchedule> quantities, FinancialUnitEnum financialUnit) {
            filteredQuantities.addAll(this.toBuilder(MapperC.of(quantities).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getUnit", quantitySchedule -> quantitySchedule.getUnit()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit()), (Mapper)MapperS.of((Object)((Object)financialUnit)), (CardinalityOperator)CardinalityOperator.All).get()).getMulti()));
            return Optional.ofNullable(filteredQuantities).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

