/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.functions;

import cdm.base.math.RoundingDirectionEnum;
import cdm.base.math.functions.RoundToSignificantFigures;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class RoundToSignificantFiguresImpl
extends RoundToSignificantFigures {
    @Override
    protected BigDecimal doEvaluate(BigDecimal value, Integer significantFigures, RoundingDirectionEnum roundingMode) {
        if (value == null) {
            return null;
        }
        if (significantFigures == null || roundingMode == null) {
            return value;
        }
        return value.round(new MathContext(significantFigures, this.toRoundingMode(roundingMode)));
    }

    private RoundingMode toRoundingMode(RoundingDirectionEnum roundingMode) {
        switch (roundingMode) {
            case UP: {
                return RoundingMode.UP;
            }
            case DOWN: {
                return RoundingMode.DOWN;
            }
            case NEAREST: {
                return RoundingMode.HALF_UP;
            }
        }
        throw new IllegalArgumentException("Unsupported RoundingDirectionEnum " + (Object)((Object)roundingMode));
    }
}

