/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.CompoundingTypeEnum;
import cdm.base.datetime.RoundingFrequencyEnum;
import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.base.math.Rounding;
import cdm.product.collateral.CollateralAgreementFloatingRate;
import cdm.product.collateral.meta.CollateralInterestCalculationParametersMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CollateralInterestCalculationParameters", builder=CollateralInterestCalculationParametersBuilderImpl.class, version="5.29.0")
@RuneDataType(value="CollateralInterestCalculationParameters", model="cdm", builder=CollateralInterestCalculationParametersBuilderImpl.class, version="5.29.0")
public interface CollateralInterestCalculationParameters
extends RosettaModelObject {
    public static final CollateralInterestCalculationParametersMeta metaData = new CollateralInterestCalculationParametersMeta();

    public BigDecimal getFixedRate();

    public CollateralAgreementFloatingRate getFloatingRate();

    public Boolean getInBaseCurrency();

    public CompoundingTypeEnum getCompoundingType();

    public List<BusinessCenterEnum> getCompoundingBusinessCenter();

    public DayCountFractionEnum getDayCountFraction();

    public Rounding getRounding();

    public RoundingFrequencyEnum getRoundingFrequency();

    public BigDecimal getWithholdingTaxRate();

    public CollateralInterestCalculationParameters build();

    public CollateralInterestCalculationParametersBuilder toBuilder();

    public static CollateralInterestCalculationParametersBuilder builder() {
        return new CollateralInterestCalculationParametersBuilderImpl();
    }

    default public RosettaMetaData<? extends CollateralInterestCalculationParameters> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CollateralInterestCalculationParameters> getType() {
        return CollateralInterestCalculationParameters.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingRate"), processor, CollateralAgreementFloatingRate.class, this.getFloatingRate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("inBaseCurrency"), Boolean.class, (Object)this.getInBaseCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("compoundingType"), CompoundingTypeEnum.class, (Object)this.getCompoundingType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("compoundingBusinessCenter"), BusinessCenterEnum.class, this.getCompoundingBusinessCenter(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayCountFraction"), DayCountFractionEnum.class, (Object)this.getDayCountFraction(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rounding"), processor, Rounding.class, this.getRounding(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("roundingFrequency"), RoundingFrequencyEnum.class, (Object)this.getRoundingFrequency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("withholdingTaxRate"), BigDecimal.class, (Object)this.getWithholdingTaxRate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CollateralInterestCalculationParametersBuilderImpl
    implements CollateralInterestCalculationParametersBuilder {
        protected BigDecimal fixedRate;
        protected CollateralAgreementFloatingRate.CollateralAgreementFloatingRateBuilder floatingRate;
        protected Boolean inBaseCurrency;
        protected CompoundingTypeEnum compoundingType;
        protected List<BusinessCenterEnum> compoundingBusinessCenter = new ArrayList<BusinessCenterEnum>();
        protected DayCountFractionEnum dayCountFraction;
        protected Rounding.RoundingBuilder rounding;
        protected RoundingFrequencyEnum roundingFrequency;
        protected BigDecimal withholdingTaxRate;

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        @RosettaAttribute(value="floatingRate")
        @RuneAttribute(value="floatingRate")
        public CollateralAgreementFloatingRate.CollateralAgreementFloatingRateBuilder getFloatingRate() {
            return this.floatingRate;
        }

        @Override
        public CollateralAgreementFloatingRate.CollateralAgreementFloatingRateBuilder getOrCreateFloatingRate() {
            CollateralAgreementFloatingRate.CollateralAgreementFloatingRateBuilder result = this.floatingRate != null ? this.floatingRate : (this.floatingRate = CollateralAgreementFloatingRate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="inBaseCurrency", isRequired=true)
        @RuneAttribute(value="inBaseCurrency", isRequired=true)
        public Boolean getInBaseCurrency() {
            return this.inBaseCurrency;
        }

        @Override
        @RosettaAttribute(value="compoundingType")
        @RuneAttribute(value="compoundingType")
        public CompoundingTypeEnum getCompoundingType() {
            return this.compoundingType;
        }

        @Override
        @RosettaAttribute(value="compoundingBusinessCenter")
        @RuneAttribute(value="compoundingBusinessCenter")
        public List<BusinessCenterEnum> getCompoundingBusinessCenter() {
            return this.compoundingBusinessCenter;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public DayCountFractionEnum getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public Rounding.RoundingBuilder getRounding() {
            return this.rounding;
        }

        @Override
        public Rounding.RoundingBuilder getOrCreateRounding() {
            Rounding.RoundingBuilder result = this.rounding != null ? this.rounding : (this.rounding = Rounding.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="roundingFrequency")
        @RuneAttribute(value="roundingFrequency")
        public RoundingFrequencyEnum getRoundingFrequency() {
            return this.roundingFrequency;
        }

        @Override
        @RosettaAttribute(value="withholdingTaxRate")
        @RuneAttribute(value="withholdingTaxRate")
        public BigDecimal getWithholdingTaxRate() {
            return this.withholdingTaxRate;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public CollateralInterestCalculationParametersBuilder setFixedRate(BigDecimal _fixedRate) {
            this.fixedRate = _fixedRate == null ? null : _fixedRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRate")
        @RuneAttribute(value="floatingRate")
        public CollateralInterestCalculationParametersBuilder setFloatingRate(CollateralAgreementFloatingRate _floatingRate) {
            this.floatingRate = _floatingRate == null ? null : _floatingRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="inBaseCurrency", isRequired=true)
        @RuneAttribute(value="inBaseCurrency", isRequired=true)
        public CollateralInterestCalculationParametersBuilder setInBaseCurrency(Boolean _inBaseCurrency) {
            this.inBaseCurrency = _inBaseCurrency == null ? null : _inBaseCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="compoundingType")
        @RuneAttribute(value="compoundingType")
        public CollateralInterestCalculationParametersBuilder setCompoundingType(CompoundingTypeEnum _compoundingType) {
            this.compoundingType = _compoundingType == null ? null : _compoundingType;
            return this;
        }

        @Override
        @RosettaAttribute(value="compoundingBusinessCenter")
        @RuneAttribute(value="compoundingBusinessCenter")
        public CollateralInterestCalculationParametersBuilder addCompoundingBusinessCenter(BusinessCenterEnum _compoundingBusinessCenter) {
            if (_compoundingBusinessCenter != null) {
                this.compoundingBusinessCenter.add(_compoundingBusinessCenter);
            }
            return this;
        }

        @Override
        public CollateralInterestCalculationParametersBuilder addCompoundingBusinessCenter(BusinessCenterEnum _compoundingBusinessCenter, int idx) {
            this.getIndex(this.compoundingBusinessCenter, idx, () -> _compoundingBusinessCenter);
            return this;
        }

        @Override
        public CollateralInterestCalculationParametersBuilder addCompoundingBusinessCenter(List<BusinessCenterEnum> compoundingBusinessCenters) {
            if (compoundingBusinessCenters != null) {
                for (BusinessCenterEnum toAdd : compoundingBusinessCenters) {
                    this.compoundingBusinessCenter.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="compoundingBusinessCenter")
        public CollateralInterestCalculationParametersBuilder setCompoundingBusinessCenter(List<BusinessCenterEnum> compoundingBusinessCenters) {
            this.compoundingBusinessCenter = compoundingBusinessCenters == null ? new ArrayList<BusinessCenterEnum>() : (List)compoundingBusinessCenters.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public CollateralInterestCalculationParametersBuilder setDayCountFraction(DayCountFractionEnum _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction;
            return this;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public CollateralInterestCalculationParametersBuilder setRounding(Rounding _rounding) {
            this.rounding = _rounding == null ? null : _rounding.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="roundingFrequency")
        @RuneAttribute(value="roundingFrequency")
        public CollateralInterestCalculationParametersBuilder setRoundingFrequency(RoundingFrequencyEnum _roundingFrequency) {
            this.roundingFrequency = _roundingFrequency == null ? null : _roundingFrequency;
            return this;
        }

        @Override
        @RosettaAttribute(value="withholdingTaxRate")
        @RuneAttribute(value="withholdingTaxRate")
        public CollateralInterestCalculationParametersBuilder setWithholdingTaxRate(BigDecimal _withholdingTaxRate) {
            this.withholdingTaxRate = _withholdingTaxRate == null ? null : _withholdingTaxRate;
            return this;
        }

        @Override
        public CollateralInterestCalculationParameters build() {
            return new CollateralInterestCalculationParametersImpl(this);
        }

        @Override
        public CollateralInterestCalculationParametersBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralInterestCalculationParametersBuilder prune() {
            if (this.floatingRate != null && !this.floatingRate.prune().hasData()) {
                this.floatingRate = null;
            }
            if (this.rounding != null && !this.rounding.prune().hasData()) {
                this.rounding = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFixedRate() != null) {
                return true;
            }
            if (this.getFloatingRate() != null && this.getFloatingRate().hasData()) {
                return true;
            }
            if (this.getInBaseCurrency() != null) {
                return true;
            }
            if (this.getCompoundingType() != null) {
                return true;
            }
            if (this.getCompoundingBusinessCenter() != null && !this.getCompoundingBusinessCenter().isEmpty()) {
                return true;
            }
            if (this.getDayCountFraction() != null) {
                return true;
            }
            if (this.getRounding() != null && this.getRounding().hasData()) {
                return true;
            }
            if (this.getRoundingFrequency() != null) {
                return true;
            }
            return this.getWithholdingTaxRate() != null;
        }

        public CollateralInterestCalculationParametersBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralInterestCalculationParametersBuilder o = (CollateralInterestCalculationParametersBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingRate(), (RosettaModelObjectBuilder)o.getFloatingRate(), this::setFloatingRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRounding(), (RosettaModelObjectBuilder)o.getRounding(), this::setRounding);
            merger.mergeBasic((Object)this.getFixedRate(), (Object)o.getFixedRate(), this::setFixedRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInBaseCurrency(), (Object)o.getInBaseCurrency(), this::setInBaseCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCompoundingType(), (Object)o.getCompoundingType(), this::setCompoundingType, new AttributeMeta[0]);
            merger.mergeBasic(this.getCompoundingBusinessCenter(), o.getCompoundingBusinessCenter(), this::addCompoundingBusinessCenter);
            merger.mergeBasic((Object)this.getDayCountFraction(), (Object)o.getDayCountFraction(), this::setDayCountFraction, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRoundingFrequency(), (Object)o.getRoundingFrequency(), this::setRoundingFrequency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getWithholdingTaxRate(), (Object)o.getWithholdingTaxRate(), this::setWithholdingTaxRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralInterestCalculationParameters _that = this.getType().cast(o);
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.floatingRate, _that.getFloatingRate())) {
                return false;
            }
            if (!Objects.equals(this.inBaseCurrency, _that.getInBaseCurrency())) {
                return false;
            }
            if (!Objects.equals((Object)this.compoundingType, (Object)_that.getCompoundingType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.compoundingBusinessCenter, _that.getCompoundingBusinessCenter())) {
                return false;
            }
            if (!Objects.equals((Object)this.dayCountFraction, (Object)_that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.rounding, _that.getRounding())) {
                return false;
            }
            if (!Objects.equals((Object)this.roundingFrequency, (Object)_that.getRoundingFrequency())) {
                return false;
            }
            return Objects.equals(this.withholdingTaxRate, _that.getWithholdingTaxRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.floatingRate != null ? this.floatingRate.hashCode() : 0);
            _result = 31 * _result + (this.inBaseCurrency != null ? this.inBaseCurrency.hashCode() : 0);
            _result = 31 * _result + (this.compoundingType != null ? ((Object)((Object)this.compoundingType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.compoundingBusinessCenter != null ? this.compoundingBusinessCenter.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? ((Object)((Object)this.dayCountFraction)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            _result = 31 * _result + (this.roundingFrequency != null ? ((Object)((Object)this.roundingFrequency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.withholdingTaxRate != null ? this.withholdingTaxRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralInterestCalculationParametersBuilder {fixedRate=" + this.fixedRate + ", floatingRate=" + this.floatingRate + ", inBaseCurrency=" + this.inBaseCurrency + ", compoundingType=" + (Object)((Object)this.compoundingType) + ", compoundingBusinessCenter=" + this.compoundingBusinessCenter + ", dayCountFraction=" + (Object)((Object)this.dayCountFraction) + ", rounding=" + this.rounding + ", roundingFrequency=" + (Object)((Object)this.roundingFrequency) + ", withholdingTaxRate=" + this.withholdingTaxRate + '}';
        }
    }

    public static interface CollateralInterestCalculationParametersBuilder
    extends CollateralInterestCalculationParameters,
    RosettaModelObjectBuilder {
        public CollateralAgreementFloatingRate.CollateralAgreementFloatingRateBuilder getOrCreateFloatingRate();

        @Override
        public CollateralAgreementFloatingRate.CollateralAgreementFloatingRateBuilder getFloatingRate();

        public Rounding.RoundingBuilder getOrCreateRounding();

        @Override
        public Rounding.RoundingBuilder getRounding();

        public CollateralInterestCalculationParametersBuilder setFixedRate(BigDecimal var1);

        public CollateralInterestCalculationParametersBuilder setFloatingRate(CollateralAgreementFloatingRate var1);

        public CollateralInterestCalculationParametersBuilder setInBaseCurrency(Boolean var1);

        public CollateralInterestCalculationParametersBuilder setCompoundingType(CompoundingTypeEnum var1);

        public CollateralInterestCalculationParametersBuilder addCompoundingBusinessCenter(BusinessCenterEnum var1);

        public CollateralInterestCalculationParametersBuilder addCompoundingBusinessCenter(BusinessCenterEnum var1, int var2);

        public CollateralInterestCalculationParametersBuilder addCompoundingBusinessCenter(List<BusinessCenterEnum> var1);

        public CollateralInterestCalculationParametersBuilder setCompoundingBusinessCenter(List<BusinessCenterEnum> var1);

        public CollateralInterestCalculationParametersBuilder setDayCountFraction(DayCountFractionEnum var1);

        public CollateralInterestCalculationParametersBuilder setRounding(Rounding var1);

        public CollateralInterestCalculationParametersBuilder setRoundingFrequency(RoundingFrequencyEnum var1);

        public CollateralInterestCalculationParametersBuilder setWithholdingTaxRate(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingRate"), processor, CollateralAgreementFloatingRate.CollateralAgreementFloatingRateBuilder.class, this.getFloatingRate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("inBaseCurrency"), Boolean.class, (Object)this.getInBaseCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("compoundingType"), CompoundingTypeEnum.class, (Object)this.getCompoundingType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("compoundingBusinessCenter"), BusinessCenterEnum.class, this.getCompoundingBusinessCenter(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayCountFraction"), DayCountFractionEnum.class, (Object)this.getDayCountFraction(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rounding"), processor, Rounding.RoundingBuilder.class, this.getRounding(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("roundingFrequency"), RoundingFrequencyEnum.class, (Object)this.getRoundingFrequency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("withholdingTaxRate"), BigDecimal.class, (Object)this.getWithholdingTaxRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CollateralInterestCalculationParametersBuilder prune();
    }

    public static class CollateralInterestCalculationParametersImpl
    implements CollateralInterestCalculationParameters {
        private final BigDecimal fixedRate;
        private final CollateralAgreementFloatingRate floatingRate;
        private final Boolean inBaseCurrency;
        private final CompoundingTypeEnum compoundingType;
        private final List<BusinessCenterEnum> compoundingBusinessCenter;
        private final DayCountFractionEnum dayCountFraction;
        private final Rounding rounding;
        private final RoundingFrequencyEnum roundingFrequency;
        private final BigDecimal withholdingTaxRate;

        protected CollateralInterestCalculationParametersImpl(CollateralInterestCalculationParametersBuilder builder) {
            this.fixedRate = builder.getFixedRate();
            this.floatingRate = Optional.ofNullable(builder.getFloatingRate()).map(f -> f.build()).orElse(null);
            this.inBaseCurrency = builder.getInBaseCurrency();
            this.compoundingType = builder.getCompoundingType();
            this.compoundingBusinessCenter = Optional.ofNullable(builder.getCompoundingBusinessCenter()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.dayCountFraction = builder.getDayCountFraction();
            this.rounding = Optional.ofNullable(builder.getRounding()).map(f -> f.build()).orElse(null);
            this.roundingFrequency = builder.getRoundingFrequency();
            this.withholdingTaxRate = builder.getWithholdingTaxRate();
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        @RosettaAttribute(value="floatingRate")
        @RuneAttribute(value="floatingRate")
        public CollateralAgreementFloatingRate getFloatingRate() {
            return this.floatingRate;
        }

        @Override
        @RosettaAttribute(value="inBaseCurrency", isRequired=true)
        @RuneAttribute(value="inBaseCurrency", isRequired=true)
        public Boolean getInBaseCurrency() {
            return this.inBaseCurrency;
        }

        @Override
        @RosettaAttribute(value="compoundingType")
        @RuneAttribute(value="compoundingType")
        public CompoundingTypeEnum getCompoundingType() {
            return this.compoundingType;
        }

        @Override
        @RosettaAttribute(value="compoundingBusinessCenter")
        @RuneAttribute(value="compoundingBusinessCenter")
        public List<BusinessCenterEnum> getCompoundingBusinessCenter() {
            return this.compoundingBusinessCenter;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public DayCountFractionEnum getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public Rounding getRounding() {
            return this.rounding;
        }

        @Override
        @RosettaAttribute(value="roundingFrequency")
        @RuneAttribute(value="roundingFrequency")
        public RoundingFrequencyEnum getRoundingFrequency() {
            return this.roundingFrequency;
        }

        @Override
        @RosettaAttribute(value="withholdingTaxRate")
        @RuneAttribute(value="withholdingTaxRate")
        public BigDecimal getWithholdingTaxRate() {
            return this.withholdingTaxRate;
        }

        @Override
        public CollateralInterestCalculationParameters build() {
            return this;
        }

        @Override
        public CollateralInterestCalculationParametersBuilder toBuilder() {
            CollateralInterestCalculationParametersBuilder builder = CollateralInterestCalculationParameters.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralInterestCalculationParametersBuilder builder) {
            Optional.ofNullable(this.getFixedRate()).ifPresent(builder::setFixedRate);
            Optional.ofNullable(this.getFloatingRate()).ifPresent(builder::setFloatingRate);
            Optional.ofNullable(this.getInBaseCurrency()).ifPresent(builder::setInBaseCurrency);
            Optional.ofNullable(this.getCompoundingType()).ifPresent(builder::setCompoundingType);
            Optional.ofNullable(this.getCompoundingBusinessCenter()).ifPresent(builder::setCompoundingBusinessCenter);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
            Optional.ofNullable(this.getRounding()).ifPresent(builder::setRounding);
            Optional.ofNullable(this.getRoundingFrequency()).ifPresent(builder::setRoundingFrequency);
            Optional.ofNullable(this.getWithholdingTaxRate()).ifPresent(builder::setWithholdingTaxRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralInterestCalculationParameters _that = this.getType().cast(o);
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.floatingRate, _that.getFloatingRate())) {
                return false;
            }
            if (!Objects.equals(this.inBaseCurrency, _that.getInBaseCurrency())) {
                return false;
            }
            if (!Objects.equals((Object)this.compoundingType, (Object)_that.getCompoundingType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.compoundingBusinessCenter, _that.getCompoundingBusinessCenter())) {
                return false;
            }
            if (!Objects.equals((Object)this.dayCountFraction, (Object)_that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.rounding, _that.getRounding())) {
                return false;
            }
            if (!Objects.equals((Object)this.roundingFrequency, (Object)_that.getRoundingFrequency())) {
                return false;
            }
            return Objects.equals(this.withholdingTaxRate, _that.getWithholdingTaxRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.floatingRate != null ? this.floatingRate.hashCode() : 0);
            _result = 31 * _result + (this.inBaseCurrency != null ? this.inBaseCurrency.hashCode() : 0);
            _result = 31 * _result + (this.compoundingType != null ? ((Object)((Object)this.compoundingType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.compoundingBusinessCenter != null ? this.compoundingBusinessCenter.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? ((Object)((Object)this.dayCountFraction)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            _result = 31 * _result + (this.roundingFrequency != null ? ((Object)((Object)this.roundingFrequency)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.withholdingTaxRate != null ? this.withholdingTaxRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralInterestCalculationParameters {fixedRate=" + this.fixedRate + ", floatingRate=" + this.floatingRate + ", inBaseCurrency=" + this.inBaseCurrency + ", compoundingType=" + (Object)((Object)this.compoundingType) + ", compoundingBusinessCenter=" + this.compoundingBusinessCenter + ", dayCountFraction=" + (Object)((Object)this.dayCountFraction) + ", rounding=" + this.rounding + ", roundingFrequency=" + (Object)((Object)this.roundingFrequency) + ", withholdingTaxRate=" + this.withholdingTaxRate + '}';
        }
    }
}

