/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.array;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.collect.function.IntIntConsumer;
import com.opengamma.strata.collect.function.IntTernaryOperator;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.Property;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.BasicImmutableBeanBuilder;
import org.joda.beans.impl.BasicMetaBean;
import org.joda.beans.impl.BasicMetaProperty;

public final class IntArray
implements Matrix,
ImmutableBean,
Serializable {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final IntArray EMPTY = new IntArray(EMPTY_INT_ARRAY);
    private static final long serialVersionUID = 1L;
    private final int[] array;

    public static IntArray of() {
        return EMPTY;
    }

    public static IntArray of(int value) {
        return new IntArray(new int[]{value});
    }

    public static IntArray of(int value1, int value2) {
        return new IntArray(new int[]{value1, value2});
    }

    public static IntArray of(int value1, int value2, int value3) {
        return new IntArray(new int[]{value1, value2, value3});
    }

    public static IntArray of(int value1, int value2, int value3, int value4) {
        return new IntArray(new int[]{value1, value2, value3, value4});
    }

    public static IntArray of(int value1, int value2, int value3, int value4, int value5) {
        return new IntArray(new int[]{value1, value2, value3, value4, value5});
    }

    public static IntArray of(int value1, int value2, int value3, int value4, int value5, int value6) {
        return new IntArray(new int[]{value1, value2, value3, value4, value5, value6});
    }

    public static IntArray of(int value1, int value2, int value3, int value4, int value5, int value6, int value7) {
        return new IntArray(new int[]{value1, value2, value3, value4, value5, value6, value7});
    }

    public static IntArray of(int value1, int value2, int value3, int value4, int value5, int value6, int value7, int value8) {
        return new IntArray(new int[]{value1, value2, value3, value4, value5, value6, value7, value8});
    }

    public static IntArray of(int value1, int value2, int value3, int value4, int value5, int value6, int value7, int value8, int ... otherValues) {
        int[] base = new int[otherValues.length + 8];
        base[0] = value1;
        base[1] = value2;
        base[2] = value3;
        base[3] = value4;
        base[4] = value5;
        base[5] = value6;
        base[6] = value7;
        base[7] = value8;
        System.arraycopy(otherValues, 0, base, 8, otherValues.length);
        return new IntArray(base);
    }

    public static IntArray of(int size, IntUnaryOperator valueFunction) {
        if (size == 0) {
            return EMPTY;
        }
        int[] array = new int[size];
        Arrays.setAll(array, valueFunction);
        return new IntArray(array);
    }

    public static IntArray of(IntStream stream) {
        return IntArray.ofUnsafe(stream.toArray());
    }

    public static IntArray ofUnsafe(int[] array) {
        if (array.length == 0) {
            return EMPTY;
        }
        return new IntArray(array);
    }

    public static IntArray copyOf(Collection<Integer> collection) {
        if (collection.size() == 0) {
            return EMPTY;
        }
        if (collection instanceof ImmList) {
            return ((ImmList)collection).underlying;
        }
        return new IntArray(Ints.toArray(collection));
    }

    public static IntArray copyOf(int[] array) {
        if (array.length == 0) {
            return EMPTY;
        }
        return new IntArray((int[])array.clone());
    }

    public static IntArray copyOf(int[] array, int fromIndex) {
        return IntArray.copyOf(array, fromIndex, array.length);
    }

    public static IntArray copyOf(int[] array, int fromIndexInclusive, int toIndexExclusive) {
        if (fromIndexInclusive > array.length) {
            throw new IndexOutOfBoundsException("Array index out of bounds: " + fromIndexInclusive + " > " + array.length);
        }
        if (toIndexExclusive > array.length) {
            throw new IndexOutOfBoundsException("Array index out of bounds: " + toIndexExclusive + " > " + array.length);
        }
        if (toIndexExclusive - fromIndexInclusive == 0) {
            return EMPTY;
        }
        return new IntArray(Arrays.copyOfRange(array, fromIndexInclusive, toIndexExclusive));
    }

    public static IntArray filled(int size) {
        if (size == 0) {
            return EMPTY;
        }
        return new IntArray(new int[size]);
    }

    public static IntArray filled(int size, int value) {
        if (size == 0) {
            return EMPTY;
        }
        int[] array = new int[size];
        Arrays.fill(array, value);
        return new IntArray(array);
    }

    private IntArray(int[] array) {
        this.array = array;
    }

    @Override
    public int dimensions() {
        return 1;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    public boolean isEmpty() {
        return this.array.length == 0;
    }

    public int get(int index) {
        return this.array[index];
    }

    public boolean contains(int value) {
        return Ints.contains((int[])this.array, (int)value);
    }

    public int indexOf(int value) {
        return Ints.indexOf((int[])this.array, (int)value);
    }

    public int lastIndexOf(int value) {
        return Ints.lastIndexOf((int[])this.array, (int)value);
    }

    public void copyInto(int[] destination, int offset) {
        if (destination.length < this.array.length + offset) {
            throw new IndexOutOfBoundsException("Destination array is not large enough");
        }
        System.arraycopy(this.array, 0, destination, offset, this.array.length);
    }

    public IntArray subArray(int fromIndexInclusive) {
        return this.subArray(fromIndexInclusive, this.array.length);
    }

    public IntArray subArray(int fromIndexInclusive, int toIndexExclusive) {
        return IntArray.copyOf(this.array, fromIndexInclusive, toIndexExclusive);
    }

    public int[] toArray() {
        return (int[])this.array.clone();
    }

    public int[] toArrayUnsafe() {
        return this.array;
    }

    public List<Integer> toList() {
        return new ImmList(this);
    }

    public IntStream stream() {
        return IntStream.of(this.array);
    }

    public void forEach(IntIntConsumer action) {
        for (int i = 0; i < this.array.length; ++i) {
            action.accept(i, this.array[i]);
        }
    }

    public IntArray with(int index, int newValue) {
        if (this.array[index] == newValue) {
            return this;
        }
        int[] result = (int[])this.array.clone();
        result[index] = newValue;
        return new IntArray(result);
    }

    public IntArray plus(int amount) {
        if (amount == 0) {
            return this;
        }
        int[] result = new int[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] + amount;
        }
        return new IntArray(result);
    }

    public IntArray minus(int amount) {
        if (amount == 0) {
            return this;
        }
        int[] result = new int[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] - amount;
        }
        return new IntArray(result);
    }

    public IntArray multipliedBy(int factor) {
        if (factor == 1) {
            return this;
        }
        int[] result = new int[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] * factor;
        }
        return new IntArray(result);
    }

    public IntArray dividedBy(int divisor) {
        if (divisor == 1) {
            return this;
        }
        int[] result = new int[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] / divisor;
        }
        return new IntArray(result);
    }

    public IntArray map(IntUnaryOperator operator) {
        int[] result = new int[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = operator.applyAsInt(this.array[i]);
        }
        return new IntArray(result);
    }

    public IntArray mapWithIndex(IntBinaryOperator function) {
        int[] result = new int[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = function.applyAsInt(i, this.array[i]);
        }
        return new IntArray(result);
    }

    public IntArray plus(IntArray other) {
        if (this.array.length != other.array.length) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        int[] result = new int[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] + other.array[i];
        }
        return new IntArray(result);
    }

    public IntArray minus(IntArray other) {
        if (this.array.length != other.array.length) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        int[] result = new int[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] - other.array[i];
        }
        return new IntArray(result);
    }

    public IntArray multipliedBy(IntArray other) {
        if (this.array.length != other.array.length) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        int[] result = new int[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] * other.array[i];
        }
        return new IntArray(result);
    }

    public IntArray dividedBy(IntArray other) {
        if (this.array.length != other.array.length) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        int[] result = new int[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] / other.array[i];
        }
        return new IntArray(result);
    }

    public IntArray combine(IntArray other, IntBinaryOperator operator) {
        if (this.array.length != other.array.length) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        int[] result = new int[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = operator.applyAsInt(this.array[i], other.array[i]);
        }
        return new IntArray(result);
    }

    public int combineReduce(IntArray other, IntTernaryOperator operator) {
        if (this.array.length != other.array.length) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        int result = 0;
        for (int i = 0; i < this.array.length; ++i) {
            result = operator.applyAsInt(result, this.array[i], other.array[i]);
        }
        return result;
    }

    public IntArray concat(int ... arrayToConcat) {
        if (this.array.length == 0) {
            return IntArray.copyOf(arrayToConcat);
        }
        if (arrayToConcat.length == 0) {
            return this;
        }
        int[] result = new int[this.array.length + arrayToConcat.length];
        System.arraycopy(this.array, 0, result, 0, this.array.length);
        System.arraycopy(arrayToConcat, 0, result, this.array.length, arrayToConcat.length);
        return new IntArray(result);
    }

    public IntArray concat(IntArray arrayToConcat) {
        if (this.array.length == 0) {
            return arrayToConcat;
        }
        if (arrayToConcat.array.length == 0) {
            return this;
        }
        return this.concat(arrayToConcat.array);
    }

    public IntArray sorted() {
        if (this.array.length < 2) {
            return this;
        }
        int[] result = (int[])this.array.clone();
        Arrays.sort(result);
        return new IntArray(result);
    }

    public int min() {
        if (this.array.length == 0) {
            throw new IllegalStateException("Unable to find minimum of an empty array");
        }
        if (this.array.length == 1) {
            return this.array[0];
        }
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.array.length; ++i) {
            min = Math.min(min, this.array[i]);
        }
        return min;
    }

    public int max() {
        if (this.array.length == 0) {
            throw new IllegalStateException("Unable to find maximum of an empty array");
        }
        if (this.array.length == 1) {
            return this.array[0];
        }
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < this.array.length; ++i) {
            max = Math.max(max, this.array[i]);
        }
        return max;
    }

    public int sum() {
        int total = 0;
        for (int i = 0; i < this.array.length; ++i) {
            total += this.array[i];
        }
        return total;
    }

    public int reduce(int identity, IntBinaryOperator operator) {
        int result = identity;
        for (int i = 0; i < this.array.length; ++i) {
            result = operator.applyAsInt(result, this.array[i]);
        }
        return result;
    }

    public MetaBean metaBean() {
        return Meta.META;
    }

    public <R> Property<R> property(String propertyName) {
        return this.metaBean().metaProperty(propertyName).createProperty((Bean)this);
    }

    public Set<String> propertyNames() {
        return this.metaBean().metaPropertyMap().keySet();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IntArray) {
            IntArray other = (IntArray)obj;
            return Arrays.equals(this.array, other.array);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    static {
        MetaBean.register((MetaBean)Meta.META);
    }

    static final class Meta
    extends BasicMetaBean {
        private static final MetaBean META = new Meta();
        private static final MetaProperty<int[]> ARRAY = new BasicMetaProperty<int[]>("array"){

            public MetaBean metaBean() {
                return META;
            }

            public Class<?> declaringType() {
                return IntArray.class;
            }

            public Class<int[]> propertyType() {
                return int[].class;
            }

            public Type propertyGenericType() {
                return int[].class;
            }

            public PropertyStyle style() {
                return PropertyStyle.IMMUTABLE;
            }

            public List<Annotation> annotations() {
                return ImmutableList.of();
            }

            public int[] get(Bean bean) {
                return ((IntArray)bean).toArray();
            }

            public void set(Bean bean, Object value) {
                throw new UnsupportedOperationException("Property cannot be written: " + this.name());
            }
        };
        private static final ImmutableMap<String, MetaProperty<?>> MAP = ImmutableMap.of((Object)"array", ARRAY);

        private Meta() {
        }

        public boolean isBuildable() {
            return true;
        }

        public BeanBuilder<IntArray> builder() {
            return new BasicImmutableBeanBuilder<IntArray>((MetaBean)this){
                private int[] array;
                {
                    super(x0);
                    this.array = EMPTY_INT_ARRAY;
                }

                public Object get(String propertyName) {
                    if (propertyName.equals(ARRAY.name())) {
                        return this.array.clone();
                    }
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }

                public BeanBuilder<IntArray> set(String propertyName, Object value) {
                    if (!propertyName.equals(ARRAY.name())) {
                        throw new NoSuchElementException("Unknown property: " + propertyName);
                    }
                    this.array = (int[])((int[])ArgChecker.notNull(value, "value")).clone();
                    return this;
                }

                public IntArray build() {
                    return new IntArray(this.array);
                }
            };
        }

        public Class<? extends Bean> beanType() {
            return IntArray.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return MAP;
        }
    }

    static class ImmList
    extends AbstractList<Integer>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final IntArray underlying;

        ImmList(IntArray underlying) {
            this.underlying = underlying;
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public Integer get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public boolean contains(Object obj) {
            return obj instanceof Integer ? this.underlying.contains((Integer)obj) : false;
        }

        @Override
        public int indexOf(Object obj) {
            return obj instanceof Integer ? this.underlying.indexOf((Integer)obj) : -1;
        }

        @Override
        public int lastIndexOf(Object obj) {
            return obj instanceof Integer ? this.underlying.lastIndexOf((Integer)obj) : -1;
        }

        @Override
        public ListIterator<Integer> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<Integer> listIterator() {
            return new ImmIterator(this.underlying.array);
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Unable to remove range from IntArray");
        }
    }

    static class ImmIterator
    implements ListIterator<Integer> {
        private final int[] array;
        private int index;

        public ImmIterator(int[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.array.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public Integer next() {
            if (this.hasNext()) {
                return this.array[this.index++];
            }
            throw new NoSuchElementException("Iteration has reached the last element");
        }

        @Override
        public Integer previous() {
            if (this.hasPrevious()) {
                return this.array[--this.index];
            }
            throw new NoSuchElementException("Iteration has reached the first element");
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove from IntArray");
        }

        @Override
        public void set(Integer value) {
            throw new UnsupportedOperationException("Unable to set value in IntArray");
        }

        @Override
        public void add(Integer value) {
            throw new UnsupportedOperationException("Unable to add value to IntArray");
        }
    }
}

