/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.PeekingIterator;
import com.google.common.io.CharSource;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Unchecked;
import com.opengamma.strata.collect.io.CsvFile;
import com.opengamma.strata.collect.io.CsvRow;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class CsvIterator
implements AutoCloseable,
PeekingIterator<CsvRow> {
    private final BufferedReader reader;
    private final char separator;
    private final ImmutableList<String> headers;
    private final ImmutableMap<String, Integer> searchHeaders;
    private CsvRow nextRow;
    private int currentLineNumber;

    public static CsvIterator of(CharSource source, boolean headerRow) {
        return CsvIterator.of(source, headerRow, ',');
    }

    public static CsvIterator of(CharSource source, boolean headerRow, char separator) {
        ArgChecker.notNull(source, "source");
        BufferedReader reader = Unchecked.wrap(() -> source.openBufferedStream());
        return CsvIterator.create(reader, headerRow, separator);
    }

    public static CsvIterator of(Reader reader, boolean headerRow) {
        return CsvIterator.of(reader, headerRow, ',');
    }

    public static CsvIterator of(Reader reader, boolean headerRow, char separator) {
        ArgChecker.notNull(reader, "reader");
        BufferedReader breader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        return CsvIterator.create(breader, headerRow, separator);
    }

    private static CsvIterator create(BufferedReader breader, boolean headerRow, char separator) {
        try {
            if (!headerRow) {
                return new CsvIterator(breader, separator, (ImmutableList<String>)ImmutableList.of(), (ImmutableMap<String, Integer>)ImmutableMap.of(), 0);
            }
            String line = breader.readLine();
            int lineNumber = 1;
            while (line != null) {
                ImmutableList<String> headers = CsvFile.parseLine(line, lineNumber, separator);
                if (!headers.isEmpty()) {
                    return new CsvIterator(breader, separator, headers, CsvFile.buildSearchHeaders(headers), lineNumber);
                }
                line = breader.readLine();
                ++lineNumber;
            }
            throw new IllegalArgumentException("Could not read header row from empty CSV file");
        }
        catch (RuntimeException ex) {
            try {
                breader.close();
            }
            catch (IOException ex2) {
                ex.addSuppressed(ex2);
            }
            throw ex;
        }
        catch (IOException ex) {
            try {
                breader.close();
            }
            catch (IOException ex2) {
                ex.addSuppressed(ex2);
            }
            throw new UncheckedIOException(ex);
        }
    }

    private CsvIterator(BufferedReader reader, char separator, ImmutableList<String> headers, ImmutableMap<String, Integer> searchHeaders, int currentLineNumber) {
        this.reader = reader;
        this.separator = separator;
        this.headers = headers;
        this.searchHeaders = searchHeaders;
        this.currentLineNumber = currentLineNumber;
    }

    public ImmutableList<String> headers() {
        return this.headers;
    }

    public boolean containsHeader(String header) {
        return this.searchHeaders.containsKey((Object)header.toLowerCase(Locale.ENGLISH));
    }

    public boolean containsHeader(Pattern headerPattern) {
        for (int i = 0; i < this.headers.size(); ++i) {
            if (!headerPattern.matcher((CharSequence)this.headers.get(i)).matches()) continue;
            return true;
        }
        return false;
    }

    public Stream<CsvRow> asStream() {
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(this, 272);
        return StreamSupport.stream(spliterator, false);
    }

    public boolean hasNext() {
        if (this.nextRow != null) {
            return true;
        }
        String line = null;
        while ((line = Unchecked.wrap(() -> this.reader.readLine())) != null) {
            ++this.currentLineNumber;
            ImmutableList<String> fields = CsvFile.parseLine(line, this.currentLineNumber, this.separator);
            if (fields.isEmpty()) continue;
            this.nextRow = new CsvRow(this.headers, this.searchHeaders, this.currentLineNumber, fields);
            return true;
        }
        return false;
    }

    public CsvRow peek() {
        if (this.nextRow != null || this.hasNext()) {
            return this.nextRow;
        }
        throw new NoSuchElementException("CsvIterator has reached the end of the file");
    }

    public CsvRow next() {
        if (this.nextRow != null || this.hasNext()) {
            CsvRow row = this.nextRow;
            this.nextRow = null;
            return row;
        }
        throw new NoSuchElementException("CsvIterator has reached the end of the file");
    }

    public List<CsvRow> nextBatch(int count) {
        ArrayList<CsvRow> rows = new ArrayList<CsvRow>();
        for (int i = 0; i < count; ++i) {
            if (!this.hasNext()) continue;
            rows.add(this.next());
        }
        return rows;
    }

    public void remove() {
        throw new UnsupportedOperationException("CsvIterator does not support remove()");
    }

    @Override
    public void close() {
        Unchecked.wrap(() -> this.reader.close());
    }

    public String toString() {
        return "CsvIterator" + this.headers.toString();
    }
}

