/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.translation;

import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingDelegate;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.translation.SynonymToEnumMap;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public abstract class MappingProcessor
implements MappingDelegate {
    private final RosettaPath modelPath;
    private final List<Path> synonymPaths;
    private final MappingContext context;

    public MappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        this.modelPath = modelPath;
        this.synonymPaths = synonymPaths;
        this.context = context;
    }

    @Override
    public void map(Path synonymPath, Optional<RosettaModelObjectBuilder> builder, RosettaModelObjectBuilder parent) {
        builder.ifPresent(b -> this.map(synonymPath, (RosettaModelObjectBuilder)b, parent));
    }

    public void map(Path synonymPath, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent) {
    }

    @Override
    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builder, RosettaModelObjectBuilder parent) {
    }

    @Override
    public <T> void mapBasic(Path synonymPath, Optional<T> instance, RosettaModelObjectBuilder parent) {
        instance.ifPresent(i -> this.mapBasic(synonymPath, i, parent));
    }

    public <T> void mapBasic(Path synonymPath, T instance, RosettaModelObjectBuilder parent) {
    }

    @Override
    public <T> void mapBasic(Path synonymPath, Collection<? extends T> instance, RosettaModelObjectBuilder parent) {
    }

    @Override
    public RosettaPath getModelPath() {
        return this.modelPath;
    }

    @Override
    public List<Path> getSynonymPaths() {
        return this.synonymPaths;
    }

    protected List<Mapping> getMappings() {
        return this.context.getMappings();
    }

    protected MappingContext getContext() {
        return this.context;
    }

    protected void addInvokedTask(CompletableFuture<?> invokedTask) {
        this.context.getInvokedTasks().add(invokedTask);
    }

    protected void setValueAndUpdateMappings(String synonymPath, Consumer<String> setter) {
        this.setValueAndUpdateMappings(Path.parse(synonymPath), setter);
    }

    protected void setValueAndUpdateMappings(Path synonymPath, Consumer<String> setter) {
        MappingProcessorUtils.setValueAndUpdateMappings(synonymPath, setter, this.getMappings(), this.modelPath);
    }

    protected Optional<String> getValueAndUpdateMappings(Path synonymPath) {
        return MappingProcessorUtils.getValueAndUpdateMappings(synonymPath, this.getMappings(), this.modelPath);
    }

    protected SynonymToEnumMap getSynonymToEnumMap() {
        return this.context.getSynonymToEnumMap();
    }
}

