/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.hkma.rewrite.trade.tr.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.projection.iso20022.hkma.rewrite.trade.tr.functions.Create_OrganisationIdentification15Choice__3;
import drr.regulation.common.HKTRPartyScheme;
import drr.regulation.common.PartyIdentifierFormat2Enum;
import drr.regulation.common.PartyIdentifierFormatEnum;
import drr.regulation.hkma.rewrite.trade.HKMATransactionReport;
import iso20022.auth030.hkma.tr.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import iso20022.auth030.hkma.tr.AmountAndDirection106__3;
import iso20022.auth030.hkma.tr.GenericIdentification175__1;
import iso20022.auth030.hkma.tr.NaturalPersonIdentification2__1;
import iso20022.auth030.hkma.tr.OtherPayment5__1;
import iso20022.auth030.hkma.tr.PartyIdentification236Choice__1;
import iso20022.auth030.hkma.tr.PaymentType4Code;
import iso20022.auth030.hkma.tr.PaymentType5Choice__1;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetOthrPmtDefault.class)
public abstract class GetOthrPmt
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_OrganisationIdentification15Choice__3 create_OrganisationIdentification15Choice__3;

    public List<? extends OtherPayment5__1> evaluate(HKMATransactionReport drrReport) {
        List othrPmt;
        List<OtherPayment5__1.OtherPayment5__1Builder> othrPmtBuilder = this.doEvaluate(drrReport);
        if (othrPmtBuilder == null) {
            othrPmt = null;
        } else {
            othrPmt = othrPmtBuilder.stream().map(OtherPayment5__1::build).collect(Collectors.toList());
            this.objectValidator.validate(OtherPayment5__1.class, othrPmt);
        }
        return othrPmt;
    }

    protected abstract List<OtherPayment5__1.OtherPayment5__1Builder> doEvaluate(HKMATransactionReport var1);

    public static class GetOthrPmtDefault
    extends GetOthrPmt {
        @Override
        protected List<OtherPayment5__1.OtherPayment5__1Builder> doEvaluate(HKMATransactionReport drrReport) {
            ArrayList<OtherPayment5__1.OtherPayment5__1Builder> othrPmt = new ArrayList<OtherPayment5__1.OtherPayment5__1Builder>();
            return this.assignOutput(othrPmt, drrReport);
        }

        protected List<OtherPayment5__1.OtherPayment5__1Builder> assignOutput(List<OtherPayment5__1.OtherPayment5__1Builder> othrPmt, HKMATransactionReport drrReport) {
            othrPmt.addAll(this.toBuilder(MapperS.of((Object)drrReport).mapC("getOtherPayment", hKMATransactionReport -> hKMATransactionReport.getOtherPayment()).mapItem(item -> {
                String ifThenElseResult0 = null;
                if (ExpressionOperators.areEqual((Mapper)item.map("getPayerFormat", otherPayment -> otherPayment.getPayerFormat()), (Mapper)MapperS.of((Object)((Object)PartyIdentifierFormatEnum.LEI_AND_PERSON)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult0 = (String)item.map("getPayer", otherPayment -> otherPayment.getPayer()).get();
                }
                String ifThenElseResult1 = null;
                if (ExpressionOperators.areEqual((Mapper)item.map("getReceiverFormat", otherPayment -> otherPayment.getReceiverFormat()), (Mapper)MapperS.of((Object)((Object)PartyIdentifierFormatEnum.LEI_AND_PERSON)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult1 = (String)item.map("getReceiver", otherPayment -> otherPayment.getReceiver()).get();
                }
                return MapperS.of((Object)OtherPayment5__1.builder().setPmtTp(PaymentType5Choice__1.builder().setTp((PaymentType4Code)item.map("getPaymentType", otherPayment -> otherPayment.getPaymentType()).checkedMap("to-enum", e -> PaymentType4Code.valueOf((String)e.name()), IllegalArgumentException.class).get()).build()).setPmtAmt(AmountAndDirection106__3.builder().setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue((BigDecimal)item.map("getAmount", otherPayment -> otherPayment.getAmount()).get()).setCcy((String)item.map("getCurrency", otherPayment -> otherPayment.getCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).build()).setPmtDt((Date)item.map("getDate", otherPayment -> otherPayment.getDate()).get()).setPmtPyer(PartyIdentification236Choice__1.builder().setLgl(this.create_OrganisationIdentification15Choice__3.evaluate((PartyIdentifierFormat2Enum)((Object)((Object)item.map("getPayerFormat", otherPayment -> otherPayment.getPayerFormat()).checkedMap("to-enum", e -> PartyIdentifierFormat2Enum.valueOf(e.name()), IllegalArgumentException.class).get())), (String)item.map("getPayer", otherPayment -> otherPayment.getPayer()).get(), (HKTRPartyScheme)((Object)((Object)item.map("getPayerSchemeName", otherPayment -> otherPayment.getPayerSchemeName()).checkedMap("to-enum", HKTRPartyScheme::fromDisplayName, IllegalArgumentException.class).get())))).setNtrl(NaturalPersonIdentification2__1.builder().setId(GenericIdentification175__1.builder().setId(ifThenElseResult0).build()).build()).build()).setPmtRcvr(PartyIdentification236Choice__1.builder().setLgl(this.create_OrganisationIdentification15Choice__3.evaluate((PartyIdentifierFormat2Enum)((Object)((Object)item.map("getReceiverFormat", otherPayment -> otherPayment.getReceiverFormat()).checkedMap("to-enum", e -> PartyIdentifierFormat2Enum.valueOf(e.name()), IllegalArgumentException.class).get())), (String)item.map("getReceiver", otherPayment -> otherPayment.getReceiver()).get(), (HKTRPartyScheme)((Object)((Object)item.map("getReceiverSchemeName", otherPayment -> otherPayment.getReceiverSchemeName()).checkedMap("to-enum", HKTRPartyScheme::fromDisplayName, IllegalArgumentException.class).get())))).setNtrl(NaturalPersonIdentification2__1.builder().setId(GenericIdentification175__1.builder().setId(ifThenElseResult1).build()).build()).build()).build());
            }).getMulti()));
            return Optional.ofNullable(othrPmt).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

