/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.jfsa.rewrite.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import iso20022.auth030.jfsa.ActiveOrHistoricCurrencyAnd13DecimalAmount;
import iso20022.auth030.jfsa.AmountAndDirection106__1;
import iso20022.auth030.jfsa.SecuritiesTransactionPrice17Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetPricDefault.class)
public abstract class GetPric
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Abs abs;

    public SecuritiesTransactionPrice17Choice__1 evaluate(JFSATransactionReport drrReport) {
        SecuritiesTransactionPrice17Choice__1 pric;
        SecuritiesTransactionPrice17Choice__1.SecuritiesTransactionPrice17Choice__1Builder pricBuilder = this.doEvaluate(drrReport);
        if (pricBuilder == null) {
            pric = null;
        } else {
            pric = pricBuilder.build();
            this.objectValidator.validate(SecuritiesTransactionPrice17Choice__1.class, (RosettaModelObject)pric);
        }
        return pric;
    }

    protected abstract SecuritiesTransactionPrice17Choice__1.SecuritiesTransactionPrice17Choice__1Builder doEvaluate(JFSATransactionReport var1);

    public static class GetPricDefault
    extends GetPric {
        @Override
        protected SecuritiesTransactionPrice17Choice__1.SecuritiesTransactionPrice17Choice__1Builder doEvaluate(JFSATransactionReport drrReport) {
            SecuritiesTransactionPrice17Choice__1.SecuritiesTransactionPrice17Choice__1Builder pric = SecuritiesTransactionPrice17Choice__1.builder();
            return this.assignOutput(pric, drrReport);
        }

        protected SecuritiesTransactionPrice17Choice__1.SecuritiesTransactionPrice17Choice__1Builder assignOutput(SecuritiesTransactionPrice17Choice__1.SecuritiesTransactionPrice17Choice__1Builder pric, JFSATransactionReport drrReport) {
            pric = (SecuritiesTransactionPrice17Choice__1.SecuritiesTransactionPrice17Choice__1Builder)this.toBuilder((RosettaModelObject)MapperS.of((Object)drrReport).mapSingleToItem(item -> {
                Boolean ifThenElseResult = null;
                if (ExpressionOperators.lessThan((Mapper)item.map("getPrice", jFSATransactionReport -> jFSATransactionReport.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = false;
                }
                return MapperS.of((Object)SecuritiesTransactionPrice17Choice__1.builder().setMntryVal(AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getPrice", jFSATransactionReport -> jFSATransactionReport.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getPriceCurrency", jFSATransactionReport -> jFSATransactionReport.getPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult).build()).setDcml((BigDecimal)item.map("getPrice", jFSATransactionReport -> jFSATransactionReport.getPrice()).map("getDecimal", priceFormat -> priceFormat.getDecimal()).get()).build());
            }).get());
            return Optional.ofNullable(pric).map(o -> o.prune()).orElse(null);
        }
    }
}

