/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.jfsa.rewrite.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.standards.iso.ConfirmationEnum;
import iso20022.auth030.jfsa.TradeConfirmation4Choice;
import iso20022.auth030.jfsa.TradeConfirmation5;
import iso20022.auth030.jfsa.TradeConfirmationType1Code;
import iso20022.auth030.jfsa.TradeConfirmationType2Code;
import iso20022.auth030.jfsa.TradeNonConfirmation1;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetTradConfDefault.class)
public abstract class GetTradConf
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public TradeConfirmation4Choice evaluate(JFSATransactionReport drrReport) {
        TradeConfirmation4Choice tradConf;
        TradeConfirmation4Choice.TradeConfirmation4ChoiceBuilder tradConfBuilder = this.doEvaluate(drrReport);
        if (tradConfBuilder == null) {
            tradConf = null;
        } else {
            tradConf = tradConfBuilder.build();
            this.objectValidator.validate(TradeConfirmation4Choice.class, (RosettaModelObject)tradConf);
        }
        return tradConf;
    }

    protected abstract TradeConfirmation4Choice.TradeConfirmation4ChoiceBuilder doEvaluate(JFSATransactionReport var1);

    public static class GetTradConfDefault
    extends GetTradConf {
        @Override
        protected TradeConfirmation4Choice.TradeConfirmation4ChoiceBuilder doEvaluate(JFSATransactionReport drrReport) {
            TradeConfirmation4Choice.TradeConfirmation4ChoiceBuilder tradConf = TradeConfirmation4Choice.builder();
            return this.assignOutput(tradConf, drrReport);
        }

        protected TradeConfirmation4Choice.TradeConfirmation4ChoiceBuilder assignOutput(TradeConfirmation4Choice.TradeConfirmation4ChoiceBuilder tradConf, JFSATransactionReport drrReport) {
            ZonedDateTime ifThenElseResult0 = null;
            if (ExpressionOperators.notEqual((Mapper)MapperS.of((Object)drrReport).map("getConfirmed", jFSATransactionReport -> jFSATransactionReport.getConfirmed()), (Mapper)MapperS.of((Object)((Object)ConfirmationEnum.NCNF)), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult0 = (ZonedDateTime)MapperS.of((Object)drrReport).map("getConfirmationTimestamp", jFSATransactionReport -> jFSATransactionReport.getConfirmationTimestamp()).get();
            }
            TradeConfirmationType1Code ifThenElseResult1 = null;
            if (ExpressionOperators.notEqual((Mapper)MapperS.of((Object)drrReport).map("getConfirmed", jFSATransactionReport -> jFSATransactionReport.getConfirmed()), (Mapper)MapperS.of((Object)((Object)ConfirmationEnum.NCNF)), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult1 = (TradeConfirmationType1Code)MapperS.of((Object)drrReport).map("getConfirmed", jFSATransactionReport -> jFSATransactionReport.getConfirmed()).checkedMap("to-enum", e -> TradeConfirmationType1Code.valueOf((String)e.name()), IllegalArgumentException.class).get();
            }
            TradeConfirmationType2Code ifThenElseResult2 = null;
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getConfirmed", jFSATransactionReport -> jFSATransactionReport.getConfirmed()), (Mapper)MapperS.of((Object)((Object)ConfirmationEnum.NCNF)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult2 = (TradeConfirmationType2Code)MapperS.of((Object)drrReport).map("getConfirmed", jFSATransactionReport -> jFSATransactionReport.getConfirmed()).checkedMap("to-enum", e -> TradeConfirmationType2Code.valueOf((String)e.name()), IllegalArgumentException.class).get();
            }
            tradConf = (TradeConfirmation4Choice.TradeConfirmation4ChoiceBuilder)this.toBuilder((RosettaModelObject)TradeConfirmation4Choice.builder().setConfd(TradeConfirmation5.builder().setTmStmp(ifThenElseResult0).setTp(ifThenElseResult1).build()).setNonConfd(TradeNonConfirmation1.builder().setTp(ifThenElseResult2).build()).build());
            return Optional.ofNullable(tradConf).map(o -> o.prune()).orElse(null);
        }
    }
}

