/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iso.ActionTypeEnum;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ASICTransactionReportDTCC_ASIC_BR_1048_01")
@ImplementedBy(value=Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1048_01
extends Validator<ASICTransactionReport> {
    public static final String NAME = "ASICTransactionReportDTCC_ASIC_BR_1048_01";
    public static final String DEFINITION = "if [ActionTypeEnum -> NEWT, ActionTypeEnum -> MODI, ActionTypeEnum -> CORR, ActionTypeEnum -> REVI] any = actionType then if priceNotation = Monetary and price -> monetary <> 999999999999999999 and priceCurrency exists then [ISOCurrencyCodeEnum -> XAG, ISOCurrencyCodeEnum -> XAU, ISOCurrencyCodeEnum -> XBA, ISOCurrencyCodeEnum -> XBB, ISOCurrencyCodeEnum -> XBC, ISOCurrencyCodeEnum -> XBD, ISOCurrencyCodeEnum -> XDR, ISOCurrencyCodeEnum -> XPD, ISOCurrencyCodeEnum -> XPT, ISOCurrencyCodeEnum -> XTS] any <> priceCurrency else if priceNotation = Decimal then priceCurrency is absent";

    public static class NoOp
    implements ASICTransactionReportDTCC_ASIC_BR_1048_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ASICTransactionReportDTCC_ASIC_BR_1048_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
            ComparisonResult result = this.executeDataRule(aSICTransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ASICTransactionReportDTCC_ASIC_BR_1048_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ASICTransactionReport", (RosettaPath)path, (String)ASICTransactionReportDTCC_ASIC_BR_1048_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ASICTransactionReportDTCC_ASIC_BR_1048_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ASICTransactionReport", (RosettaPath)path, (String)ASICTransactionReportDTCC_ASIC_BR_1048_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)aSICTransactionReport).map("getPriceNotation", _aSICTransactionReport -> _aSICTransactionReport.getPriceNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)aSICTransactionReport).map("getPrice", _aSICTransactionReport -> _aSICTransactionReport.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(999999999999999999L)), (CardinalityOperator)CardinalityOperator.Any)).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)aSICTransactionReport).map("getPriceCurrency", _aSICTransactionReport -> _aSICTransactionReport.getPriceCurrency()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.notEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)ISOCurrencyCodeEnum.XAG), MapperS.of((Object)ISOCurrencyCodeEnum.XAU), MapperS.of((Object)ISOCurrencyCodeEnum.XBA), MapperS.of((Object)ISOCurrencyCodeEnum.XBB), MapperS.of((Object)ISOCurrencyCodeEnum.XBC), MapperS.of((Object)ISOCurrencyCodeEnum.XBD), MapperS.of((Object)ISOCurrencyCodeEnum.XDR), MapperS.of((Object)ISOCurrencyCodeEnum.XPD), MapperS.of((Object)ISOCurrencyCodeEnum.XPT), MapperS.of((Object)ISOCurrencyCodeEnum.XTS)}), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getPriceCurrency", _aSICTransactionReport -> _aSICTransactionReport.getPriceCurrency()), (CardinalityOperator)CardinalityOperator.Any);
                    }
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)aSICTransactionReport).map("getPriceNotation", _aSICTransactionReport -> _aSICTransactionReport.getPriceNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.DECIMAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.notExists((Mapper)MapperS.of((Object)aSICTransactionReport).map("getPriceCurrency", _aSICTransactionReport -> _aSICTransactionReport.getPriceCurrency()));
                    }
                    return ComparisonResult.successEmptyOperand((String)"");
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

