/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.margin;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import drr.regulation.cftc.rewrite.margin.meta.CFTCMarginReportMeta;
import drr.regulation.common.MarginActionEnum;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.standards.iso.CollateralisationType3Code__1;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CFTCMarginReport", builder=CFTCMarginReportBuilderImpl.class, version="6.17.1")
@RuneDataType(value="CFTCMarginReport", model="drr", builder=CFTCMarginReportBuilderImpl.class, version="6.17.1")
public interface CFTCMarginReport
extends RosettaModelObject {
    public static final CFTCMarginReportMeta metaData = new CFTCMarginReportMeta();

    public String getCounterparty1();

    public String getCounterparty2();

    public String getCounterparty2IdentifierSource();

    public String getSubmitterIdentifier();

    public MarginActionEnum getActionType();

    public ZonedDateTime getEventTimestamp();

    public ZonedDateTime getReportingTimestamp();

    public String getUniqueSwapIdentifier();

    public String getUniqueTransactionIdentifier();

    public Boolean getAffiliatedCounterpartyForMarginAndCapitalIndicator();

    public CollateralisationType3Code__1 getCollateralisationCategory();

    public String getInitialMarginCollateralPortfolioCode();

    public Boolean getPortfolioContainingNonReportableComponentIndicator();

    public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPostHaircut();

    public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPreHaircut();

    public ISOCurrencyCodeEnum getCurrencyOfInitialMarginPosted();

    public BigDecimal getInitialMarginCollectedByTheReportingCounterpartyPostHaircut();

    public BigDecimal getInitialMarginCollectedByTheReportingCounterpartyPreHaircut();

    public ISOCurrencyCodeEnum getCurrencyOfInitialMarginCollected();

    public String getVariationMarginCollateralPortfolioCode();

    public BigDecimal getVariationMarginPostedByTheReportingCounterpartyPreHaircut();

    public ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted();

    public BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPreHaircut();

    public ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected();

    public PartyIdentifierTypeEnum getTradeParty1IDType();

    public PartyIdentifierTypeEnum getSubmittingPartyIDType();

    public String getUsiIDPrefix();

    public String getUtiIDPrefix();

    public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination();

    public String getComment1();

    public String getMessageID();

    public String getMessageType();

    public String getVersion();

    public CFTCMarginReport build();

    public CFTCMarginReportBuilder toBuilder();

    public static CFTCMarginReportBuilder builder() {
        return new CFTCMarginReportBuilderImpl();
    }

    default public RosettaMetaData<? extends CFTCMarginReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CFTCMarginReport> getType() {
        return CFTCMarginReport.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, (Object)this.getSubmitterIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueSwapIdentifier"), String.class, (Object)this.getUniqueSwapIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("affiliatedCounterpartyForMarginAndCapitalIndicator"), Boolean.class, (Object)this.getAffiliatedCounterpartyForMarginAndCapitalIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code__1.class, (Object)this.getCollateralisationCategory(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("portfolioContainingNonReportableComponentIndicator"), Boolean.class, (Object)this.getPortfolioContainingNonReportableComponentIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfInitialMarginPosted"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyOfInitialMarginPosted(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByTheReportingCounterpartyPostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByTheReportingCounterpartyPreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfInitialMarginCollected"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyOfInitialMarginCollected(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfVariationMarginPosted"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyOfVariationMarginPosted(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfVariationMarginCollected"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyOfVariationMarginCollected(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1IDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1IDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submittingPartyIDType"), PartyIdentifierTypeEnum.class, (Object)this.getSubmittingPartyIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("usiIDPrefix"), String.class, (Object)this.getUsiIDPrefix(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("utiIDPrefix"), String.class, (Object)this.getUtiIDPrefix(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty1ReportingDestination(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment1"), String.class, (Object)this.getComment1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("messageID"), String.class, (Object)this.getMessageID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("messageType"), String.class, (Object)this.getMessageType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("version"), String.class, (Object)this.getVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CFTCMarginReportBuilderImpl
    implements CFTCMarginReportBuilder {
        protected String counterparty1;
        protected String counterparty2;
        protected String counterparty2IdentifierSource;
        protected String submitterIdentifier;
        protected MarginActionEnum actionType;
        protected ZonedDateTime eventTimestamp;
        protected ZonedDateTime reportingTimestamp;
        protected String uniqueSwapIdentifier;
        protected String uniqueTransactionIdentifier;
        protected Boolean affiliatedCounterpartyForMarginAndCapitalIndicator;
        protected CollateralisationType3Code__1 collateralisationCategory;
        protected String initialMarginCollateralPortfolioCode;
        protected Boolean portfolioContainingNonReportableComponentIndicator;
        protected BigDecimal initialMarginPostedByTheReportingCounterpartyPostHaircut;
        protected BigDecimal initialMarginPostedByTheReportingCounterpartyPreHaircut;
        protected ISOCurrencyCodeEnum currencyOfInitialMarginPosted;
        protected BigDecimal initialMarginCollectedByTheReportingCounterpartyPostHaircut;
        protected BigDecimal initialMarginCollectedByTheReportingCounterpartyPreHaircut;
        protected ISOCurrencyCodeEnum currencyOfInitialMarginCollected;
        protected String variationMarginCollateralPortfolioCode;
        protected BigDecimal variationMarginPostedByTheReportingCounterpartyPreHaircut;
        protected ISOCurrencyCodeEnum currencyOfVariationMarginPosted;
        protected BigDecimal variationMarginCollectedByTheReportingCounterpartyPreHaircut;
        protected ISOCurrencyCodeEnum currencyOfVariationMarginCollected;
        protected PartyIdentifierTypeEnum tradeParty1IDType;
        protected PartyIdentifierTypeEnum submittingPartyIDType;
        protected String usiIDPrefix;
        protected String utiIDPrefix;
        protected List<SupervisoryBodyEnum> tradeParty1ReportingDestination = new ArrayList<SupervisoryBodyEnum>();
        protected String comment1;
        protected String messageID;
        protected String messageType;
        protected String version;

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
        public String getCounterparty2IdentifierSource() {
            return this.counterparty2IdentifierSource;
        }

        @Override
        @RosettaAttribute(value="submitterIdentifier", isRequired=true)
        @RuneAttribute(value="submitterIdentifier", isRequired=true)
        public String getSubmitterIdentifier() {
            return this.submitterIdentifier;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public MarginActionEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="uniqueSwapIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueSwapIdentifier", isRequired=true)
        public String getUniqueSwapIdentifier() {
            return this.uniqueSwapIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="affiliatedCounterpartyForMarginAndCapitalIndicator", isRequired=true)
        @RuneAttribute(value="affiliatedCounterpartyForMarginAndCapitalIndicator", isRequired=true)
        public Boolean getAffiliatedCounterpartyForMarginAndCapitalIndicator() {
            return this.affiliatedCounterpartyForMarginAndCapitalIndicator;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory")
        @RuneAttribute(value="collateralisationCategory")
        public CollateralisationType3Code__1 getCollateralisationCategory() {
            return this.collateralisationCategory;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
        @RuneAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
        public Boolean getPortfolioContainingNonReportableComponentIndicator() {
            return this.portfolioContainingNonReportableComponentIndicator;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheReportingCounterpartyPostHaircut")
        @RuneAttribute(value="initialMarginPostedByTheReportingCounterpartyPostHaircut")
        public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPostHaircut() {
            return this.initialMarginPostedByTheReportingCounterpartyPostHaircut;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="initialMarginPostedByTheReportingCounterpartyPreHaircut")
        public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPreHaircut() {
            return this.initialMarginPostedByTheReportingCounterpartyPreHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyOfInitialMarginPosted")
        @RuneAttribute(value="currencyOfInitialMarginPosted")
        public ISOCurrencyCodeEnum getCurrencyOfInitialMarginPosted() {
            return this.currencyOfInitialMarginPosted;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByTheReportingCounterpartyPostHaircut")
        @RuneAttribute(value="initialMarginCollectedByTheReportingCounterpartyPostHaircut")
        public BigDecimal getInitialMarginCollectedByTheReportingCounterpartyPostHaircut() {
            return this.initialMarginCollectedByTheReportingCounterpartyPostHaircut;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="initialMarginCollectedByTheReportingCounterpartyPreHaircut")
        public BigDecimal getInitialMarginCollectedByTheReportingCounterpartyPreHaircut() {
            return this.initialMarginCollectedByTheReportingCounterpartyPreHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyOfInitialMarginCollected")
        @RuneAttribute(value="currencyOfInitialMarginCollected")
        public ISOCurrencyCodeEnum getCurrencyOfInitialMarginCollected() {
            return this.currencyOfInitialMarginCollected;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="variationMarginPostedByTheReportingCounterpartyPreHaircut")
        public BigDecimal getVariationMarginPostedByTheReportingCounterpartyPreHaircut() {
            return this.variationMarginPostedByTheReportingCounterpartyPreHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyOfVariationMarginPosted")
        @RuneAttribute(value="currencyOfVariationMarginPosted")
        public ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted() {
            return this.currencyOfVariationMarginPosted;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheReportingCounterpartyPreHaircut")
        public BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPreHaircut() {
            return this.variationMarginCollectedByTheReportingCounterpartyPreHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyOfVariationMarginCollected")
        @RuneAttribute(value="currencyOfVariationMarginCollected")
        public ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected() {
            return this.currencyOfVariationMarginCollected;
        }

        @Override
        @RosettaAttribute(value="tradeParty1IDType", isRequired=true)
        @RuneAttribute(value="tradeParty1IDType", isRequired=true)
        public PartyIdentifierTypeEnum getTradeParty1IDType() {
            return this.tradeParty1IDType;
        }

        @Override
        @RosettaAttribute(value="submittingPartyIDType", isRequired=true)
        @RuneAttribute(value="submittingPartyIDType", isRequired=true)
        public PartyIdentifierTypeEnum getSubmittingPartyIDType() {
            return this.submittingPartyIDType;
        }

        @Override
        @RosettaAttribute(value="usiIDPrefix")
        @RuneAttribute(value="usiIDPrefix")
        public String getUsiIDPrefix() {
            return this.usiIDPrefix;
        }

        @Override
        @RosettaAttribute(value="utiIDPrefix")
        @RuneAttribute(value="utiIDPrefix")
        public String getUtiIDPrefix() {
            return this.utiIDPrefix;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        @RuneAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination() {
            return this.tradeParty1ReportingDestination;
        }

        @Override
        @RosettaAttribute(value="comment1", isRequired=true)
        @RuneAttribute(value="comment1", isRequired=true)
        public String getComment1() {
            return this.comment1;
        }

        @Override
        @RosettaAttribute(value="messageID", isRequired=true)
        @RuneAttribute(value="messageID", isRequired=true)
        public String getMessageID() {
            return this.messageID;
        }

        @Override
        @RosettaAttribute(value="messageType", isRequired=true)
        @RuneAttribute(value="messageType", isRequired=true)
        public String getMessageType() {
            return this.messageType;
        }

        @Override
        @RosettaAttribute(value="version", isRequired=true)
        @RuneAttribute(value="version", isRequired=true)
        public String getVersion() {
            return this.version;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public CFTCMarginReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public CFTCMarginReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
        public CFTCMarginReportBuilder setCounterparty2IdentifierSource(String _counterparty2IdentifierSource) {
            this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="submitterIdentifier", isRequired=true)
        @RuneAttribute(value="submitterIdentifier", isRequired=true)
        public CFTCMarginReportBuilder setSubmitterIdentifier(String _submitterIdentifier) {
            this.submitterIdentifier = _submitterIdentifier == null ? null : _submitterIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public CFTCMarginReportBuilder setActionType(MarginActionEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public CFTCMarginReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
            this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public CFTCMarginReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueSwapIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueSwapIdentifier", isRequired=true)
        public CFTCMarginReportBuilder setUniqueSwapIdentifier(String _uniqueSwapIdentifier) {
            this.uniqueSwapIdentifier = _uniqueSwapIdentifier == null ? null : _uniqueSwapIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public CFTCMarginReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="affiliatedCounterpartyForMarginAndCapitalIndicator", isRequired=true)
        @RuneAttribute(value="affiliatedCounterpartyForMarginAndCapitalIndicator", isRequired=true)
        public CFTCMarginReportBuilder setAffiliatedCounterpartyForMarginAndCapitalIndicator(Boolean _affiliatedCounterpartyForMarginAndCapitalIndicator) {
            this.affiliatedCounterpartyForMarginAndCapitalIndicator = _affiliatedCounterpartyForMarginAndCapitalIndicator == null ? null : _affiliatedCounterpartyForMarginAndCapitalIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory")
        @RuneAttribute(value="collateralisationCategory")
        public CFTCMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code__1 _collateralisationCategory) {
            this.collateralisationCategory = _collateralisationCategory == null ? null : _collateralisationCategory;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public CFTCMarginReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
        @RuneAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
        public CFTCMarginReportBuilder setPortfolioContainingNonReportableComponentIndicator(Boolean _portfolioContainingNonReportableComponentIndicator) {
            this.portfolioContainingNonReportableComponentIndicator = _portfolioContainingNonReportableComponentIndicator == null ? null : _portfolioContainingNonReportableComponentIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheReportingCounterpartyPostHaircut")
        @RuneAttribute(value="initialMarginPostedByTheReportingCounterpartyPostHaircut")
        public CFTCMarginReportBuilder setInitialMarginPostedByTheReportingCounterpartyPostHaircut(BigDecimal _initialMarginPostedByTheReportingCounterpartyPostHaircut) {
            this.initialMarginPostedByTheReportingCounterpartyPostHaircut = _initialMarginPostedByTheReportingCounterpartyPostHaircut == null ? null : _initialMarginPostedByTheReportingCounterpartyPostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="initialMarginPostedByTheReportingCounterpartyPreHaircut")
        public CFTCMarginReportBuilder setInitialMarginPostedByTheReportingCounterpartyPreHaircut(BigDecimal _initialMarginPostedByTheReportingCounterpartyPreHaircut) {
            this.initialMarginPostedByTheReportingCounterpartyPreHaircut = _initialMarginPostedByTheReportingCounterpartyPreHaircut == null ? null : _initialMarginPostedByTheReportingCounterpartyPreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfInitialMarginPosted")
        @RuneAttribute(value="currencyOfInitialMarginPosted")
        public CFTCMarginReportBuilder setCurrencyOfInitialMarginPosted(ISOCurrencyCodeEnum _currencyOfInitialMarginPosted) {
            this.currencyOfInitialMarginPosted = _currencyOfInitialMarginPosted == null ? null : _currencyOfInitialMarginPosted;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByTheReportingCounterpartyPostHaircut")
        @RuneAttribute(value="initialMarginCollectedByTheReportingCounterpartyPostHaircut")
        public CFTCMarginReportBuilder setInitialMarginCollectedByTheReportingCounterpartyPostHaircut(BigDecimal _initialMarginCollectedByTheReportingCounterpartyPostHaircut) {
            this.initialMarginCollectedByTheReportingCounterpartyPostHaircut = _initialMarginCollectedByTheReportingCounterpartyPostHaircut == null ? null : _initialMarginCollectedByTheReportingCounterpartyPostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="initialMarginCollectedByTheReportingCounterpartyPreHaircut")
        public CFTCMarginReportBuilder setInitialMarginCollectedByTheReportingCounterpartyPreHaircut(BigDecimal _initialMarginCollectedByTheReportingCounterpartyPreHaircut) {
            this.initialMarginCollectedByTheReportingCounterpartyPreHaircut = _initialMarginCollectedByTheReportingCounterpartyPreHaircut == null ? null : _initialMarginCollectedByTheReportingCounterpartyPreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfInitialMarginCollected")
        @RuneAttribute(value="currencyOfInitialMarginCollected")
        public CFTCMarginReportBuilder setCurrencyOfInitialMarginCollected(ISOCurrencyCodeEnum _currencyOfInitialMarginCollected) {
            this.currencyOfInitialMarginCollected = _currencyOfInitialMarginCollected == null ? null : _currencyOfInitialMarginCollected;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public CFTCMarginReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="variationMarginPostedByTheReportingCounterpartyPreHaircut")
        public CFTCMarginReportBuilder setVariationMarginPostedByTheReportingCounterpartyPreHaircut(BigDecimal _variationMarginPostedByTheReportingCounterpartyPreHaircut) {
            this.variationMarginPostedByTheReportingCounterpartyPreHaircut = _variationMarginPostedByTheReportingCounterpartyPreHaircut == null ? null : _variationMarginPostedByTheReportingCounterpartyPreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfVariationMarginPosted")
        @RuneAttribute(value="currencyOfVariationMarginPosted")
        public CFTCMarginReportBuilder setCurrencyOfVariationMarginPosted(ISOCurrencyCodeEnum _currencyOfVariationMarginPosted) {
            this.currencyOfVariationMarginPosted = _currencyOfVariationMarginPosted == null ? null : _currencyOfVariationMarginPosted;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheReportingCounterpartyPreHaircut")
        public CFTCMarginReportBuilder setVariationMarginCollectedByTheReportingCounterpartyPreHaircut(BigDecimal _variationMarginCollectedByTheReportingCounterpartyPreHaircut) {
            this.variationMarginCollectedByTheReportingCounterpartyPreHaircut = _variationMarginCollectedByTheReportingCounterpartyPreHaircut == null ? null : _variationMarginCollectedByTheReportingCounterpartyPreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfVariationMarginCollected")
        @RuneAttribute(value="currencyOfVariationMarginCollected")
        public CFTCMarginReportBuilder setCurrencyOfVariationMarginCollected(ISOCurrencyCodeEnum _currencyOfVariationMarginCollected) {
            this.currencyOfVariationMarginCollected = _currencyOfVariationMarginCollected == null ? null : _currencyOfVariationMarginCollected;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1IDType", isRequired=true)
        @RuneAttribute(value="tradeParty1IDType", isRequired=true)
        public CFTCMarginReportBuilder setTradeParty1IDType(PartyIdentifierTypeEnum _tradeParty1IDType) {
            this.tradeParty1IDType = _tradeParty1IDType == null ? null : _tradeParty1IDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="submittingPartyIDType", isRequired=true)
        @RuneAttribute(value="submittingPartyIDType", isRequired=true)
        public CFTCMarginReportBuilder setSubmittingPartyIDType(PartyIdentifierTypeEnum _submittingPartyIDType) {
            this.submittingPartyIDType = _submittingPartyIDType == null ? null : _submittingPartyIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="usiIDPrefix")
        @RuneAttribute(value="usiIDPrefix")
        public CFTCMarginReportBuilder setUsiIDPrefix(String _usiIDPrefix) {
            this.usiIDPrefix = _usiIDPrefix == null ? null : _usiIDPrefix;
            return this;
        }

        @Override
        @RosettaAttribute(value="utiIDPrefix")
        @RuneAttribute(value="utiIDPrefix")
        public CFTCMarginReportBuilder setUtiIDPrefix(String _utiIDPrefix) {
            this.utiIDPrefix = _utiIDPrefix == null ? null : _utiIDPrefix;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        @RuneAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        public CFTCMarginReportBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum _tradeParty1ReportingDestination) {
            if (_tradeParty1ReportingDestination != null) {
                this.tradeParty1ReportingDestination.add(_tradeParty1ReportingDestination);
            }
            return this;
        }

        @Override
        public CFTCMarginReportBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum _tradeParty1ReportingDestination, int idx) {
            this.getIndex(this.tradeParty1ReportingDestination, idx, () -> _tradeParty1ReportingDestination);
            return this;
        }

        @Override
        public CFTCMarginReportBuilder addTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestinations) {
            if (tradeParty1ReportingDestinations != null) {
                for (SupervisoryBodyEnum toAdd : tradeParty1ReportingDestinations) {
                    this.tradeParty1ReportingDestination.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeParty1ReportingDestination")
        public CFTCMarginReportBuilder setTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestinations) {
            this.tradeParty1ReportingDestination = tradeParty1ReportingDestinations == null ? new ArrayList<SupervisoryBodyEnum>() : (List)tradeParty1ReportingDestinations.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="comment1", isRequired=true)
        @RuneAttribute(value="comment1", isRequired=true)
        public CFTCMarginReportBuilder setComment1(String _comment1) {
            this.comment1 = _comment1 == null ? null : _comment1;
            return this;
        }

        @Override
        @RosettaAttribute(value="messageID", isRequired=true)
        @RuneAttribute(value="messageID", isRequired=true)
        public CFTCMarginReportBuilder setMessageID(String _messageID) {
            this.messageID = _messageID == null ? null : _messageID;
            return this;
        }

        @Override
        @RosettaAttribute(value="messageType", isRequired=true)
        @RuneAttribute(value="messageType", isRequired=true)
        public CFTCMarginReportBuilder setMessageType(String _messageType) {
            this.messageType = _messageType == null ? null : _messageType;
            return this;
        }

        @Override
        @RosettaAttribute(value="version", isRequired=true)
        @RuneAttribute(value="version", isRequired=true)
        public CFTCMarginReportBuilder setVersion(String _version) {
            this.version = _version == null ? null : _version;
            return this;
        }

        @Override
        public CFTCMarginReport build() {
            return new CFTCMarginReportImpl(this);
        }

        @Override
        public CFTCMarginReportBuilder toBuilder() {
            return this;
        }

        @Override
        public CFTCMarginReportBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getCounterparty1() != null) {
                return true;
            }
            if (this.getCounterparty2() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierSource() != null) {
                return true;
            }
            if (this.getSubmitterIdentifier() != null) {
                return true;
            }
            if (this.getActionType() != null) {
                return true;
            }
            if (this.getEventTimestamp() != null) {
                return true;
            }
            if (this.getReportingTimestamp() != null) {
                return true;
            }
            if (this.getUniqueSwapIdentifier() != null) {
                return true;
            }
            if (this.getUniqueTransactionIdentifier() != null) {
                return true;
            }
            if (this.getAffiliatedCounterpartyForMarginAndCapitalIndicator() != null) {
                return true;
            }
            if (this.getCollateralisationCategory() != null) {
                return true;
            }
            if (this.getInitialMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getPortfolioContainingNonReportableComponentIndicator() != null) {
                return true;
            }
            if (this.getInitialMarginPostedByTheReportingCounterpartyPostHaircut() != null) {
                return true;
            }
            if (this.getInitialMarginPostedByTheReportingCounterpartyPreHaircut() != null) {
                return true;
            }
            if (this.getCurrencyOfInitialMarginPosted() != null) {
                return true;
            }
            if (this.getInitialMarginCollectedByTheReportingCounterpartyPostHaircut() != null) {
                return true;
            }
            if (this.getInitialMarginCollectedByTheReportingCounterpartyPreHaircut() != null) {
                return true;
            }
            if (this.getCurrencyOfInitialMarginCollected() != null) {
                return true;
            }
            if (this.getVariationMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getVariationMarginPostedByTheReportingCounterpartyPreHaircut() != null) {
                return true;
            }
            if (this.getCurrencyOfVariationMarginPosted() != null) {
                return true;
            }
            if (this.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut() != null) {
                return true;
            }
            if (this.getCurrencyOfVariationMarginCollected() != null) {
                return true;
            }
            if (this.getTradeParty1IDType() != null) {
                return true;
            }
            if (this.getSubmittingPartyIDType() != null) {
                return true;
            }
            if (this.getUsiIDPrefix() != null) {
                return true;
            }
            if (this.getUtiIDPrefix() != null) {
                return true;
            }
            if (this.getTradeParty1ReportingDestination() != null && !this.getTradeParty1ReportingDestination().isEmpty()) {
                return true;
            }
            if (this.getComment1() != null) {
                return true;
            }
            if (this.getMessageID() != null) {
                return true;
            }
            if (this.getMessageType() != null) {
                return true;
            }
            return this.getVersion() != null;
        }

        public CFTCMarginReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CFTCMarginReportBuilder o = (CFTCMarginReportBuilder)other;
            merger.mergeBasic((Object)this.getCounterparty1(), (Object)o.getCounterparty1(), this::setCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2(), (Object)o.getCounterparty2(), this::setCounterparty2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierSource(), (Object)o.getCounterparty2IdentifierSource(), this::setCounterparty2IdentifierSource, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSubmitterIdentifier(), (Object)o.getSubmitterIdentifier(), this::setSubmitterIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getActionType(), (Object)o.getActionType(), this::setActionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventTimestamp(), (Object)o.getEventTimestamp(), this::setEventTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingTimestamp(), (Object)o.getReportingTimestamp(), this::setReportingTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueSwapIdentifier(), (Object)o.getUniqueSwapIdentifier(), this::setUniqueSwapIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifier(), (Object)o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAffiliatedCounterpartyForMarginAndCapitalIndicator(), (Object)o.getAffiliatedCounterpartyForMarginAndCapitalIndicator(), this::setAffiliatedCounterpartyForMarginAndCapitalIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCollateralisationCategory(), (Object)o.getCollateralisationCategory(), this::setCollateralisationCategory, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginCollateralPortfolioCode(), (Object)o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPortfolioContainingNonReportableComponentIndicator(), (Object)o.getPortfolioContainingNonReportableComponentIndicator(), this::setPortfolioContainingNonReportableComponentIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), (Object)o.getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), this::setInitialMarginPostedByTheReportingCounterpartyPostHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), (Object)o.getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), this::setInitialMarginPostedByTheReportingCounterpartyPreHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrencyOfInitialMarginPosted(), (Object)o.getCurrencyOfInitialMarginPosted(), this::setCurrencyOfInitialMarginPosted, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginCollectedByTheReportingCounterpartyPostHaircut(), (Object)o.getInitialMarginCollectedByTheReportingCounterpartyPostHaircut(), this::setInitialMarginCollectedByTheReportingCounterpartyPostHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginCollectedByTheReportingCounterpartyPreHaircut(), (Object)o.getInitialMarginCollectedByTheReportingCounterpartyPreHaircut(), this::setInitialMarginCollectedByTheReportingCounterpartyPreHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrencyOfInitialMarginCollected(), (Object)o.getCurrencyOfInitialMarginCollected(), this::setCurrencyOfInitialMarginCollected, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginCollateralPortfolioCode(), (Object)o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), (Object)o.getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), this::setVariationMarginPostedByTheReportingCounterpartyPreHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrencyOfVariationMarginPosted(), (Object)o.getCurrencyOfVariationMarginPosted(), this::setCurrencyOfVariationMarginPosted, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), (Object)o.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), this::setVariationMarginCollectedByTheReportingCounterpartyPreHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrencyOfVariationMarginCollected(), (Object)o.getCurrencyOfVariationMarginCollected(), this::setCurrencyOfVariationMarginCollected, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty1IDType(), (Object)o.getTradeParty1IDType(), this::setTradeParty1IDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSubmittingPartyIDType(), (Object)o.getSubmittingPartyIDType(), this::setSubmittingPartyIDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUsiIDPrefix(), (Object)o.getUsiIDPrefix(), this::setUsiIDPrefix, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUtiIDPrefix(), (Object)o.getUtiIDPrefix(), this::setUtiIDPrefix, new AttributeMeta[0]);
            merger.mergeBasic(this.getTradeParty1ReportingDestination(), o.getTradeParty1ReportingDestination(), this::addTradeParty1ReportingDestination);
            merger.mergeBasic((Object)this.getComment1(), (Object)o.getComment1(), this::setComment1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMessageID(), (Object)o.getMessageID(), this::setMessageID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMessageType(), (Object)o.getMessageType(), this::setMessageType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVersion(), (Object)o.getVersion(), this::setVersion, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CFTCMarginReport _that = this.getType().cast(o);
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierSource, _that.getCounterparty2IdentifierSource())) {
                return false;
            }
            if (!Objects.equals(this.submitterIdentifier, _that.getSubmitterIdentifier())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.uniqueSwapIdentifier, _that.getUniqueSwapIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.affiliatedCounterpartyForMarginAndCapitalIndicator, _that.getAffiliatedCounterpartyForMarginAndCapitalIndicator())) {
                return false;
            }
            if (!Objects.equals((Object)this.collateralisationCategory, (Object)_that.getCollateralisationCategory())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.portfolioContainingNonReportableComponentIndicator, _that.getPortfolioContainingNonReportableComponentIndicator())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginPostedByTheReportingCounterpartyPostHaircut, _that.getInitialMarginPostedByTheReportingCounterpartyPostHaircut())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginPostedByTheReportingCounterpartyPreHaircut, _that.getInitialMarginPostedByTheReportingCounterpartyPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfInitialMarginPosted, _that.getCurrencyOfInitialMarginPosted())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollectedByTheReportingCounterpartyPostHaircut, _that.getInitialMarginCollectedByTheReportingCounterpartyPostHaircut())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollectedByTheReportingCounterpartyPreHaircut, _that.getInitialMarginCollectedByTheReportingCounterpartyPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfInitialMarginCollected, _that.getCurrencyOfInitialMarginCollected())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginPostedByTheReportingCounterpartyPreHaircut, _that.getVariationMarginPostedByTheReportingCounterpartyPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfVariationMarginPosted, _that.getCurrencyOfVariationMarginPosted())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollectedByTheReportingCounterpartyPreHaircut, _that.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfVariationMarginCollected, _that.getCurrencyOfVariationMarginCollected())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1IDType, _that.getTradeParty1IDType())) {
                return false;
            }
            if (!Objects.equals(this.submittingPartyIDType, _that.getSubmittingPartyIDType())) {
                return false;
            }
            if (!Objects.equals(this.usiIDPrefix, _that.getUsiIDPrefix())) {
                return false;
            }
            if (!Objects.equals(this.utiIDPrefix, _that.getUtiIDPrefix())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeParty1ReportingDestination, _that.getTradeParty1ReportingDestination())) {
                return false;
            }
            if (!Objects.equals(this.comment1, _that.getComment1())) {
                return false;
            }
            if (!Objects.equals(this.messageID, _that.getMessageID())) {
                return false;
            }
            if (!Objects.equals(this.messageType, _that.getMessageType())) {
                return false;
            }
            return Objects.equals(this.version, _that.getVersion());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierSource != null ? this.counterparty2IdentifierSource.hashCode() : 0);
            _result = 31 * _result + (this.submitterIdentifier != null ? this.submitterIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.uniqueSwapIdentifier != null ? this.uniqueSwapIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.affiliatedCounterpartyForMarginAndCapitalIndicator != null ? this.affiliatedCounterpartyForMarginAndCapitalIndicator.hashCode() : 0);
            _result = 31 * _result + (this.collateralisationCategory != null ? ((Object)((Object)this.collateralisationCategory)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.portfolioContainingNonReportableComponentIndicator != null ? this.portfolioContainingNonReportableComponentIndicator.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginPostedByTheReportingCounterpartyPostHaircut != null ? this.initialMarginPostedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginPostedByTheReportingCounterpartyPreHaircut != null ? this.initialMarginPostedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfInitialMarginPosted != null ? this.currencyOfInitialMarginPosted.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollectedByTheReportingCounterpartyPostHaircut != null ? this.initialMarginCollectedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollectedByTheReportingCounterpartyPreHaircut != null ? this.initialMarginCollectedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfInitialMarginCollected != null ? this.currencyOfInitialMarginCollected.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginPostedByTheReportingCounterpartyPreHaircut != null ? this.variationMarginPostedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfVariationMarginPosted != null ? this.currencyOfVariationMarginPosted.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollectedByTheReportingCounterpartyPreHaircut != null ? this.variationMarginCollectedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfVariationMarginCollected != null ? this.currencyOfVariationMarginCollected.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1IDType != null ? this.tradeParty1IDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.submittingPartyIDType != null ? this.submittingPartyIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.usiIDPrefix != null ? this.usiIDPrefix.hashCode() : 0);
            _result = 31 * _result + (this.utiIDPrefix != null ? this.utiIDPrefix.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ReportingDestination != null ? this.tradeParty1ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.comment1 != null ? this.comment1.hashCode() : 0);
            _result = 31 * _result + (this.messageID != null ? this.messageID.hashCode() : 0);
            _result = 31 * _result + (this.messageType != null ? this.messageType.hashCode() : 0);
            _result = 31 * _result + (this.version != null ? this.version.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CFTCMarginReportBuilder {counterparty1=" + this.counterparty1 + ", counterparty2=" + this.counterparty2 + ", counterparty2IdentifierSource=" + this.counterparty2IdentifierSource + ", submitterIdentifier=" + this.submitterIdentifier + ", actionType=" + String.valueOf((Object)this.actionType) + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", uniqueSwapIdentifier=" + this.uniqueSwapIdentifier + ", uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", affiliatedCounterpartyForMarginAndCapitalIndicator=" + this.affiliatedCounterpartyForMarginAndCapitalIndicator + ", collateralisationCategory=" + String.valueOf((Object)this.collateralisationCategory) + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", portfolioContainingNonReportableComponentIndicator=" + this.portfolioContainingNonReportableComponentIndicator + ", initialMarginPostedByTheReportingCounterpartyPostHaircut=" + String.valueOf(this.initialMarginPostedByTheReportingCounterpartyPostHaircut) + ", initialMarginPostedByTheReportingCounterpartyPreHaircut=" + String.valueOf(this.initialMarginPostedByTheReportingCounterpartyPreHaircut) + ", currencyOfInitialMarginPosted=" + String.valueOf(this.currencyOfInitialMarginPosted) + ", initialMarginCollectedByTheReportingCounterpartyPostHaircut=" + String.valueOf(this.initialMarginCollectedByTheReportingCounterpartyPostHaircut) + ", initialMarginCollectedByTheReportingCounterpartyPreHaircut=" + String.valueOf(this.initialMarginCollectedByTheReportingCounterpartyPreHaircut) + ", currencyOfInitialMarginCollected=" + String.valueOf(this.currencyOfInitialMarginCollected) + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", variationMarginPostedByTheReportingCounterpartyPreHaircut=" + String.valueOf(this.variationMarginPostedByTheReportingCounterpartyPreHaircut) + ", currencyOfVariationMarginPosted=" + String.valueOf(this.currencyOfVariationMarginPosted) + ", variationMarginCollectedByTheReportingCounterpartyPreHaircut=" + String.valueOf(this.variationMarginCollectedByTheReportingCounterpartyPreHaircut) + ", currencyOfVariationMarginCollected=" + String.valueOf(this.currencyOfVariationMarginCollected) + ", tradeParty1IDType=" + String.valueOf(this.tradeParty1IDType) + ", submittingPartyIDType=" + String.valueOf(this.submittingPartyIDType) + ", usiIDPrefix=" + this.usiIDPrefix + ", utiIDPrefix=" + this.utiIDPrefix + ", tradeParty1ReportingDestination=" + String.valueOf(this.tradeParty1ReportingDestination) + ", comment1=" + this.comment1 + ", messageID=" + this.messageID + ", messageType=" + this.messageType + ", version=" + this.version + "}";
        }
    }

    public static interface CFTCMarginReportBuilder
    extends CFTCMarginReport,
    RosettaModelObjectBuilder {
        public CFTCMarginReportBuilder setCounterparty1(String var1);

        public CFTCMarginReportBuilder setCounterparty2(String var1);

        public CFTCMarginReportBuilder setCounterparty2IdentifierSource(String var1);

        public CFTCMarginReportBuilder setSubmitterIdentifier(String var1);

        public CFTCMarginReportBuilder setActionType(MarginActionEnum var1);

        public CFTCMarginReportBuilder setEventTimestamp(ZonedDateTime var1);

        public CFTCMarginReportBuilder setReportingTimestamp(ZonedDateTime var1);

        public CFTCMarginReportBuilder setUniqueSwapIdentifier(String var1);

        public CFTCMarginReportBuilder setUniqueTransactionIdentifier(String var1);

        public CFTCMarginReportBuilder setAffiliatedCounterpartyForMarginAndCapitalIndicator(Boolean var1);

        public CFTCMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code__1 var1);

        public CFTCMarginReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        public CFTCMarginReportBuilder setPortfolioContainingNonReportableComponentIndicator(Boolean var1);

        public CFTCMarginReportBuilder setInitialMarginPostedByTheReportingCounterpartyPostHaircut(BigDecimal var1);

        public CFTCMarginReportBuilder setInitialMarginPostedByTheReportingCounterpartyPreHaircut(BigDecimal var1);

        public CFTCMarginReportBuilder setCurrencyOfInitialMarginPosted(ISOCurrencyCodeEnum var1);

        public CFTCMarginReportBuilder setInitialMarginCollectedByTheReportingCounterpartyPostHaircut(BigDecimal var1);

        public CFTCMarginReportBuilder setInitialMarginCollectedByTheReportingCounterpartyPreHaircut(BigDecimal var1);

        public CFTCMarginReportBuilder setCurrencyOfInitialMarginCollected(ISOCurrencyCodeEnum var1);

        public CFTCMarginReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        public CFTCMarginReportBuilder setVariationMarginPostedByTheReportingCounterpartyPreHaircut(BigDecimal var1);

        public CFTCMarginReportBuilder setCurrencyOfVariationMarginPosted(ISOCurrencyCodeEnum var1);

        public CFTCMarginReportBuilder setVariationMarginCollectedByTheReportingCounterpartyPreHaircut(BigDecimal var1);

        public CFTCMarginReportBuilder setCurrencyOfVariationMarginCollected(ISOCurrencyCodeEnum var1);

        public CFTCMarginReportBuilder setTradeParty1IDType(PartyIdentifierTypeEnum var1);

        public CFTCMarginReportBuilder setSubmittingPartyIDType(PartyIdentifierTypeEnum var1);

        public CFTCMarginReportBuilder setUsiIDPrefix(String var1);

        public CFTCMarginReportBuilder setUtiIDPrefix(String var1);

        public CFTCMarginReportBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum var1);

        public CFTCMarginReportBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum var1, int var2);

        public CFTCMarginReportBuilder addTradeParty1ReportingDestination(List<SupervisoryBodyEnum> var1);

        public CFTCMarginReportBuilder setTradeParty1ReportingDestination(List<SupervisoryBodyEnum> var1);

        public CFTCMarginReportBuilder setComment1(String var1);

        public CFTCMarginReportBuilder setMessageID(String var1);

        public CFTCMarginReportBuilder setMessageType(String var1);

        public CFTCMarginReportBuilder setVersion(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, (Object)this.getSubmitterIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueSwapIdentifier"), String.class, (Object)this.getUniqueSwapIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("affiliatedCounterpartyForMarginAndCapitalIndicator"), Boolean.class, (Object)this.getAffiliatedCounterpartyForMarginAndCapitalIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code__1.class, (Object)this.getCollateralisationCategory(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("portfolioContainingNonReportableComponentIndicator"), Boolean.class, (Object)this.getPortfolioContainingNonReportableComponentIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfInitialMarginPosted"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyOfInitialMarginPosted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByTheReportingCounterpartyPostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByTheReportingCounterpartyPreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfInitialMarginCollected"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyOfInitialMarginCollected(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfVariationMarginPosted"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyOfVariationMarginPosted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfVariationMarginCollected"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyOfVariationMarginCollected(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1IDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1IDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submittingPartyIDType"), PartyIdentifierTypeEnum.class, (Object)this.getSubmittingPartyIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("usiIDPrefix"), String.class, (Object)this.getUsiIDPrefix(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("utiIDPrefix"), String.class, (Object)this.getUtiIDPrefix(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty1ReportingDestination(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment1"), String.class, (Object)this.getComment1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("messageID"), String.class, (Object)this.getMessageID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("messageType"), String.class, (Object)this.getMessageType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("version"), String.class, (Object)this.getVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CFTCMarginReportBuilder prune();
    }

    public static class CFTCMarginReportImpl
    implements CFTCMarginReport {
        private final String counterparty1;
        private final String counterparty2;
        private final String counterparty2IdentifierSource;
        private final String submitterIdentifier;
        private final MarginActionEnum actionType;
        private final ZonedDateTime eventTimestamp;
        private final ZonedDateTime reportingTimestamp;
        private final String uniqueSwapIdentifier;
        private final String uniqueTransactionIdentifier;
        private final Boolean affiliatedCounterpartyForMarginAndCapitalIndicator;
        private final CollateralisationType3Code__1 collateralisationCategory;
        private final String initialMarginCollateralPortfolioCode;
        private final Boolean portfolioContainingNonReportableComponentIndicator;
        private final BigDecimal initialMarginPostedByTheReportingCounterpartyPostHaircut;
        private final BigDecimal initialMarginPostedByTheReportingCounterpartyPreHaircut;
        private final ISOCurrencyCodeEnum currencyOfInitialMarginPosted;
        private final BigDecimal initialMarginCollectedByTheReportingCounterpartyPostHaircut;
        private final BigDecimal initialMarginCollectedByTheReportingCounterpartyPreHaircut;
        private final ISOCurrencyCodeEnum currencyOfInitialMarginCollected;
        private final String variationMarginCollateralPortfolioCode;
        private final BigDecimal variationMarginPostedByTheReportingCounterpartyPreHaircut;
        private final ISOCurrencyCodeEnum currencyOfVariationMarginPosted;
        private final BigDecimal variationMarginCollectedByTheReportingCounterpartyPreHaircut;
        private final ISOCurrencyCodeEnum currencyOfVariationMarginCollected;
        private final PartyIdentifierTypeEnum tradeParty1IDType;
        private final PartyIdentifierTypeEnum submittingPartyIDType;
        private final String usiIDPrefix;
        private final String utiIDPrefix;
        private final List<SupervisoryBodyEnum> tradeParty1ReportingDestination;
        private final String comment1;
        private final String messageID;
        private final String messageType;
        private final String version;

        protected CFTCMarginReportImpl(CFTCMarginReportBuilder builder) {
            this.counterparty1 = builder.getCounterparty1();
            this.counterparty2 = builder.getCounterparty2();
            this.counterparty2IdentifierSource = builder.getCounterparty2IdentifierSource();
            this.submitterIdentifier = builder.getSubmitterIdentifier();
            this.actionType = builder.getActionType();
            this.eventTimestamp = builder.getEventTimestamp();
            this.reportingTimestamp = builder.getReportingTimestamp();
            this.uniqueSwapIdentifier = builder.getUniqueSwapIdentifier();
            this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
            this.affiliatedCounterpartyForMarginAndCapitalIndicator = builder.getAffiliatedCounterpartyForMarginAndCapitalIndicator();
            this.collateralisationCategory = builder.getCollateralisationCategory();
            this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
            this.portfolioContainingNonReportableComponentIndicator = builder.getPortfolioContainingNonReportableComponentIndicator();
            this.initialMarginPostedByTheReportingCounterpartyPostHaircut = builder.getInitialMarginPostedByTheReportingCounterpartyPostHaircut();
            this.initialMarginPostedByTheReportingCounterpartyPreHaircut = builder.getInitialMarginPostedByTheReportingCounterpartyPreHaircut();
            this.currencyOfInitialMarginPosted = builder.getCurrencyOfInitialMarginPosted();
            this.initialMarginCollectedByTheReportingCounterpartyPostHaircut = builder.getInitialMarginCollectedByTheReportingCounterpartyPostHaircut();
            this.initialMarginCollectedByTheReportingCounterpartyPreHaircut = builder.getInitialMarginCollectedByTheReportingCounterpartyPreHaircut();
            this.currencyOfInitialMarginCollected = builder.getCurrencyOfInitialMarginCollected();
            this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
            this.variationMarginPostedByTheReportingCounterpartyPreHaircut = builder.getVariationMarginPostedByTheReportingCounterpartyPreHaircut();
            this.currencyOfVariationMarginPosted = builder.getCurrencyOfVariationMarginPosted();
            this.variationMarginCollectedByTheReportingCounterpartyPreHaircut = builder.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut();
            this.currencyOfVariationMarginCollected = builder.getCurrencyOfVariationMarginCollected();
            this.tradeParty1IDType = builder.getTradeParty1IDType();
            this.submittingPartyIDType = builder.getSubmittingPartyIDType();
            this.usiIDPrefix = builder.getUsiIDPrefix();
            this.utiIDPrefix = builder.getUtiIDPrefix();
            this.tradeParty1ReportingDestination = Optional.ofNullable(builder.getTradeParty1ReportingDestination()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.comment1 = builder.getComment1();
            this.messageID = builder.getMessageID();
            this.messageType = builder.getMessageType();
            this.version = builder.getVersion();
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
        public String getCounterparty2IdentifierSource() {
            return this.counterparty2IdentifierSource;
        }

        @Override
        @RosettaAttribute(value="submitterIdentifier", isRequired=true)
        @RuneAttribute(value="submitterIdentifier", isRequired=true)
        public String getSubmitterIdentifier() {
            return this.submitterIdentifier;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public MarginActionEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="uniqueSwapIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueSwapIdentifier", isRequired=true)
        public String getUniqueSwapIdentifier() {
            return this.uniqueSwapIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="affiliatedCounterpartyForMarginAndCapitalIndicator", isRequired=true)
        @RuneAttribute(value="affiliatedCounterpartyForMarginAndCapitalIndicator", isRequired=true)
        public Boolean getAffiliatedCounterpartyForMarginAndCapitalIndicator() {
            return this.affiliatedCounterpartyForMarginAndCapitalIndicator;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory")
        @RuneAttribute(value="collateralisationCategory")
        public CollateralisationType3Code__1 getCollateralisationCategory() {
            return this.collateralisationCategory;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
        @RuneAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
        public Boolean getPortfolioContainingNonReportableComponentIndicator() {
            return this.portfolioContainingNonReportableComponentIndicator;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheReportingCounterpartyPostHaircut")
        @RuneAttribute(value="initialMarginPostedByTheReportingCounterpartyPostHaircut")
        public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPostHaircut() {
            return this.initialMarginPostedByTheReportingCounterpartyPostHaircut;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="initialMarginPostedByTheReportingCounterpartyPreHaircut")
        public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPreHaircut() {
            return this.initialMarginPostedByTheReportingCounterpartyPreHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyOfInitialMarginPosted")
        @RuneAttribute(value="currencyOfInitialMarginPosted")
        public ISOCurrencyCodeEnum getCurrencyOfInitialMarginPosted() {
            return this.currencyOfInitialMarginPosted;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByTheReportingCounterpartyPostHaircut")
        @RuneAttribute(value="initialMarginCollectedByTheReportingCounterpartyPostHaircut")
        public BigDecimal getInitialMarginCollectedByTheReportingCounterpartyPostHaircut() {
            return this.initialMarginCollectedByTheReportingCounterpartyPostHaircut;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="initialMarginCollectedByTheReportingCounterpartyPreHaircut")
        public BigDecimal getInitialMarginCollectedByTheReportingCounterpartyPreHaircut() {
            return this.initialMarginCollectedByTheReportingCounterpartyPreHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyOfInitialMarginCollected")
        @RuneAttribute(value="currencyOfInitialMarginCollected")
        public ISOCurrencyCodeEnum getCurrencyOfInitialMarginCollected() {
            return this.currencyOfInitialMarginCollected;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="variationMarginPostedByTheReportingCounterpartyPreHaircut")
        public BigDecimal getVariationMarginPostedByTheReportingCounterpartyPreHaircut() {
            return this.variationMarginPostedByTheReportingCounterpartyPreHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyOfVariationMarginPosted")
        @RuneAttribute(value="currencyOfVariationMarginPosted")
        public ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted() {
            return this.currencyOfVariationMarginPosted;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheReportingCounterpartyPreHaircut")
        public BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPreHaircut() {
            return this.variationMarginCollectedByTheReportingCounterpartyPreHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyOfVariationMarginCollected")
        @RuneAttribute(value="currencyOfVariationMarginCollected")
        public ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected() {
            return this.currencyOfVariationMarginCollected;
        }

        @Override
        @RosettaAttribute(value="tradeParty1IDType", isRequired=true)
        @RuneAttribute(value="tradeParty1IDType", isRequired=true)
        public PartyIdentifierTypeEnum getTradeParty1IDType() {
            return this.tradeParty1IDType;
        }

        @Override
        @RosettaAttribute(value="submittingPartyIDType", isRequired=true)
        @RuneAttribute(value="submittingPartyIDType", isRequired=true)
        public PartyIdentifierTypeEnum getSubmittingPartyIDType() {
            return this.submittingPartyIDType;
        }

        @Override
        @RosettaAttribute(value="usiIDPrefix")
        @RuneAttribute(value="usiIDPrefix")
        public String getUsiIDPrefix() {
            return this.usiIDPrefix;
        }

        @Override
        @RosettaAttribute(value="utiIDPrefix")
        @RuneAttribute(value="utiIDPrefix")
        public String getUtiIDPrefix() {
            return this.utiIDPrefix;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        @RuneAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination() {
            return this.tradeParty1ReportingDestination;
        }

        @Override
        @RosettaAttribute(value="comment1", isRequired=true)
        @RuneAttribute(value="comment1", isRequired=true)
        public String getComment1() {
            return this.comment1;
        }

        @Override
        @RosettaAttribute(value="messageID", isRequired=true)
        @RuneAttribute(value="messageID", isRequired=true)
        public String getMessageID() {
            return this.messageID;
        }

        @Override
        @RosettaAttribute(value="messageType", isRequired=true)
        @RuneAttribute(value="messageType", isRequired=true)
        public String getMessageType() {
            return this.messageType;
        }

        @Override
        @RosettaAttribute(value="version", isRequired=true)
        @RuneAttribute(value="version", isRequired=true)
        public String getVersion() {
            return this.version;
        }

        @Override
        public CFTCMarginReport build() {
            return this;
        }

        @Override
        public CFTCMarginReportBuilder toBuilder() {
            CFTCMarginReportBuilder builder = CFTCMarginReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CFTCMarginReportBuilder builder) {
            Optional.ofNullable(this.getCounterparty1()).ifPresent(builder::setCounterparty1);
            Optional.ofNullable(this.getCounterparty2()).ifPresent(builder::setCounterparty2);
            Optional.ofNullable(this.getCounterparty2IdentifierSource()).ifPresent(builder::setCounterparty2IdentifierSource);
            Optional.ofNullable(this.getSubmitterIdentifier()).ifPresent(builder::setSubmitterIdentifier);
            Optional.ofNullable(this.getActionType()).ifPresent(builder::setActionType);
            Optional.ofNullable(this.getEventTimestamp()).ifPresent(builder::setEventTimestamp);
            Optional.ofNullable(this.getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
            Optional.ofNullable(this.getUniqueSwapIdentifier()).ifPresent(builder::setUniqueSwapIdentifier);
            Optional.ofNullable(this.getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
            Optional.ofNullable(this.getAffiliatedCounterpartyForMarginAndCapitalIndicator()).ifPresent(builder::setAffiliatedCounterpartyForMarginAndCapitalIndicator);
            Optional.ofNullable(this.getCollateralisationCategory()).ifPresent(builder::setCollateralisationCategory);
            Optional.ofNullable(this.getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
            Optional.ofNullable(this.getPortfolioContainingNonReportableComponentIndicator()).ifPresent(builder::setPortfolioContainingNonReportableComponentIndicator);
            Optional.ofNullable(this.getInitialMarginPostedByTheReportingCounterpartyPostHaircut()).ifPresent(builder::setInitialMarginPostedByTheReportingCounterpartyPostHaircut);
            Optional.ofNullable(this.getInitialMarginPostedByTheReportingCounterpartyPreHaircut()).ifPresent(builder::setInitialMarginPostedByTheReportingCounterpartyPreHaircut);
            Optional.ofNullable(this.getCurrencyOfInitialMarginPosted()).ifPresent(builder::setCurrencyOfInitialMarginPosted);
            Optional.ofNullable(this.getInitialMarginCollectedByTheReportingCounterpartyPostHaircut()).ifPresent(builder::setInitialMarginCollectedByTheReportingCounterpartyPostHaircut);
            Optional.ofNullable(this.getInitialMarginCollectedByTheReportingCounterpartyPreHaircut()).ifPresent(builder::setInitialMarginCollectedByTheReportingCounterpartyPreHaircut);
            Optional.ofNullable(this.getCurrencyOfInitialMarginCollected()).ifPresent(builder::setCurrencyOfInitialMarginCollected);
            Optional.ofNullable(this.getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
            Optional.ofNullable(this.getVariationMarginPostedByTheReportingCounterpartyPreHaircut()).ifPresent(builder::setVariationMarginPostedByTheReportingCounterpartyPreHaircut);
            Optional.ofNullable(this.getCurrencyOfVariationMarginPosted()).ifPresent(builder::setCurrencyOfVariationMarginPosted);
            Optional.ofNullable(this.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut()).ifPresent(builder::setVariationMarginCollectedByTheReportingCounterpartyPreHaircut);
            Optional.ofNullable(this.getCurrencyOfVariationMarginCollected()).ifPresent(builder::setCurrencyOfVariationMarginCollected);
            Optional.ofNullable(this.getTradeParty1IDType()).ifPresent(builder::setTradeParty1IDType);
            Optional.ofNullable(this.getSubmittingPartyIDType()).ifPresent(builder::setSubmittingPartyIDType);
            Optional.ofNullable(this.getUsiIDPrefix()).ifPresent(builder::setUsiIDPrefix);
            Optional.ofNullable(this.getUtiIDPrefix()).ifPresent(builder::setUtiIDPrefix);
            Optional.ofNullable(this.getTradeParty1ReportingDestination()).ifPresent(builder::setTradeParty1ReportingDestination);
            Optional.ofNullable(this.getComment1()).ifPresent(builder::setComment1);
            Optional.ofNullable(this.getMessageID()).ifPresent(builder::setMessageID);
            Optional.ofNullable(this.getMessageType()).ifPresent(builder::setMessageType);
            Optional.ofNullable(this.getVersion()).ifPresent(builder::setVersion);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CFTCMarginReport _that = this.getType().cast(o);
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierSource, _that.getCounterparty2IdentifierSource())) {
                return false;
            }
            if (!Objects.equals(this.submitterIdentifier, _that.getSubmitterIdentifier())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.uniqueSwapIdentifier, _that.getUniqueSwapIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.affiliatedCounterpartyForMarginAndCapitalIndicator, _that.getAffiliatedCounterpartyForMarginAndCapitalIndicator())) {
                return false;
            }
            if (!Objects.equals((Object)this.collateralisationCategory, (Object)_that.getCollateralisationCategory())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.portfolioContainingNonReportableComponentIndicator, _that.getPortfolioContainingNonReportableComponentIndicator())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginPostedByTheReportingCounterpartyPostHaircut, _that.getInitialMarginPostedByTheReportingCounterpartyPostHaircut())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginPostedByTheReportingCounterpartyPreHaircut, _that.getInitialMarginPostedByTheReportingCounterpartyPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfInitialMarginPosted, _that.getCurrencyOfInitialMarginPosted())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollectedByTheReportingCounterpartyPostHaircut, _that.getInitialMarginCollectedByTheReportingCounterpartyPostHaircut())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollectedByTheReportingCounterpartyPreHaircut, _that.getInitialMarginCollectedByTheReportingCounterpartyPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfInitialMarginCollected, _that.getCurrencyOfInitialMarginCollected())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginPostedByTheReportingCounterpartyPreHaircut, _that.getVariationMarginPostedByTheReportingCounterpartyPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfVariationMarginPosted, _that.getCurrencyOfVariationMarginPosted())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollectedByTheReportingCounterpartyPreHaircut, _that.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfVariationMarginCollected, _that.getCurrencyOfVariationMarginCollected())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1IDType, _that.getTradeParty1IDType())) {
                return false;
            }
            if (!Objects.equals(this.submittingPartyIDType, _that.getSubmittingPartyIDType())) {
                return false;
            }
            if (!Objects.equals(this.usiIDPrefix, _that.getUsiIDPrefix())) {
                return false;
            }
            if (!Objects.equals(this.utiIDPrefix, _that.getUtiIDPrefix())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeParty1ReportingDestination, _that.getTradeParty1ReportingDestination())) {
                return false;
            }
            if (!Objects.equals(this.comment1, _that.getComment1())) {
                return false;
            }
            if (!Objects.equals(this.messageID, _that.getMessageID())) {
                return false;
            }
            if (!Objects.equals(this.messageType, _that.getMessageType())) {
                return false;
            }
            return Objects.equals(this.version, _that.getVersion());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierSource != null ? this.counterparty2IdentifierSource.hashCode() : 0);
            _result = 31 * _result + (this.submitterIdentifier != null ? this.submitterIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.uniqueSwapIdentifier != null ? this.uniqueSwapIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.affiliatedCounterpartyForMarginAndCapitalIndicator != null ? this.affiliatedCounterpartyForMarginAndCapitalIndicator.hashCode() : 0);
            _result = 31 * _result + (this.collateralisationCategory != null ? ((Object)((Object)this.collateralisationCategory)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.portfolioContainingNonReportableComponentIndicator != null ? this.portfolioContainingNonReportableComponentIndicator.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginPostedByTheReportingCounterpartyPostHaircut != null ? this.initialMarginPostedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginPostedByTheReportingCounterpartyPreHaircut != null ? this.initialMarginPostedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfInitialMarginPosted != null ? this.currencyOfInitialMarginPosted.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollectedByTheReportingCounterpartyPostHaircut != null ? this.initialMarginCollectedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollectedByTheReportingCounterpartyPreHaircut != null ? this.initialMarginCollectedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfInitialMarginCollected != null ? this.currencyOfInitialMarginCollected.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginPostedByTheReportingCounterpartyPreHaircut != null ? this.variationMarginPostedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfVariationMarginPosted != null ? this.currencyOfVariationMarginPosted.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollectedByTheReportingCounterpartyPreHaircut != null ? this.variationMarginCollectedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfVariationMarginCollected != null ? this.currencyOfVariationMarginCollected.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1IDType != null ? this.tradeParty1IDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.submittingPartyIDType != null ? this.submittingPartyIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.usiIDPrefix != null ? this.usiIDPrefix.hashCode() : 0);
            _result = 31 * _result + (this.utiIDPrefix != null ? this.utiIDPrefix.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ReportingDestination != null ? this.tradeParty1ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.comment1 != null ? this.comment1.hashCode() : 0);
            _result = 31 * _result + (this.messageID != null ? this.messageID.hashCode() : 0);
            _result = 31 * _result + (this.messageType != null ? this.messageType.hashCode() : 0);
            _result = 31 * _result + (this.version != null ? this.version.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CFTCMarginReport {counterparty1=" + this.counterparty1 + ", counterparty2=" + this.counterparty2 + ", counterparty2IdentifierSource=" + this.counterparty2IdentifierSource + ", submitterIdentifier=" + this.submitterIdentifier + ", actionType=" + String.valueOf((Object)this.actionType) + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", uniqueSwapIdentifier=" + this.uniqueSwapIdentifier + ", uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", affiliatedCounterpartyForMarginAndCapitalIndicator=" + this.affiliatedCounterpartyForMarginAndCapitalIndicator + ", collateralisationCategory=" + String.valueOf((Object)this.collateralisationCategory) + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", portfolioContainingNonReportableComponentIndicator=" + this.portfolioContainingNonReportableComponentIndicator + ", initialMarginPostedByTheReportingCounterpartyPostHaircut=" + String.valueOf(this.initialMarginPostedByTheReportingCounterpartyPostHaircut) + ", initialMarginPostedByTheReportingCounterpartyPreHaircut=" + String.valueOf(this.initialMarginPostedByTheReportingCounterpartyPreHaircut) + ", currencyOfInitialMarginPosted=" + String.valueOf(this.currencyOfInitialMarginPosted) + ", initialMarginCollectedByTheReportingCounterpartyPostHaircut=" + String.valueOf(this.initialMarginCollectedByTheReportingCounterpartyPostHaircut) + ", initialMarginCollectedByTheReportingCounterpartyPreHaircut=" + String.valueOf(this.initialMarginCollectedByTheReportingCounterpartyPreHaircut) + ", currencyOfInitialMarginCollected=" + String.valueOf(this.currencyOfInitialMarginCollected) + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", variationMarginPostedByTheReportingCounterpartyPreHaircut=" + String.valueOf(this.variationMarginPostedByTheReportingCounterpartyPreHaircut) + ", currencyOfVariationMarginPosted=" + String.valueOf(this.currencyOfVariationMarginPosted) + ", variationMarginCollectedByTheReportingCounterpartyPreHaircut=" + String.valueOf(this.variationMarginCollectedByTheReportingCounterpartyPreHaircut) + ", currencyOfVariationMarginCollected=" + String.valueOf(this.currencyOfVariationMarginCollected) + ", tradeParty1IDType=" + String.valueOf(this.tradeParty1IDType) + ", submittingPartyIDType=" + String.valueOf(this.submittingPartyIDType) + ", usiIDPrefix=" + this.usiIDPrefix + ", utiIDPrefix=" + this.utiIDPrefix + ", tradeParty1ReportingDestination=" + String.valueOf(this.tradeParty1ReportingDestination) + ", comment1=" + this.comment1 + ", messageID=" + this.messageID + ", messageType=" + this.messageType + ", version=" + this.version + "}";
        }
    }
}

