/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.trade.reports;

import cdm.base.staticdata.identifier.TradeIdentifierTypeEnum;
import cdm.event.common.TradeIdentifier;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.cftc.rewrite.trade.functions.IsAllowableActionForCFTC;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.IsActionTypeNEWT;
import drr.regulation.common.functions.IsCleared;
import drr.standards.iosco.cde.version3.event.reports.EventTypeRule;
import drr.standards.iso.EventTypeEnum;
import javax.inject.Inject;

@ImplementedBy(value=OriginalSwapUSIRuleDefault.class)
public abstract class OriginalSwapUSIRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected BeforeTradeForEvent beforeTradeForEvent;
    @Inject
    protected EventTypeRule eventTypeRule;
    @Inject
    protected IsActionTypeNEWT isActionTypeNEWT;
    @Inject
    protected IsAllowableActionForCFTC isAllowableActionForCFTC;
    @Inject
    protected IsCleared isCleared;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class OriginalSwapUSIRuleDefault
    extends OriginalSwapUSIRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCFTC.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isCleared.evaluate((WorkflowStep)item.map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isActionTypeNEWT.evaluate((ReportableEvent)item.get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)this.eventTypeRule.evaluate((TransactionReportInstruction)item.get()))), (Mapper)MapperS.of((Object)((Object)EventTypeEnum.CLRG)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.beforeTradeForEvent.evaluate((ReportableEvent)item.get()));
                }
                return MapperS.ofNull();
            });
            MapperC thenArg2 = thenArg1.mapSingleToList(item -> item.mapC("getTradeIdentifier", trade -> trade.getTradeIdentifier()));
            MapperC thenArg3 = thenArg2.filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getIdentifierType", tradeIdentifier -> tradeIdentifier.getIdentifierType()), (Mapper)MapperS.of((Object)TradeIdentifierTypeEnum.UNIQUE_SWAP_IDENTIFIER), (CardinalityOperator)CardinalityOperator.All).get());
            MapperS thenArg4 = MapperS.of((Object)((TradeIdentifier)thenArg3.get()));
            MapperC thenArg5 = thenArg4.mapSingleToList(item -> item.mapC("getAssignedIdentifier", tradeIdentifier -> tradeIdentifier.getAssignedIdentifier()).map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier()));
            FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)thenArg5.last().get();
            output = fieldWithMetaString == null ? null : fieldWithMetaString.getValue();
            return output;
        }
    }
}

