/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.cftc.rewrite.trade.functions.IsAllowableActionForCFTC;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.base.payment.OtherPayment;
import drr.standards.iosco.cde.version3.payment.reports.OtherPaymentRule;
import drr.standards.iso.PaymentType4Code;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=OtherPaymentP43RuleDefault.class)
public abstract class OtherPaymentP43Rule
implements ReportFunction<TransactionReportInstruction, List<? extends OtherPayment>> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected IsAllowableActionForCFTC isAllowableActionForCFTC;
    @Inject
    protected OtherPaymentRule otherPaymentRule;

    public List<? extends OtherPayment> evaluate(TransactionReportInstruction input) {
        List output;
        List<OtherPayment.OtherPaymentBuilder> outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.stream().map(OtherPayment::build).collect(Collectors.toList());
            this.objectValidator.validate(OtherPayment.class, output);
        }
        return output;
    }

    protected abstract List<OtherPayment.OtherPaymentBuilder> doEvaluate(TransactionReportInstruction var1);

    public static class OtherPaymentP43RuleDefault
    extends OtherPaymentP43Rule {
        @Override
        protected List<OtherPayment.OtherPaymentBuilder> doEvaluate(TransactionReportInstruction input) {
            ArrayList<OtherPayment.OtherPaymentBuilder> output = new ArrayList<OtherPayment.OtherPaymentBuilder>();
            return this.assignOutput(output, input);
        }

        protected List<OtherPayment.OtherPaymentBuilder> assignOutput(List<OtherPayment.OtherPaymentBuilder> output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCFTC.evaluate((ReportableEvent)item.get()));
            MapperC thenArg1 = thenArg0.mapSingleToList(item -> MapperC.of(this.otherPaymentRule.evaluate((TransactionReportInstruction)item.get())));
            output = this.toBuilder(thenArg1.mapItem(item -> MapperS.of((Object)OtherPayment.builder().setPaymentType((PaymentType4Code)((Object)((Object)item.map("getPaymentType", otherPayment -> otherPayment.getPaymentType()).get()))).setAmount((BigDecimal)item.map("getAmount", otherPayment -> otherPayment.getAmount()).get()).setCurrency((ISOCurrencyCodeEnum)item.map("getCurrency", otherPayment -> otherPayment.getCurrency()).get()).setDate(null).setPayer(null).setPayerFormat(null).setReceiver(null).setReceiverFormat(null).setPayerSchemeName(null).setReceiverSchemeName(null).build())).getMulti());
            return Optional.ofNullable(output).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

