/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.valuation;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.cftc.rewrite.valuation.meta.CFTCValuationReportMeta;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CFTCValuationReport", builder=CFTCValuationReportBuilderImpl.class, version="6.17.1")
@RuneDataType(value="CFTCValuationReport", model="drr", builder=CFTCValuationReportBuilderImpl.class, version="6.17.1")
public interface CFTCValuationReport
extends RosettaModelObject {
    public static final CFTCValuationReportMeta metaData = new CFTCValuationReportMeta();

    public String getCounterparty1();

    public String getCounterparty2();

    public String getCounterparty2IdentifierSource();

    public String getSubmitterIdentifier();

    public ActionTypeEnum getActionType();

    public String getUniqueProductIdentifier();

    public ZonedDateTime getReportingTimestamp();

    public String getUniqueSwapIdentifier();

    public String getUniqueTransactionIdentifier();

    public Date getNextFloatingReferenceResetDateLeg1();

    public Date getNextFloatingReferenceResetDateLeg2();

    public BigDecimal getLastFloatingReferenceValueLeg1();

    public BigDecimal getLastFloatingReferenceValueLeg2();

    public Date getLastFloatingReferenceResetDateLeg1();

    public Date getLastFloatingReferenceResetDateLeg2();

    public BigDecimal getDelta();

    public BigDecimal getValuationAmount();

    public ISOCurrencyCodeEnum getValuationCurrency();

    public ValuationType1Code getValuationMethod();

    public ZonedDateTime getValuationTimestamp();

    public String getInitialMarginCollateralPortfolioCode();

    public String getVariationMarginCollateralPortfolioCode();

    public PartyIdentifierTypeEnum getTradeParty1IDType();

    public PartyIdentifierTypeEnum getSubmittingPartyIDType();

    public String getUsiIDPrefix();

    public String getUtiIDPrefix();

    public String getSubmittedForParty();

    public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination();

    public List<SupervisoryBodyEnum> getTradeParty2ReportingDestination();

    public AssetClassEnum getPrimaryAssetClass();

    public String getComment1();

    public String getMessageID();

    public String getMessageType();

    public String getTradeParty2ExecutionAgentID();

    public PartyIdentifierTypeEnum getTradeParty2ExecutionAgentIDType();

    public String getTradeParty1ExecutionAgentID();

    public PartyIdentifierTypeEnum getTradeParty1ExecutionAgentIDType();

    public String getTradeParty1TransactionID();

    public String getVersion();

    public CFTCValuationReport build();

    public CFTCValuationReportBuilder toBuilder();

    public static CFTCValuationReportBuilder builder() {
        return new CFTCValuationReportBuilderImpl();
    }

    default public RosettaMetaData<? extends CFTCValuationReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CFTCValuationReport> getType() {
        return CFTCValuationReport.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, (Object)this.getSubmitterIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueSwapIdentifier"), String.class, (Object)this.getUniqueSwapIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg1"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg2"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1IDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1IDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submittingPartyIDType"), PartyIdentifierTypeEnum.class, (Object)this.getSubmittingPartyIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("usiIDPrefix"), String.class, (Object)this.getUsiIDPrefix(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("utiIDPrefix"), String.class, (Object)this.getUtiIDPrefix(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submittedForParty"), String.class, (Object)this.getSubmittedForParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty1ReportingDestination(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty2ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty2ReportingDestination(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("primaryAssetClass"), AssetClassEnum.class, (Object)this.getPrimaryAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment1"), String.class, (Object)this.getComment1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("messageID"), String.class, (Object)this.getMessageID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("messageType"), String.class, (Object)this.getMessageType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentID"), String.class, (Object)this.getTradeParty2ExecutionAgentID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty2ExecutionAgentIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentID"), String.class, (Object)this.getTradeParty1ExecutionAgentID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1ExecutionAgentIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1TransactionID"), String.class, (Object)this.getTradeParty1TransactionID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("version"), String.class, (Object)this.getVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CFTCValuationReportBuilderImpl
    implements CFTCValuationReportBuilder {
        protected String counterparty1;
        protected String counterparty2;
        protected String counterparty2IdentifierSource;
        protected String submitterIdentifier;
        protected ActionTypeEnum actionType;
        protected String uniqueProductIdentifier;
        protected ZonedDateTime reportingTimestamp;
        protected String uniqueSwapIdentifier;
        protected String uniqueTransactionIdentifier;
        protected Date nextFloatingReferenceResetDateLeg1;
        protected Date nextFloatingReferenceResetDateLeg2;
        protected BigDecimal lastFloatingReferenceValueLeg1;
        protected BigDecimal lastFloatingReferenceValueLeg2;
        protected Date lastFloatingReferenceResetDateLeg1;
        protected Date lastFloatingReferenceResetDateLeg2;
        protected BigDecimal delta;
        protected BigDecimal valuationAmount;
        protected ISOCurrencyCodeEnum valuationCurrency;
        protected ValuationType1Code valuationMethod;
        protected ZonedDateTime valuationTimestamp;
        protected String initialMarginCollateralPortfolioCode;
        protected String variationMarginCollateralPortfolioCode;
        protected PartyIdentifierTypeEnum tradeParty1IDType;
        protected PartyIdentifierTypeEnum submittingPartyIDType;
        protected String usiIDPrefix;
        protected String utiIDPrefix;
        protected String submittedForParty;
        protected List<SupervisoryBodyEnum> tradeParty1ReportingDestination = new ArrayList<SupervisoryBodyEnum>();
        protected List<SupervisoryBodyEnum> tradeParty2ReportingDestination = new ArrayList<SupervisoryBodyEnum>();
        protected AssetClassEnum primaryAssetClass;
        protected String comment1;
        protected String messageID;
        protected String messageType;
        protected String tradeParty2ExecutionAgentID;
        protected PartyIdentifierTypeEnum tradeParty2ExecutionAgentIDType;
        protected String tradeParty1ExecutionAgentID;
        protected PartyIdentifierTypeEnum tradeParty1ExecutionAgentIDType;
        protected String tradeParty1TransactionID;
        protected String version;

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
        public String getCounterparty2IdentifierSource() {
            return this.counterparty2IdentifierSource;
        }

        @Override
        @RosettaAttribute(value="submitterIdentifier", isRequired=true)
        @RuneAttribute(value="submitterIdentifier", isRequired=true)
        public String getSubmitterIdentifier() {
            return this.submitterIdentifier;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public ActionTypeEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueProductIdentifier", isRequired=true)
        public String getUniqueProductIdentifier() {
            return this.uniqueProductIdentifier;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="uniqueSwapIdentifier")
        @RuneAttribute(value="uniqueSwapIdentifier")
        public String getUniqueSwapIdentifier() {
            return this.uniqueSwapIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public Date getNextFloatingReferenceResetDateLeg1() {
            return this.nextFloatingReferenceResetDateLeg1;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public Date getNextFloatingReferenceResetDateLeg2() {
            return this.nextFloatingReferenceResetDateLeg2;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg1")
        @RuneAttribute(value="lastFloatingReferenceValueLeg1")
        public BigDecimal getLastFloatingReferenceValueLeg1() {
            return this.lastFloatingReferenceValueLeg1;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg2")
        @RuneAttribute(value="lastFloatingReferenceValueLeg2")
        public BigDecimal getLastFloatingReferenceValueLeg2() {
            return this.lastFloatingReferenceValueLeg2;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg1")
        public Date getLastFloatingReferenceResetDateLeg1() {
            return this.lastFloatingReferenceResetDateLeg1;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg2")
        public Date getLastFloatingReferenceResetDateLeg2() {
            return this.lastFloatingReferenceResetDateLeg2;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public BigDecimal getDelta() {
            return this.delta;
        }

        @Override
        @RosettaAttribute(value="valuationAmount", isRequired=true)
        @RuneAttribute(value="valuationAmount", isRequired=true)
        public BigDecimal getValuationAmount() {
            return this.valuationAmount;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency", isRequired=true)
        @RuneAttribute(value="valuationCurrency", isRequired=true)
        public ISOCurrencyCodeEnum getValuationCurrency() {
            return this.valuationCurrency;
        }

        @Override
        @RosettaAttribute(value="valuationMethod", isRequired=true)
        @RuneAttribute(value="valuationMethod", isRequired=true)
        public ValuationType1Code getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp", isRequired=true)
        @RuneAttribute(value="valuationTimestamp", isRequired=true)
        public ZonedDateTime getValuationTimestamp() {
            return this.valuationTimestamp;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="initialMarginCollateralPortfolioCode", isRequired=true)
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="tradeParty1IDType", isRequired=true)
        @RuneAttribute(value="tradeParty1IDType", isRequired=true)
        public PartyIdentifierTypeEnum getTradeParty1IDType() {
            return this.tradeParty1IDType;
        }

        @Override
        @RosettaAttribute(value="submittingPartyIDType", isRequired=true)
        @RuneAttribute(value="submittingPartyIDType", isRequired=true)
        public PartyIdentifierTypeEnum getSubmittingPartyIDType() {
            return this.submittingPartyIDType;
        }

        @Override
        @RosettaAttribute(value="usiIDPrefix")
        @RuneAttribute(value="usiIDPrefix")
        public String getUsiIDPrefix() {
            return this.usiIDPrefix;
        }

        @Override
        @RosettaAttribute(value="utiIDPrefix")
        @RuneAttribute(value="utiIDPrefix")
        public String getUtiIDPrefix() {
            return this.utiIDPrefix;
        }

        @Override
        @RosettaAttribute(value="submittedForParty", isRequired=true)
        @RuneAttribute(value="submittedForParty", isRequired=true)
        public String getSubmittedForParty() {
            return this.submittedForParty;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        @RuneAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination() {
            return this.tradeParty1ReportingDestination;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ReportingDestination", isRequired=true)
        @RuneAttribute(value="tradeParty2ReportingDestination", isRequired=true)
        public List<SupervisoryBodyEnum> getTradeParty2ReportingDestination() {
            return this.tradeParty2ReportingDestination;
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass", isRequired=true)
        @RuneAttribute(value="primaryAssetClass", isRequired=true)
        public AssetClassEnum getPrimaryAssetClass() {
            return this.primaryAssetClass;
        }

        @Override
        @RosettaAttribute(value="comment1", isRequired=true)
        @RuneAttribute(value="comment1", isRequired=true)
        public String getComment1() {
            return this.comment1;
        }

        @Override
        @RosettaAttribute(value="messageID", isRequired=true)
        @RuneAttribute(value="messageID", isRequired=true)
        public String getMessageID() {
            return this.messageID;
        }

        @Override
        @RosettaAttribute(value="messageType", isRequired=true)
        @RuneAttribute(value="messageType", isRequired=true)
        public String getMessageType() {
            return this.messageType;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentID")
        @RuneAttribute(value="tradeParty2ExecutionAgentID")
        public String getTradeParty2ExecutionAgentID() {
            return this.tradeParty2ExecutionAgentID;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty2ExecutionAgentIDType")
        public PartyIdentifierTypeEnum getTradeParty2ExecutionAgentIDType() {
            return this.tradeParty2ExecutionAgentIDType;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentID")
        @RuneAttribute(value="tradeParty1ExecutionAgentID")
        public String getTradeParty1ExecutionAgentID() {
            return this.tradeParty1ExecutionAgentID;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty1ExecutionAgentIDType")
        public PartyIdentifierTypeEnum getTradeParty1ExecutionAgentIDType() {
            return this.tradeParty1ExecutionAgentIDType;
        }

        @Override
        @RosettaAttribute(value="tradeParty1TransactionID")
        @RuneAttribute(value="tradeParty1TransactionID")
        public String getTradeParty1TransactionID() {
            return this.tradeParty1TransactionID;
        }

        @Override
        @RosettaAttribute(value="version")
        @RuneAttribute(value="version")
        public String getVersion() {
            return this.version;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public CFTCValuationReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public CFTCValuationReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
        public CFTCValuationReportBuilder setCounterparty2IdentifierSource(String _counterparty2IdentifierSource) {
            this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="submitterIdentifier", isRequired=true)
        @RuneAttribute(value="submitterIdentifier", isRequired=true)
        public CFTCValuationReportBuilder setSubmitterIdentifier(String _submitterIdentifier) {
            this.submitterIdentifier = _submitterIdentifier == null ? null : _submitterIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public CFTCValuationReportBuilder setActionType(ActionTypeEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueProductIdentifier", isRequired=true)
        public CFTCValuationReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
            this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public CFTCValuationReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueSwapIdentifier")
        @RuneAttribute(value="uniqueSwapIdentifier")
        public CFTCValuationReportBuilder setUniqueSwapIdentifier(String _uniqueSwapIdentifier) {
            this.uniqueSwapIdentifier = _uniqueSwapIdentifier == null ? null : _uniqueSwapIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public CFTCValuationReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public CFTCValuationReportBuilder setNextFloatingReferenceResetDateLeg1(Date _nextFloatingReferenceResetDateLeg1) {
            this.nextFloatingReferenceResetDateLeg1 = _nextFloatingReferenceResetDateLeg1 == null ? null : _nextFloatingReferenceResetDateLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public CFTCValuationReportBuilder setNextFloatingReferenceResetDateLeg2(Date _nextFloatingReferenceResetDateLeg2) {
            this.nextFloatingReferenceResetDateLeg2 = _nextFloatingReferenceResetDateLeg2 == null ? null : _nextFloatingReferenceResetDateLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg1")
        @RuneAttribute(value="lastFloatingReferenceValueLeg1")
        public CFTCValuationReportBuilder setLastFloatingReferenceValueLeg1(BigDecimal _lastFloatingReferenceValueLeg1) {
            this.lastFloatingReferenceValueLeg1 = _lastFloatingReferenceValueLeg1 == null ? null : _lastFloatingReferenceValueLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg2")
        @RuneAttribute(value="lastFloatingReferenceValueLeg2")
        public CFTCValuationReportBuilder setLastFloatingReferenceValueLeg2(BigDecimal _lastFloatingReferenceValueLeg2) {
            this.lastFloatingReferenceValueLeg2 = _lastFloatingReferenceValueLeg2 == null ? null : _lastFloatingReferenceValueLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg1")
        public CFTCValuationReportBuilder setLastFloatingReferenceResetDateLeg1(Date _lastFloatingReferenceResetDateLeg1) {
            this.lastFloatingReferenceResetDateLeg1 = _lastFloatingReferenceResetDateLeg1 == null ? null : _lastFloatingReferenceResetDateLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg2")
        public CFTCValuationReportBuilder setLastFloatingReferenceResetDateLeg2(Date _lastFloatingReferenceResetDateLeg2) {
            this.lastFloatingReferenceResetDateLeg2 = _lastFloatingReferenceResetDateLeg2 == null ? null : _lastFloatingReferenceResetDateLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public CFTCValuationReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount", isRequired=true)
        @RuneAttribute(value="valuationAmount", isRequired=true)
        public CFTCValuationReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency", isRequired=true)
        @RuneAttribute(value="valuationCurrency", isRequired=true)
        public CFTCValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod", isRequired=true)
        @RuneAttribute(value="valuationMethod", isRequired=true)
        public CFTCValuationReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp", isRequired=true)
        @RuneAttribute(value="valuationTimestamp", isRequired=true)
        public CFTCValuationReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="initialMarginCollateralPortfolioCode", isRequired=true)
        public CFTCValuationReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        public CFTCValuationReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1IDType", isRequired=true)
        @RuneAttribute(value="tradeParty1IDType", isRequired=true)
        public CFTCValuationReportBuilder setTradeParty1IDType(PartyIdentifierTypeEnum _tradeParty1IDType) {
            this.tradeParty1IDType = _tradeParty1IDType == null ? null : _tradeParty1IDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="submittingPartyIDType", isRequired=true)
        @RuneAttribute(value="submittingPartyIDType", isRequired=true)
        public CFTCValuationReportBuilder setSubmittingPartyIDType(PartyIdentifierTypeEnum _submittingPartyIDType) {
            this.submittingPartyIDType = _submittingPartyIDType == null ? null : _submittingPartyIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="usiIDPrefix")
        @RuneAttribute(value="usiIDPrefix")
        public CFTCValuationReportBuilder setUsiIDPrefix(String _usiIDPrefix) {
            this.usiIDPrefix = _usiIDPrefix == null ? null : _usiIDPrefix;
            return this;
        }

        @Override
        @RosettaAttribute(value="utiIDPrefix")
        @RuneAttribute(value="utiIDPrefix")
        public CFTCValuationReportBuilder setUtiIDPrefix(String _utiIDPrefix) {
            this.utiIDPrefix = _utiIDPrefix == null ? null : _utiIDPrefix;
            return this;
        }

        @Override
        @RosettaAttribute(value="submittedForParty", isRequired=true)
        @RuneAttribute(value="submittedForParty", isRequired=true)
        public CFTCValuationReportBuilder setSubmittedForParty(String _submittedForParty) {
            this.submittedForParty = _submittedForParty == null ? null : _submittedForParty;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        @RuneAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        public CFTCValuationReportBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum _tradeParty1ReportingDestination) {
            if (_tradeParty1ReportingDestination != null) {
                this.tradeParty1ReportingDestination.add(_tradeParty1ReportingDestination);
            }
            return this;
        }

        @Override
        public CFTCValuationReportBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum _tradeParty1ReportingDestination, int idx) {
            this.getIndex(this.tradeParty1ReportingDestination, idx, () -> _tradeParty1ReportingDestination);
            return this;
        }

        @Override
        public CFTCValuationReportBuilder addTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestinations) {
            if (tradeParty1ReportingDestinations != null) {
                for (SupervisoryBodyEnum toAdd : tradeParty1ReportingDestinations) {
                    this.tradeParty1ReportingDestination.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeParty1ReportingDestination")
        public CFTCValuationReportBuilder setTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestinations) {
            this.tradeParty1ReportingDestination = tradeParty1ReportingDestinations == null ? new ArrayList<SupervisoryBodyEnum>() : (List)tradeParty1ReportingDestinations.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ReportingDestination", isRequired=true)
        @RuneAttribute(value="tradeParty2ReportingDestination", isRequired=true)
        public CFTCValuationReportBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum _tradeParty2ReportingDestination) {
            if (_tradeParty2ReportingDestination != null) {
                this.tradeParty2ReportingDestination.add(_tradeParty2ReportingDestination);
            }
            return this;
        }

        @Override
        public CFTCValuationReportBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum _tradeParty2ReportingDestination, int idx) {
            this.getIndex(this.tradeParty2ReportingDestination, idx, () -> _tradeParty2ReportingDestination);
            return this;
        }

        @Override
        public CFTCValuationReportBuilder addTradeParty2ReportingDestination(List<SupervisoryBodyEnum> tradeParty2ReportingDestinations) {
            if (tradeParty2ReportingDestinations != null) {
                for (SupervisoryBodyEnum toAdd : tradeParty2ReportingDestinations) {
                    this.tradeParty2ReportingDestination.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeParty2ReportingDestination")
        public CFTCValuationReportBuilder setTradeParty2ReportingDestination(List<SupervisoryBodyEnum> tradeParty2ReportingDestinations) {
            this.tradeParty2ReportingDestination = tradeParty2ReportingDestinations == null ? new ArrayList<SupervisoryBodyEnum>() : (List)tradeParty2ReportingDestinations.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass", isRequired=true)
        @RuneAttribute(value="primaryAssetClass", isRequired=true)
        public CFTCValuationReportBuilder setPrimaryAssetClass(AssetClassEnum _primaryAssetClass) {
            this.primaryAssetClass = _primaryAssetClass == null ? null : _primaryAssetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="comment1", isRequired=true)
        @RuneAttribute(value="comment1", isRequired=true)
        public CFTCValuationReportBuilder setComment1(String _comment1) {
            this.comment1 = _comment1 == null ? null : _comment1;
            return this;
        }

        @Override
        @RosettaAttribute(value="messageID", isRequired=true)
        @RuneAttribute(value="messageID", isRequired=true)
        public CFTCValuationReportBuilder setMessageID(String _messageID) {
            this.messageID = _messageID == null ? null : _messageID;
            return this;
        }

        @Override
        @RosettaAttribute(value="messageType", isRequired=true)
        @RuneAttribute(value="messageType", isRequired=true)
        public CFTCValuationReportBuilder setMessageType(String _messageType) {
            this.messageType = _messageType == null ? null : _messageType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentID")
        @RuneAttribute(value="tradeParty2ExecutionAgentID")
        public CFTCValuationReportBuilder setTradeParty2ExecutionAgentID(String _tradeParty2ExecutionAgentID) {
            this.tradeParty2ExecutionAgentID = _tradeParty2ExecutionAgentID == null ? null : _tradeParty2ExecutionAgentID;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty2ExecutionAgentIDType")
        public CFTCValuationReportBuilder setTradeParty2ExecutionAgentIDType(PartyIdentifierTypeEnum _tradeParty2ExecutionAgentIDType) {
            this.tradeParty2ExecutionAgentIDType = _tradeParty2ExecutionAgentIDType == null ? null : _tradeParty2ExecutionAgentIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentID")
        @RuneAttribute(value="tradeParty1ExecutionAgentID")
        public CFTCValuationReportBuilder setTradeParty1ExecutionAgentID(String _tradeParty1ExecutionAgentID) {
            this.tradeParty1ExecutionAgentID = _tradeParty1ExecutionAgentID == null ? null : _tradeParty1ExecutionAgentID;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty1ExecutionAgentIDType")
        public CFTCValuationReportBuilder setTradeParty1ExecutionAgentIDType(PartyIdentifierTypeEnum _tradeParty1ExecutionAgentIDType) {
            this.tradeParty1ExecutionAgentIDType = _tradeParty1ExecutionAgentIDType == null ? null : _tradeParty1ExecutionAgentIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1TransactionID")
        @RuneAttribute(value="tradeParty1TransactionID")
        public CFTCValuationReportBuilder setTradeParty1TransactionID(String _tradeParty1TransactionID) {
            this.tradeParty1TransactionID = _tradeParty1TransactionID == null ? null : _tradeParty1TransactionID;
            return this;
        }

        @Override
        @RosettaAttribute(value="version")
        @RuneAttribute(value="version")
        public CFTCValuationReportBuilder setVersion(String _version) {
            this.version = _version == null ? null : _version;
            return this;
        }

        @Override
        public CFTCValuationReport build() {
            return new CFTCValuationReportImpl(this);
        }

        @Override
        public CFTCValuationReportBuilder toBuilder() {
            return this;
        }

        @Override
        public CFTCValuationReportBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getCounterparty1() != null) {
                return true;
            }
            if (this.getCounterparty2() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierSource() != null) {
                return true;
            }
            if (this.getSubmitterIdentifier() != null) {
                return true;
            }
            if (this.getActionType() != null) {
                return true;
            }
            if (this.getUniqueProductIdentifier() != null) {
                return true;
            }
            if (this.getReportingTimestamp() != null) {
                return true;
            }
            if (this.getUniqueSwapIdentifier() != null) {
                return true;
            }
            if (this.getUniqueTransactionIdentifier() != null) {
                return true;
            }
            if (this.getNextFloatingReferenceResetDateLeg1() != null) {
                return true;
            }
            if (this.getNextFloatingReferenceResetDateLeg2() != null) {
                return true;
            }
            if (this.getLastFloatingReferenceValueLeg1() != null) {
                return true;
            }
            if (this.getLastFloatingReferenceValueLeg2() != null) {
                return true;
            }
            if (this.getLastFloatingReferenceResetDateLeg1() != null) {
                return true;
            }
            if (this.getLastFloatingReferenceResetDateLeg2() != null) {
                return true;
            }
            if (this.getDelta() != null) {
                return true;
            }
            if (this.getValuationAmount() != null) {
                return true;
            }
            if (this.getValuationCurrency() != null) {
                return true;
            }
            if (this.getValuationMethod() != null) {
                return true;
            }
            if (this.getValuationTimestamp() != null) {
                return true;
            }
            if (this.getInitialMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getVariationMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getTradeParty1IDType() != null) {
                return true;
            }
            if (this.getSubmittingPartyIDType() != null) {
                return true;
            }
            if (this.getUsiIDPrefix() != null) {
                return true;
            }
            if (this.getUtiIDPrefix() != null) {
                return true;
            }
            if (this.getSubmittedForParty() != null) {
                return true;
            }
            if (this.getTradeParty1ReportingDestination() != null && !this.getTradeParty1ReportingDestination().isEmpty()) {
                return true;
            }
            if (this.getTradeParty2ReportingDestination() != null && !this.getTradeParty2ReportingDestination().isEmpty()) {
                return true;
            }
            if (this.getPrimaryAssetClass() != null) {
                return true;
            }
            if (this.getComment1() != null) {
                return true;
            }
            if (this.getMessageID() != null) {
                return true;
            }
            if (this.getMessageType() != null) {
                return true;
            }
            if (this.getTradeParty2ExecutionAgentID() != null) {
                return true;
            }
            if (this.getTradeParty2ExecutionAgentIDType() != null) {
                return true;
            }
            if (this.getTradeParty1ExecutionAgentID() != null) {
                return true;
            }
            if (this.getTradeParty1ExecutionAgentIDType() != null) {
                return true;
            }
            if (this.getTradeParty1TransactionID() != null) {
                return true;
            }
            return this.getVersion() != null;
        }

        public CFTCValuationReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CFTCValuationReportBuilder o = (CFTCValuationReportBuilder)other;
            merger.mergeBasic((Object)this.getCounterparty1(), (Object)o.getCounterparty1(), this::setCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2(), (Object)o.getCounterparty2(), this::setCounterparty2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierSource(), (Object)o.getCounterparty2IdentifierSource(), this::setCounterparty2IdentifierSource, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSubmitterIdentifier(), (Object)o.getSubmitterIdentifier(), this::setSubmitterIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getActionType(), (Object)o.getActionType(), this::setActionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueProductIdentifier(), (Object)o.getUniqueProductIdentifier(), this::setUniqueProductIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingTimestamp(), (Object)o.getReportingTimestamp(), this::setReportingTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueSwapIdentifier(), (Object)o.getUniqueSwapIdentifier(), this::setUniqueSwapIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifier(), (Object)o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNextFloatingReferenceResetDateLeg1(), (Object)o.getNextFloatingReferenceResetDateLeg1(), this::setNextFloatingReferenceResetDateLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNextFloatingReferenceResetDateLeg2(), (Object)o.getNextFloatingReferenceResetDateLeg2(), this::setNextFloatingReferenceResetDateLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLastFloatingReferenceValueLeg1(), (Object)o.getLastFloatingReferenceValueLeg1(), this::setLastFloatingReferenceValueLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLastFloatingReferenceValueLeg2(), (Object)o.getLastFloatingReferenceValueLeg2(), this::setLastFloatingReferenceValueLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLastFloatingReferenceResetDateLeg1(), (Object)o.getLastFloatingReferenceResetDateLeg1(), this::setLastFloatingReferenceResetDateLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLastFloatingReferenceResetDateLeg2(), (Object)o.getLastFloatingReferenceResetDateLeg2(), this::setLastFloatingReferenceResetDateLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDelta(), (Object)o.getDelta(), this::setDelta, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationAmount(), (Object)o.getValuationAmount(), this::setValuationAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationCurrency(), (Object)o.getValuationCurrency(), this::setValuationCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationMethod(), (Object)o.getValuationMethod(), this::setValuationMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationTimestamp(), (Object)o.getValuationTimestamp(), this::setValuationTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginCollateralPortfolioCode(), (Object)o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginCollateralPortfolioCode(), (Object)o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty1IDType(), (Object)o.getTradeParty1IDType(), this::setTradeParty1IDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSubmittingPartyIDType(), (Object)o.getSubmittingPartyIDType(), this::setSubmittingPartyIDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUsiIDPrefix(), (Object)o.getUsiIDPrefix(), this::setUsiIDPrefix, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUtiIDPrefix(), (Object)o.getUtiIDPrefix(), this::setUtiIDPrefix, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSubmittedForParty(), (Object)o.getSubmittedForParty(), this::setSubmittedForParty, new AttributeMeta[0]);
            merger.mergeBasic(this.getTradeParty1ReportingDestination(), o.getTradeParty1ReportingDestination(), this::addTradeParty1ReportingDestination);
            merger.mergeBasic(this.getTradeParty2ReportingDestination(), o.getTradeParty2ReportingDestination(), this::addTradeParty2ReportingDestination);
            merger.mergeBasic((Object)this.getPrimaryAssetClass(), (Object)o.getPrimaryAssetClass(), this::setPrimaryAssetClass, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getComment1(), (Object)o.getComment1(), this::setComment1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMessageID(), (Object)o.getMessageID(), this::setMessageID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMessageType(), (Object)o.getMessageType(), this::setMessageType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty2ExecutionAgentID(), (Object)o.getTradeParty2ExecutionAgentID(), this::setTradeParty2ExecutionAgentID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty2ExecutionAgentIDType(), (Object)o.getTradeParty2ExecutionAgentIDType(), this::setTradeParty2ExecutionAgentIDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty1ExecutionAgentID(), (Object)o.getTradeParty1ExecutionAgentID(), this::setTradeParty1ExecutionAgentID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty1ExecutionAgentIDType(), (Object)o.getTradeParty1ExecutionAgentIDType(), this::setTradeParty1ExecutionAgentIDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty1TransactionID(), (Object)o.getTradeParty1TransactionID(), this::setTradeParty1TransactionID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVersion(), (Object)o.getVersion(), this::setVersion, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CFTCValuationReport _that = this.getType().cast(o);
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierSource, _that.getCounterparty2IdentifierSource())) {
                return false;
            }
            if (!Objects.equals(this.submitterIdentifier, _that.getSubmitterIdentifier())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.uniqueProductIdentifier, _that.getUniqueProductIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.uniqueSwapIdentifier, _that.getUniqueSwapIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg1, _that.getNextFloatingReferenceResetDateLeg1())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg2, _that.getNextFloatingReferenceResetDateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.lastFloatingReferenceValueLeg1, _that.getLastFloatingReferenceValueLeg1())) {
                return false;
            }
            if (!Objects.equals(this.lastFloatingReferenceValueLeg2, _that.getLastFloatingReferenceValueLeg2())) {
                return false;
            }
            if (!Objects.equals(this.lastFloatingReferenceResetDateLeg1, _that.getLastFloatingReferenceResetDateLeg1())) {
                return false;
            }
            if (!Objects.equals(this.lastFloatingReferenceResetDateLeg2, _that.getLastFloatingReferenceResetDateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.delta, _that.getDelta())) {
                return false;
            }
            if (!Objects.equals(this.valuationAmount, _that.getValuationAmount())) {
                return false;
            }
            if (!Objects.equals(this.valuationCurrency, _that.getValuationCurrency())) {
                return false;
            }
            if (!Objects.equals((Object)this.valuationMethod, (Object)_that.getValuationMethod())) {
                return false;
            }
            if (!Objects.equals(this.valuationTimestamp, _that.getValuationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1IDType, _that.getTradeParty1IDType())) {
                return false;
            }
            if (!Objects.equals(this.submittingPartyIDType, _that.getSubmittingPartyIDType())) {
                return false;
            }
            if (!Objects.equals(this.usiIDPrefix, _that.getUsiIDPrefix())) {
                return false;
            }
            if (!Objects.equals(this.utiIDPrefix, _that.getUtiIDPrefix())) {
                return false;
            }
            if (!Objects.equals(this.submittedForParty, _that.getSubmittedForParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeParty1ReportingDestination, _that.getTradeParty1ReportingDestination())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeParty2ReportingDestination, _that.getTradeParty2ReportingDestination())) {
                return false;
            }
            if (!Objects.equals(this.primaryAssetClass, _that.getPrimaryAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.comment1, _that.getComment1())) {
                return false;
            }
            if (!Objects.equals(this.messageID, _that.getMessageID())) {
                return false;
            }
            if (!Objects.equals(this.messageType, _that.getMessageType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty2ExecutionAgentID, _that.getTradeParty2ExecutionAgentID())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty2ExecutionAgentIDType, _that.getTradeParty2ExecutionAgentIDType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1ExecutionAgentID, _that.getTradeParty1ExecutionAgentID())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1ExecutionAgentIDType, _that.getTradeParty1ExecutionAgentIDType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1TransactionID, _that.getTradeParty1TransactionID())) {
                return false;
            }
            return Objects.equals(this.version, _that.getVersion());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierSource != null ? this.counterparty2IdentifierSource.hashCode() : 0);
            _result = 31 * _result + (this.submitterIdentifier != null ? this.submitterIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.uniqueProductIdentifier != null ? this.uniqueProductIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.uniqueSwapIdentifier != null ? this.uniqueSwapIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg1 != null ? this.nextFloatingReferenceResetDateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg2 != null ? this.nextFloatingReferenceResetDateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReferenceValueLeg1 != null ? this.lastFloatingReferenceValueLeg1.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReferenceValueLeg2 != null ? this.lastFloatingReferenceValueLeg2.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReferenceResetDateLeg1 != null ? this.lastFloatingReferenceResetDateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReferenceResetDateLeg2 != null ? this.lastFloatingReferenceResetDateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.delta != null ? this.delta.hashCode() : 0);
            _result = 31 * _result + (this.valuationAmount != null ? this.valuationAmount.hashCode() : 0);
            _result = 31 * _result + (this.valuationCurrency != null ? this.valuationCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? ((Object)((Object)this.valuationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationTimestamp != null ? this.valuationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1IDType != null ? this.tradeParty1IDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.submittingPartyIDType != null ? this.submittingPartyIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.usiIDPrefix != null ? this.usiIDPrefix.hashCode() : 0);
            _result = 31 * _result + (this.utiIDPrefix != null ? this.utiIDPrefix.hashCode() : 0);
            _result = 31 * _result + (this.submittedForParty != null ? this.submittedForParty.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ReportingDestination != null ? this.tradeParty1ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.tradeParty2ReportingDestination != null ? this.tradeParty2ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.primaryAssetClass != null ? this.primaryAssetClass.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.comment1 != null ? this.comment1.hashCode() : 0);
            _result = 31 * _result + (this.messageID != null ? this.messageID.hashCode() : 0);
            _result = 31 * _result + (this.messageType != null ? this.messageType.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty2ExecutionAgentID != null ? this.tradeParty2ExecutionAgentID.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty2ExecutionAgentIDType != null ? this.tradeParty2ExecutionAgentIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ExecutionAgentID != null ? this.tradeParty1ExecutionAgentID.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ExecutionAgentIDType != null ? this.tradeParty1ExecutionAgentIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1TransactionID != null ? this.tradeParty1TransactionID.hashCode() : 0);
            _result = 31 * _result + (this.version != null ? this.version.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CFTCValuationReportBuilder {counterparty1=" + this.counterparty1 + ", counterparty2=" + this.counterparty2 + ", counterparty2IdentifierSource=" + this.counterparty2IdentifierSource + ", submitterIdentifier=" + this.submitterIdentifier + ", actionType=" + String.valueOf((Object)this.actionType) + ", uniqueProductIdentifier=" + this.uniqueProductIdentifier + ", reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", uniqueSwapIdentifier=" + this.uniqueSwapIdentifier + ", uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", nextFloatingReferenceResetDateLeg1=" + String.valueOf(this.nextFloatingReferenceResetDateLeg1) + ", nextFloatingReferenceResetDateLeg2=" + String.valueOf(this.nextFloatingReferenceResetDateLeg2) + ", lastFloatingReferenceValueLeg1=" + String.valueOf(this.lastFloatingReferenceValueLeg1) + ", lastFloatingReferenceValueLeg2=" + String.valueOf(this.lastFloatingReferenceValueLeg2) + ", lastFloatingReferenceResetDateLeg1=" + String.valueOf(this.lastFloatingReferenceResetDateLeg1) + ", lastFloatingReferenceResetDateLeg2=" + String.valueOf(this.lastFloatingReferenceResetDateLeg2) + ", delta=" + String.valueOf(this.delta) + ", valuationAmount=" + String.valueOf(this.valuationAmount) + ", valuationCurrency=" + String.valueOf(this.valuationCurrency) + ", valuationMethod=" + String.valueOf((Object)this.valuationMethod) + ", valuationTimestamp=" + String.valueOf(this.valuationTimestamp) + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", tradeParty1IDType=" + String.valueOf(this.tradeParty1IDType) + ", submittingPartyIDType=" + String.valueOf(this.submittingPartyIDType) + ", usiIDPrefix=" + this.usiIDPrefix + ", utiIDPrefix=" + this.utiIDPrefix + ", submittedForParty=" + this.submittedForParty + ", tradeParty1ReportingDestination=" + String.valueOf(this.tradeParty1ReportingDestination) + ", tradeParty2ReportingDestination=" + String.valueOf(this.tradeParty2ReportingDestination) + ", primaryAssetClass=" + String.valueOf(this.primaryAssetClass) + ", comment1=" + this.comment1 + ", messageID=" + this.messageID + ", messageType=" + this.messageType + ", tradeParty2ExecutionAgentID=" + this.tradeParty2ExecutionAgentID + ", tradeParty2ExecutionAgentIDType=" + String.valueOf(this.tradeParty2ExecutionAgentIDType) + ", tradeParty1ExecutionAgentID=" + this.tradeParty1ExecutionAgentID + ", tradeParty1ExecutionAgentIDType=" + String.valueOf(this.tradeParty1ExecutionAgentIDType) + ", tradeParty1TransactionID=" + this.tradeParty1TransactionID + ", version=" + this.version + "}";
        }
    }

    public static interface CFTCValuationReportBuilder
    extends CFTCValuationReport,
    RosettaModelObjectBuilder {
        public CFTCValuationReportBuilder setCounterparty1(String var1);

        public CFTCValuationReportBuilder setCounterparty2(String var1);

        public CFTCValuationReportBuilder setCounterparty2IdentifierSource(String var1);

        public CFTCValuationReportBuilder setSubmitterIdentifier(String var1);

        public CFTCValuationReportBuilder setActionType(ActionTypeEnum var1);

        public CFTCValuationReportBuilder setUniqueProductIdentifier(String var1);

        public CFTCValuationReportBuilder setReportingTimestamp(ZonedDateTime var1);

        public CFTCValuationReportBuilder setUniqueSwapIdentifier(String var1);

        public CFTCValuationReportBuilder setUniqueTransactionIdentifier(String var1);

        public CFTCValuationReportBuilder setNextFloatingReferenceResetDateLeg1(Date var1);

        public CFTCValuationReportBuilder setNextFloatingReferenceResetDateLeg2(Date var1);

        public CFTCValuationReportBuilder setLastFloatingReferenceValueLeg1(BigDecimal var1);

        public CFTCValuationReportBuilder setLastFloatingReferenceValueLeg2(BigDecimal var1);

        public CFTCValuationReportBuilder setLastFloatingReferenceResetDateLeg1(Date var1);

        public CFTCValuationReportBuilder setLastFloatingReferenceResetDateLeg2(Date var1);

        public CFTCValuationReportBuilder setDelta(BigDecimal var1);

        public CFTCValuationReportBuilder setValuationAmount(BigDecimal var1);

        public CFTCValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        public CFTCValuationReportBuilder setValuationMethod(ValuationType1Code var1);

        public CFTCValuationReportBuilder setValuationTimestamp(ZonedDateTime var1);

        public CFTCValuationReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        public CFTCValuationReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        public CFTCValuationReportBuilder setTradeParty1IDType(PartyIdentifierTypeEnum var1);

        public CFTCValuationReportBuilder setSubmittingPartyIDType(PartyIdentifierTypeEnum var1);

        public CFTCValuationReportBuilder setUsiIDPrefix(String var1);

        public CFTCValuationReportBuilder setUtiIDPrefix(String var1);

        public CFTCValuationReportBuilder setSubmittedForParty(String var1);

        public CFTCValuationReportBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum var1);

        public CFTCValuationReportBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum var1, int var2);

        public CFTCValuationReportBuilder addTradeParty1ReportingDestination(List<SupervisoryBodyEnum> var1);

        public CFTCValuationReportBuilder setTradeParty1ReportingDestination(List<SupervisoryBodyEnum> var1);

        public CFTCValuationReportBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum var1);

        public CFTCValuationReportBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum var1, int var2);

        public CFTCValuationReportBuilder addTradeParty2ReportingDestination(List<SupervisoryBodyEnum> var1);

        public CFTCValuationReportBuilder setTradeParty2ReportingDestination(List<SupervisoryBodyEnum> var1);

        public CFTCValuationReportBuilder setPrimaryAssetClass(AssetClassEnum var1);

        public CFTCValuationReportBuilder setComment1(String var1);

        public CFTCValuationReportBuilder setMessageID(String var1);

        public CFTCValuationReportBuilder setMessageType(String var1);

        public CFTCValuationReportBuilder setTradeParty2ExecutionAgentID(String var1);

        public CFTCValuationReportBuilder setTradeParty2ExecutionAgentIDType(PartyIdentifierTypeEnum var1);

        public CFTCValuationReportBuilder setTradeParty1ExecutionAgentID(String var1);

        public CFTCValuationReportBuilder setTradeParty1ExecutionAgentIDType(PartyIdentifierTypeEnum var1);

        public CFTCValuationReportBuilder setTradeParty1TransactionID(String var1);

        public CFTCValuationReportBuilder setVersion(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, (Object)this.getSubmitterIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueSwapIdentifier"), String.class, (Object)this.getUniqueSwapIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg1"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg2"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1IDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1IDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submittingPartyIDType"), PartyIdentifierTypeEnum.class, (Object)this.getSubmittingPartyIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("usiIDPrefix"), String.class, (Object)this.getUsiIDPrefix(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("utiIDPrefix"), String.class, (Object)this.getUtiIDPrefix(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submittedForParty"), String.class, (Object)this.getSubmittedForParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty1ReportingDestination(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty2ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty2ReportingDestination(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("primaryAssetClass"), AssetClassEnum.class, (Object)this.getPrimaryAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment1"), String.class, (Object)this.getComment1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("messageID"), String.class, (Object)this.getMessageID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("messageType"), String.class, (Object)this.getMessageType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentID"), String.class, (Object)this.getTradeParty2ExecutionAgentID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty2ExecutionAgentIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentID"), String.class, (Object)this.getTradeParty1ExecutionAgentID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1ExecutionAgentIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1TransactionID"), String.class, (Object)this.getTradeParty1TransactionID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("version"), String.class, (Object)this.getVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CFTCValuationReportBuilder prune();
    }

    public static class CFTCValuationReportImpl
    implements CFTCValuationReport {
        private final String counterparty1;
        private final String counterparty2;
        private final String counterparty2IdentifierSource;
        private final String submitterIdentifier;
        private final ActionTypeEnum actionType;
        private final String uniqueProductIdentifier;
        private final ZonedDateTime reportingTimestamp;
        private final String uniqueSwapIdentifier;
        private final String uniqueTransactionIdentifier;
        private final Date nextFloatingReferenceResetDateLeg1;
        private final Date nextFloatingReferenceResetDateLeg2;
        private final BigDecimal lastFloatingReferenceValueLeg1;
        private final BigDecimal lastFloatingReferenceValueLeg2;
        private final Date lastFloatingReferenceResetDateLeg1;
        private final Date lastFloatingReferenceResetDateLeg2;
        private final BigDecimal delta;
        private final BigDecimal valuationAmount;
        private final ISOCurrencyCodeEnum valuationCurrency;
        private final ValuationType1Code valuationMethod;
        private final ZonedDateTime valuationTimestamp;
        private final String initialMarginCollateralPortfolioCode;
        private final String variationMarginCollateralPortfolioCode;
        private final PartyIdentifierTypeEnum tradeParty1IDType;
        private final PartyIdentifierTypeEnum submittingPartyIDType;
        private final String usiIDPrefix;
        private final String utiIDPrefix;
        private final String submittedForParty;
        private final List<SupervisoryBodyEnum> tradeParty1ReportingDestination;
        private final List<SupervisoryBodyEnum> tradeParty2ReportingDestination;
        private final AssetClassEnum primaryAssetClass;
        private final String comment1;
        private final String messageID;
        private final String messageType;
        private final String tradeParty2ExecutionAgentID;
        private final PartyIdentifierTypeEnum tradeParty2ExecutionAgentIDType;
        private final String tradeParty1ExecutionAgentID;
        private final PartyIdentifierTypeEnum tradeParty1ExecutionAgentIDType;
        private final String tradeParty1TransactionID;
        private final String version;

        protected CFTCValuationReportImpl(CFTCValuationReportBuilder builder) {
            this.counterparty1 = builder.getCounterparty1();
            this.counterparty2 = builder.getCounterparty2();
            this.counterparty2IdentifierSource = builder.getCounterparty2IdentifierSource();
            this.submitterIdentifier = builder.getSubmitterIdentifier();
            this.actionType = builder.getActionType();
            this.uniqueProductIdentifier = builder.getUniqueProductIdentifier();
            this.reportingTimestamp = builder.getReportingTimestamp();
            this.uniqueSwapIdentifier = builder.getUniqueSwapIdentifier();
            this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
            this.nextFloatingReferenceResetDateLeg1 = builder.getNextFloatingReferenceResetDateLeg1();
            this.nextFloatingReferenceResetDateLeg2 = builder.getNextFloatingReferenceResetDateLeg2();
            this.lastFloatingReferenceValueLeg1 = builder.getLastFloatingReferenceValueLeg1();
            this.lastFloatingReferenceValueLeg2 = builder.getLastFloatingReferenceValueLeg2();
            this.lastFloatingReferenceResetDateLeg1 = builder.getLastFloatingReferenceResetDateLeg1();
            this.lastFloatingReferenceResetDateLeg2 = builder.getLastFloatingReferenceResetDateLeg2();
            this.delta = builder.getDelta();
            this.valuationAmount = builder.getValuationAmount();
            this.valuationCurrency = builder.getValuationCurrency();
            this.valuationMethod = builder.getValuationMethod();
            this.valuationTimestamp = builder.getValuationTimestamp();
            this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
            this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
            this.tradeParty1IDType = builder.getTradeParty1IDType();
            this.submittingPartyIDType = builder.getSubmittingPartyIDType();
            this.usiIDPrefix = builder.getUsiIDPrefix();
            this.utiIDPrefix = builder.getUtiIDPrefix();
            this.submittedForParty = builder.getSubmittedForParty();
            this.tradeParty1ReportingDestination = Optional.ofNullable(builder.getTradeParty1ReportingDestination()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.tradeParty2ReportingDestination = Optional.ofNullable(builder.getTradeParty2ReportingDestination()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.primaryAssetClass = builder.getPrimaryAssetClass();
            this.comment1 = builder.getComment1();
            this.messageID = builder.getMessageID();
            this.messageType = builder.getMessageType();
            this.tradeParty2ExecutionAgentID = builder.getTradeParty2ExecutionAgentID();
            this.tradeParty2ExecutionAgentIDType = builder.getTradeParty2ExecutionAgentIDType();
            this.tradeParty1ExecutionAgentID = builder.getTradeParty1ExecutionAgentID();
            this.tradeParty1ExecutionAgentIDType = builder.getTradeParty1ExecutionAgentIDType();
            this.tradeParty1TransactionID = builder.getTradeParty1TransactionID();
            this.version = builder.getVersion();
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
        public String getCounterparty2IdentifierSource() {
            return this.counterparty2IdentifierSource;
        }

        @Override
        @RosettaAttribute(value="submitterIdentifier", isRequired=true)
        @RuneAttribute(value="submitterIdentifier", isRequired=true)
        public String getSubmitterIdentifier() {
            return this.submitterIdentifier;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public ActionTypeEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueProductIdentifier", isRequired=true)
        public String getUniqueProductIdentifier() {
            return this.uniqueProductIdentifier;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="uniqueSwapIdentifier")
        @RuneAttribute(value="uniqueSwapIdentifier")
        public String getUniqueSwapIdentifier() {
            return this.uniqueSwapIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public Date getNextFloatingReferenceResetDateLeg1() {
            return this.nextFloatingReferenceResetDateLeg1;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public Date getNextFloatingReferenceResetDateLeg2() {
            return this.nextFloatingReferenceResetDateLeg2;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg1")
        @RuneAttribute(value="lastFloatingReferenceValueLeg1")
        public BigDecimal getLastFloatingReferenceValueLeg1() {
            return this.lastFloatingReferenceValueLeg1;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg2")
        @RuneAttribute(value="lastFloatingReferenceValueLeg2")
        public BigDecimal getLastFloatingReferenceValueLeg2() {
            return this.lastFloatingReferenceValueLeg2;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg1")
        public Date getLastFloatingReferenceResetDateLeg1() {
            return this.lastFloatingReferenceResetDateLeg1;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg2")
        public Date getLastFloatingReferenceResetDateLeg2() {
            return this.lastFloatingReferenceResetDateLeg2;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public BigDecimal getDelta() {
            return this.delta;
        }

        @Override
        @RosettaAttribute(value="valuationAmount", isRequired=true)
        @RuneAttribute(value="valuationAmount", isRequired=true)
        public BigDecimal getValuationAmount() {
            return this.valuationAmount;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency", isRequired=true)
        @RuneAttribute(value="valuationCurrency", isRequired=true)
        public ISOCurrencyCodeEnum getValuationCurrency() {
            return this.valuationCurrency;
        }

        @Override
        @RosettaAttribute(value="valuationMethod", isRequired=true)
        @RuneAttribute(value="valuationMethod", isRequired=true)
        public ValuationType1Code getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp", isRequired=true)
        @RuneAttribute(value="valuationTimestamp", isRequired=true)
        public ZonedDateTime getValuationTimestamp() {
            return this.valuationTimestamp;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="initialMarginCollateralPortfolioCode", isRequired=true)
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="tradeParty1IDType", isRequired=true)
        @RuneAttribute(value="tradeParty1IDType", isRequired=true)
        public PartyIdentifierTypeEnum getTradeParty1IDType() {
            return this.tradeParty1IDType;
        }

        @Override
        @RosettaAttribute(value="submittingPartyIDType", isRequired=true)
        @RuneAttribute(value="submittingPartyIDType", isRequired=true)
        public PartyIdentifierTypeEnum getSubmittingPartyIDType() {
            return this.submittingPartyIDType;
        }

        @Override
        @RosettaAttribute(value="usiIDPrefix")
        @RuneAttribute(value="usiIDPrefix")
        public String getUsiIDPrefix() {
            return this.usiIDPrefix;
        }

        @Override
        @RosettaAttribute(value="utiIDPrefix")
        @RuneAttribute(value="utiIDPrefix")
        public String getUtiIDPrefix() {
            return this.utiIDPrefix;
        }

        @Override
        @RosettaAttribute(value="submittedForParty", isRequired=true)
        @RuneAttribute(value="submittedForParty", isRequired=true)
        public String getSubmittedForParty() {
            return this.submittedForParty;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        @RuneAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination() {
            return this.tradeParty1ReportingDestination;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ReportingDestination", isRequired=true)
        @RuneAttribute(value="tradeParty2ReportingDestination", isRequired=true)
        public List<SupervisoryBodyEnum> getTradeParty2ReportingDestination() {
            return this.tradeParty2ReportingDestination;
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass", isRequired=true)
        @RuneAttribute(value="primaryAssetClass", isRequired=true)
        public AssetClassEnum getPrimaryAssetClass() {
            return this.primaryAssetClass;
        }

        @Override
        @RosettaAttribute(value="comment1", isRequired=true)
        @RuneAttribute(value="comment1", isRequired=true)
        public String getComment1() {
            return this.comment1;
        }

        @Override
        @RosettaAttribute(value="messageID", isRequired=true)
        @RuneAttribute(value="messageID", isRequired=true)
        public String getMessageID() {
            return this.messageID;
        }

        @Override
        @RosettaAttribute(value="messageType", isRequired=true)
        @RuneAttribute(value="messageType", isRequired=true)
        public String getMessageType() {
            return this.messageType;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentID")
        @RuneAttribute(value="tradeParty2ExecutionAgentID")
        public String getTradeParty2ExecutionAgentID() {
            return this.tradeParty2ExecutionAgentID;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty2ExecutionAgentIDType")
        public PartyIdentifierTypeEnum getTradeParty2ExecutionAgentIDType() {
            return this.tradeParty2ExecutionAgentIDType;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentID")
        @RuneAttribute(value="tradeParty1ExecutionAgentID")
        public String getTradeParty1ExecutionAgentID() {
            return this.tradeParty1ExecutionAgentID;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty1ExecutionAgentIDType")
        public PartyIdentifierTypeEnum getTradeParty1ExecutionAgentIDType() {
            return this.tradeParty1ExecutionAgentIDType;
        }

        @Override
        @RosettaAttribute(value="tradeParty1TransactionID")
        @RuneAttribute(value="tradeParty1TransactionID")
        public String getTradeParty1TransactionID() {
            return this.tradeParty1TransactionID;
        }

        @Override
        @RosettaAttribute(value="version")
        @RuneAttribute(value="version")
        public String getVersion() {
            return this.version;
        }

        @Override
        public CFTCValuationReport build() {
            return this;
        }

        @Override
        public CFTCValuationReportBuilder toBuilder() {
            CFTCValuationReportBuilder builder = CFTCValuationReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CFTCValuationReportBuilder builder) {
            Optional.ofNullable(this.getCounterparty1()).ifPresent(builder::setCounterparty1);
            Optional.ofNullable(this.getCounterparty2()).ifPresent(builder::setCounterparty2);
            Optional.ofNullable(this.getCounterparty2IdentifierSource()).ifPresent(builder::setCounterparty2IdentifierSource);
            Optional.ofNullable(this.getSubmitterIdentifier()).ifPresent(builder::setSubmitterIdentifier);
            Optional.ofNullable(this.getActionType()).ifPresent(builder::setActionType);
            Optional.ofNullable(this.getUniqueProductIdentifier()).ifPresent(builder::setUniqueProductIdentifier);
            Optional.ofNullable(this.getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
            Optional.ofNullable(this.getUniqueSwapIdentifier()).ifPresent(builder::setUniqueSwapIdentifier);
            Optional.ofNullable(this.getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
            Optional.ofNullable(this.getNextFloatingReferenceResetDateLeg1()).ifPresent(builder::setNextFloatingReferenceResetDateLeg1);
            Optional.ofNullable(this.getNextFloatingReferenceResetDateLeg2()).ifPresent(builder::setNextFloatingReferenceResetDateLeg2);
            Optional.ofNullable(this.getLastFloatingReferenceValueLeg1()).ifPresent(builder::setLastFloatingReferenceValueLeg1);
            Optional.ofNullable(this.getLastFloatingReferenceValueLeg2()).ifPresent(builder::setLastFloatingReferenceValueLeg2);
            Optional.ofNullable(this.getLastFloatingReferenceResetDateLeg1()).ifPresent(builder::setLastFloatingReferenceResetDateLeg1);
            Optional.ofNullable(this.getLastFloatingReferenceResetDateLeg2()).ifPresent(builder::setLastFloatingReferenceResetDateLeg2);
            Optional.ofNullable(this.getDelta()).ifPresent(builder::setDelta);
            Optional.ofNullable(this.getValuationAmount()).ifPresent(builder::setValuationAmount);
            Optional.ofNullable(this.getValuationCurrency()).ifPresent(builder::setValuationCurrency);
            Optional.ofNullable(this.getValuationMethod()).ifPresent(builder::setValuationMethod);
            Optional.ofNullable(this.getValuationTimestamp()).ifPresent(builder::setValuationTimestamp);
            Optional.ofNullable(this.getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
            Optional.ofNullable(this.getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
            Optional.ofNullable(this.getTradeParty1IDType()).ifPresent(builder::setTradeParty1IDType);
            Optional.ofNullable(this.getSubmittingPartyIDType()).ifPresent(builder::setSubmittingPartyIDType);
            Optional.ofNullable(this.getUsiIDPrefix()).ifPresent(builder::setUsiIDPrefix);
            Optional.ofNullable(this.getUtiIDPrefix()).ifPresent(builder::setUtiIDPrefix);
            Optional.ofNullable(this.getSubmittedForParty()).ifPresent(builder::setSubmittedForParty);
            Optional.ofNullable(this.getTradeParty1ReportingDestination()).ifPresent(builder::setTradeParty1ReportingDestination);
            Optional.ofNullable(this.getTradeParty2ReportingDestination()).ifPresent(builder::setTradeParty2ReportingDestination);
            Optional.ofNullable(this.getPrimaryAssetClass()).ifPresent(builder::setPrimaryAssetClass);
            Optional.ofNullable(this.getComment1()).ifPresent(builder::setComment1);
            Optional.ofNullable(this.getMessageID()).ifPresent(builder::setMessageID);
            Optional.ofNullable(this.getMessageType()).ifPresent(builder::setMessageType);
            Optional.ofNullable(this.getTradeParty2ExecutionAgentID()).ifPresent(builder::setTradeParty2ExecutionAgentID);
            Optional.ofNullable(this.getTradeParty2ExecutionAgentIDType()).ifPresent(builder::setTradeParty2ExecutionAgentIDType);
            Optional.ofNullable(this.getTradeParty1ExecutionAgentID()).ifPresent(builder::setTradeParty1ExecutionAgentID);
            Optional.ofNullable(this.getTradeParty1ExecutionAgentIDType()).ifPresent(builder::setTradeParty1ExecutionAgentIDType);
            Optional.ofNullable(this.getTradeParty1TransactionID()).ifPresent(builder::setTradeParty1TransactionID);
            Optional.ofNullable(this.getVersion()).ifPresent(builder::setVersion);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CFTCValuationReport _that = this.getType().cast(o);
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierSource, _that.getCounterparty2IdentifierSource())) {
                return false;
            }
            if (!Objects.equals(this.submitterIdentifier, _that.getSubmitterIdentifier())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.uniqueProductIdentifier, _that.getUniqueProductIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.uniqueSwapIdentifier, _that.getUniqueSwapIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg1, _that.getNextFloatingReferenceResetDateLeg1())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg2, _that.getNextFloatingReferenceResetDateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.lastFloatingReferenceValueLeg1, _that.getLastFloatingReferenceValueLeg1())) {
                return false;
            }
            if (!Objects.equals(this.lastFloatingReferenceValueLeg2, _that.getLastFloatingReferenceValueLeg2())) {
                return false;
            }
            if (!Objects.equals(this.lastFloatingReferenceResetDateLeg1, _that.getLastFloatingReferenceResetDateLeg1())) {
                return false;
            }
            if (!Objects.equals(this.lastFloatingReferenceResetDateLeg2, _that.getLastFloatingReferenceResetDateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.delta, _that.getDelta())) {
                return false;
            }
            if (!Objects.equals(this.valuationAmount, _that.getValuationAmount())) {
                return false;
            }
            if (!Objects.equals(this.valuationCurrency, _that.getValuationCurrency())) {
                return false;
            }
            if (!Objects.equals((Object)this.valuationMethod, (Object)_that.getValuationMethod())) {
                return false;
            }
            if (!Objects.equals(this.valuationTimestamp, _that.getValuationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1IDType, _that.getTradeParty1IDType())) {
                return false;
            }
            if (!Objects.equals(this.submittingPartyIDType, _that.getSubmittingPartyIDType())) {
                return false;
            }
            if (!Objects.equals(this.usiIDPrefix, _that.getUsiIDPrefix())) {
                return false;
            }
            if (!Objects.equals(this.utiIDPrefix, _that.getUtiIDPrefix())) {
                return false;
            }
            if (!Objects.equals(this.submittedForParty, _that.getSubmittedForParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeParty1ReportingDestination, _that.getTradeParty1ReportingDestination())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeParty2ReportingDestination, _that.getTradeParty2ReportingDestination())) {
                return false;
            }
            if (!Objects.equals(this.primaryAssetClass, _that.getPrimaryAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.comment1, _that.getComment1())) {
                return false;
            }
            if (!Objects.equals(this.messageID, _that.getMessageID())) {
                return false;
            }
            if (!Objects.equals(this.messageType, _that.getMessageType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty2ExecutionAgentID, _that.getTradeParty2ExecutionAgentID())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty2ExecutionAgentIDType, _that.getTradeParty2ExecutionAgentIDType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1ExecutionAgentID, _that.getTradeParty1ExecutionAgentID())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1ExecutionAgentIDType, _that.getTradeParty1ExecutionAgentIDType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1TransactionID, _that.getTradeParty1TransactionID())) {
                return false;
            }
            return Objects.equals(this.version, _that.getVersion());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierSource != null ? this.counterparty2IdentifierSource.hashCode() : 0);
            _result = 31 * _result + (this.submitterIdentifier != null ? this.submitterIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.uniqueProductIdentifier != null ? this.uniqueProductIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.uniqueSwapIdentifier != null ? this.uniqueSwapIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg1 != null ? this.nextFloatingReferenceResetDateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg2 != null ? this.nextFloatingReferenceResetDateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReferenceValueLeg1 != null ? this.lastFloatingReferenceValueLeg1.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReferenceValueLeg2 != null ? this.lastFloatingReferenceValueLeg2.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReferenceResetDateLeg1 != null ? this.lastFloatingReferenceResetDateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReferenceResetDateLeg2 != null ? this.lastFloatingReferenceResetDateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.delta != null ? this.delta.hashCode() : 0);
            _result = 31 * _result + (this.valuationAmount != null ? this.valuationAmount.hashCode() : 0);
            _result = 31 * _result + (this.valuationCurrency != null ? this.valuationCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? ((Object)((Object)this.valuationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationTimestamp != null ? this.valuationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1IDType != null ? this.tradeParty1IDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.submittingPartyIDType != null ? this.submittingPartyIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.usiIDPrefix != null ? this.usiIDPrefix.hashCode() : 0);
            _result = 31 * _result + (this.utiIDPrefix != null ? this.utiIDPrefix.hashCode() : 0);
            _result = 31 * _result + (this.submittedForParty != null ? this.submittedForParty.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ReportingDestination != null ? this.tradeParty1ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.tradeParty2ReportingDestination != null ? this.tradeParty2ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.primaryAssetClass != null ? this.primaryAssetClass.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.comment1 != null ? this.comment1.hashCode() : 0);
            _result = 31 * _result + (this.messageID != null ? this.messageID.hashCode() : 0);
            _result = 31 * _result + (this.messageType != null ? this.messageType.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty2ExecutionAgentID != null ? this.tradeParty2ExecutionAgentID.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty2ExecutionAgentIDType != null ? this.tradeParty2ExecutionAgentIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ExecutionAgentID != null ? this.tradeParty1ExecutionAgentID.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ExecutionAgentIDType != null ? this.tradeParty1ExecutionAgentIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1TransactionID != null ? this.tradeParty1TransactionID.hashCode() : 0);
            _result = 31 * _result + (this.version != null ? this.version.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CFTCValuationReport {counterparty1=" + this.counterparty1 + ", counterparty2=" + this.counterparty2 + ", counterparty2IdentifierSource=" + this.counterparty2IdentifierSource + ", submitterIdentifier=" + this.submitterIdentifier + ", actionType=" + String.valueOf((Object)this.actionType) + ", uniqueProductIdentifier=" + this.uniqueProductIdentifier + ", reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", uniqueSwapIdentifier=" + this.uniqueSwapIdentifier + ", uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", nextFloatingReferenceResetDateLeg1=" + String.valueOf(this.nextFloatingReferenceResetDateLeg1) + ", nextFloatingReferenceResetDateLeg2=" + String.valueOf(this.nextFloatingReferenceResetDateLeg2) + ", lastFloatingReferenceValueLeg1=" + String.valueOf(this.lastFloatingReferenceValueLeg1) + ", lastFloatingReferenceValueLeg2=" + String.valueOf(this.lastFloatingReferenceValueLeg2) + ", lastFloatingReferenceResetDateLeg1=" + String.valueOf(this.lastFloatingReferenceResetDateLeg1) + ", lastFloatingReferenceResetDateLeg2=" + String.valueOf(this.lastFloatingReferenceResetDateLeg2) + ", delta=" + String.valueOf(this.delta) + ", valuationAmount=" + String.valueOf(this.valuationAmount) + ", valuationCurrency=" + String.valueOf(this.valuationCurrency) + ", valuationMethod=" + String.valueOf((Object)this.valuationMethod) + ", valuationTimestamp=" + String.valueOf(this.valuationTimestamp) + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", tradeParty1IDType=" + String.valueOf(this.tradeParty1IDType) + ", submittingPartyIDType=" + String.valueOf(this.submittingPartyIDType) + ", usiIDPrefix=" + this.usiIDPrefix + ", utiIDPrefix=" + this.utiIDPrefix + ", submittedForParty=" + this.submittedForParty + ", tradeParty1ReportingDestination=" + String.valueOf(this.tradeParty1ReportingDestination) + ", tradeParty2ReportingDestination=" + String.valueOf(this.tradeParty2ReportingDestination) + ", primaryAssetClass=" + String.valueOf(this.primaryAssetClass) + ", comment1=" + this.comment1 + ", messageID=" + this.messageID + ", messageType=" + this.messageType + ", tradeParty2ExecutionAgentID=" + this.tradeParty2ExecutionAgentID + ", tradeParty2ExecutionAgentIDType=" + String.valueOf(this.tradeParty2ExecutionAgentIDType) + ", tradeParty1ExecutionAgentID=" + this.tradeParty1ExecutionAgentID + ", tradeParty1ExecutionAgentIDType=" + String.valueOf(this.tradeParty1ExecutionAgentIDType) + ", tradeParty1TransactionID=" + this.tradeParty1TransactionID + ", version=" + this.version + "}";
        }
    }
}

