/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import cdm.event.common.TradeIdentifier;
import cdm.product.collateral.Collateral;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.MarginActionEnum;
import drr.regulation.common.meta.CollateralDetailsMeta;
import drr.standards.iso.CollateralisationType3Code__1;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CollateralDetails", builder=CollateralDetailsBuilderImpl.class, version="6.17.1")
@RuneDataType(value="CollateralDetails", model="drr", builder=CollateralDetailsBuilderImpl.class, version="6.17.1")
public interface CollateralDetails
extends RosettaModelObject {
    public static final CollateralDetailsMeta metaData = new CollateralDetailsMeta();

    public ZonedDateTime getCollateralTimestamp();

    public Collateral getCollateral();

    public TradeIdentifier getUniqueTradeIdentifier();

    public MarginActionEnum getAction();

    public CollateralisationType3Code__1 getCollateralisationCategory();

    public CollateralDetails build();

    public CollateralDetailsBuilder toBuilder();

    public static CollateralDetailsBuilder builder() {
        return new CollateralDetailsBuilderImpl();
    }

    default public RosettaMetaData<? extends CollateralDetails> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CollateralDetails> getType() {
        return CollateralDetails.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, (Object)this.getCollateralTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateral"), processor, Collateral.class, (RosettaModelObject)this.getCollateral(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("uniqueTradeIdentifier"), processor, TradeIdentifier.class, (RosettaModelObject)this.getUniqueTradeIdentifier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("action"), MarginActionEnum.class, (Object)this.getAction(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code__1.class, (Object)this.getCollateralisationCategory(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CollateralDetailsBuilderImpl
    implements CollateralDetailsBuilder {
        protected ZonedDateTime collateralTimestamp;
        protected Collateral.CollateralBuilder collateral;
        protected TradeIdentifier.TradeIdentifierBuilder uniqueTradeIdentifier;
        protected MarginActionEnum action;
        protected CollateralisationType3Code__1 collateralisationCategory;

        @Override
        @RosettaAttribute(value="collateralTimestamp", isRequired=true)
        @RuneAttribute(value="collateralTimestamp", isRequired=true)
        public ZonedDateTime getCollateralTimestamp() {
            return this.collateralTimestamp;
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public Collateral.CollateralBuilder getCollateral() {
            return this.collateral;
        }

        @Override
        public Collateral.CollateralBuilder getOrCreateCollateral() {
            Collateral.CollateralBuilder result = this.collateral != null ? this.collateral : (this.collateral = Collateral.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="uniqueTradeIdentifier")
        @RuneAttribute(value="uniqueTradeIdentifier")
        public TradeIdentifier.TradeIdentifierBuilder getUniqueTradeIdentifier() {
            return this.uniqueTradeIdentifier;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateUniqueTradeIdentifier() {
            TradeIdentifier.TradeIdentifierBuilder result = this.uniqueTradeIdentifier != null ? this.uniqueTradeIdentifier : (this.uniqueTradeIdentifier = TradeIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="action")
        @RuneAttribute(value="action")
        public MarginActionEnum getAction() {
            return this.action;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory", isRequired=true)
        @RuneAttribute(value="collateralisationCategory", isRequired=true)
        public CollateralisationType3Code__1 getCollateralisationCategory() {
            return this.collateralisationCategory;
        }

        @Override
        @RosettaAttribute(value="collateralTimestamp", isRequired=true)
        @RuneAttribute(value="collateralTimestamp", isRequired=true)
        public CollateralDetailsBuilder setCollateralTimestamp(ZonedDateTime _collateralTimestamp) {
            this.collateralTimestamp = _collateralTimestamp == null ? null : _collateralTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public CollateralDetailsBuilder setCollateral(Collateral _collateral) {
            this.collateral = _collateral == null ? null : _collateral.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTradeIdentifier")
        @RuneAttribute(value="uniqueTradeIdentifier")
        public CollateralDetailsBuilder setUniqueTradeIdentifier(TradeIdentifier _uniqueTradeIdentifier) {
            this.uniqueTradeIdentifier = _uniqueTradeIdentifier == null ? null : _uniqueTradeIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="action")
        @RuneAttribute(value="action")
        public CollateralDetailsBuilder setAction(MarginActionEnum _action) {
            this.action = _action == null ? null : _action;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory", isRequired=true)
        @RuneAttribute(value="collateralisationCategory", isRequired=true)
        public CollateralDetailsBuilder setCollateralisationCategory(CollateralisationType3Code__1 _collateralisationCategory) {
            this.collateralisationCategory = _collateralisationCategory == null ? null : _collateralisationCategory;
            return this;
        }

        @Override
        public CollateralDetails build() {
            return new CollateralDetailsImpl(this);
        }

        @Override
        public CollateralDetailsBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralDetailsBuilder prune() {
            if (this.collateral != null && !this.collateral.prune().hasData()) {
                this.collateral = null;
            }
            if (this.uniqueTradeIdentifier != null && !this.uniqueTradeIdentifier.prune().hasData()) {
                this.uniqueTradeIdentifier = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCollateralTimestamp() != null) {
                return true;
            }
            if (this.getCollateral() != null && this.getCollateral().hasData()) {
                return true;
            }
            if (this.getUniqueTradeIdentifier() != null && this.getUniqueTradeIdentifier().hasData()) {
                return true;
            }
            if (this.getAction() != null) {
                return true;
            }
            return this.getCollateralisationCategory() != null;
        }

        public CollateralDetailsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralDetailsBuilder o = (CollateralDetailsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateral(), (RosettaModelObjectBuilder)o.getCollateral(), this::setCollateral);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUniqueTradeIdentifier(), (RosettaModelObjectBuilder)o.getUniqueTradeIdentifier(), this::setUniqueTradeIdentifier);
            merger.mergeBasic((Object)this.getCollateralTimestamp(), (Object)o.getCollateralTimestamp(), this::setCollateralTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAction(), (Object)o.getAction(), this::setAction, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCollateralisationCategory(), (Object)o.getCollateralisationCategory(), this::setCollateralisationCategory, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralDetails _that = this.getType().cast(o);
            if (!Objects.equals(this.collateralTimestamp, _that.getCollateralTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.collateral, _that.getCollateral())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTradeIdentifier, _that.getUniqueTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals((Object)this.action, (Object)_that.getAction())) {
                return false;
            }
            return Objects.equals((Object)this.collateralisationCategory, (Object)_that.getCollateralisationCategory());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateralTimestamp != null ? this.collateralTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTradeIdentifier != null ? this.uniqueTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.action != null ? ((Object)((Object)this.action)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.collateralisationCategory != null ? ((Object)((Object)this.collateralisationCategory)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralDetailsBuilder {collateralTimestamp=" + String.valueOf(this.collateralTimestamp) + ", collateral=" + String.valueOf(this.collateral) + ", uniqueTradeIdentifier=" + String.valueOf(this.uniqueTradeIdentifier) + ", action=" + String.valueOf((Object)this.action) + ", collateralisationCategory=" + String.valueOf((Object)this.collateralisationCategory) + "}";
        }
    }

    public static interface CollateralDetailsBuilder
    extends CollateralDetails,
    RosettaModelObjectBuilder {
        public Collateral.CollateralBuilder getOrCreateCollateral();

        public Collateral.CollateralBuilder getCollateral();

        public TradeIdentifier.TradeIdentifierBuilder getOrCreateUniqueTradeIdentifier();

        public TradeIdentifier.TradeIdentifierBuilder getUniqueTradeIdentifier();

        public CollateralDetailsBuilder setCollateralTimestamp(ZonedDateTime var1);

        public CollateralDetailsBuilder setCollateral(Collateral var1);

        public CollateralDetailsBuilder setUniqueTradeIdentifier(TradeIdentifier var1);

        public CollateralDetailsBuilder setAction(MarginActionEnum var1);

        public CollateralDetailsBuilder setCollateralisationCategory(CollateralisationType3Code__1 var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, (Object)this.getCollateralTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateral"), processor, Collateral.CollateralBuilder.class, (RosettaModelObjectBuilder)this.getCollateral(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("uniqueTradeIdentifier"), processor, TradeIdentifier.TradeIdentifierBuilder.class, (RosettaModelObjectBuilder)this.getUniqueTradeIdentifier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("action"), MarginActionEnum.class, (Object)this.getAction(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code__1.class, (Object)this.getCollateralisationCategory(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CollateralDetailsBuilder prune();
    }

    public static class CollateralDetailsImpl
    implements CollateralDetails {
        private final ZonedDateTime collateralTimestamp;
        private final Collateral collateral;
        private final TradeIdentifier uniqueTradeIdentifier;
        private final MarginActionEnum action;
        private final CollateralisationType3Code__1 collateralisationCategory;

        protected CollateralDetailsImpl(CollateralDetailsBuilder builder) {
            this.collateralTimestamp = builder.getCollateralTimestamp();
            this.collateral = Optional.ofNullable(builder.getCollateral()).map(f -> f.build()).orElse(null);
            this.uniqueTradeIdentifier = Optional.ofNullable(builder.getUniqueTradeIdentifier()).map(f -> f.build()).orElse(null);
            this.action = builder.getAction();
            this.collateralisationCategory = builder.getCollateralisationCategory();
        }

        @Override
        @RosettaAttribute(value="collateralTimestamp", isRequired=true)
        @RuneAttribute(value="collateralTimestamp", isRequired=true)
        public ZonedDateTime getCollateralTimestamp() {
            return this.collateralTimestamp;
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public Collateral getCollateral() {
            return this.collateral;
        }

        @Override
        @RosettaAttribute(value="uniqueTradeIdentifier")
        @RuneAttribute(value="uniqueTradeIdentifier")
        public TradeIdentifier getUniqueTradeIdentifier() {
            return this.uniqueTradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="action")
        @RuneAttribute(value="action")
        public MarginActionEnum getAction() {
            return this.action;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory", isRequired=true)
        @RuneAttribute(value="collateralisationCategory", isRequired=true)
        public CollateralisationType3Code__1 getCollateralisationCategory() {
            return this.collateralisationCategory;
        }

        @Override
        public CollateralDetails build() {
            return this;
        }

        @Override
        public CollateralDetailsBuilder toBuilder() {
            CollateralDetailsBuilder builder = CollateralDetails.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralDetailsBuilder builder) {
            Optional.ofNullable(this.getCollateralTimestamp()).ifPresent(builder::setCollateralTimestamp);
            Optional.ofNullable(this.getCollateral()).ifPresent(builder::setCollateral);
            Optional.ofNullable(this.getUniqueTradeIdentifier()).ifPresent(builder::setUniqueTradeIdentifier);
            Optional.ofNullable(this.getAction()).ifPresent(builder::setAction);
            Optional.ofNullable(this.getCollateralisationCategory()).ifPresent(builder::setCollateralisationCategory);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralDetails _that = this.getType().cast(o);
            if (!Objects.equals(this.collateralTimestamp, _that.getCollateralTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.collateral, _that.getCollateral())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTradeIdentifier, _that.getUniqueTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals((Object)this.action, (Object)_that.getAction())) {
                return false;
            }
            return Objects.equals((Object)this.collateralisationCategory, (Object)_that.getCollateralisationCategory());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateralTimestamp != null ? this.collateralTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTradeIdentifier != null ? this.uniqueTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.action != null ? ((Object)((Object)this.action)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.collateralisationCategory != null ? ((Object)((Object)this.collateralisationCategory)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralDetails {collateralTimestamp=" + String.valueOf(this.collateralTimestamp) + ", collateral=" + String.valueOf(this.collateral) + ", uniqueTradeIdentifier=" + String.valueOf(this.uniqueTradeIdentifier) + ", action=" + String.valueOf((Object)this.action) + ", collateralisationCategory=" + String.valueOf((Object)this.collateralisationCategory) + "}";
        }
    }
}

