/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.CommodityTimeUnitEnum;
import drr.regulation.common.CommonTransactionInformation;
import drr.regulation.common.TradableOnTradingVenueEnum;
import drr.regulation.common.meta.ESMATransactionInformationMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ESMATransactionInformation", builder=ESMATransactionInformationBuilderImpl.class, version="6.17.1")
@RuneDataType(value="ESMATransactionInformation", model="drr", builder=ESMATransactionInformationBuilderImpl.class, version="6.17.1")
public interface ESMATransactionInformation
extends CommonTransactionInformation {
    public static final ESMATransactionInformationMeta metaData = new ESMATransactionInformationMeta();

    public CommodityTimeUnitEnum getDuration();

    @Override
    public ESMATransactionInformation build();

    @Override
    public ESMATransactionInformationBuilder toBuilder();

    public static ESMATransactionInformationBuilder builder() {
        return new ESMATransactionInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends ESMATransactionInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ESMATransactionInformation> getType() {
        return ESMATransactionInformation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("tradableOnTradingVenue"), TradableOnTradingVenueEnum.class, (Object)this.getTradableOnTradingVenue(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlierTradedOnTradingVenue"), Boolean.class, (Object)this.getUnderlierTradedOnTradingVenue(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlierAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlierAssetTradingPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("duration"), CommodityTimeUnitEnum.class, (Object)this.getDuration(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ESMATransactionInformationBuilderImpl
    extends CommonTransactionInformation.CommonTransactionInformationBuilderImpl
    implements ESMATransactionInformationBuilder {
        protected CommodityTimeUnitEnum duration;

        @Override
        @RosettaAttribute(value="duration")
        @RuneAttribute(value="duration")
        public CommodityTimeUnitEnum getDuration() {
            return this.duration;
        }

        @Override
        @RosettaAttribute(value="tradableOnTradingVenue")
        @RuneAttribute(value="tradableOnTradingVenue")
        public ESMATransactionInformationBuilder setTradableOnTradingVenue(TradableOnTradingVenueEnum _tradableOnTradingVenue) {
            this.tradableOnTradingVenue = _tradableOnTradingVenue == null ? null : _tradableOnTradingVenue;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlierTradedOnTradingVenue")
        @RuneAttribute(value="underlierTradedOnTradingVenue")
        public ESMATransactionInformationBuilder setUnderlierTradedOnTradingVenue(Boolean _underlierTradedOnTradingVenue) {
            this.underlierTradedOnTradingVenue = _underlierTradedOnTradingVenue == null ? null : _underlierTradedOnTradingVenue;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlierAssetTradingPlatformIdentifier")
        @RuneAttribute(value="underlierAssetTradingPlatformIdentifier")
        public ESMATransactionInformationBuilder setUnderlierAssetTradingPlatformIdentifier(String _underlierAssetTradingPlatformIdentifier) {
            this.underlierAssetTradingPlatformIdentifier = _underlierAssetTradingPlatformIdentifier == null ? null : _underlierAssetTradingPlatformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="duration")
        @RuneAttribute(value="duration")
        public ESMATransactionInformationBuilder setDuration(CommodityTimeUnitEnum _duration) {
            this.duration = _duration == null ? null : _duration;
            return this;
        }

        @Override
        public ESMATransactionInformation build() {
            return new ESMATransactionInformationImpl(this);
        }

        @Override
        public ESMATransactionInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public ESMATransactionInformationBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getDuration() != null;
        }

        @Override
        public ESMATransactionInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ESMATransactionInformationBuilder o = (ESMATransactionInformationBuilder)other;
            merger.mergeBasic((Object)this.getDuration(), (Object)o.getDuration(), this::setDuration, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ESMATransactionInformation _that = (ESMATransactionInformation)this.getType().cast(o);
            return Objects.equals((Object)this.duration, (Object)_that.getDuration());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.duration != null ? ((Object)((Object)this.duration)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ESMATransactionInformationBuilder {duration=" + String.valueOf((Object)this.duration) + "} " + super.toString();
        }
    }

    public static interface ESMATransactionInformationBuilder
    extends ESMATransactionInformation,
    CommonTransactionInformation.CommonTransactionInformationBuilder {
        @Override
        public ESMATransactionInformationBuilder setTradableOnTradingVenue(TradableOnTradingVenueEnum var1);

        @Override
        public ESMATransactionInformationBuilder setUnderlierTradedOnTradingVenue(Boolean var1);

        @Override
        public ESMATransactionInformationBuilder setUnderlierAssetTradingPlatformIdentifier(String var1);

        public ESMATransactionInformationBuilder setDuration(CommodityTimeUnitEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("tradableOnTradingVenue"), TradableOnTradingVenueEnum.class, (Object)this.getTradableOnTradingVenue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlierTradedOnTradingVenue"), Boolean.class, (Object)this.getUnderlierTradedOnTradingVenue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlierAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlierAssetTradingPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("duration"), CommodityTimeUnitEnum.class, (Object)this.getDuration(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public ESMATransactionInformationBuilder prune();
    }

    public static class ESMATransactionInformationImpl
    extends CommonTransactionInformation.CommonTransactionInformationImpl
    implements ESMATransactionInformation {
        private final CommodityTimeUnitEnum duration;

        protected ESMATransactionInformationImpl(ESMATransactionInformationBuilder builder) {
            super(builder);
            this.duration = builder.getDuration();
        }

        @Override
        @RosettaAttribute(value="duration")
        @RuneAttribute(value="duration")
        public CommodityTimeUnitEnum getDuration() {
            return this.duration;
        }

        @Override
        public ESMATransactionInformation build() {
            return this;
        }

        @Override
        public ESMATransactionInformationBuilder toBuilder() {
            ESMATransactionInformationBuilder builder = ESMATransactionInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ESMATransactionInformationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDuration()).ifPresent(builder::setDuration);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ESMATransactionInformation _that = (ESMATransactionInformation)this.getType().cast(o);
            return Objects.equals((Object)this.duration, (Object)_that.getDuration());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.duration != null ? ((Object)((Object)this.duration)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ESMATransactionInformation {duration=" + String.valueOf((Object)this.duration) + "} " + super.toString();
        }
    }
}

