/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import cdm.event.common.CounterpartyPositionState;
import cdm.event.common.TradeState;
import cdm.event.workflow.WorkflowStep;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import drr.regulation.common.RegimeReportingSide;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.meta.RegimeReportableEventMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RegimeReportableEvent", builder=RegimeReportableEventBuilderImpl.class, version="6.17.1")
@RuneDataType(value="RegimeReportableEvent", model="drr", builder=RegimeReportableEventBuilderImpl.class, version="6.17.1")
public interface RegimeReportableEvent
extends ReportableEvent {
    public static final RegimeReportableEventMeta metaData = new RegimeReportableEventMeta();

    public List<? extends RegimeReportingSide> getRegimeReportingSide();

    @Override
    public RegimeReportableEvent build();

    @Override
    public RegimeReportableEventBuilder toBuilder();

    public static RegimeReportableEventBuilder builder() {
        return new RegimeReportableEventBuilderImpl();
    }

    default public RosettaMetaData<? extends RegimeReportableEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegimeReportableEvent> getType() {
        return RegimeReportableEvent.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("originatingWorkflowStep"), processor, WorkflowStep.class, (RosettaModelObject)this.getOriginatingWorkflowStep(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportableTrade"), processor, TradeState.class, (RosettaModelObject)this.getReportableTrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.class, this.getReportableInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportablePosition"), processor, CounterpartyPositionState.class, (RosettaModelObject)this.getReportablePosition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("regimeReportingSide"), processor, RegimeReportingSide.class, this.getRegimeReportingSide(), new AttributeMeta[0]);
    }

    public static class RegimeReportableEventBuilderImpl
    extends ReportableEvent.ReportableEventBuilderImpl
    implements RegimeReportableEventBuilder {
        protected List<RegimeReportingSide.RegimeReportingSideBuilder> regimeReportingSide = new ArrayList<RegimeReportingSide.RegimeReportingSideBuilder>();

        @Override
        @RosettaAttribute(value="regimeReportingSide")
        @RuneAttribute(value="regimeReportingSide")
        public List<? extends RegimeReportingSide.RegimeReportingSideBuilder> getRegimeReportingSide() {
            return this.regimeReportingSide;
        }

        @Override
        public RegimeReportingSide.RegimeReportingSideBuilder getOrCreateRegimeReportingSide(int index) {
            if (this.regimeReportingSide == null) {
                this.regimeReportingSide = new ArrayList<RegimeReportingSide.RegimeReportingSideBuilder>();
            }
            return (RegimeReportingSide.RegimeReportingSideBuilder)this.getIndex(this.regimeReportingSide, index, () -> {
                RegimeReportingSide.RegimeReportingSideBuilder newRegimeReportingSide = RegimeReportingSide.builder();
                return newRegimeReportingSide;
            });
        }

        @Override
        @RosettaAttribute(value="originatingWorkflowStep", isRequired=true)
        @RuneAttribute(value="originatingWorkflowStep", isRequired=true)
        public RegimeReportableEventBuilder setOriginatingWorkflowStep(WorkflowStep _originatingWorkflowStep) {
            this.originatingWorkflowStep = _originatingWorkflowStep == null ? null : _originatingWorkflowStep.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportableTrade")
        @RuneAttribute(value="reportableTrade")
        public RegimeReportableEventBuilder setReportableTrade(TradeState _reportableTrade) {
            this.reportableTrade = _reportableTrade == null ? null : _reportableTrade.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportableInformation", isRequired=true)
        @RuneAttribute(value="reportableInformation", isRequired=true)
        public RegimeReportableEventBuilder setReportableInformation(ReportableInformation _reportableInformation) {
            this.reportableInformation = _reportableInformation == null ? null : _reportableInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportablePosition")
        @RuneAttribute(value="reportablePosition")
        public RegimeReportableEventBuilder setReportablePosition(CounterpartyPositionState _reportablePosition) {
            this.reportablePosition = _reportablePosition == null ? null : _reportablePosition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="regimeReportingSide")
        @RuneAttribute(value="regimeReportingSide")
        public RegimeReportableEventBuilder addRegimeReportingSide(RegimeReportingSide _regimeReportingSide) {
            if (_regimeReportingSide != null) {
                this.regimeReportingSide.add(_regimeReportingSide.toBuilder());
            }
            return this;
        }

        @Override
        public RegimeReportableEventBuilder addRegimeReportingSide(RegimeReportingSide _regimeReportingSide, int idx) {
            this.getIndex(this.regimeReportingSide, idx, () -> _regimeReportingSide.toBuilder());
            return this;
        }

        @Override
        public RegimeReportableEventBuilder addRegimeReportingSide(List<? extends RegimeReportingSide> regimeReportingSides) {
            if (regimeReportingSides != null) {
                for (RegimeReportingSide regimeReportingSide : regimeReportingSides) {
                    this.regimeReportingSide.add(regimeReportingSide.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="regimeReportingSide")
        public RegimeReportableEventBuilder setRegimeReportingSide(List<? extends RegimeReportingSide> regimeReportingSides) {
            this.regimeReportingSide = regimeReportingSides == null ? new ArrayList<RegimeReportingSide.RegimeReportingSideBuilder>() : (List)regimeReportingSides.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public RegimeReportableEvent build() {
            return new RegimeReportableEventImpl(this);
        }

        @Override
        public RegimeReportableEventBuilder toBuilder() {
            return this;
        }

        @Override
        public RegimeReportableEventBuilder prune() {
            super.prune();
            this.regimeReportingSide = this.regimeReportingSide.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getRegimeReportingSide() != null && this.getRegimeReportingSide().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public RegimeReportableEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RegimeReportableEventBuilder o = (RegimeReportableEventBuilder)other;
            merger.mergeRosetta(this.getRegimeReportingSide(), o.getRegimeReportingSide(), this::getOrCreateRegimeReportingSide);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegimeReportableEvent _that = (RegimeReportableEvent)this.getType().cast(o);
            return ListEquals.listEquals(this.regimeReportingSide, _that.getRegimeReportingSide());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.regimeReportingSide != null ? this.regimeReportingSide.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegimeReportableEventBuilder {regimeReportingSide=" + String.valueOf(this.regimeReportingSide) + "} " + super.toString();
        }
    }

    public static interface RegimeReportableEventBuilder
    extends RegimeReportableEvent,
    ReportableEvent.ReportableEventBuilder {
        public RegimeReportingSide.RegimeReportingSideBuilder getOrCreateRegimeReportingSide(int var1);

        public List<? extends RegimeReportingSide.RegimeReportingSideBuilder> getRegimeReportingSide();

        @Override
        public RegimeReportableEventBuilder setOriginatingWorkflowStep(WorkflowStep var1);

        @Override
        public RegimeReportableEventBuilder setReportableTrade(TradeState var1);

        @Override
        public RegimeReportableEventBuilder setReportableInformation(ReportableInformation var1);

        @Override
        public RegimeReportableEventBuilder setReportablePosition(CounterpartyPositionState var1);

        public RegimeReportableEventBuilder addRegimeReportingSide(RegimeReportingSide var1);

        public RegimeReportableEventBuilder addRegimeReportingSide(RegimeReportingSide var1, int var2);

        public RegimeReportableEventBuilder addRegimeReportingSide(List<? extends RegimeReportingSide> var1);

        public RegimeReportableEventBuilder setRegimeReportingSide(List<? extends RegimeReportingSide> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("originatingWorkflowStep"), processor, WorkflowStep.WorkflowStepBuilder.class, (RosettaModelObjectBuilder)this.getOriginatingWorkflowStep(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportableTrade"), processor, TradeState.TradeStateBuilder.class, (RosettaModelObjectBuilder)this.getReportableTrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.ReportableInformationBuilder.class, (RosettaModelObjectBuilder)this.getReportableInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportablePosition"), processor, CounterpartyPositionState.CounterpartyPositionStateBuilder.class, (RosettaModelObjectBuilder)this.getReportablePosition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("regimeReportingSide"), processor, RegimeReportingSide.RegimeReportingSideBuilder.class, this.getRegimeReportingSide(), new AttributeMeta[0]);
        }

        @Override
        public RegimeReportableEventBuilder prune();
    }

    public static class RegimeReportableEventImpl
    extends ReportableEvent.ReportableEventImpl
    implements RegimeReportableEvent {
        private final List<? extends RegimeReportingSide> regimeReportingSide;

        protected RegimeReportableEventImpl(RegimeReportableEventBuilder builder) {
            super(builder);
            this.regimeReportingSide = Optional.ofNullable(builder.getRegimeReportingSide()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="regimeReportingSide")
        @RuneAttribute(value="regimeReportingSide")
        public List<? extends RegimeReportingSide> getRegimeReportingSide() {
            return this.regimeReportingSide;
        }

        @Override
        public RegimeReportableEvent build() {
            return this;
        }

        @Override
        public RegimeReportableEventBuilder toBuilder() {
            RegimeReportableEventBuilder builder = RegimeReportableEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegimeReportableEventBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getRegimeReportingSide()).ifPresent(builder::setRegimeReportingSide);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegimeReportableEvent _that = (RegimeReportableEvent)this.getType().cast(o);
            return ListEquals.listEquals(this.regimeReportingSide, _that.getRegimeReportingSide());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.regimeReportingSide != null ? this.regimeReportingSide.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegimeReportableEvent {regimeReportingSide=" + String.valueOf(this.regimeReportingSide) + "} " + super.toString();
        }
    }
}

