/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.datetime.DayOfWeekEnum;
import cdm.product.asset.BankHolidayTreatmentEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@ImplementedBy(value=GetDaysOfTheWeekDefault.class)
public abstract class GetDaysOfTheWeek
implements RosettaFunction {
    public List<String> evaluate(List<DayOfWeekEnum> daysOfTheWeek, BankHolidayTreatmentEnum bankHolidaysTreatment) {
        List<String> dayCode = this.doEvaluate(daysOfTheWeek, bankHolidaysTreatment);
        return dayCode;
    }

    protected abstract List<String> doEvaluate(List<DayOfWeekEnum> var1, BankHolidayTreatmentEnum var2);

    protected abstract MapperS<Boolean> mon(List<DayOfWeekEnum> var1, BankHolidayTreatmentEnum var2);

    protected abstract MapperS<Boolean> tue(List<DayOfWeekEnum> var1, BankHolidayTreatmentEnum var2);

    protected abstract MapperS<Boolean> wed(List<DayOfWeekEnum> var1, BankHolidayTreatmentEnum var2);

    protected abstract MapperS<Boolean> thu(List<DayOfWeekEnum> var1, BankHolidayTreatmentEnum var2);

    protected abstract MapperS<Boolean> fri(List<DayOfWeekEnum> var1, BankHolidayTreatmentEnum var2);

    protected abstract MapperS<Boolean> sat(List<DayOfWeekEnum> var1, BankHolidayTreatmentEnum var2);

    protected abstract MapperS<Boolean> sun(List<DayOfWeekEnum> var1, BankHolidayTreatmentEnum var2);

    public static class GetDaysOfTheWeekDefault
    extends GetDaysOfTheWeek {
        @Override
        protected List<String> doEvaluate(List<DayOfWeekEnum> daysOfTheWeek, BankHolidayTreatmentEnum bankHolidaysTreatment) {
            if (daysOfTheWeek == null) {
                daysOfTheWeek = Collections.emptyList();
            }
            ArrayList<String> dayCode = new ArrayList<String>();
            return this.assignOutput(dayCode, daysOfTheWeek, bankHolidaysTreatment);
        }

        protected List<String> assignOutput(List<String> dayCode, List<DayOfWeekEnum> daysOfTheWeek, BankHolidayTreatmentEnum bankHolidaysTreatment) {
            if (ComparisonResult.of(this.mon(daysOfTheWeek, bankHolidaysTreatment)).and(ExpressionOperators.areEqual(this.tue(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual(this.wed(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual(this.thu(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual(this.fri(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                String string0 = "MOND";
                if ("MOND" == null) {
                    dayCode.addAll(Collections.emptyList());
                } else {
                    dayCode.addAll(Collections.singletonList("MOND"));
                }
            } else {
                dayCode.addAll(Collections.emptyList());
            }
            if (ComparisonResult.of(this.tue(daysOfTheWeek, bankHolidaysTreatment)).and(ExpressionOperators.areEqual(this.mon(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual(this.wed(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual(this.thu(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual(this.fri(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                String string1 = "TUED";
                if ("TUED" == null) {
                    dayCode.addAll(Collections.emptyList());
                } else {
                    dayCode.addAll(Collections.singletonList("TUED"));
                }
            } else {
                dayCode.addAll(Collections.emptyList());
            }
            if (ComparisonResult.of(this.wed(daysOfTheWeek, bankHolidaysTreatment)).and(ExpressionOperators.areEqual(this.mon(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual(this.tue(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual(this.thu(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual(this.fri(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                String string2 = "WEDD";
                if ("WEDD" == null) {
                    dayCode.addAll(Collections.emptyList());
                } else {
                    dayCode.addAll(Collections.singletonList("WEDD"));
                }
            } else {
                dayCode.addAll(Collections.emptyList());
            }
            if (ComparisonResult.of(this.thu(daysOfTheWeek, bankHolidaysTreatment)).and(ExpressionOperators.areEqual(this.mon(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual(this.tue(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual(this.wed(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual(this.fri(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                String string3 = "THUD";
                if ("THUD" == null) {
                    dayCode.addAll(Collections.emptyList());
                } else {
                    dayCode.addAll(Collections.singletonList("THUD"));
                }
            } else {
                dayCode.addAll(Collections.emptyList());
            }
            if (ComparisonResult.of(this.fri(daysOfTheWeek, bankHolidaysTreatment)).and(ExpressionOperators.areEqual(this.mon(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual(this.tue(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual(this.wed(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual(this.thu(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                String string4 = "FRID";
                if ("FRID" == null) {
                    dayCode.addAll(Collections.emptyList());
                } else {
                    dayCode.addAll(Collections.singletonList("FRID"));
                }
            } else {
                dayCode.addAll(Collections.emptyList());
            }
            if (ComparisonResult.of(this.sat(daysOfTheWeek, bankHolidaysTreatment)).and(ExpressionOperators.areEqual(this.sun(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                String string5 = "SATD";
                if ("SATD" == null) {
                    dayCode.addAll(Collections.emptyList());
                } else {
                    dayCode.addAll(Collections.singletonList("SATD"));
                }
            } else {
                dayCode.addAll(Collections.emptyList());
            }
            if (ComparisonResult.of(this.sun(daysOfTheWeek, bankHolidaysTreatment)).and(ExpressionOperators.areEqual(this.sat(daysOfTheWeek, bankHolidaysTreatment), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                String string6 = "SUND";
                if ("SUND" == null) {
                    dayCode.addAll(Collections.emptyList());
                } else {
                    dayCode.addAll(Collections.singletonList("SUND"));
                }
            } else {
                dayCode.addAll(Collections.emptyList());
            }
            if (ComparisonResult.of(this.mon(daysOfTheWeek, bankHolidaysTreatment)).and(ComparisonResult.of(this.tue(daysOfTheWeek, bankHolidaysTreatment))).and(ComparisonResult.of(this.wed(daysOfTheWeek, bankHolidaysTreatment))).and(ComparisonResult.of(this.thu(daysOfTheWeek, bankHolidaysTreatment))).and(ComparisonResult.of(this.fri(daysOfTheWeek, bankHolidaysTreatment))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                String string7 = "WDAY";
                if ("WDAY" == null) {
                    dayCode.addAll(Collections.emptyList());
                } else {
                    dayCode.addAll(Collections.singletonList("WDAY"));
                }
            } else {
                dayCode.addAll(Collections.emptyList());
            }
            if (ComparisonResult.of(this.sat(daysOfTheWeek, bankHolidaysTreatment)).and(ComparisonResult.of(this.sun(daysOfTheWeek, bankHolidaysTreatment))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                String string8 = "WEND";
                if ("WEND" == null) {
                    dayCode.addAll(Collections.emptyList());
                } else {
                    dayCode.addAll(Collections.singletonList("WEND"));
                }
            } else {
                dayCode.addAll(Collections.emptyList());
            }
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)bankHolidaysTreatment), (Mapper)MapperS.of((Object)BankHolidayTreatmentEnum.AS_WEEKDAY), (CardinalityOperator)CardinalityOperator.All).and(ComparisonResult.of(this.mon(daysOfTheWeek, bankHolidaysTreatment)).or(ComparisonResult.of(this.tue(daysOfTheWeek, bankHolidaysTreatment))).or(ComparisonResult.of(this.wed(daysOfTheWeek, bankHolidaysTreatment))).or(ComparisonResult.of(this.thu(daysOfTheWeek, bankHolidaysTreatment))).or(ComparisonResult.of(this.fri(daysOfTheWeek, bankHolidaysTreatment)))).and(ExpressionOperators.areEqual((Mapper)ComparisonResult.of(this.sat(daysOfTheWeek, bankHolidaysTreatment)).or(ComparisonResult.of(this.sun(daysOfTheWeek, bankHolidaysTreatment))), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                String string9 = "IBHL";
                if ("IBHL" == null) {
                    dayCode.addAll(Collections.emptyList());
                } else {
                    dayCode.addAll(Collections.singletonList("IBHL"));
                }
            } else if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)bankHolidaysTreatment), (Mapper)MapperS.of((Object)BankHolidayTreatmentEnum.AS_WEEKEND), (CardinalityOperator)CardinalityOperator.All).and(ComparisonResult.of(this.sat(daysOfTheWeek, bankHolidaysTreatment)).or(ComparisonResult.of(this.sun(daysOfTheWeek, bankHolidaysTreatment)))).and(ExpressionOperators.areEqual((Mapper)ComparisonResult.of(this.mon(daysOfTheWeek, bankHolidaysTreatment)).or(ComparisonResult.of(this.tue(daysOfTheWeek, bankHolidaysTreatment))).or(ComparisonResult.of(this.wed(daysOfTheWeek, bankHolidaysTreatment))).or(ComparisonResult.of(this.thu(daysOfTheWeek, bankHolidaysTreatment))).or(ComparisonResult.of(this.fri(daysOfTheWeek, bankHolidaysTreatment))), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                String string10 = "IBHL";
                if ("IBHL" == null) {
                    dayCode.addAll(Collections.emptyList());
                } else {
                    dayCode.addAll(Collections.singletonList("IBHL"));
                }
            } else {
                dayCode.addAll(Collections.emptyList());
            }
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)bankHolidaysTreatment), (Mapper)MapperS.of((Object)BankHolidayTreatmentEnum.AS_WEEKEND), (CardinalityOperator)CardinalityOperator.All).and(ComparisonResult.of(this.mon(daysOfTheWeek, bankHolidaysTreatment)).or(ComparisonResult.of(this.tue(daysOfTheWeek, bankHolidaysTreatment))).or(ComparisonResult.of(this.wed(daysOfTheWeek, bankHolidaysTreatment))).or(ComparisonResult.of(this.thu(daysOfTheWeek, bankHolidaysTreatment))).or(ComparisonResult.of(this.fri(daysOfTheWeek, bankHolidaysTreatment)))).and(ExpressionOperators.areEqual((Mapper)ComparisonResult.of(this.sat(daysOfTheWeek, bankHolidaysTreatment)).or(ComparisonResult.of(this.sun(daysOfTheWeek, bankHolidaysTreatment))), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                String string11 = "XBHL";
                if ("XBHL" == null) {
                    dayCode.addAll(Collections.emptyList());
                } else {
                    dayCode.addAll(Collections.singletonList("XBHL"));
                }
            } else if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)bankHolidaysTreatment), (Mapper)MapperS.of((Object)BankHolidayTreatmentEnum.AS_WEEKDAY), (CardinalityOperator)CardinalityOperator.All).and(ComparisonResult.of(this.sat(daysOfTheWeek, bankHolidaysTreatment)).or(ComparisonResult.of(this.sun(daysOfTheWeek, bankHolidaysTreatment)))).and(ExpressionOperators.areEqual((Mapper)ComparisonResult.of(this.mon(daysOfTheWeek, bankHolidaysTreatment)).or(ComparisonResult.of(this.tue(daysOfTheWeek, bankHolidaysTreatment))).or(ComparisonResult.of(this.wed(daysOfTheWeek, bankHolidaysTreatment))).or(ComparisonResult.of(this.thu(daysOfTheWeek, bankHolidaysTreatment))).or(ComparisonResult.of(this.fri(daysOfTheWeek, bankHolidaysTreatment))), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                String string12 = "XBHL";
                if ("XBHL" == null) {
                    dayCode.addAll(Collections.emptyList());
                } else {
                    dayCode.addAll(Collections.singletonList("XBHL"));
                }
            } else {
                dayCode.addAll(Collections.emptyList());
            }
            return dayCode;
        }

        @Override
        protected MapperS<Boolean> mon(List<DayOfWeekEnum> daysOfTheWeek, BankHolidayTreatmentEnum bankHolidaysTreatment) {
            return ExpressionOperators.contains((Mapper)MapperC.of(daysOfTheWeek), (Mapper)MapperS.of((Object)DayOfWeekEnum.MON)).asMapper();
        }

        @Override
        protected MapperS<Boolean> tue(List<DayOfWeekEnum> daysOfTheWeek, BankHolidayTreatmentEnum bankHolidaysTreatment) {
            return ExpressionOperators.contains((Mapper)MapperC.of(daysOfTheWeek), (Mapper)MapperS.of((Object)DayOfWeekEnum.TUE)).asMapper();
        }

        @Override
        protected MapperS<Boolean> wed(List<DayOfWeekEnum> daysOfTheWeek, BankHolidayTreatmentEnum bankHolidaysTreatment) {
            return ExpressionOperators.contains((Mapper)MapperC.of(daysOfTheWeek), (Mapper)MapperS.of((Object)DayOfWeekEnum.WED)).asMapper();
        }

        @Override
        protected MapperS<Boolean> thu(List<DayOfWeekEnum> daysOfTheWeek, BankHolidayTreatmentEnum bankHolidaysTreatment) {
            return ExpressionOperators.contains((Mapper)MapperC.of(daysOfTheWeek), (Mapper)MapperS.of((Object)DayOfWeekEnum.THU)).asMapper();
        }

        @Override
        protected MapperS<Boolean> fri(List<DayOfWeekEnum> daysOfTheWeek, BankHolidayTreatmentEnum bankHolidaysTreatment) {
            return ExpressionOperators.contains((Mapper)MapperC.of(daysOfTheWeek), (Mapper)MapperS.of((Object)DayOfWeekEnum.FRI)).asMapper();
        }

        @Override
        protected MapperS<Boolean> sat(List<DayOfWeekEnum> daysOfTheWeek, BankHolidayTreatmentEnum bankHolidaysTreatment) {
            return ExpressionOperators.contains((Mapper)MapperC.of(daysOfTheWeek), (Mapper)MapperS.of((Object)DayOfWeekEnum.SAT)).asMapper();
        }

        @Override
        protected MapperS<Boolean> sun(List<DayOfWeekEnum> daysOfTheWeek, BankHolidayTreatmentEnum bankHolidaysTreatment) {
            return ExpressionOperators.contains((Mapper)MapperC.of(daysOfTheWeek), (Mapper)MapperS.of((Object)DayOfWeekEnum.SUN)).asMapper();
        }
    }
}

