/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.datetime.RelativeDateOffset;
import cdm.base.datetime.functions.AddBusinessDays;
import cdm.product.qualification.functions.Qualify_InterestRate_Fra;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iosco.cde.version3.datetime.reports.EffectiveDateRule;
import drr.standards.iosco.cde.version3.datetime.reports.ExpirationDateRule;
import javax.inject.Inject;

@ImplementedBy(value=GetExpirationDateDefault.class)
public abstract class GetExpirationDate
implements RosettaFunction {
    @Inject
    protected AddBusinessDays addBusinessDays;
    @Inject
    protected EffectiveDateRule effectiveDateRule;
    @Inject
    protected ExpirationDateRule expirationDateRule;
    @Inject
    protected InterestRateLeg2 interestRateLeg2;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected Qualify_InterestRate_Fra qualify_InterestRate_Fra;

    public Date evaluate(TransactionReportInstruction transactionReportInstruction) {
        Date expirationDate = this.doEvaluate(transactionReportInstruction);
        return expirationDate;
    }

    protected abstract Date doEvaluate(TransactionReportInstruction var1);

    protected abstract MapperS<? extends Product> product(TransactionReportInstruction var1);

    protected abstract MapperS<? extends RelativeDateOffset> fixingDates(TransactionReportInstruction var1);

    protected abstract MapperS<Integer> periodMultiplier(TransactionReportInstruction var1);

    public static class GetExpirationDateDefault
    extends GetExpirationDate {
        @Override
        protected Date doEvaluate(TransactionReportInstruction transactionReportInstruction) {
            Date expirationDate = null;
            return this.assignOutput(expirationDate, transactionReportInstruction);
        }

        protected Date assignOutput(Date expirationDate, TransactionReportInstruction transactionReportInstruction) {
            Boolean _boolean = this.qualify_InterestRate_Fra.evaluate((EconomicTerms)this.product(transactionReportInstruction).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
            expirationDate = _boolean != null && _boolean != false ? this.addBusinessDays.evaluate(this.effectiveDateRule.evaluate(transactionReportInstruction), (Integer)this.periodMultiplier(transactionReportInstruction).get(), this.fixingDates(transactionReportInstruction).map("getBusinessCenters", relativeDateOffset -> relativeDateOffset.getBusinessCenters()).mapC("getBusinessCenter", businessCenters -> businessCenters.getBusinessCenter()).map("Type coercion", fieldWithMetaBusinessCenterEnum -> fieldWithMetaBusinessCenterEnum.getValue()).getMulti()) : this.expirationDateRule.evaluate((Product)this.product(transactionReportInstruction).get());
            return expirationDate;
        }

        @Override
        protected MapperS<? extends Product> product(TransactionReportInstruction transactionReportInstruction) {
            return MapperS.of((Object)this.productForEvent.evaluate(transactionReportInstruction));
        }

        @Override
        protected MapperS<? extends RelativeDateOffset> fixingDates(TransactionReportInstruction transactionReportInstruction) {
            return MapperS.of((Object)this.interestRateLeg2.evaluate((Product)this.product(transactionReportInstruction).get())).map("getResetDates", interestRatePayout -> interestRatePayout.getResetDates()).map("getFixingDates", resetDates -> resetDates.getFixingDates());
        }

        @Override
        protected MapperS<Integer> periodMultiplier(TransactionReportInstruction transactionReportInstruction) {
            if (ExpressionOperators.exists((Mapper)this.fixingDates(transactionReportInstruction).map("getPeriodMultiplier", relativeDateOffset -> relativeDateOffset.getPeriodMultiplier())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.fixingDates(transactionReportInstruction).map("getPeriodMultiplier", relativeDateOffset -> relativeDateOffset.getPeriodMultiplier());
            }
            return MapperS.of((Object)0);
        }
    }
}

