/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.observable.asset.PriceExpressionEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;

@ImplementedBy(value=GetPriceNotationDefault.class)
public abstract class GetPriceNotation
implements RosettaFunction {
    public PriceNotationEnum evaluate(PriceSchedule price) {
        PriceNotationEnum notation = this.doEvaluate(price);
        return notation;
    }

    protected abstract PriceNotationEnum doEvaluate(PriceSchedule var1);

    public static class GetPriceNotationDefault
    extends GetPriceNotation {
        @Override
        protected PriceNotationEnum doEvaluate(PriceSchedule price) {
            PriceNotationEnum notation = null;
            return this.assignOutput(notation, price);
        }

        protected PriceNotationEnum assignOutput(PriceNotationEnum notation, PriceSchedule price) {
            notation = ExpressionOperators.exists((Mapper)MapperS.of((Object)price).map("getValue", priceSchedule -> priceSchedule.getValue())).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)price).mapC("getDatedValue", priceSchedule -> priceSchedule.getDatedValue()))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)price).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.INTEREST_RATE), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)price).map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()), (Mapper)MapperS.of((Object)ArithmeticOperationEnum.ADD), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? PriceNotationEnum.BASIS : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)price).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.INTEREST_RATE), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)price).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.VARIANCE), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)price).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.VOLATILITY), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)price).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.ASSET_PRICE), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)price).map("getUnit", priceSchedule -> priceSchedule.getUnit()), (Mapper)MapperS.of((Object)price).map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()), (CardinalityOperator)CardinalityOperator.All))).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)price).map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()), (Mapper)MapperS.of((Object)PriceExpressionEnum.PERCENTAGE_OF_NOTIONAL), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? PriceNotationEnum.PERCENTAGE : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)price).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.EXCHANGE_RATE), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)price).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.ASSET_PRICE), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)price).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.CASH_PRICE), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)price).map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)price).map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()), (Mapper)MapperS.of((Object)PriceExpressionEnum.ABSOLUTE_TERMS), (CardinalityOperator)CardinalityOperator.All))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? PriceNotationEnum.MONETARY : PriceNotationEnum.DECIMAL))) : null;
            return notation;
        }
    }
}

