/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.math.Quantity;
import cdm.product.asset.AssetDeliveryInformation;
import cdm.product.asset.BankHolidayTreatmentEnum;
import cdm.product.asset.CommodityPayout;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.EconomicTerms;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.CommodityTimeUnitEnum;
import drr.regulation.common.ReportableDelivery;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.Create_DeliveryBlock;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsSingleCommodityPayoutProduct;
import drr.regulation.common.functions.ProductForEvent;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetReportableDeliveryDefault.class)
public abstract class GetReportableDelivery
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_DeliveryBlock create_DeliveryBlock;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected Qualify_Commodity_Forward qualify_Commodity_Forward;
    @Inject
    protected Qualify_Commodity_Option qualify_Commodity_Option;
    @Inject
    protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
    @Inject
    protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
    @Inject
    protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;

    public List<? extends ReportableDelivery> evaluate(ReportableEvent reportableEvent) {
        List reportableDelivery;
        List<ReportableDelivery.ReportableDeliveryBuilder> reportableDeliveryBuilder = this.doEvaluate(reportableEvent);
        if (reportableDeliveryBuilder == null) {
            reportableDelivery = null;
        } else {
            reportableDelivery = reportableDeliveryBuilder.stream().map(ReportableDelivery::build).collect(Collectors.toList());
            this.objectValidator.validate(ReportableDelivery.class, reportableDelivery);
        }
        return reportableDelivery;
    }

    protected abstract List<ReportableDelivery.ReportableDeliveryBuilder> doEvaluate(ReportableEvent var1);

    protected abstract MapperS<? extends Product> product(ReportableEvent var1);

    protected abstract MapperS<? extends EconomicTerms> economicTerms(ReportableEvent var1);

    protected abstract MapperS<? extends AssetDeliveryInformation> delivery(ReportableEvent var1);

    protected abstract MapperS<? extends CalculationSchedule> customizedSchedule(ReportableEvent var1);

    protected abstract MapperS<CommodityTimeUnitEnum> duration(ReportableEvent var1);

    public static class GetReportableDeliveryDefault
    extends GetReportableDelivery {
        @Override
        protected List<ReportableDelivery.ReportableDeliveryBuilder> doEvaluate(ReportableEvent reportableEvent) {
            ArrayList<ReportableDelivery.ReportableDeliveryBuilder> reportableDelivery = new ArrayList<ReportableDelivery.ReportableDeliveryBuilder>();
            return this.assignOutput(reportableDelivery, reportableEvent);
        }

        protected List<ReportableDelivery.ReportableDeliveryBuilder> assignOutput(List<ReportableDelivery.ReportableDeliveryBuilder> reportableDelivery, ReportableEvent reportableEvent) {
            if (ExpressionOperators.exists(this.customizedSchedule(reportableEvent)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperListOfLists thenArg = this.customizedSchedule(reportableEvent).mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).mapItemToList(schedulePeriod -> {
                    MapperListOfLists _thenArg = schedulePeriod.map("getDeliveryPeriod", _schedulePeriod -> _schedulePeriod.getDeliveryPeriod()).mapC("getProfile", calculationScheduleDeliveryPeriods -> calculationScheduleDeliveryPeriods.getProfile()).mapItemToList(deliveryProfile -> deliveryProfile.mapC("getBlock", assetDeliveryProfile -> assetDeliveryProfile.getBlock()).mapItem(deliveryBlock -> {
                        FieldWithMetaString fieldWithMetaString1;
                        FieldWithMetaString fieldWithMetaString0;
                        Object ifThenElseResult0 = ExpressionOperators.exists((Mapper)schedulePeriod.map("getDeliveryPeriod", _schedulePeriod -> _schedulePeriod.getDeliveryPeriod()).map("getDeliveryCapacity", calculationScheduleDeliveryPeriods -> calculationScheduleDeliveryPeriods.getDeliveryCapacity())).getOrDefault(Boolean.valueOf(false)) != false ? (Quantity)schedulePeriod.map("getDeliveryPeriod", _schedulePeriod -> _schedulePeriod.getDeliveryPeriod()).map("getDeliveryCapacity", calculationScheduleDeliveryPeriods -> calculationScheduleDeliveryPeriods.getDeliveryCapacity()).get() : (ExpressionOperators.exists((Mapper)deliveryBlock.map("getDeliveryCapacity", assetDeliveryProfileBlock -> assetDeliveryProfileBlock.getDeliveryCapacity())).getOrDefault(Boolean.valueOf(false)) != false ? (Quantity)deliveryBlock.map("getDeliveryCapacity", assetDeliveryProfileBlock -> assetDeliveryProfileBlock.getDeliveryCapacity()).get() : null);
                        BigDecimal ifThenElseResult1 = ExpressionOperators.exists((Mapper)schedulePeriod.map("getDeliveryPeriod", _schedulePeriod -> _schedulePeriod.getDeliveryPeriod()).map("getPriceTimeIntervalQuantity", calculationScheduleDeliveryPeriods -> calculationScheduleDeliveryPeriods.getPriceTimeIntervalQuantity())).getOrDefault(Boolean.valueOf(false)) != false ? (BigDecimal)schedulePeriod.map("getDeliveryPeriod", _schedulePeriod -> _schedulePeriod.getDeliveryPeriod()).map("getPriceTimeIntervalQuantity", calculationScheduleDeliveryPeriods -> calculationScheduleDeliveryPeriods.getPriceTimeIntervalQuantity()).map("getValue", price -> price.getValue()).get() : (ExpressionOperators.exists((Mapper)deliveryBlock.map("getPriceTimeIntervalQuantity", assetDeliveryProfileBlock -> assetDeliveryProfileBlock.getPriceTimeIntervalQuantity())).getOrDefault(Boolean.valueOf(false)) != false ? (BigDecimal)deliveryBlock.map("getPriceTimeIntervalQuantity", assetDeliveryProfileBlock -> assetDeliveryProfileBlock.getPriceTimeIntervalQuantity()).map("getValue", price -> price.getValue()).get() : null);
                        String ifThenElseResult2 = ExpressionOperators.exists((Mapper)schedulePeriod.map("getDeliveryPeriod", _schedulePeriod -> _schedulePeriod.getDeliveryPeriod()).map("getPriceTimeIntervalQuantity", calculationScheduleDeliveryPeriods -> calculationScheduleDeliveryPeriods.getPriceTimeIntervalQuantity())).getOrDefault(Boolean.valueOf(false)) != false ? ((fieldWithMetaString0 = (FieldWithMetaString)schedulePeriod.map("getDeliveryPeriod", _schedulePeriod -> _schedulePeriod.getDeliveryPeriod()).map("getPriceTimeIntervalQuantity", calculationScheduleDeliveryPeriods -> calculationScheduleDeliveryPeriods.getPriceTimeIntervalQuantity()).map("getUnit", price -> price.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get()) == null ? null : fieldWithMetaString0.getValue()) : (ExpressionOperators.exists((Mapper)deliveryBlock.map("getPriceTimeIntervalQuantity", assetDeliveryProfileBlock -> assetDeliveryProfileBlock.getPriceTimeIntervalQuantity())).getOrDefault(Boolean.valueOf(false)) != false ? ((fieldWithMetaString1 = (FieldWithMetaString)deliveryBlock.map("getPriceTimeIntervalQuantity", assetDeliveryProfileBlock -> assetDeliveryProfileBlock.getPriceTimeIntervalQuantity()).map("getUnit", price -> price.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get()) == null ? null : fieldWithMetaString1.getValue()) : null);
                        return MapperS.of((Object)this.create_DeliveryBlock.evaluate((LocalTime)deliveryBlock.map("getStartTime", assetDeliveryProfileBlock -> assetDeliveryProfileBlock.getStartTime()).get(), (LocalTime)deliveryBlock.map("getEndTime", assetDeliveryProfileBlock -> assetDeliveryProfileBlock.getEndTime()).get(), (Date)schedulePeriod.map("getDeliveryPeriod", _schedulePeriod -> _schedulePeriod.getDeliveryPeriod()).map("getStartDate", calculationScheduleDeliveryPeriods -> calculationScheduleDeliveryPeriods.getStartDate()).get(), (Date)schedulePeriod.map("getDeliveryPeriod", _schedulePeriod -> _schedulePeriod.getDeliveryPeriod()).map("getEndDate", calculationScheduleDeliveryPeriods -> calculationScheduleDeliveryPeriods.getEndDate()).get(), (BankHolidayTreatmentEnum)deliveryProfile.map("getBankHolidaysTreatment", assetDeliveryProfile -> assetDeliveryProfile.getBankHolidaysTreatment()).get(), (CommodityTimeUnitEnum)((Object)((Object)((Object)((Object)this.duration(reportableEvent).get())))), deliveryBlock.mapC("getDayOfWeek", assetDeliveryProfileBlock -> assetDeliveryProfileBlock.getDayOfWeek()).getMulti(), (Quantity)ifThenElseResult0, ifThenElseResult1, ifThenElseResult2));
                    }));
                    return _thenArg.flattenList();
                });
                reportableDelivery.addAll(this.toBuilder(thenArg.flattenList().getMulti()));
            } else {
                reportableDelivery.addAll(this.toBuilder(this.delivery(reportableEvent).map("getPeriods", assetDeliveryInformation -> assetDeliveryInformation.getPeriods()).mapSingleToList(periods -> {
                    MapperListOfLists _thenArg = periods.mapC("getProfile", assetDeliveryPeriods -> assetDeliveryPeriods.getProfile()).mapItemToList(deliveryProfile -> deliveryProfile.mapC("getBlock", assetDeliveryProfile -> assetDeliveryProfile.getBlock()).mapItem(deliveryBlock -> {
                        Object ifThenElseResult = ExpressionOperators.exists((Mapper)this.delivery(reportableEvent).map("getDeliveryCapacity", assetDeliveryInformation -> assetDeliveryInformation.getDeliveryCapacity())).getOrDefault(Boolean.valueOf(false)) != false ? (Quantity)this.delivery(reportableEvent).map("getDeliveryCapacity", assetDeliveryInformation -> assetDeliveryInformation.getDeliveryCapacity()).get() : (ExpressionOperators.exists((Mapper)deliveryBlock.map("getDeliveryCapacity", assetDeliveryProfileBlock -> assetDeliveryProfileBlock.getDeliveryCapacity())).getOrDefault(Boolean.valueOf(false)) != false ? (Quantity)deliveryBlock.map("getDeliveryCapacity", assetDeliveryProfileBlock -> assetDeliveryProfileBlock.getDeliveryCapacity()).get() : null);
                        FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)deliveryBlock.map("getPriceTimeIntervalQuantity", assetDeliveryProfileBlock -> assetDeliveryProfileBlock.getPriceTimeIntervalQuantity()).map("getUnit", price -> price.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get();
                        return MapperS.of((Object)this.create_DeliveryBlock.evaluate((LocalTime)deliveryBlock.map("getStartTime", assetDeliveryProfileBlock -> assetDeliveryProfileBlock.getStartTime()).get(), (LocalTime)deliveryBlock.map("getEndTime", assetDeliveryProfileBlock -> assetDeliveryProfileBlock.getEndTime()).get(), (Date)periods.map("getStartDate", assetDeliveryPeriods -> assetDeliveryPeriods.getStartDate()).get(), (Date)periods.map("getEndDate", assetDeliveryPeriods -> assetDeliveryPeriods.getEndDate()).get(), (BankHolidayTreatmentEnum)deliveryProfile.map("getBankHolidaysTreatment", assetDeliveryProfile -> assetDeliveryProfile.getBankHolidaysTreatment()).get(), (CommodityTimeUnitEnum)((Object)((Object)((Object)((Object)this.duration(reportableEvent).get())))), deliveryBlock.mapC("getDayOfWeek", assetDeliveryProfileBlock -> assetDeliveryProfileBlock.getDayOfWeek()).getMulti(), (Quantity)ifThenElseResult, (BigDecimal)deliveryBlock.map("getPriceTimeIntervalQuantity", assetDeliveryProfileBlock -> assetDeliveryProfileBlock.getPriceTimeIntervalQuantity()).map("getValue", price -> price.getValue()).get(), fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
                    }));
                    return _thenArg.flattenList();
                }).getMulti()));
            }
            return Optional.ofNullable(reportableDelivery).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends Product> product(ReportableEvent reportableEvent) {
            return MapperS.of((Object)this.productForEvent.evaluate(reportableEvent));
        }

        @Override
        protected MapperS<? extends EconomicTerms> economicTerms(ReportableEvent reportableEvent) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(reportableEvent).get()));
        }

        @Override
        protected MapperS<? extends AssetDeliveryInformation> delivery(ReportableEvent reportableEvent) {
            if (ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_FixedFloat.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get()))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_Basis.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getDelivery", commodityPayout -> commodityPayout.getDelivery()).first();
            }
            Boolean boolean0 = this.qualify_Commodity_Option.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get());
            if (boolean0 != null && boolean0.booleanValue()) {
                return MapperS.of((Object)((AssetDeliveryInformation)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getDelivery", optionPayout -> optionPayout.getDelivery()).get()));
            }
            Boolean boolean1 = this.qualify_Commodity_Swaption.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get());
            if (boolean1 != null && boolean1.booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).get())).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getDelivery", commodityPayout -> commodityPayout.getDelivery()).first();
            }
            Boolean boolean2 = this.isSingleCommodityPayoutProduct.evaluate((Product)this.product(reportableEvent).get());
            if (boolean2 != null && boolean2.booleanValue()) {
                return MapperS.of((Object)((CommodityPayout)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get())).map("getDelivery", commodityPayout -> commodityPayout.getDelivery());
            }
            Boolean boolean3 = this.qualify_Commodity_Forward.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get());
            if (boolean3 != null && boolean3.booleanValue()) {
                return MapperS.of((Object)((ForwardPayout)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getDelivery", forwardPayout -> forwardPayout.getDelivery());
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<? extends CalculationSchedule> customizedSchedule(ReportableEvent reportableEvent) {
            if (ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_FixedFloat.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get()))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_Basis.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getSchedule", commodityPayout -> commodityPayout.getSchedule()).first();
            }
            if (ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Option.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get()))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Swaption.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((OptionPayout)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getSchedule", optionPayout -> optionPayout.getSchedule());
            }
            Boolean boolean0 = this.isSingleCommodityPayoutProduct.evaluate((Product)this.product(reportableEvent).get());
            if (boolean0 != null && boolean0.booleanValue()) {
                return MapperS.of((Object)((CommodityPayout)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get())).map("getSchedule", commodityPayout -> commodityPayout.getSchedule());
            }
            Boolean boolean1 = this.qualify_Commodity_Forward.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get());
            if (boolean1 != null && boolean1.booleanValue()) {
                return MapperS.of((Object)((ForwardPayout)this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getSchedule", forwardPayout -> forwardPayout.getSchedule());
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<CommodityTimeUnitEnum> duration(ReportableEvent reportableEvent) {
            return MapperS.of((Object)reportableEvent).map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).mapC("getTransactionInformation", reportableInformation -> reportableInformation.getTransactionInformation()).map("getEsmaTransactionInformation", transactionInformation -> transactionInformation.getEsmaTransactionInformation()).map("getDuration", eSMATransactionInformation -> eSMATransactionInformation.getDuration()).first();
        }
    }
}

