/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.datetime.PeriodEnum;
import cdm.base.datetime.PeriodExtendedEnum;
import cdm.base.datetime.functions.DateDifference;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.functions.PeriodCalculation;
import javax.inject.Inject;

@ImplementedBy(value=PeriodExtendedCalculationDefault.class)
public abstract class PeriodExtendedCalculation
implements RosettaFunction {
    @Inject
    protected DateDifference dateDifference;
    @Inject
    protected PeriodCalculation periodCalculation;

    public Integer evaluate(PeriodExtendedEnum periodExtended, Integer periodMultiplier, Date effectiveDate, Date terminationDate) {
        Integer result = this.doEvaluate(periodExtended, periodMultiplier, effectiveDate, terminationDate);
        return result;
    }

    protected abstract Integer doEvaluate(PeriodExtendedEnum var1, Integer var2, Date var3, Date var4);

    protected abstract MapperS<PeriodEnum> period(PeriodExtendedEnum var1, Integer var2, Date var3, Date var4);

    public static class PeriodExtendedCalculationDefault
    extends PeriodExtendedCalculation {
        @Override
        protected Integer doEvaluate(PeriodExtendedEnum periodExtended, Integer periodMultiplier, Date effectiveDate, Date terminationDate) {
            Integer result = null;
            return this.assignOutput(result, periodExtended, periodMultiplier, effectiveDate, terminationDate);
        }

        protected Integer assignOutput(Integer result, PeriodExtendedEnum periodExtended, Integer periodMultiplier, Date effectiveDate, Date terminationDate) {
            result = ExpressionOperators.exists(this.period(periodExtended, periodMultiplier, effectiveDate, terminationDate)).getOrDefault(Boolean.valueOf(false)) != false ? this.periodCalculation.evaluate((PeriodEnum)this.period(periodExtended, periodMultiplier, effectiveDate, terminationDate).get(), periodMultiplier) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)periodExtended), (Mapper)MapperS.of((Object)PeriodExtendedEnum.T), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)periodExtended), (Mapper)MapperS.of((Object)PeriodExtendedEnum.C), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? (Integer)MapperMaths.multiply((Mapper)MapperS.of((Object)periodMultiplier), (Mapper)MapperS.of((Object)this.dateDifference.evaluate(effectiveDate, terminationDate))).get() : null);
            return result;
        }

        @Override
        protected MapperS<PeriodEnum> period(PeriodExtendedEnum periodExtended, Integer periodMultiplier, Date effectiveDate, Date terminationDate) {
            return MapperS.of((Object)periodExtended).checkedMap("to-enum", e -> PeriodEnum.valueOf((String)e.name()), IllegalArgumentException.class);
        }
    }
}

