/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.basket.reports;

import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.template.BasketConstituent;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import java.math.BigDecimal;

@ImplementedBy(value=BasketConstituentNumberOfUnitsRuleDefault.class)
public abstract class BasketConstituentNumberOfUnitsRule
implements ReportFunction<BasketConstituent, BigDecimal> {
    public BigDecimal evaluate(BasketConstituent input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(BasketConstituent var1);

    public static class BasketConstituentNumberOfUnitsRuleDefault
    extends BasketConstituentNumberOfUnitsRule {
        @Override
        protected BigDecimal doEvaluate(BasketConstituent input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, BasketConstituent input) {
            ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule = (ReferenceWithMetaNonNegativeQuantitySchedule)MapperS.of((Object)input).mapC("getQuantity", basketConstituent -> basketConstituent.getQuantity()).get();
            output = (BigDecimal)(referenceWithMetaNonNegativeQuantitySchedule == null ? MapperS.ofNull() : MapperS.of((Object)referenceWithMetaNonNegativeQuantitySchedule.getValue())).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get();
            return output;
        }
    }
}

