/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.payment.functions.PeriodicPaymentToCommonPeriodicPayment;
import drr.standards.iosco.cde.base.payment.PeriodicPayment;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.version3.Leg;
import drr.standards.iso.Direction2Enum;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=LegToCommonLegDefault.class)
public abstract class LegToCommonLeg
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected PeriodicPaymentToCommonPeriodicPayment periodicPaymentToCommonPeriodicPayment;

    public CommonLeg evaluate(Leg leg) {
        CommonLeg commonLeg;
        CommonLeg.CommonLegBuilder commonLegBuilder = this.doEvaluate(leg);
        if (commonLegBuilder == null) {
            commonLeg = null;
        } else {
            commonLeg = commonLegBuilder.build();
            this.objectValidator.validate(CommonLeg.class, (RosettaModelObject)commonLeg);
        }
        return commonLeg;
    }

    protected abstract CommonLeg.CommonLegBuilder doEvaluate(Leg var1);

    public static class LegToCommonLegDefault
    extends LegToCommonLeg {
        @Override
        protected CommonLeg.CommonLegBuilder doEvaluate(Leg leg) {
            CommonLeg.CommonLegBuilder commonLeg = CommonLeg.builder();
            return this.assignOutput(commonLeg, leg);
        }

        protected CommonLeg.CommonLegBuilder assignOutput(CommonLeg.CommonLegBuilder commonLeg, Leg leg) {
            commonLeg = (CommonLeg.CommonLegBuilder)this.toBuilder(CommonLeg.builder().setPeriodicPayment(this.periodicPaymentToCommonPeriodicPayment.evaluate((PeriodicPayment)MapperS.of((Object)leg).map("getPeriodicPayment", _leg -> _leg.getPeriodicPayment()).get())).setFixedRate((BigDecimal)MapperS.of((Object)leg).map("getFixedRate", _leg -> _leg.getFixedRate()).get()).setNotionalAmount((BigDecimal)MapperS.of((Object)leg).map("getNotionalAmount", _leg -> _leg.getNotionalAmount()).get()).setNotionalCurrency((ISOCurrencyCodeEnum)MapperS.of((Object)leg).map("getNotionalCurrency", _leg -> _leg.getNotionalCurrency()).get()).setNotionalAmountSchedule(MapperS.of((Object)leg).mapC("getNotionalAmountSchedule", _leg -> _leg.getNotionalAmountSchedule()).getMulti()).setTotalNotionalQuantity((BigDecimal)MapperS.of((Object)leg).map("getTotalNotionalQuantity", _leg -> _leg.getTotalNotionalQuantity()).get()).setNotionalQuantitySchedule(MapperS.of((Object)leg).mapC("getNotionalQuantitySchedule", _leg -> _leg.getNotionalQuantitySchedule()).getMulti()).setSettlementCurrency((ISOCurrencyCodeEnum)MapperS.of((Object)leg).map("getSettlementCurrency", _leg -> _leg.getSettlementCurrency()).get()).setSpread((PriceFormat)MapperS.of((Object)leg).map("getSpread", _leg -> _leg.getSpread()).get()).setSpreadNotation((PriceNotationEnum)((Object)MapperS.of((Object)leg).map("getSpreadNotation", _leg -> _leg.getSpreadNotation()).get())).setSpreadCurrency((ISOCurrencyCodeEnum)MapperS.of((Object)leg).map("getSpreadCurrency", _leg -> _leg.getSpreadCurrency()).get()).setQuantityUnitOfMeasure((String)MapperS.of((Object)leg).map("getQuantityUnitOfMeasure", _leg -> _leg.getQuantityUnitOfMeasure()).get()).setDirection2((Direction2Enum)((Object)MapperS.of((Object)leg).map("getDirection2", _leg -> _leg.getDirection2()).get())).build());
            return Optional.ofNullable(commonLeg).map(o -> o.prune()).orElse(null);
        }
    }
}

