/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.price.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.observable.event.TriggerEvent;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.common.trade.price.BarrierPrice;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=BarrierFromTriggerEventDefault.class)
public abstract class BarrierFromTriggerEvent
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;

    public BarrierPrice evaluate(TriggerEvent triggerEvent) {
        BarrierPrice barrier;
        BarrierPrice.BarrierPriceBuilder barrierBuilder = this.doEvaluate(triggerEvent);
        if (barrierBuilder == null) {
            barrier = null;
        } else {
            barrier = barrierBuilder.build();
            this.objectValidator.validate(BarrierPrice.class, (RosettaModelObject)barrier);
        }
        return barrier;
    }

    protected abstract BarrierPrice.BarrierPriceBuilder doEvaluate(TriggerEvent var1);

    public static class BarrierFromTriggerEventDefault
    extends BarrierFromTriggerEvent {
        @Override
        protected BarrierPrice.BarrierPriceBuilder doEvaluate(TriggerEvent triggerEvent) {
            BarrierPrice.BarrierPriceBuilder barrier = BarrierPrice.builder();
            return this.assignOutput(barrier, triggerEvent);
        }

        protected BarrierPrice.BarrierPriceBuilder assignOutput(BarrierPrice.BarrierPriceBuilder barrier, TriggerEvent triggerEvent) {
            PriceNotationEnum ifThenElseResult = ExpressionOperators.exists((Mapper)MapperS.of((Object)triggerEvent).map("getTrigger", _triggerEvent -> _triggerEvent.getTrigger()).map("getLevel", trigger -> trigger.getLevel())).getOrDefault(Boolean.valueOf(false)) != false ? PriceNotationEnum.MONETARY : (ExpressionOperators.exists((Mapper)MapperS.of((Object)triggerEvent).map("getTrigger", _triggerEvent -> _triggerEvent.getTrigger()).map("getLevelPercentage", trigger -> trigger.getLevelPercentage())).getOrDefault(Boolean.valueOf(false)) != false ? PriceNotationEnum.DECIMAL : null);
            barrier = (BarrierPrice.BarrierPriceBuilder)this.toBuilder(BarrierPrice.builder().setPrice(PriceFormat.builder().setMonetary((BigDecimal)MapperS.of((Object)triggerEvent).map("getTrigger", _triggerEvent -> _triggerEvent.getTrigger()).map("getLevel", trigger -> trigger.getLevel()).get()).setDecimal((BigDecimal)MapperS.of((Object)triggerEvent).map("getTrigger", _triggerEvent -> _triggerEvent.getTrigger()).map("getLevelPercentage", trigger -> trigger.getLevelPercentage()).get()).build()).setNotation(ifThenElseResult).setCurrency((ISOCurrencyCodeEnum)MapperS.of((Object)triggerEvent).map("getFeaturePayment", _triggerEvent -> _triggerEvent.getFeaturePayment()).map("getCurrency", featurePayment -> featurePayment.getCurrency()).mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get()).build());
            return Optional.ofNullable(barrier).map(o -> o.prune()).orElse(null);
        }
    }
}

