/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.PayoutLegWithAuxiliary;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PayoutLegWithAuxiliaryFixedOrCommodityPayout")
@ImplementedBy(value=Default.class)
public interface PayoutLegWithAuxiliaryFixedOrCommodityPayout
extends Validator<PayoutLegWithAuxiliary> {
    public static final String NAME = "PayoutLegWithAuxiliaryFixedOrCommodityPayout";
    public static final String DEFINITION = "auxiliaryLeg -> fixedPricePayout only exists or auxiliaryLeg -> commodityPayout only exists";

    public static class NoOp
    implements PayoutLegWithAuxiliaryFixedOrCommodityPayout {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PayoutLegWithAuxiliary payoutLegWithAuxiliary) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PayoutLegWithAuxiliaryFixedOrCommodityPayout {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PayoutLegWithAuxiliary payoutLegWithAuxiliary) {
            ComparisonResult result = this.executeDataRule(payoutLegWithAuxiliary);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PayoutLegWithAuxiliaryFixedOrCommodityPayout.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PayoutLegWithAuxiliary", (RosettaPath)path, (String)PayoutLegWithAuxiliaryFixedOrCommodityPayout.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PayoutLegWithAuxiliaryFixedOrCommodityPayout.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PayoutLegWithAuxiliary", (RosettaPath)path, (String)PayoutLegWithAuxiliaryFixedOrCommodityPayout.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PayoutLegWithAuxiliary payoutLegWithAuxiliary) {
            try {
                return ExpressionOperators.onlyExists((Mapper)MapperS.of((Object)payoutLegWithAuxiliary).map("getAuxiliaryLeg", _payoutLegWithAuxiliary -> _payoutLegWithAuxiliary.getAuxiliaryLeg()), Arrays.asList("creditDefaultPayout", "optionPayout", "forwardPayout", "performancePayout", "interestRatePayout", "cashflow", "fixedPricePayout", "commodityPayout"), Arrays.asList("fixedPricePayout")).or(ExpressionOperators.onlyExists((Mapper)MapperS.of((Object)payoutLegWithAuxiliary).map("getAuxiliaryLeg", _payoutLegWithAuxiliary -> _payoutLegWithAuxiliary.getAuxiliaryLeg()), Arrays.asList("creditDefaultPayout", "optionPayout", "forwardPayout", "performancePayout", "interestRatePayout", "cashflow", "fixedPricePayout", "commodityPayout"), Arrays.asList("commodityPayout")));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

