/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionInformation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TransactionInformationSupervisorInformation")
@ImplementedBy(value=Default.class)
public interface TransactionInformationSupervisorInformation
extends Validator<TransactionInformation> {
    public static final String NAME = "TransactionInformationSupervisorInformation";
    public static final String DEFINITION = "if regimeName = RegimeNameEnum -> DoddFrankAct then supervisoryBody = SupervisoryBodyEnum -> CFTC or supervisoryBody = SupervisoryBodyEnum -> SEC";

    public static class NoOp
    implements TransactionInformationSupervisorInformation {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TransactionInformation transactionInformation) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TransactionInformationSupervisorInformation {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TransactionInformation transactionInformation) {
            ComparisonResult result = this.executeDataRule(transactionInformation);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TransactionInformationSupervisorInformation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TransactionInformation", (RosettaPath)path, (String)TransactionInformationSupervisorInformation.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TransactionInformationSupervisorInformation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TransactionInformation", (RosettaPath)path, (String)TransactionInformationSupervisorInformation.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(TransactionInformation transactionInformation) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)transactionInformation).map("getRegimeName", _transactionInformation -> _transactionInformation.getRegimeName()).map("Type coercion", fieldWithMetaRegimeNameEnum -> fieldWithMetaRegimeNameEnum == null ? null : fieldWithMetaRegimeNameEnum.getValue()), (Mapper)MapperS.of((Object)((Object)RegimeNameEnum.DODD_FRANK_ACT)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)transactionInformation).map("getSupervisoryBody", _transactionInformation -> _transactionInformation.getSupervisoryBody()).map("Type coercion", fieldWithMetaSupervisoryBodyEnum0 -> fieldWithMetaSupervisoryBodyEnum0 == null ? null : fieldWithMetaSupervisoryBodyEnum0.getValue()), (Mapper)MapperS.of((Object)((Object)SupervisoryBodyEnum.CFTC)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)transactionInformation).map("getSupervisoryBody", _transactionInformation -> _transactionInformation.getSupervisoryBody()).map("Type coercion", fieldWithMetaSupervisoryBodyEnum1 -> fieldWithMetaSupervisoryBodyEnum1 == null ? null : fieldWithMetaSupervisoryBodyEnum1.getValue()), (Mapper)MapperS.of((Object)((Object)SupervisoryBodyEnum.SEC)), (CardinalityOperator)CardinalityOperator.All));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

