/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsCommoditySwapFloatFloat;
import drr.regulation.csa.rewrite.trade.functions.CommodityBasisLeg2;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CommodityLeg2Default.class)
public abstract class CommodityLeg2
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CommodityBasisLeg2 commodityBasisLeg2;
    @Inject
    protected drr.regulation.common.functions.CommodityLeg2 commodityLeg2;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsCommoditySwapFloatFloat isCommoditySwapFloatFloat;

    public CommodityPayout evaluate(Product product) {
        CommodityPayout _commodityLeg2;
        CommodityPayout.CommodityPayoutBuilder commodityLeg2Builder = this.doEvaluate(product);
        if (commodityLeg2Builder == null) {
            _commodityLeg2 = null;
        } else {
            _commodityLeg2 = commodityLeg2Builder.build();
            this.objectValidator.validate(CommodityPayout.class, (RosettaModelObject)_commodityLeg2);
        }
        return _commodityLeg2;
    }

    protected abstract CommodityPayout.CommodityPayoutBuilder doEvaluate(Product var1);

    protected abstract MapperC<? extends CommodityPayout> commodityPayouts(Product var1);

    public static class CommodityLeg2Default
    extends CommodityLeg2 {
        @Override
        protected CommodityPayout.CommodityPayoutBuilder doEvaluate(Product product) {
            CommodityPayout.CommodityPayoutBuilder _commodityLeg2 = CommodityPayout.builder();
            return this.assignOutput(_commodityLeg2, product);
        }

        protected CommodityPayout.CommodityPayoutBuilder assignOutput(CommodityPayout.CommodityPayoutBuilder _commodityLeg2, Product product) {
            Boolean _boolean = this.isCommoditySwapFloatFloat.evaluate(product);
            _commodityLeg2 = _boolean != null && _boolean != false ? (CommodityPayout.CommodityPayoutBuilder)this.toBuilder((RosettaModelObject)this.commodityBasisLeg2.evaluate(product)) : (CommodityPayout.CommodityPayoutBuilder)this.toBuilder((RosettaModelObject)this.commodityLeg2.evaluate(product));
            return Optional.ofNullable(_commodityLeg2).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends CommodityPayout> commodityPayouts(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout());
        }
    }
}

