/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.party.reports.BrokerIDRule;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import javax.inject.Inject;

@ImplementedBy(value=BrokerIdentifierRuleDefault.class)
public abstract class BrokerIdentifierRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected BrokerIDRule brokerIDRule;
    @Inject
    protected IsAllowableActionForCSA isAllowableActionForCSA;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class BrokerIdentifierRuleDefault
    extends BrokerIdentifierRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCSA.evaluate((ReportableEvent)item.get()));
            output = (String)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.brokerIDRule.evaluate((TransactionReportInstruction)item.get()))).get();
            return output;
        }
    }
}

