/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.reports.PriceNotationRule;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.functions.PriceFormatFromNotation;
import drr.standards.iosco.cde.version3.price.reports.PriceNoFormatRule;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PriceRuleDefault.class)
public abstract class PriceRule
implements ReportFunction<TransactionReportInstruction, PriceFormat> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsAllowableActionForCSA isAllowableActionForCSA;
    @Inject
    protected PriceFormatFromNotation priceFormatFromNotation;
    @Inject
    protected PriceNoFormatRule priceNoFormatRule;
    @Inject
    protected PriceNotationRule priceNotationRule;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
    @Inject
    protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;

    public PriceFormat evaluate(TransactionReportInstruction input) {
        PriceFormat output;
        PriceFormat.PriceFormatBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(PriceFormat.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction var1);

    public static class PriceRuleDefault
    extends PriceRule {
        @Override
        protected PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction input) {
            PriceFormat.PriceFormatBuilder output = PriceFormat.builder();
            return this.assignOutput(output, input);
        }

        protected PriceFormat.PriceFormatBuilder assignOutput(PriceFormat.PriceFormatBuilder output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCSA.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.filterSingleNullSafe(item -> ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_AssetClass_Commodity.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate((ReportableEvent)item.get()))))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_AssetClass_Equity.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate((ReportableEvent)item.get())))))).get());
            output = (PriceFormat.PriceFormatBuilder)this.toBuilder((RosettaModelObject)thenArg1.mapSingleToItem(item -> MapperS.of((Object)this.priceFormatFromNotation.evaluate(this.priceNoFormatRule.evaluate((TransactionReportInstruction)item.get()), this.priceNotationRule.evaluate((TransactionReportInstruction)item.get())))).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

