/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.standards.iosco.upi.AnnaDsbAssetClassEnum;
import drr.standards.iosco.upi.AnnaDsbInstrumentTypeEnum;
import drr.standards.iso.PaymentType4Code;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CSATransactionReportCSA_VR_0045_01")
@ImplementedBy(value=Default.class)
public interface CSATransactionReportCSA_VR_0045_01
extends Validator<CSATransactionReport> {
    public static final String NAME = "CSATransactionReportCSA_VR_0045_01";
    public static final String DEFINITION = "if (nonReportable -> postUpiData -> Header -> AssetClass = Credit or dtccAdditionalFields -> primaryAssetClass = Credit) and otherPayment -> paymentType any <> UFRO and ((nonReportable -> postUpiData -> Header -> InstrumentType exists and nonReportable -> postUpiData -> Header -> InstrumentType <> Option) or nonReportable -> instrumentType <> Option) then ((if leg1 -> spread is absent and leg1 exists then leg1 -> fixedRate exists else leg1 -> fixedRate is absent) and (if leg2 -> spread is absent and leg2 exists then leg2 -> fixedRate exists else leg2 -> fixedRate is absent)) else if (nonReportable -> postUpiData -> Header -> AssetClass = Rates or dtccAdditionalFields -> primaryAssetClass = InterestRate) and ((nonReportable -> postUpiData -> Header -> InstrumentType exists and nonReportable -> postUpiData -> Header -> InstrumentType <> Option) or nonReportable -> instrumentType <> Option) then ((if leg1 -> spread is absent and leg1 exists then leg1 -> fixedRate exists else leg1 -> fixedRate is absent) and (if leg2 -> spread is absent and leg2 exists then leg2 -> fixedRate exists else leg2 -> fixedRate is absent)) else if (nonReportable -> postUpiData -> Header -> AssetClass = Commodities or dtccAdditionalFields -> primaryAssetClass = Commodity) and price is absent and ((nonReportable -> postUpiData -> Header -> InstrumentType exists and nonReportable -> postUpiData -> Header -> InstrumentType <> Option) or nonReportable -> instrumentType <> Option) then ((if leg1 -> spread is absent and leg1 exists then leg1 -> fixedRate exists else leg1 -> fixedRate is absent) and (if leg2 -> spread is absent and leg2 exists then leg2 -> fixedRate exists else leg2 -> fixedRate is absent))";

    public static class NoOp
    implements CSATransactionReportCSA_VR_0045_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CSATransactionReportCSA_VR_0045_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            ComparisonResult result = this.executeDataRule(cSATransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CSATransactionReportCSA_VR_0045_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportCSA_VR_0045_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CSATransactionReportCSA_VR_0045_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportCSA_VR_0045_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CSATransactionReport cSATransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), (Mapper)MapperS.of((Object)((Object)AnnaDsbAssetClassEnum.CREDIT)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getDtccAdditionalFields", _cSATransactionReport -> _cSATransactionReport.getDtccAdditionalFields()).map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), (Mapper)MapperS.of((Object)AssetClassEnum.CREDIT), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)cSATransactionReport).mapC("getOtherPayment", _cSATransactionReport -> _cSATransactionReport.getOtherPayment()).map("getPaymentType", otherPayment -> otherPayment.getPaymentType()), (Mapper)MapperS.of((Object)((Object)PaymentType4Code.UFRO)), (CardinalityOperator)CardinalityOperator.Any)).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType())).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getInstrumentType", cSANonReportable -> cSANonReportable.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.Any))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ComparisonResult ifThenElseResult0 = ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getSpread", cSALeg -> cSALeg.getSpread())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()))).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getFixedRate", cSALeg -> cSALeg.getFixedRate())) : ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getFixedRate", cSALeg -> cSALeg.getFixedRate()));
                    ComparisonResult ifThenElseResult1 = ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getSpread", cSALeg -> cSALeg.getSpread())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()))).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getFixedRate", cSALeg -> cSALeg.getFixedRate())) : ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getFixedRate", cSALeg -> cSALeg.getFixedRate()));
                    return ifThenElseResult0.and(ifThenElseResult1);
                }
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), (Mapper)MapperS.of((Object)((Object)AnnaDsbAssetClassEnum.RATES)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getDtccAdditionalFields", _cSATransactionReport -> _cSATransactionReport.getDtccAdditionalFields()).map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), (Mapper)MapperS.of((Object)AssetClassEnum.INTEREST_RATE), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType())).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getInstrumentType", cSANonReportable -> cSANonReportable.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.Any))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ComparisonResult ifThenElseResult2 = ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getSpread", cSALeg -> cSALeg.getSpread())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()))).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getFixedRate", cSALeg -> cSALeg.getFixedRate())) : ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getFixedRate", cSALeg -> cSALeg.getFixedRate()));
                    ComparisonResult ifThenElseResult3 = ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getSpread", cSALeg -> cSALeg.getSpread())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()))).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getFixedRate", cSALeg -> cSALeg.getFixedRate())) : ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getFixedRate", cSALeg -> cSALeg.getFixedRate()));
                    return ifThenElseResult2.and(ifThenElseResult3);
                }
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), (Mapper)MapperS.of((Object)((Object)AnnaDsbAssetClassEnum.COMMODITIES)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getDtccAdditionalFields", _cSATransactionReport -> _cSATransactionReport.getDtccAdditionalFields()).map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), (Mapper)MapperS.of((Object)AssetClassEnum.COMMODITY), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getPrice", _cSATransactionReport -> _cSATransactionReport.getPrice()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType())).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getInstrumentType", cSANonReportable -> cSANonReportable.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.Any))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ComparisonResult ifThenElseResult4 = ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getSpread", cSALeg -> cSALeg.getSpread())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()))).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getFixedRate", cSALeg -> cSALeg.getFixedRate())) : ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg1", _cSATransactionReport -> _cSATransactionReport.getLeg1()).map("getFixedRate", cSALeg -> cSALeg.getFixedRate()));
                    ComparisonResult ifThenElseResult5 = ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getSpread", cSALeg -> cSALeg.getSpread())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()))).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getFixedRate", cSALeg -> cSALeg.getFixedRate())) : ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getFixedRate", cSALeg -> cSALeg.getFixedRate()));
                    return ifThenElseResult4.and(ifThenElseResult5);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

