/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.ClearingAccountOriginEnum;
import drr.regulation.common.ClearingExceptionsAndExemptionsEnum;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.Counterparty2IdentifierEnum;
import drr.regulation.common.ReportableDelivery;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.EMIRTransactionReport;
import drr.regulation.common.trade.NonReportable;
import drr.regulation.common.trade.contract.MasterAgreementEnum;
import drr.regulation.common.trade.party.NatureOfCounterpartyEnum;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier;
import drr.regulation.common.trade.underlier.UnderlyingIdentificationTypeEnum;
import drr.regulation.esma.emir.refit.trade.meta.ESMAEMIRTransactionReportMeta;
import drr.standards.iosco.cde.base.basket.BasketConstituentsReport;
import drr.standards.iosco.cde.base.payment.OtherPayment;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.base.price.PricePeriod;
import drr.standards.iosco.cde.version1.LegV1;
import drr.standards.iosco.cde.version2.LegV2;
import drr.standards.iosco.cde.version3.Leg;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.ClearingObligationEnum;
import drr.standards.iso.ConfirmationEnum;
import drr.standards.iso.DeliveryTypeEnum;
import drr.standards.iso.Direction1Enum;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.EnergyLoadType1Code;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.IndexEnum;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.RiskReductionTechniqueEnum;
import drr.standards.iso.SeniorityEnum;
import drr.standards.iso.TradingCapacity7Code;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ESMAEMIRTransactionReport", builder=ESMAEMIRTransactionReportBuilderImpl.class, version="6.17.1")
@RuneDataType(value="ESMAEMIRTransactionReport", model="drr", builder=ESMAEMIRTransactionReportBuilderImpl.class, version="6.17.1")
public interface ESMAEMIRTransactionReport
extends EMIRTransactionReport {
    public static final ESMAEMIRTransactionReportMeta metaData = new ESMAEMIRTransactionReportMeta();

    @Override
    public NatureOfCounterpartyEnum getNatureOfCounterparty1();

    @Override
    public Boolean getCounterparty2IdentifierType();

    @Override
    public CommonContractType getContractType();

    @Override
    public CommonAssetClass getAssetClass();

    @Override
    public Boolean getCryptoAssetUnderlyingIndicator();

    @Override
    public ClearedEnum getCleared();

    @Override
    public MasterAgreementEnum getMasterAgreementType();

    @Override
    public ZonedDateTime getExecutionTimestamp();

    @Override
    public Date getEffectiveDate();

    @Override
    public DeliveryTypeEnum getDeliveryType();

    @Override
    public ReportLevelEnum getLevel();

    @Override
    public ESMAEMIRTransactionReport build();

    @Override
    public ESMAEMIRTransactionReportBuilder toBuilder();

    public static ESMAEMIRTransactionReportBuilder builder() {
        return new ESMAEMIRTransactionReportBuilderImpl();
    }

    default public RosettaMetaData<? extends ESMAEMIRTransactionReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ESMAEMIRTransactionReport> getType() {
        return ESMAEMIRTransactionReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, (Object)this.getEarlyTerminationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary1"), String.class, (Object)this.getBeneficiary1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, (Object)this.getBeneficiary1IdentifierTypeIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, (Object)this.getBuyerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, (Object)this.getSellerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, (Object)this.getCleared(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, (Object)this.getConfirmed(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.class, this.getPriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("price"), processor, PriceFormat.class, this.getPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, (Object)this.getPriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.class, this.getPackageTransactionPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionPriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionPriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.class, this.getPackageTransactionSpread(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionSpreadNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionSpreadCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.class, this.getStrikePrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, (Object)this.getStrikePriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, (Object)this.getStrikePriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("customBasketCode"), String.class, (Object)this.getCustomBasketCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, this.getBasketConstituents(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.class, this.getOtherPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("leg1"), processor, CommonLeg.class, this.getLeg1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("leg2"), processor, CommonLeg.class, this.getLeg2(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, (Object)this.getUnderlyingIdOther(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, (Object)this.getUnderlyingIdOtherSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, (Object)this.getUnderlyingAssetPriceSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, (Object)this.getCryptoAssetUnderlyingIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, (Object)this.getEventType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventIdentifier"), String.class, (Object)this.getEventIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, (Object)this.getExecutionAgentCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentCounterparty2"), String.class, (Object)this.getExecutionAgentCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, (Object)this.getPriorUTIProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, (Object)this.getContractType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, (Object)this.getAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, (Object)this.getClearingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("platformIdentifier"), String.class, (Object)this.getPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, (Object)this.getDirection1(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.class, this.getBarrier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, (Object)this.getNameOfTheUnderlyingIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, (Object)this.getOptionStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, (Object)this.getDeliveryType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, (Object)this.getCountryOfTheCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, (Object)this.getBookingLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, (Object)this.getTraderLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, (Object)this.getTradingCapacity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, (Object)this.getEmbeddedOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, (Object)this.getSeniority(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("series"), Integer.class, (Object)this.getSeries(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, (Object)this.getClearingAccountOrigin(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, (Object)this.getOriginalSwapUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, (Object)this.getOriginalSwapSDRIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, (Object)this.getClearingReceiptTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUSI"), String.class, (Object)this.getPriorUSI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, (Object)this.getNewSDRIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, (Object)this.getSubsequentPositionUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("masterAgreementType"), MasterAgreementEnum.class, (Object)this.getMasterAgreementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, (Object)this.getMasterAgreementVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, (Object)this.getNonStandardizedTermIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, (Object)this.getAmendmentIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, (Object)this.getPackageIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("brokerID"), String.class, (Object)this.getBrokerID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, (Object)this.getConfirmationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seriesVersion"), Integer.class, (Object)this.getSeriesVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, (Object)this.getSecondaryTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("natureOfCounterparty1"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("natureOfCounterparty2"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("swapLinkID"), String.class, (Object)this.getSwapLinkID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("baseProduct"), String.class, (Object)this.getBaseProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("subProduct"), String.class, (Object)this.getSubProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, (Object)this.getFurtherSubProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("intragroup"), Boolean.class, (Object)this.getIntragroup(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("referenceEntity"), String.class, (Object)this.getReferenceEntity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), Counterparty2IdentifierEnum.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, (Object)this.getCustomBasketIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, (Object)this.getUnderlyingIdentification(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdentificationType"), UnderlyingIdentificationTypeEnum.class, (Object)this.getUnderlyingIdentificationType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, this.getCorporateSectorOfTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, this.getCorporateSectorOfTheCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nonReportable"), processor, NonReportable.class, this.getNonReportable(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty1"), Boolean.class, (Object)this.getClearingThresholdOfCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty2"), Boolean.class, (Object)this.getClearingThresholdOfCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingObligationOfTheCounterparty2"), Boolean.class, (Object)this.getReportingObligationOfTheCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("directlyLinkedToCommercialActivityOrTreasuryFinancing"), Boolean.class, (Object)this.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportTrackingNumber"), String.class, (Object)this.getReportTrackingNumber(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("ptrrId"), String.class, (Object)this.getPtrrId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isin"), String.class, (Object)this.getIsin(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("productClassification"), String.class, (Object)this.getProductClassification(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indicatorOfTheUnderlyingIndex"), IndexEnum.class, this.getIndicatorOfTheUnderlyingIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingObligation"), ClearingObligationEnum.class, (Object)this.getClearingObligation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("otherMasterAgreementType"), String.class, (Object)this.getOtherMasterAgreementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("ptrr"), Boolean.class, (Object)this.getPtrr(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("typeOfPTRRTechnique"), RiskReductionTechniqueEnum.class, (Object)this.getTypeOfPTRRTechnique(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("ptrrServiceProvider"), String.class, (Object)this.getPtrrServiceProvider(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("venueOfExecution"), String.class, (Object)this.getVenueOfExecution(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("forwardExchangeRate"), BigDecimal.class, (Object)this.getForwardExchangeRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryPoint"), String.class, this.getDeliveryPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("interconnectionPoint"), String.class, (Object)this.getInterconnectionPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("loadType"), EnergyLoadType1Code.class, (Object)this.getLoadType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryReport"), processor, ReportableDelivery.class, this.getDeliveryReport(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tranche"), Boolean.class, (Object)this.getTranche(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, (Object)this.getCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ESMAEMIRTransactionReportBuilderImpl
    extends EMIRTransactionReport.EMIRTransactionReportBuilderImpl
    implements ESMAEMIRTransactionReportBuilder {
        protected NatureOfCounterpartyEnum natureOfCounterparty1;
        protected Boolean counterparty2IdentifierType;
        protected CommonContractType contractType;
        protected CommonAssetClass assetClass;
        protected Boolean cryptoAssetUnderlyingIndicator;
        protected ClearedEnum cleared;
        protected MasterAgreementEnum masterAgreementType;
        protected ZonedDateTime executionTimestamp;
        protected Date effectiveDate;
        protected DeliveryTypeEnum deliveryType;
        protected ReportLevelEnum level;

        @Override
        @RosettaAttribute(value="natureOfCounterparty1", isRequired=true)
        @RuneAttribute(value="natureOfCounterparty1", isRequired=true)
        public NatureOfCounterpartyEnum getNatureOfCounterparty1() {
            return this.natureOfCounterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="contractType", isRequired=true)
        @RuneAttribute(value="contractType", isRequired=true)
        public CommonContractType getContractType() {
            return this.contractType;
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public CommonAssetClass getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="cryptoAssetUnderlyingIndicator", isRequired=true)
        @RuneAttribute(value="cryptoAssetUnderlyingIndicator", isRequired=true)
        public Boolean getCryptoAssetUnderlyingIndicator() {
            return this.cryptoAssetUnderlyingIndicator;
        }

        @Override
        @RosettaAttribute(value="cleared", isRequired=true)
        @RuneAttribute(value="cleared", isRequired=true)
        public ClearedEnum getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="masterAgreementType", isRequired=true)
        @RuneAttribute(value="masterAgreementType", isRequired=true)
        public MasterAgreementEnum getMasterAgreementType() {
            return this.masterAgreementType;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp", isRequired=true)
        @RuneAttribute(value="executionTimestamp", isRequired=true)
        public ZonedDateTime getExecutionTimestamp() {
            return this.executionTimestamp;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="deliveryType", isRequired=true)
        @RuneAttribute(value="deliveryType", isRequired=true)
        public DeliveryTypeEnum getDeliveryType() {
            return this.deliveryType;
        }

        @Override
        @RosettaAttribute(value="level", isRequired=true)
        @RuneAttribute(value="level", isRequired=true)
        public ReportLevelEnum getLevel() {
            return this.level;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public ESMAEMIRTransactionReportBuilder setEffectiveDateOverriddenAsDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaIgnore
        public ESMAEMIRTransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
            return this.setEffectiveDateOverriddenAsDate(_effectiveDate);
        }

        @Override
        @RosettaAttribute(value="earlyTerminationDate")
        @RuneAttribute(value="earlyTerminationDate")
        public ESMAEMIRTransactionReportBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
            this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ESMAEMIRTransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp", isRequired=true)
        @RuneAttribute(value="executionTimestamp", isRequired=true)
        public ESMAEMIRTransactionReportBuilder setExecutionTimestampOverriddenAsZonedDateTime(ZonedDateTime _executionTimestamp) {
            this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
            return this;
        }

        @Override
        @RosettaIgnore
        public ESMAEMIRTransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
            return this.setExecutionTimestampOverriddenAsZonedDateTime(_executionTimestamp);
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public ESMAEMIRTransactionReportBuilder setExpirationDate(Date _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public ESMAEMIRTransactionReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2")
        @RuneAttribute(value="counterparty2")
        public ESMAEMIRTransactionReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public ESMAEMIRTransactionReportBuilder setCounterparty2IdentifierTypeOverriddenAsBoolean(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaIgnore
        public ESMAEMIRTransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            return this.setCounterparty2IdentifierTypeOverriddenAsBoolean(_counterparty2IdentifierType);
        }

        @Override
        @RosettaAttribute(value="beneficiary1")
        @RuneAttribute(value="beneficiary1")
        public ESMAEMIRTransactionReportBuilder setBeneficiary1(String _beneficiary1) {
            this.beneficiary1 = _beneficiary1 == null ? null : _beneficiary1;
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiary1IdentifierTypeIndicator")
        @RuneAttribute(value="beneficiary1IdentifierTypeIndicator")
        public ESMAEMIRTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean _beneficiary1IdentifierTypeIndicator) {
            this.beneficiary1IdentifierTypeIndicator = _beneficiary1IdentifierTypeIndicator == null ? null : _beneficiary1IdentifierTypeIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerIdentifier")
        @RuneAttribute(value="buyerIdentifier")
        public ESMAEMIRTransactionReportBuilder setBuyerIdentifier(String _buyerIdentifier) {
            this.buyerIdentifier = _buyerIdentifier == null ? null : _buyerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="sellerIdentifier")
        @RuneAttribute(value="sellerIdentifier")
        public ESMAEMIRTransactionReportBuilder setSellerIdentifier(String _sellerIdentifier) {
            this.sellerIdentifier = _sellerIdentifier == null ? null : _sellerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="cleared", isRequired=true)
        @RuneAttribute(value="cleared", isRequired=true)
        public ESMAEMIRTransactionReportBuilder setClearedOverriddenAsClearedEnum(ClearedEnum _cleared) {
            this.cleared = _cleared == null ? null : _cleared;
            return this;
        }

        @Override
        @RosettaIgnore
        public ESMAEMIRTransactionReportBuilder setCleared(ClearedEnum _cleared) {
            return this.setClearedOverriddenAsClearedEnum(_cleared);
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public ESMAEMIRTransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
            this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public ESMAEMIRTransactionReportBuilder setClearingMember(String _clearingMember) {
            this.clearingMember = _clearingMember == null ? null : _clearingMember;
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public ESMAEMIRTransactionReportBuilder setConfirmed(ConfirmationEnum _confirmed) {
            this.confirmed = _confirmed == null ? null : _confirmed;
            return this;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public ESMAEMIRTransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
            this.callAmount = _callAmount == null ? null : _callAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public ESMAEMIRTransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
            this.putAmount = _putAmount == null ? null : _putAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public ESMAEMIRTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
            this.callCurrency = _callCurrency == null ? null : _callCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public ESMAEMIRTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
            this.putCurrency = _putCurrency == null ? null : _putCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public ESMAEMIRTransactionReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceSchedule")
        @RuneAttribute(value="priceSchedule")
        public ESMAEMIRTransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule) {
            if (_priceSchedule != null) {
                this.priceSchedule.add(_priceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule, int idx) {
            this.getIndex(this.priceSchedule, idx, () -> _priceSchedule.toBuilder());
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedules) {
            if (priceSchedules != null) {
                for (PricePeriod pricePeriod : priceSchedules) {
                    this.priceSchedule.add(pricePeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="priceSchedule")
        public ESMAEMIRTransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedules) {
            this.priceSchedule = priceSchedules == null ? new ArrayList() : (List)priceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public ESMAEMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule) {
            if (_strikePriceSchedule != null) {
                this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule, int idx) {
            this.getIndex(this.strikePriceSchedule, idx, () -> _strikePriceSchedule.toBuilder());
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
            if (strikePriceSchedules != null) {
                for (PricePeriod pricePeriod : strikePriceSchedules) {
                    this.strikePriceSchedule.add(pricePeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="strikePriceSchedule")
        public ESMAEMIRTransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
            this.strikePriceSchedule = strikePriceSchedules == null ? new ArrayList() : (List)strikePriceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public ESMAEMIRTransactionReportBuilder setPrice(PriceFormat _price) {
            this.price = _price == null ? null : _price.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceNotation")
        @RuneAttribute(value="priceNotation")
        public ESMAEMIRTransactionReportBuilder setPriceNotation(PriceNotationEnum _priceNotation) {
            this.priceNotation = _priceNotation == null ? null : _priceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceCurrency")
        @RuneAttribute(value="priceCurrency")
        public ESMAEMIRTransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum _priceCurrency) {
            this.priceCurrency = _priceCurrency == null ? null : _priceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPrice")
        @RuneAttribute(value="packageTransactionPrice")
        public ESMAEMIRTransactionReportBuilder setPackageTransactionPrice(PriceFormat _packageTransactionPrice) {
            this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceNotation")
        @RuneAttribute(value="packageTransactionPriceNotation")
        public ESMAEMIRTransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum _packageTransactionPriceNotation) {
            this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceCurrency")
        @RuneAttribute(value="packageTransactionPriceCurrency")
        public ESMAEMIRTransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
            this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpread")
        @RuneAttribute(value="packageTransactionSpread")
        public ESMAEMIRTransactionReportBuilder setPackageTransactionSpread(PriceFormat _packageTransactionSpread) {
            this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadNotation")
        @RuneAttribute(value="packageTransactionSpreadNotation")
        public ESMAEMIRTransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum _packageTransactionSpreadNotation) {
            this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadCurrency")
        @RuneAttribute(value="packageTransactionSpreadCurrency")
        public ESMAEMIRTransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
            this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public ESMAEMIRTransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
            this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public ESMAEMIRTransactionReportBuilder setStrikePrice(PriceFormat _strikePrice) {
            this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceNotation")
        @RuneAttribute(value="strikePriceNotation")
        public ESMAEMIRTransactionReportBuilder setStrikePriceNotation(PriceNotationEnum _strikePriceNotation) {
            this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceCurrency")
        @RuneAttribute(value="strikePriceCurrency")
        public ESMAEMIRTransactionReportBuilder setStrikePriceCurrency(String _strikePriceCurrency) {
            this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public ESMAEMIRTransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
            this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public ESMAEMIRTransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
            this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public ESMAEMIRTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
            this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumPaymentDate")
        @RuneAttribute(value="optionPremiumPaymentDate")
        public ESMAEMIRTransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
            this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public ESMAEMIRTransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
            this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public ESMAEMIRTransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
            this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexAttachmentPoint")
        @RuneAttribute(value="cdSIndexAttachmentPoint")
        public ESMAEMIRTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
            this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexDetachmentPoint")
        @RuneAttribute(value="cdSIndexDetachmentPoint")
        public ESMAEMIRTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
            this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public ESMAEMIRTransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public ESMAEMIRTransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
            this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public ESMAEMIRTransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
            this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public ESMAEMIRTransactionReportBuilder setSettlementLocation(ISOCountryCodeEnum _settlementLocation) {
            this.settlementLocation = _settlementLocation == null ? null : _settlementLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUTI")
        @RuneAttribute(value="priorUTI")
        public ESMAEMIRTransactionReportBuilder setPriorUTI(String _priorUTI) {
            this.priorUTI = _priorUTI == null ? null : _priorUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public ESMAEMIRTransactionReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public ESMAEMIRTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public ESMAEMIRTransactionReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public ESMAEMIRTransactionReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="customBasketCode")
        @RuneAttribute(value="customBasketCode")
        public ESMAEMIRTransactionReportBuilder setCustomBasketCode(String _customBasketCode) {
            this.customBasketCode = _customBasketCode == null ? null : _customBasketCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public ESMAEMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
            if (_basketConstituents != null) {
                this.basketConstituents.add(_basketConstituents.toBuilder());
            }
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int idx) {
            this.getIndex(this.basketConstituents, idx, () -> _basketConstituents.toBuilder());
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            if (basketConstituentss != null) {
                for (BasketConstituentsReport basketConstituentsReport : basketConstituentss) {
                    this.basketConstituents.add(basketConstituentsReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="basketConstituents")
        public ESMAEMIRTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            this.basketConstituents = basketConstituentss == null ? new ArrayList() : (List)basketConstituentss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public ESMAEMIRTransactionReportBuilder addOtherPayment(OtherPayment _otherPayment) {
            if (_otherPayment != null) {
                this.otherPayment.add(_otherPayment.toBuilder());
            }
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addOtherPayment(OtherPayment _otherPayment, int idx) {
            this.getIndex(this.otherPayment, idx, () -> _otherPayment.toBuilder());
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayments) {
            if (otherPayments != null) {
                for (OtherPayment otherPayment : otherPayments) {
                    this.otherPayment.add(otherPayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPayment")
        public ESMAEMIRTransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayments) {
            this.otherPayment = otherPayments == null ? new ArrayList() : (List)otherPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="leg1")
        @RuneAttribute(value="leg1")
        public ESMAEMIRTransactionReportBuilder setLeg1(CommonLeg _leg1) {
            this.leg1 = _leg1 == null ? null : _leg1.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        public ESMAEMIRTransactionReportBuilder setLeg1(Leg _leg1) {
            CommonLeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public ESMAEMIRTransactionReportBuilder setLeg1(LegV2 _leg1) {
            CommonLeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public ESMAEMIRTransactionReportBuilder setLeg1(LegV1 _leg1) {
            CommonLeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="leg2")
        @RuneAttribute(value="leg2")
        public ESMAEMIRTransactionReportBuilder setLeg2(CommonLeg _leg2) {
            this.leg2 = _leg2 == null ? null : _leg2.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        public ESMAEMIRTransactionReportBuilder setLeg2(Leg _leg2) {
            CommonLeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public ESMAEMIRTransactionReportBuilder setLeg2(LegV2 _leg2) {
            CommonLeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public ESMAEMIRTransactionReportBuilder setLeg2(LegV1 _leg2) {
            CommonLeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="underlyingIdOther")
        @RuneAttribute(value="underlyingIdOther")
        public ESMAEMIRTransactionReportBuilder setUnderlyingIdOther(String _underlyingIdOther) {
            this.underlyingIdOther = _underlyingIdOther == null ? null : _underlyingIdOther;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOtherSource")
        @RuneAttribute(value="underlyingIdOtherSource")
        public ESMAEMIRTransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum _underlyingIdOtherSource) {
            this.underlyingIdOtherSource = _underlyingIdOtherSource == null ? null : _underlyingIdOtherSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetTradingPlatformIdentifier")
        @RuneAttribute(value="underlyingAssetTradingPlatformIdentifier")
        public ESMAEMIRTransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifier(String _underlyingAssetTradingPlatformIdentifier) {
            this.underlyingAssetTradingPlatformIdentifier = _underlyingAssetTradingPlatformIdentifier == null ? null : _underlyingAssetTradingPlatformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetPriceSource")
        @RuneAttribute(value="underlyingAssetPriceSource")
        public ESMAEMIRTransactionReportBuilder setUnderlyingAssetPriceSource(String _underlyingAssetPriceSource) {
            this.underlyingAssetPriceSource = _underlyingAssetPriceSource == null ? null : _underlyingAssetPriceSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="cryptoAssetUnderlyingIndicator", isRequired=true)
        @RuneAttribute(value="cryptoAssetUnderlyingIndicator", isRequired=true)
        public ESMAEMIRTransactionReportBuilder setCryptoAssetUnderlyingIndicatorOverriddenAsBoolean(Boolean _cryptoAssetUnderlyingIndicator) {
            this.cryptoAssetUnderlyingIndicator = _cryptoAssetUnderlyingIndicator == null ? null : _cryptoAssetUnderlyingIndicator;
            return this;
        }

        @Override
        @RosettaIgnore
        public ESMAEMIRTransactionReportBuilder setCryptoAssetUnderlyingIndicator(Boolean _cryptoAssetUnderlyingIndicator) {
            return this.setCryptoAssetUnderlyingIndicatorOverriddenAsBoolean(_cryptoAssetUnderlyingIndicator);
        }

        @Override
        @RosettaAttribute(value="level", isRequired=true)
        @RuneAttribute(value="level", isRequired=true)
        public ESMAEMIRTransactionReportBuilder setLevelOverriddenAsReportLevelEnum(ReportLevelEnum _level) {
            this.level = _level == null ? null : _level;
            return this;
        }

        @Override
        @RosettaIgnore
        public ESMAEMIRTransactionReportBuilder setLevel(ReportLevelEnum _level) {
            return this.setLevelOverriddenAsReportLevelEnum(_level);
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public ESMAEMIRTransactionReportBuilder setActionType(ActionTypeEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public ESMAEMIRTransactionReportBuilder setEventType(EventTypeEnum _eventType) {
            this.eventType = _eventType == null ? null : _eventType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public ESMAEMIRTransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
            this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp")
        @RuneAttribute(value="eventTimestamp")
        public ESMAEMIRTransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
            this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name")
        @RuneAttribute(value="counterparty2Name")
        public ESMAEMIRTransactionReportBuilder setCounterparty2Name(String _counterparty2Name) {
            this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentCounterparty1")
        @RuneAttribute(value="executionAgentCounterparty1")
        public ESMAEMIRTransactionReportBuilder setExecutionAgentCounterparty1(String _executionAgentCounterparty1) {
            this.executionAgentCounterparty1 = _executionAgentCounterparty1 == null ? null : _executionAgentCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentCounterparty2")
        @RuneAttribute(value="executionAgentCounterparty2")
        public ESMAEMIRTransactionReportBuilder setExecutionAgentCounterparty2(String _executionAgentCounterparty2) {
            this.executionAgentCounterparty2 = _executionAgentCounterparty2 == null ? null : _executionAgentCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public ESMAEMIRTransactionReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public ESMAEMIRTransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public ESMAEMIRTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUTIProprietary")
        @RuneAttribute(value="priorUTIProprietary")
        public ESMAEMIRTransactionReportBuilder setPriorUTIProprietary(String _priorUTIProprietary) {
            this.priorUTIProprietary = _priorUTIProprietary == null ? null : _priorUTIProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier")
        @RuneAttribute(value="uniqueProductIdentifier")
        public ESMAEMIRTransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
            this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="contractType", isRequired=true)
        @RuneAttribute(value="contractType", isRequired=true)
        public ESMAEMIRTransactionReportBuilder setContractTypeOverriddenAsCommonContractType(CommonContractType _contractType) {
            this.contractType = _contractType == null ? null : _contractType;
            return this;
        }

        @Override
        @RosettaIgnore
        public ESMAEMIRTransactionReportBuilder setContractType(CommonContractType _contractType) {
            return this.setContractTypeOverriddenAsCommonContractType(_contractType);
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public ESMAEMIRTransactionReportBuilder setAssetClassOverriddenAsCommonAssetClass(CommonAssetClass _assetClass) {
            this.assetClass = _assetClass == null ? null : _assetClass;
            return this;
        }

        @Override
        @RosettaIgnore
        public ESMAEMIRTransactionReportBuilder setAssetClass(CommonAssetClass _assetClass) {
            return this.setAssetClassOverriddenAsCommonAssetClass(_assetClass);
        }

        @Override
        @RosettaAttribute(value="clearingTimestamp")
        @RuneAttribute(value="clearingTimestamp")
        public ESMAEMIRTransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
            this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="platformIdentifier")
        @RuneAttribute(value="platformIdentifier")
        public ESMAEMIRTransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
            this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction1")
        @RuneAttribute(value="direction1")
        public ESMAEMIRTransactionReportBuilder setDirection1(Direction1Enum _direction1) {
            this.direction1 = _direction1 == null ? null : _direction1;
            return this;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public ESMAEMIRTransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier _barrier) {
            this.barrier = _barrier == null ? null : _barrier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="nameOfTheUnderlyingIndex")
        @RuneAttribute(value="nameOfTheUnderlyingIndex")
        public ESMAEMIRTransactionReportBuilder setNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
            this.nameOfTheUnderlyingIndex = _nameOfTheUnderlyingIndex == null ? null : _nameOfTheUnderlyingIndex;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityDateOfTheUnderlying")
        @RuneAttribute(value="maturityDateOfTheUnderlying")
        public ESMAEMIRTransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
            this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public ESMAEMIRTransactionReportBuilder setOptionType(OptionTypeCode _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionStyle")
        @RuneAttribute(value="optionStyle")
        public ESMAEMIRTransactionReportBuilder setOptionStyle(OptionStyleEnum _optionStyle) {
            this.optionStyle = _optionStyle == null ? null : _optionStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryType", isRequired=true)
        @RuneAttribute(value="deliveryType", isRequired=true)
        public ESMAEMIRTransactionReportBuilder setDeliveryTypeOverriddenAsDeliveryTypeEnum(DeliveryTypeEnum _deliveryType) {
            this.deliveryType = _deliveryType == null ? null : _deliveryType;
            return this;
        }

        @Override
        @RosettaIgnore
        public ESMAEMIRTransactionReportBuilder setDeliveryType(DeliveryTypeEnum _deliveryType) {
            return this.setDeliveryTypeOverriddenAsDeliveryTypeEnum(_deliveryType);
        }

        @Override
        @RosettaAttribute(value="countryOfTheCounterparty2")
        @RuneAttribute(value="countryOfTheCounterparty2")
        public ESMAEMIRTransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum _countryOfTheCounterparty2) {
            this.countryOfTheCounterparty2 = _countryOfTheCounterparty2 == null ? null : _countryOfTheCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="bookingLocation")
        @RuneAttribute(value="bookingLocation")
        public ESMAEMIRTransactionReportBuilder setBookingLocation(ISOCountryCodeEnum _bookingLocation) {
            this.bookingLocation = _bookingLocation == null ? null : _bookingLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="traderLocation")
        @RuneAttribute(value="traderLocation")
        public ESMAEMIRTransactionReportBuilder setTraderLocation(ISOCountryCodeEnum _traderLocation) {
            this.traderLocation = _traderLocation == null ? null : _traderLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradingCapacity")
        @RuneAttribute(value="tradingCapacity")
        public ESMAEMIRTransactionReportBuilder setTradingCapacity(TradingCapacity7Code _tradingCapacity) {
            this.tradingCapacity = _tradingCapacity == null ? null : _tradingCapacity;
            return this;
        }

        @Override
        @RosettaAttribute(value="embeddedOptionType")
        @RuneAttribute(value="embeddedOptionType")
        public ESMAEMIRTransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum _embeddedOptionType) {
            this.embeddedOptionType = _embeddedOptionType == null ? null : _embeddedOptionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public ESMAEMIRTransactionReportBuilder setSeniority(SeniorityEnum _seniority) {
            this.seniority = _seniority == null ? null : _seniority;
            return this;
        }

        @Override
        @RosettaAttribute(value="series")
        @RuneAttribute(value="series")
        public ESMAEMIRTransactionReportBuilder setSeries(Integer _series) {
            this.series = _series == null ? null : _series;
            return this;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public ESMAEMIRTransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
            this.indexFactor = _indexFactor == null ? null : _indexFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public ESMAEMIRTransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingAccountOrigin")
        @RuneAttribute(value="clearingAccountOrigin")
        public ESMAEMIRTransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum _clearingAccountOrigin) {
            this.clearingAccountOrigin = _clearingAccountOrigin == null ? null : _clearingAccountOrigin;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalSwapUTI")
        @RuneAttribute(value="originalSwapUTI")
        public ESMAEMIRTransactionReportBuilder setOriginalSwapUTI(String _originalSwapUTI) {
            this.originalSwapUTI = _originalSwapUTI == null ? null : _originalSwapUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalSwapSDRIdentifier")
        @RuneAttribute(value="originalSwapSDRIdentifier")
        public ESMAEMIRTransactionReportBuilder setOriginalSwapSDRIdentifier(String _originalSwapSDRIdentifier) {
            this.originalSwapSDRIdentifier = _originalSwapSDRIdentifier == null ? null : _originalSwapSDRIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingReceiptTimestamp")
        @RuneAttribute(value="clearingReceiptTimestamp")
        public ESMAEMIRTransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime _clearingReceiptTimestamp) {
            this.clearingReceiptTimestamp = _clearingReceiptTimestamp == null ? null : _clearingReceiptTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUSI")
        @RuneAttribute(value="priorUSI")
        public ESMAEMIRTransactionReportBuilder setPriorUSI(String _priorUSI) {
            this.priorUSI = _priorUSI == null ? null : _priorUSI;
            return this;
        }

        @Override
        @RosettaAttribute(value="newSDRIdentifier")
        @RuneAttribute(value="newSDRIdentifier")
        public ESMAEMIRTransactionReportBuilder setNewSDRIdentifier(String _newSDRIdentifier) {
            this.newSDRIdentifier = _newSDRIdentifier == null ? null : _newSDRIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public ESMAEMIRTransactionReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public ESMAEMIRTransactionReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="subsequentPositionUTI")
        @RuneAttribute(value="subsequentPositionUTI")
        public ESMAEMIRTransactionReportBuilder setSubsequentPositionUTI(String _subsequentPositionUTI) {
            this.subsequentPositionUTI = _subsequentPositionUTI == null ? null : _subsequentPositionUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="masterAgreementType", isRequired=true)
        @RuneAttribute(value="masterAgreementType", isRequired=true)
        public ESMAEMIRTransactionReportBuilder setMasterAgreementTypeOverriddenAsMasterAgreementEnum(MasterAgreementEnum _masterAgreementType) {
            this.masterAgreementType = _masterAgreementType == null ? null : _masterAgreementType;
            return this;
        }

        @Override
        @RosettaIgnore
        public ESMAEMIRTransactionReportBuilder setMasterAgreementType(MasterAgreementEnum _masterAgreementType) {
            return this.setMasterAgreementTypeOverriddenAsMasterAgreementEnum(_masterAgreementType);
        }

        @Override
        @RosettaAttribute(value="masterAgreementVersion")
        @RuneAttribute(value="masterAgreementVersion")
        public ESMAEMIRTransactionReportBuilder setMasterAgreementVersion(Integer _masterAgreementVersion) {
            this.masterAgreementVersion = _masterAgreementVersion == null ? null : _masterAgreementVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="nonStandardizedTermIndicator")
        @RuneAttribute(value="nonStandardizedTermIndicator")
        public ESMAEMIRTransactionReportBuilder setNonStandardizedTermIndicator(Boolean _nonStandardizedTermIndicator) {
            this.nonStandardizedTermIndicator = _nonStandardizedTermIndicator == null ? null : _nonStandardizedTermIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="amendmentIndicator")
        @RuneAttribute(value="amendmentIndicator")
        public ESMAEMIRTransactionReportBuilder setAmendmentIndicator(Boolean _amendmentIndicator) {
            this.amendmentIndicator = _amendmentIndicator == null ? null : _amendmentIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageIndicator")
        @RuneAttribute(value="packageIndicator")
        public ESMAEMIRTransactionReportBuilder setPackageIndicator(Boolean _packageIndicator) {
            this.packageIndicator = _packageIndicator == null ? null : _packageIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="brokerID")
        @RuneAttribute(value="brokerID")
        public ESMAEMIRTransactionReportBuilder setBrokerID(String _brokerID) {
            this.brokerID = _brokerID == null ? null : _brokerID;
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmationTimestamp")
        @RuneAttribute(value="confirmationTimestamp")
        public ESMAEMIRTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime _confirmationTimestamp) {
            this.confirmationTimestamp = _confirmationTimestamp == null ? null : _confirmationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="seriesVersion")
        @RuneAttribute(value="seriesVersion")
        public ESMAEMIRTransactionReportBuilder setSeriesVersion(Integer _seriesVersion) {
            this.seriesVersion = _seriesVersion == null ? null : _seriesVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="secondaryTransactionIdentifier")
        @RuneAttribute(value="secondaryTransactionIdentifier")
        public ESMAEMIRTransactionReportBuilder setSecondaryTransactionIdentifier(String _secondaryTransactionIdentifier) {
            this.secondaryTransactionIdentifier = _secondaryTransactionIdentifier == null ? null : _secondaryTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="natureOfCounterparty1", isRequired=true)
        @RuneAttribute(value="natureOfCounterparty1", isRequired=true)
        public ESMAEMIRTransactionReportBuilder setNatureOfCounterparty1OverriddenAsNatureOfCounterpartyEnum(NatureOfCounterpartyEnum _natureOfCounterparty1) {
            this.natureOfCounterparty1 = _natureOfCounterparty1 == null ? null : _natureOfCounterparty1;
            return this;
        }

        @Override
        @RosettaIgnore
        public ESMAEMIRTransactionReportBuilder setNatureOfCounterparty1(NatureOfCounterpartyEnum _natureOfCounterparty1) {
            return this.setNatureOfCounterparty1OverriddenAsNatureOfCounterpartyEnum(_natureOfCounterparty1);
        }

        @Override
        @RosettaAttribute(value="natureOfCounterparty2")
        @RuneAttribute(value="natureOfCounterparty2")
        public ESMAEMIRTransactionReportBuilder setNatureOfCounterparty2(NatureOfCounterpartyEnum _natureOfCounterparty2) {
            this.natureOfCounterparty2 = _natureOfCounterparty2 == null ? null : _natureOfCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="swapLinkID")
        @RuneAttribute(value="swapLinkID")
        public ESMAEMIRTransactionReportBuilder setSwapLinkID(String _swapLinkID) {
            this.swapLinkID = _swapLinkID == null ? null : _swapLinkID;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        public ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty1) {
            if (_clearingExceptionsAndExemptionsCounterparty1 != null) {
                this.clearingExceptionsAndExemptionsCounterparty1.add(_clearingExceptionsAndExemptionsCounterparty1);
            }
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty1, int idx) {
            this.getIndex(this.clearingExceptionsAndExemptionsCounterparty1, idx, () -> _clearingExceptionsAndExemptionsCounterparty1);
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1s) {
            if (clearingExceptionsAndExemptionsCounterparty1s != null) {
                for (ClearingExceptionsAndExemptionsEnum toAdd : clearingExceptionsAndExemptionsCounterparty1s) {
                    this.clearingExceptionsAndExemptionsCounterparty1.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        public ESMAEMIRTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1s) {
            this.clearingExceptionsAndExemptionsCounterparty1 = clearingExceptionsAndExemptionsCounterparty1s == null ? new ArrayList() : (List)clearingExceptionsAndExemptionsCounterparty1s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        public ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty2) {
            if (_clearingExceptionsAndExemptionsCounterparty2 != null) {
                this.clearingExceptionsAndExemptionsCounterparty2.add(_clearingExceptionsAndExemptionsCounterparty2);
            }
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty2, int idx) {
            this.getIndex(this.clearingExceptionsAndExemptionsCounterparty2, idx, () -> _clearingExceptionsAndExemptionsCounterparty2);
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2s) {
            if (clearingExceptionsAndExemptionsCounterparty2s != null) {
                for (ClearingExceptionsAndExemptionsEnum toAdd : clearingExceptionsAndExemptionsCounterparty2s) {
                    this.clearingExceptionsAndExemptionsCounterparty2.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        public ESMAEMIRTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2s) {
            this.clearingExceptionsAndExemptionsCounterparty2 = clearingExceptionsAndExemptionsCounterparty2s == null ? new ArrayList() : (List)clearingExceptionsAndExemptionsCounterparty2s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="baseProduct")
        @RuneAttribute(value="baseProduct")
        public ESMAEMIRTransactionReportBuilder setBaseProduct(String _baseProduct) {
            this.baseProduct = _baseProduct == null ? null : _baseProduct;
            return this;
        }

        @Override
        @RosettaAttribute(value="subProduct")
        @RuneAttribute(value="subProduct")
        public ESMAEMIRTransactionReportBuilder setSubProduct(String _subProduct) {
            this.subProduct = _subProduct == null ? null : _subProduct;
            return this;
        }

        @Override
        @RosettaAttribute(value="furtherSubProduct")
        @RuneAttribute(value="furtherSubProduct")
        public ESMAEMIRTransactionReportBuilder setFurtherSubProduct(String _furtherSubProduct) {
            this.furtherSubProduct = _furtherSubProduct == null ? null : _furtherSubProduct;
            return this;
        }

        @Override
        @RosettaAttribute(value="intragroup")
        @RuneAttribute(value="intragroup")
        public ESMAEMIRTransactionReportBuilder setIntragroup(Boolean _intragroup) {
            this.intragroup = _intragroup == null ? null : _intragroup;
            return this;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public ESMAEMIRTransactionReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
            this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceEntity")
        @RuneAttribute(value="referenceEntity")
        public ESMAEMIRTransactionReportBuilder setReferenceEntity(String _referenceEntity) {
            this.referenceEntity = _referenceEntity == null ? null : _referenceEntity;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource")
        @RuneAttribute(value="counterparty2IdentifierSource")
        public ESMAEMIRTransactionReportBuilder setCounterparty2IdentifierSource(Counterparty2IdentifierEnum _counterparty2IdentifierSource) {
            this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="customBasketIndicator")
        @RuneAttribute(value="customBasketIndicator")
        public ESMAEMIRTransactionReportBuilder setCustomBasketIndicator(Boolean _customBasketIndicator) {
            this.customBasketIndicator = _customBasketIndicator == null ? null : _customBasketIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentification")
        @RuneAttribute(value="underlyingIdentification")
        public ESMAEMIRTransactionReportBuilder setUnderlyingIdentification(String _underlyingIdentification) {
            this.underlyingIdentification = _underlyingIdentification == null ? null : _underlyingIdentification;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentificationType")
        @RuneAttribute(value="underlyingIdentificationType")
        public ESMAEMIRTransactionReportBuilder setUnderlyingIdentificationType(UnderlyingIdentificationTypeEnum _underlyingIdentificationType) {
            this.underlyingIdentificationType = _underlyingIdentificationType == null ? null : _underlyingIdentificationType;
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateSectorOfTheCounterparty1")
        @RuneAttribute(value="corporateSectorOfTheCounterparty1")
        public ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1) {
            if (_corporateSectorOfTheCounterparty1 != null) {
                this.corporateSectorOfTheCounterparty1.add(_corporateSectorOfTheCounterparty1);
            }
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1, int idx) {
            this.getIndex(this.corporateSectorOfTheCounterparty1, idx, () -> _corporateSectorOfTheCounterparty1);
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
            if (corporateSectorOfTheCounterparty1s != null) {
                for (String toAdd : corporateSectorOfTheCounterparty1s) {
                    this.corporateSectorOfTheCounterparty1.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="corporateSectorOfTheCounterparty1")
        public ESMAEMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
            this.corporateSectorOfTheCounterparty1 = corporateSectorOfTheCounterparty1s == null ? new ArrayList() : (List)corporateSectorOfTheCounterparty1s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateSectorOfTheCounterparty2")
        @RuneAttribute(value="corporateSectorOfTheCounterparty2")
        public ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2) {
            if (_corporateSectorOfTheCounterparty2 != null) {
                this.corporateSectorOfTheCounterparty2.add(_corporateSectorOfTheCounterparty2);
            }
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2, int idx) {
            this.getIndex(this.corporateSectorOfTheCounterparty2, idx, () -> _corporateSectorOfTheCounterparty2);
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
            if (corporateSectorOfTheCounterparty2s != null) {
                for (String toAdd : corporateSectorOfTheCounterparty2s) {
                    this.corporateSectorOfTheCounterparty2.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="corporateSectorOfTheCounterparty2")
        public ESMAEMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
            this.corporateSectorOfTheCounterparty2 = corporateSectorOfTheCounterparty2s == null ? new ArrayList() : (List)corporateSectorOfTheCounterparty2s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public ESMAEMIRTransactionReportBuilder setNonReportable(NonReportable _nonReportable) {
            this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingThresholdOfCounterparty1")
        @RuneAttribute(value="clearingThresholdOfCounterparty1")
        public ESMAEMIRTransactionReportBuilder setClearingThresholdOfCounterparty1(Boolean _clearingThresholdOfCounterparty1) {
            this.clearingThresholdOfCounterparty1 = _clearingThresholdOfCounterparty1 == null ? null : _clearingThresholdOfCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingThresholdOfCounterparty2")
        @RuneAttribute(value="clearingThresholdOfCounterparty2")
        public ESMAEMIRTransactionReportBuilder setClearingThresholdOfCounterparty2(Boolean _clearingThresholdOfCounterparty2) {
            this.clearingThresholdOfCounterparty2 = _clearingThresholdOfCounterparty2 == null ? null : _clearingThresholdOfCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
        @RuneAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
        public ESMAEMIRTransactionReportBuilder setReportingObligationOfTheCounterparty2(Boolean _reportingObligationOfTheCounterparty2) {
            this.reportingObligationOfTheCounterparty2 = _reportingObligationOfTheCounterparty2 == null ? null : _reportingObligationOfTheCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="directlyLinkedToCommercialActivityOrTreasuryFinancing")
        @RuneAttribute(value="directlyLinkedToCommercialActivityOrTreasuryFinancing")
        public ESMAEMIRTransactionReportBuilder setDirectlyLinkedToCommercialActivityOrTreasuryFinancing(Boolean _directlyLinkedToCommercialActivityOrTreasuryFinancing) {
            this.directlyLinkedToCommercialActivityOrTreasuryFinancing = _directlyLinkedToCommercialActivityOrTreasuryFinancing == null ? null : _directlyLinkedToCommercialActivityOrTreasuryFinancing;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportTrackingNumber")
        @RuneAttribute(value="reportTrackingNumber")
        public ESMAEMIRTransactionReportBuilder setReportTrackingNumber(String _reportTrackingNumber) {
            this.reportTrackingNumber = _reportTrackingNumber == null ? null : _reportTrackingNumber;
            return this;
        }

        @Override
        @RosettaAttribute(value="ptrrId")
        @RuneAttribute(value="ptrrId")
        public ESMAEMIRTransactionReportBuilder setPtrrId(String _ptrrId) {
            this.ptrrId = _ptrrId == null ? null : _ptrrId;
            return this;
        }

        @Override
        @RosettaAttribute(value="isin")
        @RuneAttribute(value="isin")
        public ESMAEMIRTransactionReportBuilder setIsin(String _isin) {
            this.isin = _isin == null ? null : _isin;
            return this;
        }

        @Override
        @RosettaAttribute(value="productClassification", isRequired=true)
        @RuneAttribute(value="productClassification", isRequired=true)
        public ESMAEMIRTransactionReportBuilder setProductClassification(String _productClassification) {
            this.productClassification = _productClassification == null ? null : _productClassification;
            return this;
        }

        @Override
        @RosettaAttribute(value="indicatorOfTheUnderlyingIndex")
        @RuneAttribute(value="indicatorOfTheUnderlyingIndex")
        public ESMAEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum _indicatorOfTheUnderlyingIndex) {
            if (_indicatorOfTheUnderlyingIndex != null) {
                this.indicatorOfTheUnderlyingIndex.add(_indicatorOfTheUnderlyingIndex);
            }
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum _indicatorOfTheUnderlyingIndex, int idx) {
            this.getIndex(this.indicatorOfTheUnderlyingIndex, idx, () -> _indicatorOfTheUnderlyingIndex);
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(List<IndexEnum> indicatorOfTheUnderlyingIndexs) {
            if (indicatorOfTheUnderlyingIndexs != null) {
                for (IndexEnum toAdd : indicatorOfTheUnderlyingIndexs) {
                    this.indicatorOfTheUnderlyingIndex.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="indicatorOfTheUnderlyingIndex")
        public ESMAEMIRTransactionReportBuilder setIndicatorOfTheUnderlyingIndex(List<IndexEnum> indicatorOfTheUnderlyingIndexs) {
            this.indicatorOfTheUnderlyingIndex = indicatorOfTheUnderlyingIndexs == null ? new ArrayList() : (List)indicatorOfTheUnderlyingIndexs.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingObligation")
        @RuneAttribute(value="clearingObligation")
        public ESMAEMIRTransactionReportBuilder setClearingObligation(ClearingObligationEnum _clearingObligation) {
            this.clearingObligation = _clearingObligation == null ? null : _clearingObligation;
            return this;
        }

        @Override
        @RosettaAttribute(value="otherMasterAgreementType")
        @RuneAttribute(value="otherMasterAgreementType")
        public ESMAEMIRTransactionReportBuilder setOtherMasterAgreementType(String _otherMasterAgreementType) {
            this.otherMasterAgreementType = _otherMasterAgreementType == null ? null : _otherMasterAgreementType;
            return this;
        }

        @Override
        @RosettaAttribute(value="ptrr")
        @RuneAttribute(value="ptrr")
        public ESMAEMIRTransactionReportBuilder setPtrr(Boolean _ptrr) {
            this.ptrr = _ptrr == null ? null : _ptrr;
            return this;
        }

        @Override
        @RosettaAttribute(value="typeOfPTRRTechnique")
        @RuneAttribute(value="typeOfPTRRTechnique")
        public ESMAEMIRTransactionReportBuilder setTypeOfPTRRTechnique(RiskReductionTechniqueEnum _typeOfPTRRTechnique) {
            this.typeOfPTRRTechnique = _typeOfPTRRTechnique == null ? null : _typeOfPTRRTechnique;
            return this;
        }

        @Override
        @RosettaAttribute(value="ptrrServiceProvider")
        @RuneAttribute(value="ptrrServiceProvider")
        public ESMAEMIRTransactionReportBuilder setPtrrServiceProvider(String _ptrrServiceProvider) {
            this.ptrrServiceProvider = _ptrrServiceProvider == null ? null : _ptrrServiceProvider;
            return this;
        }

        @Override
        @RosettaAttribute(value="venueOfExecution")
        @RuneAttribute(value="venueOfExecution")
        public ESMAEMIRTransactionReportBuilder setVenueOfExecution(String _venueOfExecution) {
            this.venueOfExecution = _venueOfExecution == null ? null : _venueOfExecution;
            return this;
        }

        @Override
        @RosettaAttribute(value="forwardExchangeRate")
        @RuneAttribute(value="forwardExchangeRate")
        public ESMAEMIRTransactionReportBuilder setForwardExchangeRate(BigDecimal _forwardExchangeRate) {
            this.forwardExchangeRate = _forwardExchangeRate == null ? null : _forwardExchangeRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryPoint")
        @RuneAttribute(value="deliveryPoint")
        public ESMAEMIRTransactionReportBuilder addDeliveryPoint(String _deliveryPoint) {
            if (_deliveryPoint != null) {
                this.deliveryPoint.add(_deliveryPoint);
            }
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addDeliveryPoint(String _deliveryPoint, int idx) {
            this.getIndex(this.deliveryPoint, idx, () -> _deliveryPoint);
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addDeliveryPoint(List<String> deliveryPoints) {
            if (deliveryPoints != null) {
                for (String toAdd : deliveryPoints) {
                    this.deliveryPoint.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="deliveryPoint")
        public ESMAEMIRTransactionReportBuilder setDeliveryPoint(List<String> deliveryPoints) {
            this.deliveryPoint = deliveryPoints == null ? new ArrayList() : (List)deliveryPoints.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="interconnectionPoint")
        @RuneAttribute(value="interconnectionPoint")
        public ESMAEMIRTransactionReportBuilder setInterconnectionPoint(String _interconnectionPoint) {
            this.interconnectionPoint = _interconnectionPoint == null ? null : _interconnectionPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="loadType")
        @RuneAttribute(value="loadType")
        public ESMAEMIRTransactionReportBuilder setLoadType(EnergyLoadType1Code _loadType) {
            this.loadType = _loadType == null ? null : _loadType;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryReport")
        @RuneAttribute(value="deliveryReport")
        public ESMAEMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery _deliveryReport) {
            if (_deliveryReport != null) {
                this.deliveryReport.add(_deliveryReport.toBuilder());
            }
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery _deliveryReport, int idx) {
            this.getIndex(this.deliveryReport, idx, () -> _deliveryReport.toBuilder());
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder addDeliveryReport(List<? extends ReportableDelivery> deliveryReports) {
            if (deliveryReports != null) {
                for (ReportableDelivery reportableDelivery : deliveryReports) {
                    this.deliveryReport.add(reportableDelivery.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="deliveryReport")
        public ESMAEMIRTransactionReportBuilder setDeliveryReport(List<? extends ReportableDelivery> deliveryReports) {
            this.deliveryReport = deliveryReports == null ? new ArrayList() : (List)deliveryReports.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public ESMAEMIRTransactionReportBuilder setTranche(Boolean _tranche) {
            this.tranche = _tranche == null ? null : _tranche;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCode")
        @RuneAttribute(value="collateralPortfolioCode")
        public ESMAEMIRTransactionReportBuilder setCollateralPortfolioCode(String _collateralPortfolioCode) {
            this.collateralPortfolioCode = _collateralPortfolioCode == null ? null : _collateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate", isRequired=true)
        @RuneAttribute(value="eventDate", isRequired=true)
        public ESMAEMIRTransactionReportBuilder setEventDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        public ESMAEMIRTransactionReport build() {
            return new ESMAEMIRTransactionReportImpl(this);
        }

        @Override
        public ESMAEMIRTransactionReportBuilder toBuilder() {
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getNatureOfCounterparty1() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierType() != null) {
                return true;
            }
            if (this.getContractType() != null) {
                return true;
            }
            if (this.getAssetClass() != null) {
                return true;
            }
            if (this.getCryptoAssetUnderlyingIndicator() != null) {
                return true;
            }
            if (this.getCleared() != null) {
                return true;
            }
            if (this.getMasterAgreementType() != null) {
                return true;
            }
            if (this.getExecutionTimestamp() != null) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getDeliveryType() != null) {
                return true;
            }
            return this.getLevel() != null;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ESMAEMIRTransactionReportBuilder o = (ESMAEMIRTransactionReportBuilder)other;
            merger.mergeBasic((Object)this.getNatureOfCounterparty1(), (Object)o.getNatureOfCounterparty1(), this::setNatureOfCounterparty1OverriddenAsNatureOfCounterpartyEnum, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierType(), (Object)o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierTypeOverriddenAsBoolean, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getContractType(), (Object)o.getContractType(), this::setContractTypeOverriddenAsCommonContractType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAssetClass(), (Object)o.getAssetClass(), this::setAssetClassOverriddenAsCommonAssetClass, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCryptoAssetUnderlyingIndicator(), (Object)o.getCryptoAssetUnderlyingIndicator(), this::setCryptoAssetUnderlyingIndicatorOverriddenAsBoolean, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCleared(), (Object)o.getCleared(), this::setClearedOverriddenAsClearedEnum, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMasterAgreementType(), (Object)o.getMasterAgreementType(), this::setMasterAgreementTypeOverriddenAsMasterAgreementEnum, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionTimestamp(), (Object)o.getExecutionTimestamp(), this::setExecutionTimestampOverriddenAsZonedDateTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDateOverriddenAsDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDeliveryType(), (Object)o.getDeliveryType(), this::setDeliveryTypeOverriddenAsDeliveryTypeEnum, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLevel(), (Object)o.getLevel(), this::setLevelOverriddenAsReportLevelEnum, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ESMAEMIRTransactionReport _that = (ESMAEMIRTransactionReport)this.getType().cast(o);
            if (!Objects.equals((Object)this.natureOfCounterparty1, (Object)_that.getNatureOfCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals((Object)this.contractType, (Object)_that.getContractType())) {
                return false;
            }
            if (!Objects.equals((Object)this.assetClass, (Object)_that.getAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.cryptoAssetUnderlyingIndicator, _that.getCryptoAssetUnderlyingIndicator())) {
                return false;
            }
            if (!Objects.equals((Object)this.cleared, (Object)_that.getCleared())) {
                return false;
            }
            if (!Objects.equals((Object)this.masterAgreementType, (Object)_that.getMasterAgreementType())) {
                return false;
            }
            if (!Objects.equals(this.executionTimestamp, _that.getExecutionTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.deliveryType, (Object)_that.getDeliveryType())) {
                return false;
            }
            return Objects.equals((Object)this.level, (Object)_that.getLevel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.natureOfCounterparty1 != null ? ((Object)((Object)this.natureOfCounterparty1)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.contractType != null ? ((Object)((Object)this.contractType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? ((Object)((Object)this.assetClass)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cryptoAssetUnderlyingIndicator != null ? this.cryptoAssetUnderlyingIndicator.hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? ((Object)((Object)this.cleared)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.masterAgreementType != null ? ((Object)((Object)this.masterAgreementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.executionTimestamp != null ? this.executionTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.deliveryType != null ? ((Object)((Object)this.deliveryType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.level != null ? ((Object)((Object)this.level)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ESMAEMIRTransactionReportBuilder {natureOfCounterparty1=" + String.valueOf((Object)this.natureOfCounterparty1) + ", counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", contractType=" + String.valueOf((Object)this.contractType) + ", assetClass=" + String.valueOf((Object)this.assetClass) + ", cryptoAssetUnderlyingIndicator=" + this.cryptoAssetUnderlyingIndicator + ", cleared=" + String.valueOf((Object)this.cleared) + ", masterAgreementType=" + String.valueOf((Object)this.masterAgreementType) + ", executionTimestamp=" + String.valueOf(this.executionTimestamp) + ", effectiveDate=" + String.valueOf(this.effectiveDate) + ", deliveryType=" + String.valueOf((Object)this.deliveryType) + ", level=" + String.valueOf((Object)this.level) + "} " + super.toString();
        }
    }

    public static interface ESMAEMIRTransactionReportBuilder
    extends ESMAEMIRTransactionReport,
    EMIRTransactionReport.EMIRTransactionReportBuilder {
        @Override
        public ESMAEMIRTransactionReportBuilder setEffectiveDate(Date var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setEarlyTerminationDate(Date var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setExecutionTimestamp(ZonedDateTime var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setExpirationDate(Date var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCounterparty1(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCounterparty2(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setBeneficiary1(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setBuyerIdentifier(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setSellerIdentifier(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCleared(ClearedEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCentralCounterparty(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setClearingMember(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setConfirmed(ConfirmationEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCallAmount(BigDecimal var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPutAmount(BigDecimal var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setDelta(BigDecimal var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addPriceSchedule(PricePeriod var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addPriceSchedule(PricePeriod var1, int var2);

        @Override
        public ESMAEMIRTransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod var1, int var2);

        @Override
        public ESMAEMIRTransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPrice(PriceFormat var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPriceNotation(PriceNotationEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPackageTransactionPrice(PriceFormat var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPackageTransactionSpread(PriceFormat var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPackageIdentifier(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setStrikePrice(PriceFormat var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setStrikePriceNotation(PriceNotationEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setStrikePriceCurrency(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPriceUnitOfMeasure(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setOptionPremiumAmount(BigDecimal var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setOptionPremiumPaymentDate(Date var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setExchangeRate(BigDecimal var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setExchangeRateBasis(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCollateralPortfolioIndicator(Boolean var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setFirstExerciseDate(Date var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setFinalContractualSettlementDate(Date var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setSettlementLocation(ISOCountryCodeEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPriorUTI(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setValuationAmount(BigDecimal var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setValuationMethod(ValuationType1Code var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setValuationTimestamp(ZonedDateTime var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCustomBasketCode(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport var1, int var2);

        @Override
        public ESMAEMIRTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addOtherPayment(OtherPayment var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addOtherPayment(OtherPayment var1, int var2);

        @Override
        public ESMAEMIRTransactionReportBuilder addOtherPayment(List<? extends OtherPayment> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setOtherPayment(List<? extends OtherPayment> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setLeg1(LegV1 var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setLeg2(LegV1 var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setLeg1(LegV2 var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setLeg2(LegV2 var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setLeg1(Leg var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setLeg2(Leg var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setUnderlyingIdOther(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifier(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setUnderlyingAssetPriceSource(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCryptoAssetUnderlyingIndicator(Boolean var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setLevel(ReportLevelEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setActionType(ActionTypeEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setEventType(EventTypeEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setEventIdentifier(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setEventTimestamp(ZonedDateTime var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setLeg1(CommonLeg var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setLeg2(CommonLeg var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCounterparty2Name(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setExecutionAgentCounterparty1(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setExecutionAgentCounterparty2(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setReportSubmittingEntityID(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setUniqueTransactionIdentifier(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPriorUTIProprietary(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setUniqueProductIdentifier(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setContractType(CommonContractType var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setAssetClass(CommonAssetClass var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setClearingTimestamp(ZonedDateTime var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPlatformIdentifier(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setDirection1(Direction1Enum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setNameOfTheUnderlyingIndex(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setMaturityDateOfTheUnderlying(Date var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setOptionType(OptionTypeCode var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setOptionStyle(OptionStyleEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setDeliveryType(DeliveryTypeEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setBookingLocation(ISOCountryCodeEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setTraderLocation(ISOCountryCodeEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setTradingCapacity(TradingCapacity7Code var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setSeniority(SeniorityEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setSeries(Integer var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setIndexFactor(BigDecimal var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setTechnicalRecordId(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setOriginalSwapUTI(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setOriginalSwapSDRIdentifier(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPriorUSI(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setNewSDRIdentifier(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setSubsequentPositionUTI(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setMasterAgreementType(MasterAgreementEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setMasterAgreementVersion(Integer var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setNonStandardizedTermIndicator(Boolean var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setAmendmentIndicator(Boolean var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPackageIndicator(Boolean var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setBrokerID(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setSeriesVersion(Integer var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setSecondaryTransactionIdentifier(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setNatureOfCounterparty1(NatureOfCounterpartyEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setNatureOfCounterparty2(NatureOfCounterpartyEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setSwapLinkID(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum var1, int var2);

        @Override
        public ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum var1, int var2);

        @Override
        public ESMAEMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setBaseProduct(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setSubProduct(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setFurtherSubProduct(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setIntragroup(Boolean var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setEntityResponsibleForReporting(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setReferenceEntity(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCounterparty2IdentifierSource(Counterparty2IdentifierEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCustomBasketIndicator(Boolean var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setUnderlyingIdentification(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setUnderlyingIdentificationType(UnderlyingIdentificationTypeEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String var1, int var2);

        @Override
        public ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String var1, int var2);

        @Override
        public ESMAEMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setNonReportable(NonReportable var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setClearingThresholdOfCounterparty1(Boolean var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setClearingThresholdOfCounterparty2(Boolean var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setReportingObligationOfTheCounterparty2(Boolean var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setDirectlyLinkedToCommercialActivityOrTreasuryFinancing(Boolean var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setReportTrackingNumber(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPtrrId(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setIsin(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setProductClassification(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum var1, int var2);

        @Override
        public ESMAEMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(List<IndexEnum> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setIndicatorOfTheUnderlyingIndex(List<IndexEnum> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setClearingObligation(ClearingObligationEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setOtherMasterAgreementType(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPtrr(Boolean var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setTypeOfPTRRTechnique(RiskReductionTechniqueEnum var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setPtrrServiceProvider(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setVenueOfExecution(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setForwardExchangeRate(BigDecimal var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addDeliveryPoint(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addDeliveryPoint(String var1, int var2);

        @Override
        public ESMAEMIRTransactionReportBuilder addDeliveryPoint(List<String> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setDeliveryPoint(List<String> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setInterconnectionPoint(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setLoadType(EnergyLoadType1Code var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery var1);

        @Override
        public ESMAEMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery var1, int var2);

        @Override
        public ESMAEMIRTransactionReportBuilder addDeliveryReport(List<? extends ReportableDelivery> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setDeliveryReport(List<? extends ReportableDelivery> var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setTranche(Boolean var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setCollateralPortfolioCode(String var1);

        @Override
        public ESMAEMIRTransactionReportBuilder setEventDate(Date var1);

        public ESMAEMIRTransactionReportBuilder setNatureOfCounterparty1OverriddenAsNatureOfCounterpartyEnum(NatureOfCounterpartyEnum var1);

        public ESMAEMIRTransactionReportBuilder setCounterparty2IdentifierTypeOverriddenAsBoolean(Boolean var1);

        public ESMAEMIRTransactionReportBuilder setContractTypeOverriddenAsCommonContractType(CommonContractType var1);

        public ESMAEMIRTransactionReportBuilder setAssetClassOverriddenAsCommonAssetClass(CommonAssetClass var1);

        public ESMAEMIRTransactionReportBuilder setCryptoAssetUnderlyingIndicatorOverriddenAsBoolean(Boolean var1);

        public ESMAEMIRTransactionReportBuilder setClearedOverriddenAsClearedEnum(ClearedEnum var1);

        public ESMAEMIRTransactionReportBuilder setMasterAgreementTypeOverriddenAsMasterAgreementEnum(MasterAgreementEnum var1);

        public ESMAEMIRTransactionReportBuilder setExecutionTimestampOverriddenAsZonedDateTime(ZonedDateTime var1);

        public ESMAEMIRTransactionReportBuilder setEffectiveDateOverriddenAsDate(Date var1);

        public ESMAEMIRTransactionReportBuilder setDeliveryTypeOverriddenAsDeliveryTypeEnum(DeliveryTypeEnum var1);

        public ESMAEMIRTransactionReportBuilder setLevelOverriddenAsReportLevelEnum(ReportLevelEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, (Object)this.getEarlyTerminationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary1"), String.class, (Object)this.getBeneficiary1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, (Object)this.getBeneficiary1IdentifierTypeIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, (Object)this.getBuyerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, (Object)this.getSellerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, (Object)this.getCleared(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, (Object)this.getConfirmed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, this.getPriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, (Object)this.getPriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPackageTransactionPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionPriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionPriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPackageTransactionSpread(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionSpreadNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionSpreadCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getStrikePrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, (Object)this.getStrikePriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, (Object)this.getStrikePriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("customBasketCode"), String.class, (Object)this.getCustomBasketCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, this.getBasketConstituents(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.OtherPaymentBuilder.class, this.getOtherPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("leg1"), processor, CommonLeg.CommonLegBuilder.class, (RosettaModelObjectBuilder)this.getLeg1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("leg2"), processor, CommonLeg.CommonLegBuilder.class, (RosettaModelObjectBuilder)this.getLeg2(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, (Object)this.getUnderlyingIdOther(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, (Object)this.getUnderlyingIdOtherSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, (Object)this.getUnderlyingAssetPriceSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, (Object)this.getCryptoAssetUnderlyingIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, (Object)this.getEventType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventIdentifier"), String.class, (Object)this.getEventIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, (Object)this.getExecutionAgentCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentCounterparty2"), String.class, (Object)this.getExecutionAgentCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, (Object)this.getPriorUTIProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, (Object)this.getContractType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, (Object)this.getAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, (Object)this.getClearingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("platformIdentifier"), String.class, (Object)this.getPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, (Object)this.getDirection1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder.class, (RosettaModelObjectBuilder)this.getBarrier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, (Object)this.getNameOfTheUnderlyingIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, (Object)this.getOptionStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, (Object)this.getDeliveryType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, (Object)this.getCountryOfTheCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, (Object)this.getBookingLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, (Object)this.getTraderLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, (Object)this.getTradingCapacity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, (Object)this.getEmbeddedOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, (Object)this.getSeniority(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("series"), Integer.class, (Object)this.getSeries(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, (Object)this.getClearingAccountOrigin(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, (Object)this.getOriginalSwapUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, (Object)this.getOriginalSwapSDRIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, (Object)this.getClearingReceiptTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUSI"), String.class, (Object)this.getPriorUSI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, (Object)this.getNewSDRIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, (Object)this.getSubsequentPositionUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("masterAgreementType"), MasterAgreementEnum.class, (Object)this.getMasterAgreementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, (Object)this.getMasterAgreementVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, (Object)this.getNonStandardizedTermIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, (Object)this.getAmendmentIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, (Object)this.getPackageIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("brokerID"), String.class, (Object)this.getBrokerID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, (Object)this.getConfirmationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seriesVersion"), Integer.class, (Object)this.getSeriesVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, (Object)this.getSecondaryTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("natureOfCounterparty1"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("natureOfCounterparty2"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("swapLinkID"), String.class, (Object)this.getSwapLinkID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("baseProduct"), String.class, (Object)this.getBaseProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("subProduct"), String.class, (Object)this.getSubProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, (Object)this.getFurtherSubProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("intragroup"), Boolean.class, (Object)this.getIntragroup(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("referenceEntity"), String.class, (Object)this.getReferenceEntity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), Counterparty2IdentifierEnum.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, (Object)this.getCustomBasketIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, (Object)this.getUnderlyingIdentification(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdentificationType"), UnderlyingIdentificationTypeEnum.class, (Object)this.getUnderlyingIdentificationType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, this.getCorporateSectorOfTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, this.getCorporateSectorOfTheCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nonReportable"), processor, NonReportable.NonReportableBuilder.class, (RosettaModelObjectBuilder)this.getNonReportable(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty1"), Boolean.class, (Object)this.getClearingThresholdOfCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty2"), Boolean.class, (Object)this.getClearingThresholdOfCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingObligationOfTheCounterparty2"), Boolean.class, (Object)this.getReportingObligationOfTheCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("directlyLinkedToCommercialActivityOrTreasuryFinancing"), Boolean.class, (Object)this.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportTrackingNumber"), String.class, (Object)this.getReportTrackingNumber(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("ptrrId"), String.class, (Object)this.getPtrrId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isin"), String.class, (Object)this.getIsin(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("productClassification"), String.class, (Object)this.getProductClassification(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indicatorOfTheUnderlyingIndex"), IndexEnum.class, this.getIndicatorOfTheUnderlyingIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingObligation"), ClearingObligationEnum.class, (Object)this.getClearingObligation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("otherMasterAgreementType"), String.class, (Object)this.getOtherMasterAgreementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("ptrr"), Boolean.class, (Object)this.getPtrr(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("typeOfPTRRTechnique"), RiskReductionTechniqueEnum.class, (Object)this.getTypeOfPTRRTechnique(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("ptrrServiceProvider"), String.class, (Object)this.getPtrrServiceProvider(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("venueOfExecution"), String.class, (Object)this.getVenueOfExecution(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("forwardExchangeRate"), BigDecimal.class, (Object)this.getForwardExchangeRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryPoint"), String.class, this.getDeliveryPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("interconnectionPoint"), String.class, (Object)this.getInterconnectionPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("loadType"), EnergyLoadType1Code.class, (Object)this.getLoadType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryReport"), processor, ReportableDelivery.ReportableDeliveryBuilder.class, this.getDeliveryReport(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tranche"), Boolean.class, (Object)this.getTranche(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, (Object)this.getCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public ESMAEMIRTransactionReportBuilder prune();
    }

    public static class ESMAEMIRTransactionReportImpl
    extends EMIRTransactionReport.EMIRTransactionReportImpl
    implements ESMAEMIRTransactionReport {
        private final NatureOfCounterpartyEnum natureOfCounterparty1;
        private final Boolean counterparty2IdentifierType;
        private final CommonContractType contractType;
        private final CommonAssetClass assetClass;
        private final Boolean cryptoAssetUnderlyingIndicator;
        private final ClearedEnum cleared;
        private final MasterAgreementEnum masterAgreementType;
        private final ZonedDateTime executionTimestamp;
        private final Date effectiveDate;
        private final DeliveryTypeEnum deliveryType;
        private final ReportLevelEnum level;

        protected ESMAEMIRTransactionReportImpl(ESMAEMIRTransactionReportBuilder builder) {
            super(builder);
            this.natureOfCounterparty1 = builder.getNatureOfCounterparty1();
            this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
            this.contractType = builder.getContractType();
            this.assetClass = builder.getAssetClass();
            this.cryptoAssetUnderlyingIndicator = builder.getCryptoAssetUnderlyingIndicator();
            this.cleared = builder.getCleared();
            this.masterAgreementType = builder.getMasterAgreementType();
            this.executionTimestamp = builder.getExecutionTimestamp();
            this.effectiveDate = builder.getEffectiveDate();
            this.deliveryType = builder.getDeliveryType();
            this.level = builder.getLevel();
        }

        @Override
        @RosettaAttribute(value="natureOfCounterparty1", isRequired=true)
        @RuneAttribute(value="natureOfCounterparty1", isRequired=true)
        public NatureOfCounterpartyEnum getNatureOfCounterparty1() {
            return this.natureOfCounterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="contractType", isRequired=true)
        @RuneAttribute(value="contractType", isRequired=true)
        public CommonContractType getContractType() {
            return this.contractType;
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public CommonAssetClass getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="cryptoAssetUnderlyingIndicator", isRequired=true)
        @RuneAttribute(value="cryptoAssetUnderlyingIndicator", isRequired=true)
        public Boolean getCryptoAssetUnderlyingIndicator() {
            return this.cryptoAssetUnderlyingIndicator;
        }

        @Override
        @RosettaAttribute(value="cleared", isRequired=true)
        @RuneAttribute(value="cleared", isRequired=true)
        public ClearedEnum getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="masterAgreementType", isRequired=true)
        @RuneAttribute(value="masterAgreementType", isRequired=true)
        public MasterAgreementEnum getMasterAgreementType() {
            return this.masterAgreementType;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp", isRequired=true)
        @RuneAttribute(value="executionTimestamp", isRequired=true)
        public ZonedDateTime getExecutionTimestamp() {
            return this.executionTimestamp;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="deliveryType", isRequired=true)
        @RuneAttribute(value="deliveryType", isRequired=true)
        public DeliveryTypeEnum getDeliveryType() {
            return this.deliveryType;
        }

        @Override
        @RosettaAttribute(value="level", isRequired=true)
        @RuneAttribute(value="level", isRequired=true)
        public ReportLevelEnum getLevel() {
            return this.level;
        }

        @Override
        public ESMAEMIRTransactionReport build() {
            return this;
        }

        @Override
        public ESMAEMIRTransactionReportBuilder toBuilder() {
            ESMAEMIRTransactionReportBuilder builder = ESMAEMIRTransactionReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ESMAEMIRTransactionReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getNatureOfCounterparty1()).ifPresent(builder::setNatureOfCounterparty1OverriddenAsNatureOfCounterpartyEnum);
            Optional.ofNullable(this.getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierTypeOverriddenAsBoolean);
            Optional.ofNullable(this.getContractType()).ifPresent(builder::setContractTypeOverriddenAsCommonContractType);
            Optional.ofNullable(this.getAssetClass()).ifPresent(builder::setAssetClassOverriddenAsCommonAssetClass);
            Optional.ofNullable(this.getCryptoAssetUnderlyingIndicator()).ifPresent(builder::setCryptoAssetUnderlyingIndicatorOverriddenAsBoolean);
            Optional.ofNullable(this.getCleared()).ifPresent(builder::setClearedOverriddenAsClearedEnum);
            Optional.ofNullable(this.getMasterAgreementType()).ifPresent(builder::setMasterAgreementTypeOverriddenAsMasterAgreementEnum);
            Optional.ofNullable(this.getExecutionTimestamp()).ifPresent(builder::setExecutionTimestampOverriddenAsZonedDateTime);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDateOverriddenAsDate);
            Optional.ofNullable(this.getDeliveryType()).ifPresent(builder::setDeliveryTypeOverriddenAsDeliveryTypeEnum);
            Optional.ofNullable(this.getLevel()).ifPresent(builder::setLevelOverriddenAsReportLevelEnum);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ESMAEMIRTransactionReport _that = (ESMAEMIRTransactionReport)this.getType().cast(o);
            if (!Objects.equals((Object)this.natureOfCounterparty1, (Object)_that.getNatureOfCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals((Object)this.contractType, (Object)_that.getContractType())) {
                return false;
            }
            if (!Objects.equals((Object)this.assetClass, (Object)_that.getAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.cryptoAssetUnderlyingIndicator, _that.getCryptoAssetUnderlyingIndicator())) {
                return false;
            }
            if (!Objects.equals((Object)this.cleared, (Object)_that.getCleared())) {
                return false;
            }
            if (!Objects.equals((Object)this.masterAgreementType, (Object)_that.getMasterAgreementType())) {
                return false;
            }
            if (!Objects.equals(this.executionTimestamp, _that.getExecutionTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.deliveryType, (Object)_that.getDeliveryType())) {
                return false;
            }
            return Objects.equals((Object)this.level, (Object)_that.getLevel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.natureOfCounterparty1 != null ? ((Object)((Object)this.natureOfCounterparty1)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.contractType != null ? ((Object)((Object)this.contractType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? ((Object)((Object)this.assetClass)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cryptoAssetUnderlyingIndicator != null ? this.cryptoAssetUnderlyingIndicator.hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? ((Object)((Object)this.cleared)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.masterAgreementType != null ? ((Object)((Object)this.masterAgreementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.executionTimestamp != null ? this.executionTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.deliveryType != null ? ((Object)((Object)this.deliveryType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.level != null ? ((Object)((Object)this.level)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ESMAEMIRTransactionReport {natureOfCounterparty1=" + String.valueOf((Object)this.natureOfCounterparty1) + ", counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", contractType=" + String.valueOf((Object)this.contractType) + ", assetClass=" + String.valueOf((Object)this.assetClass) + ", cryptoAssetUnderlyingIndicator=" + this.cryptoAssetUnderlyingIndicator + ", cleared=" + String.valueOf((Object)this.cleared) + ", masterAgreementType=" + String.valueOf((Object)this.masterAgreementType) + ", executionTimestamp=" + String.valueOf(this.executionTimestamp) + ", effectiveDate=" + String.valueOf(this.effectiveDate) + ", deliveryType=" + String.valueOf((Object)this.deliveryType) + ", level=" + String.valueOf((Object)this.level) + "} " + super.toString();
        }
    }
}

