/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="ESMAEMIRTransactionReportEMIR_VR_2003_05")
@ImplementedBy(value=Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2003_05
extends Validator<ESMAEMIRTransactionReport> {
    public static final String NAME = "ESMAEMIRTransactionReportEMIR_VR_2003_05";
    public static final String DEFINITION = "if IsVRAllowedForActionType(actionType) then [uniqueTransactionIdentifier, uniqueTransactionIdentifierProprietary, reportTrackingNumber, subsequentPositionUTI] all <> priorUTI and [uniqueTransactionIdentifier, uniqueTransactionIdentifierProprietary, reportTrackingNumber, subsequentPositionUTI] all <> priorUTIProprietary";

    public static class NoOp
    implements ESMAEMIRTransactionReportEMIR_VR_2003_05 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ESMAEMIRTransactionReportEMIR_VR_2003_05 {
        @Inject
        protected IsVRAllowedForActionType isVRAllowedForActionType;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            ComparisonResult result = this.executeDataRule(eSMAEMIRTransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ESMAEMIRTransactionReportEMIR_VR_2003_05.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_2003_05.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ESMAEMIRTransactionReportEMIR_VR_2003_05.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_2003_05.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            try {
                Boolean _boolean = this.isVRAllowedForActionType.evaluate((ActionTypeEnum)((Object)MapperS.of((Object)eSMAEMIRTransactionReport).map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get()));
                if (_boolean != null && _boolean.booleanValue()) {
                    return ExpressionOperators.notEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)eSMAEMIRTransactionReport).map("getUniqueTransactionIdentifier", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getUniqueTransactionIdentifier()), MapperS.of((Object)eSMAEMIRTransactionReport).map("getUniqueTransactionIdentifierProprietary", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getUniqueTransactionIdentifierProprietary()), MapperS.of((Object)eSMAEMIRTransactionReport).map("getReportTrackingNumber", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getReportTrackingNumber()), MapperS.of((Object)eSMAEMIRTransactionReport).map("getSubsequentPositionUTI", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getSubsequentPositionUTI())}), (Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getPriorUTI", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getPriorUTI()), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.notEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)eSMAEMIRTransactionReport).map("getUniqueTransactionIdentifier", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getUniqueTransactionIdentifier()), MapperS.of((Object)eSMAEMIRTransactionReport).map("getUniqueTransactionIdentifierProprietary", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getUniqueTransactionIdentifierProprietary()), MapperS.of((Object)eSMAEMIRTransactionReport).map("getReportTrackingNumber", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getReportTrackingNumber()), MapperS.of((Object)eSMAEMIRTransactionReport).map("getSubsequentPositionUTI", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getSubsequentPositionUTI())}), (Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getPriorUTIProprietary", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getPriorUTIProprietary()), (CardinalityOperator)CardinalityOperator.All));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

