/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.trade.reports;

import cdm.base.math.RoundingDirectionEnum;
import cdm.base.math.functions.RoundToPrecision;
import cdm.event.common.TransferState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.IsOtherPayment;
import drr.regulation.common.functions.TradeStateForEvent;
import drr.regulation.hkma.rewrite.trade.functions.IsAllowableActionForHKMA;
import drr.regulation.hkma.rewrite.trade.reports.OtherPaymentPayerFormatRule;
import drr.regulation.hkma.rewrite.trade.reports.OtherPaymentPayerRule;
import drr.regulation.hkma.rewrite.trade.reports.OtherPaymentPayerSchemeNameRule;
import drr.regulation.hkma.rewrite.trade.reports.OtherPaymentReceiverFormatRule;
import drr.regulation.hkma.rewrite.trade.reports.OtherPaymentReceiverRule;
import drr.regulation.hkma.rewrite.trade.reports.OtherPaymentReceiverSchemeNameRule;
import drr.standards.iosco.cde.base.payment.OtherPayment;
import drr.standards.iosco.cde.version3.payment.reports.OtherPaymentAmountRule;
import drr.standards.iosco.cde.version3.payment.reports.OtherPaymentCurrencyRule;
import drr.standards.iosco.cde.version3.payment.reports.OtherPaymentDateRule;
import drr.standards.iosco.cde.version3.payment.reports.OtherPaymentTypeRule;
import drr.standards.iso.PaymentType4Code;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=OtherPaymentRuleDefault.class)
public abstract class OtherPaymentRule
implements ReportFunction<TransactionReportInstruction, List<? extends OtherPayment>> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
    @Inject
    protected IsActionTypeTERM isActionTypeTERM;
    @Inject
    protected IsAllowableActionForHKMA isAllowableActionForHKMA;
    @Inject
    protected IsOtherPayment isOtherPayment;
    @Inject
    protected OtherPaymentAmountRule otherPaymentAmountRule;
    @Inject
    protected OtherPaymentCurrencyRule otherPaymentCurrencyRule;
    @Inject
    protected OtherPaymentDateRule otherPaymentDateRule;
    @Inject
    protected OtherPaymentPayerFormatRule otherPaymentPayerFormatRule;
    @Inject
    protected OtherPaymentPayerRule otherPaymentPayerRule;
    @Inject
    protected OtherPaymentPayerSchemeNameRule otherPaymentPayerSchemeNameRule;
    @Inject
    protected OtherPaymentReceiverFormatRule otherPaymentReceiverFormatRule;
    @Inject
    protected OtherPaymentReceiverRule otherPaymentReceiverRule;
    @Inject
    protected OtherPaymentReceiverSchemeNameRule otherPaymentReceiverSchemeNameRule;
    @Inject
    protected OtherPaymentTypeRule otherPaymentTypeRule;
    @Inject
    protected RoundToPrecision roundToPrecision;
    @Inject
    protected TradeStateForEvent tradeStateForEvent;

    public List<? extends OtherPayment> evaluate(TransactionReportInstruction input) {
        List output;
        List<OtherPayment.OtherPaymentBuilder> outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.stream().map(OtherPayment::build).collect(Collectors.toList());
            this.objectValidator.validate(OtherPayment.class, output);
        }
        return output;
    }

    protected abstract List<OtherPayment.OtherPaymentBuilder> doEvaluate(TransactionReportInstruction var1);

    public static class OtherPaymentRuleDefault
    extends OtherPaymentRule {
        @Override
        protected List<OtherPayment.OtherPaymentBuilder> doEvaluate(TransactionReportInstruction input) {
            ArrayList<OtherPayment.OtherPaymentBuilder> output = new ArrayList<OtherPayment.OtherPaymentBuilder>();
            return this.assignOutput(output, input);
        }

        protected List<OtherPayment.OtherPaymentBuilder> assignOutput(List<OtherPayment.OtherPaymentBuilder> output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> ComparisonResult.of((Mapper)MapperS.of((Object)this.isAllowableActionForHKMA.evaluate((ReportableEvent)item.get()))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isActionTypeTERM.evaluate((ReportableEvent)item.get())))).get());
            output = this.toBuilder(thenArg.mapSingleToList(transactionReportInstruction -> {
                MapperS thenArg0 = MapperS.of((Object)this.tradeStateForEvent.evaluate((ReportableEvent)thenArg.get()));
                MapperC thenArg1 = thenArg0.mapSingleToList(item -> item.mapC("getTransferHistory", tradeState -> tradeState.getTransferHistory()));
                MapperC thenArg2 = thenArg1.filterItemNullSafe(item -> this.isOtherPayment.evaluate((TransferState)item.get()));
                return thenArg2.mapItem(item -> {
                    MapperS _thenArg0 = MapperS.of((Object)this.otherPaymentAmountRule.evaluate((TransferState)item.get()));
                    MapperS _thenArg1 = _thenArg0.mapSingleToItem(_item -> MapperS.of((Object)this.roundToPrecision.evaluate((BigDecimal)_item.get(), Integer.valueOf(5), RoundingDirectionEnum.NEAREST)));
                    return MapperS.of((Object)OtherPayment.builder().setPaymentType((PaymentType4Code)((Object)((Object)((Object)MapperS.of((Object)this.otherPaymentTypeRule.evaluate((TransferState)item.get())).checkedMap("to-enum", PaymentType4Code::fromDisplayName, IllegalArgumentException.class).get())))).setAmount((BigDecimal)MapperS.of((Object)this.formatToShortFraction5DecimalNumber.evaluate((BigDecimal)_thenArg1.get())).get()).setCurrency(this.otherPaymentCurrencyRule.evaluate((TransferState)item.get())).setDate(this.otherPaymentDateRule.evaluate((TransferState)item.get())).setPayer(this.otherPaymentPayerRule.evaluate((TransferState)item.get())).setPayerFormat(this.otherPaymentPayerFormatRule.evaluate((TransferState)item.get())).setReceiver(this.otherPaymentReceiverRule.evaluate((TransferState)item.get())).setReceiverFormat(this.otherPaymentReceiverFormatRule.evaluate((TransferState)item.get())).setPayerSchemeName(this.otherPaymentPayerSchemeNameRule.evaluate((TransferState)item.get())).setReceiverSchemeName(this.otherPaymentReceiverSchemeNameRule.evaluate((TransferState)item.get())).build());
                });
            }).getMulti());
            return Optional.ofNullable(output).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

