/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.hkma.rewrite.trade.functions.IsAllowableActionForHKMA;
import drr.regulation.hkma.rewrite.trade.reports.PackageTransactionPriceNotationRule;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.functions.PriceFormatFromNotation;
import drr.standards.iosco.cde.version3.price.reports.PackageTransactionPriceNoFormatRule;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PackageTransactionPriceRuleDefault.class)
public abstract class PackageTransactionPriceRule
implements ReportFunction<TransactionReportInstruction, PriceFormat> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected IsAllowableActionForHKMA isAllowableActionForHKMA;
    @Inject
    protected PackageTransactionPriceNoFormatRule packageTransactionPriceNoFormatRule;
    @Inject
    protected PackageTransactionPriceNotationRule packageTransactionPriceNotationRule;
    @Inject
    protected PriceFormatFromNotation priceFormatFromNotation;

    public PriceFormat evaluate(TransactionReportInstruction input) {
        PriceFormat output;
        PriceFormat.PriceFormatBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(PriceFormat.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction var1);

    public static class PackageTransactionPriceRuleDefault
    extends PackageTransactionPriceRule {
        @Override
        protected PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction input) {
            PriceFormat.PriceFormatBuilder output = PriceFormat.builder();
            return this.assignOutput(output, input);
        }

        protected PriceFormat.PriceFormatBuilder assignOutput(PriceFormat.PriceFormatBuilder output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForHKMA.evaluate((ReportableEvent)item.get()));
            output = (PriceFormat.PriceFormatBuilder)this.toBuilder((RosettaModelObject)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.priceFormatFromNotation.evaluate(this.packageTransactionPriceNoFormatRule.evaluate((TransactionReportInstruction)item.get()), this.packageTransactionPriceNotationRule.evaluate((TransactionReportInstruction)item.get())))).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

