/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.valuation.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.hkma.rewrite.valuation.HKMAValuationReport;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class HKMAValuationReportTypeFormatValidator
implements Validator<HKMAValuationReport> {
    private List<ComparisonResult> getComparisonResults(HKMAValuationReport o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperators.checkString((String)"counterparty1", (String)o.getCounterparty1(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkString((String)"counterparty2", (String)o.getCounterparty2(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"counterparty2Name", (String)o.getCounterparty2Name(), (int)1, Optional.of(105), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,105}"))), ExpressionOperators.checkNumber((String)"valuationAmount", (BigDecimal)o.getValuationAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"delta", (BigDecimal)o.getDelta(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"uniqueTransactionIdentifier", (String)o.getUniqueTransactionIdentifier(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkString((String)"uniqueTransactionIdentifierProprietary", (String)o.getUniqueTransactionIdentifierProprietary(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkString((String)"entityResponsibleForReporting", (String)o.getEntityResponsibleForReporting(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperators.checkNumber((String)"numberRecords", (BigDecimal)o.getNumberRecords(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty())});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMAValuationReport o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"HKMAValuationReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"HKMAValuationReport", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"HKMAValuationReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"HKMAValuationReport", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

