/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.valuation.validation.datarule;

import cdm.base.datetime.functions.Now;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.hkma.rewrite.valuation.HKMAValuationReport;
import drr.standards.iso.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="HKMAValuationReportDOC0011")
@ImplementedBy(value=Default.class)
public interface HKMAValuationReportDOC0011
extends Validator<HKMAValuationReport> {
    public static final String NAME = "HKMAValuationReportDOC0011";
    public static final String DEFINITION = "if [ActionTypeEnum -> NEWT, ActionTypeEnum -> MODI, ActionTypeEnum -> CORR, ActionTypeEnum -> TERM, ActionTypeEnum -> EROR, ActionTypeEnum -> REVI, ActionTypeEnum -> PRTO] any = actionType then reportingTimestamp <= Now";

    public static class NoOp
    implements HKMAValuationReportDOC0011 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMAValuationReport hKMAValuationReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements HKMAValuationReportDOC0011 {
        @Inject
        protected Now now;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMAValuationReport hKMAValuationReport) {
            ComparisonResult result = this.executeDataRule(hKMAValuationReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)HKMAValuationReportDOC0011.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"HKMAValuationReport", (RosettaPath)path, (String)HKMAValuationReportDOC0011.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)HKMAValuationReportDOC0011.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"HKMAValuationReport", (RosettaPath)path, (String)HKMAValuationReportDOC0011.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(HKMAValuationReport hKMAValuationReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.TERM)), MapperS.of((Object)((Object)ActionTypeEnum.EROR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI)), MapperS.of((Object)((Object)ActionTypeEnum.PRTO))}), (Mapper)MapperS.of((Object)hKMAValuationReport).map("getActionType", _hKMAValuationReport -> _hKMAValuationReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.lessThanEquals((Mapper)MapperS.of((Object)hKMAValuationReport).map("getReportingTimestamp", _hKMAValuationReport -> _hKMAValuationReport.getReportingTimestamp()), (Mapper)MapperS.of((Object)this.now.evaluate()), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

