/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.datetime.reports.FixingDateLeg2Rule;
import drr.regulation.common.trade.functions.LegEnrichment;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodLeg2Rule;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodMultiplierLeg2Rule;
import drr.regulation.common.trade.underlier.reports.FloatingRateIndicatorLeg2Rule;
import drr.regulation.common.trade.underlier.reports.FloatingRateReferencePeriodLeg2Rule;
import drr.regulation.common.trade.underlier.reports.FloatingRateReferencePeriodMultiplierLeg2Rule;
import drr.regulation.common.trade.underlier.reports.NameOfTheFloatingRateOfLeg2Rule;
import drr.regulation.jfsa.rewrite.trade.functions.IsAllowableActionForJFSA;
import drr.regulation.jfsa.rewrite.trade.reports.SpreadNotationOfLeg2Rule;
import drr.standards.iosco.cde.version3.functions.Leg2;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalAmountScheduleLeg2Rule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalQuantityScheduleLeg2Rule;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Leg2ReportRuleDefault.class)
public abstract class Leg2ReportRule
implements ReportFunction<TransactionReportInstruction, CommonLeg> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected FixingDateLeg2Rule fixingDateLeg2Rule;
    @Inject
    protected FloatingRateIndicatorLeg2Rule floatingRateIndicatorLeg2Rule;
    @Inject
    protected FloatingRateReferencePeriodLeg2Rule floatingRateReferencePeriodLeg2Rule;
    @Inject
    protected FloatingRateReferencePeriodMultiplierLeg2Rule floatingRateReferencePeriodMultiplierLeg2Rule;
    @Inject
    protected FloatingRateResetFrequencyPeriodLeg2Rule floatingRateResetFrequencyPeriodLeg2Rule;
    @Inject
    protected FloatingRateResetFrequencyPeriodMultiplierLeg2Rule floatingRateResetFrequencyPeriodMultiplierLeg2Rule;
    @Inject
    protected IsAllowableActionForJFSA isAllowableActionForJFSA;
    @Inject
    protected Leg2 leg2;
    @Inject
    protected LegEnrichment legEnrichment;
    @Inject
    protected NameOfTheFloatingRateOfLeg2Rule nameOfTheFloatingRateOfLeg2Rule;
    @Inject
    protected NotionalAmountScheduleLeg2Rule notionalAmountScheduleLeg2Rule;
    @Inject
    protected NotionalQuantityScheduleLeg2Rule notionalQuantityScheduleLeg2Rule;
    @Inject
    protected SpreadNotationOfLeg2Rule spreadNotationOfLeg2Rule;

    public CommonLeg evaluate(TransactionReportInstruction input) {
        CommonLeg output;
        CommonLeg.CommonLegBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(CommonLeg.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction var1);

    public static class Leg2ReportRuleDefault
    extends Leg2ReportRule {
        @Override
        protected CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input) {
            CommonLeg.CommonLegBuilder output = CommonLeg.builder();
            return this.assignOutput(output, input);
        }

        protected CommonLeg.CommonLegBuilder assignOutput(CommonLeg.CommonLegBuilder output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForJFSA.evaluate((ReportableEvent)item.get()));
            BigInteger bigInteger = new BigInteger("9999999999999999999999999");
            BigDecimal bigDecimal = this.floatingRateReferencePeriodMultiplierLeg2Rule.evaluate((TransactionReportInstruction)thenArg.get());
            output = (CommonLeg.CommonLegBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.legEnrichment.evaluate(this.leg2.evaluate((TransactionReportInstruction)thenArg.get(), this.spreadNotationOfLeg2Rule.evaluate((TransactionReportInstruction)thenArg.get()), bigInteger == null ? null : new BigDecimal(bigInteger)), this.notionalAmountScheduleLeg2Rule.evaluate((TransactionReportInstruction)thenArg.get()), this.notionalQuantityScheduleLeg2Rule.evaluate((TransactionReportInstruction)thenArg.get()), null, this.floatingRateResetFrequencyPeriodLeg2Rule.evaluate((TransactionReportInstruction)thenArg.get()), this.floatingRateResetFrequencyPeriodMultiplierLeg2Rule.evaluate((TransactionReportInstruction)thenArg.get()), this.fixingDateLeg2Rule.evaluate((TransactionReportInstruction)thenArg.get()), null, null, this.floatingRateIndicatorLeg2Rule.evaluate((TransactionReportInstruction)thenArg.get()), null, this.floatingRateReferencePeriodLeg2Rule.evaluate((TransactionReportInstruction)thenArg.get()), bigDecimal == null ? null : Integer.valueOf(bigDecimal.intValueExact()), this.nameOfTheFloatingRateOfLeg2Rule.evaluate((TransactionReportInstruction)thenArg.get()))).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

