/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.FrequencyPeriodEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="JFSATransactionReportDTCC_JFSA_BR_0032_02")
@ImplementedBy(value=Default.class)
public interface JFSATransactionReportDTCC_JFSA_BR_0032_02
extends Validator<JFSATransactionReport> {
    public static final String NAME = "JFSATransactionReportDTCC_JFSA_BR_0032_02";
    public static final String DEFINITION = "if [ActionTypeEnum -> NEWT, ActionTypeEnum -> MODI, ActionTypeEnum -> CORR, ActionTypeEnum -> REVI] any = actionType and assetClass <> CURR then (if leg2 -> periodicPayment -> floatingRateResetFrequencyPeriod = EXPI and leg2 -> periodicPayment -> floatingRateResetFrequencyMultiplier <> 1 then leg2 -> periodicPayment -> floatingRateResetFrequencyMultiplier is absent)";

    public static class NoOp
    implements JFSATransactionReportDTCC_JFSA_BR_0032_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements JFSATransactionReportDTCC_JFSA_BR_0032_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
            ComparisonResult result = this.executeDataRule(jFSATransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)JFSATransactionReportDTCC_JFSA_BR_0032_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"JFSATransactionReport", (RosettaPath)path, (String)JFSATransactionReportDTCC_JFSA_BR_0032_02.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)JFSATransactionReportDTCC_JFSA_BR_0032_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"JFSATransactionReport", (RosettaPath)path, (String)JFSATransactionReportDTCC_JFSA_BR_0032_02.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(JFSATransactionReport jFSATransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)jFSATransactionReport).map("getActionType", _jFSATransactionReport -> _jFSATransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)jFSATransactionReport).map("getAssetClass", _jFSATransactionReport -> _jFSATransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)((Object)CommonAssetClass.CURR)), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)jFSATransactionReport).map("getLeg2", _jFSATransactionReport -> _jFSATransactionReport.getLeg2()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFloatingRateResetFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyPeriod()), (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.EXPI)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)jFSATransactionReport).map("getLeg2", _jFSATransactionReport -> _jFSATransactionReport.getLeg2()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFloatingRateResetFrequencyMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyMultiplier()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.notExists((Mapper)MapperS.of((Object)jFSATransactionReport).map("getLeg2", _jFSATransactionReport -> _jFSATransactionReport.getLeg2()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFloatingRateResetFrequencyMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyMultiplier()));
                    }
                    return ComparisonResult.successEmptyOperand((String)"");
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

